/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.Script;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.scheduler.InternalIntervalNode;
import org.eclipse.aperi.scheduler.SchChangeNode;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchIntervalNode;
import org.eclipse.aperi.scheduler.ScheduleInterval;

public class ScheduleQueue {
    public static ScheduleQueue routine = new ScheduleQueue();
    public static SchChangeNode head;
    SchChangeNode change;
    SchChangeNode tail;
    public static boolean initialized;

    public synchronized void addCreate(ScheduleHeader scheduleHeader) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addCreate", (String)"header");
        }
        this.change = new SchChangeNode(1);
        this.change.interval = this.makeInterval(scheduleHeader);
        this.addChange();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addCreate");
        }
    }

    public synchronized void addEdit(ScheduleHeader scheduleHeader) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addEdit", (String)"header");
        }
        this.change = new SchChangeNode(2);
        this.change.interval = this.makeInterval(scheduleHeader);
        this.addChange();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addEdit");
        }
    }

    public synchronized void addRename(int n, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addRename", (String)"sid, newName");
        }
        this.change = new SchChangeNode(3);
        this.change.SID = n;
        this.change.setName(string);
        this.addChange();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addRename");
        }
    }

    public synchronized void addDelete(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addDelete", (String)"sid");
        }
        this.change = new SchChangeNode(4);
        this.change.SID = n;
        this.addChange();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addDelete");
        }
    }

    public synchronized void run(int n, int n2, Serializable serializable, int n3) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"sid, computerID, jobData, alertLogID");
        }
        this.change = new SchChangeNode(5);
        this.change.SID = n;
        this.change.computerID = n2;
        this.change.jobData = serializable;
        this.change.alertLogID = n3;
        this.addChange();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }

    public void run(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"sid");
        }
        this.run(n, -1, null, -1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }

    public synchronized void setAsFirst(SchChangeNode schChangeNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setAsFirst", (String)"change");
        }
        if (head == null) {
            head = schChangeNode;
            this.tail = schChangeNode;
        } else {
            schChangeNode.next = head;
            head = schChangeNode;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setAsFirst");
        }
    }

    public synchronized void getHighRunNumber(ScheduleHeader scheduleHeader) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getHighRunNumber", (String)"header");
        }
        int n = scheduleHeader.ID;
        SchIntervalNode schIntervalNode = ScheduleInterval.runNumberHdr;
        int n2 = -1;
        while (schIntervalNode != null) {
            if (schIntervalNode.SID == n) {
                n2 = schIntervalNode.highRunNumber;
                break;
            }
            schIntervalNode = schIntervalNode.allNext;
        }
        if (n2 > scheduleHeader.highRunNumber) {
            scheduleHeader.highRunNumber = n2;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getHighRunNumber");
        }
    }

    public synchronized void rebuild() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"rebuild", (String)"");
        }
        this.change = new SchChangeNode(6);
        this.addChange();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"rebuild");
        }
    }

    public synchronized void clear() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"clear", (String)"");
        }
        while (head != null) {
            this.getNext();
        }
        InternalIDAllocator.clearIDs();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"clear");
        }
    }

    public synchronized SchChangeNode getNext() {
        SchChangeNode schChangeNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNext", (String)"");
        }
        SchChangeNode schChangeNode2 = head;
        if (head != null) {
            head = ScheduleQueue.head.next;
            if (head == null) {
                this.tail = null;
            } else if (schChangeNode2.type == 6) {
                while (head != null && ScheduleQueue.head.type == 6) {
                    head = ScheduleQueue.head.next;
                }
                if (head == null) {
                    this.tail = null;
                } else {
                    schChangeNode = head;
                    SchChangeNode schChangeNode3 = ScheduleQueue.head.next;
                    while (schChangeNode3 != null) {
                        if (schChangeNode3.type == 6) {
                            schChangeNode.next = schChangeNode3.next;
                            schChangeNode3.next = null;
                        } else {
                            schChangeNode = schChangeNode3;
                        }
                        schChangeNode3 = schChangeNode.next;
                    }
                    this.tail = schChangeNode;
                }
            }
        }
        schChangeNode = schChangeNode2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNext", (Object)schChangeNode);
        }
        return schChangeNode;
    }

    public static boolean isInternal(int n) {
        return InternalIDAllocator.isInternal(n);
    }

    public synchronized void addInternalJob(int n, Request request) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addInternalJob", (String)"delayInMinutes, request");
        }
        InternalIntervalNode internalIntervalNode = new InternalIntervalNode();
        internalIntervalNode.scheduleType = (byte)2;
        internalIntervalNode.jobType = (short)73;
        internalIntervalNode.SID = InternalIDAllocator.allocID();
        internalIntervalNode.creator = request.serviceName;
        internalIntervalNode.setName(request.subType);
        internalIntervalNode.enabled = true;
        internalIntervalNode.timezoneType = (byte)2;
        internalIntervalNode.globalType = 1;
        internalIntervalNode.alertID = -1;
        internalIntervalNode.highRunNumber = 1;
        internalIntervalNode.request = request;
        long l = 0L;
        try {
            l = CurrentTime.getTimestamp().getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"addInternalJob", (Throwable)exception);
            }
            return;
        }
        l += SchCommon.millisAdvanced;
        long l2 = n + 1;
        Date date = new Date(l += (l2 *= 60000L));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        internalIntervalNode.startYear = calendar.get(1) - 2000;
        internalIntervalNode.startMonth = calendar.get(2);
        internalIntervalNode.startDay = calendar.get(5) - 1;
        internalIntervalNode.startHour = calendar.get(10);
        internalIntervalNode.startMinute = calendar.get(12);
        this.change = new SchChangeNode(1);
        this.change.interval = internalIntervalNode;
        this.addChange();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addInternalJob");
        }
    }

    private SchIntervalNode makeInterval(ScheduleHeader scheduleHeader) {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeInterval", (String)"header");
        }
        SchIntervalNode schIntervalNode = new SchIntervalNode();
        schIntervalNode.SID = scheduleHeader.ID;
        schIntervalNode.creator = scheduleHeader.creator;
        schIntervalNode.setName(scheduleHeader.getTrueName());
        schIntervalNode.enabled = scheduleHeader.enabled;
        schIntervalNode.scheduleType = scheduleHeader.scheduleType;
        schIntervalNode.startYear = scheduleHeader.startYear - 2000;
        schIntervalNode.startMonth = scheduleHeader.startMonth - 1;
        schIntervalNode.startDay = scheduleHeader.startDay - 1;
        schIntervalNode.startHour = scheduleHeader.startHour;
        schIntervalNode.startMinute = scheduleHeader.startMinute;
        schIntervalNode.intervalType = scheduleHeader.intervalType;
        schIntervalNode.intervalNumber = scheduleHeader.intervalNumber;
        if (scheduleHeader.repeatType == 2) {
            schIntervalNode.daysArray = new boolean[7];
            if (scheduleHeader.runSunday == 2) {
                schIntervalNode.daysArray[1] = true;
            }
            if (scheduleHeader.runMonday == 2) {
                schIntervalNode.daysArray[2] = true;
            }
            if (scheduleHeader.runTuesday == 2) {
                schIntervalNode.daysArray[3] = true;
            }
            if (scheduleHeader.runWednesday == 2) {
                schIntervalNode.daysArray[4] = true;
            }
            if (scheduleHeader.runThursday == 2) {
                schIntervalNode.daysArray[5] = true;
            }
            if (scheduleHeader.runFriday == 2) {
                schIntervalNode.daysArray[6] = true;
            }
            if (scheduleHeader.runSaturday == 2) {
                schIntervalNode.daysArray[0] = true;
            }
        }
        schIntervalNode.timezoneType = scheduleHeader.timezoneType;
        schIntervalNode.globalType = scheduleHeader.globalType;
        schIntervalNode.timezone = scheduleHeader.timezone;
        schIntervalNode.arguments = scheduleHeader.arguments;
        schIntervalNode.alertID = scheduleHeader.alertID;
        schIntervalNode.jobType = scheduleHeader.jobType;
        schIntervalNode.highRunNumber = scheduleHeader.highRunNumber;
        schIntervalNode.computerID = scheduleHeader.computerID;
        if (scheduleHeader instanceof Script) {
            object = (Script)scheduleHeader;
            schIntervalNode.scriptName = object.scrName;
        }
        if (schIntervalNode.jobType != 16 && schIntervalNode.jobType != 36 && schIntervalNode.jobType != 67 && schIntervalNode.jobType != 65) {
            schIntervalNode.timezoneType = (byte)2;
        }
        object = schIntervalNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeInterval", (Object)object);
        }
        return object;
    }

    private void addChange() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addChange", (String)"");
        }
        if (this.tail == null) {
            head = this.change;
            this.tail = this.change;
        } else {
            this.tail.next = this.change;
            this.tail = this.change;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addChange");
        }
    }

    private static class InternalIDAllocator {
        private static final int HIGHEST_INTERNAL_ID = -2;
        private static long[] usedIDs = new long[1];
        private static long currentBit;
        private static int currentBitNumber;

        static {
            currentBitNumber = 63;
            currentBit = 1L;
            currentBit <<= currentBitNumber;
        }

        private InternalIDAllocator() {
        }

        public static int allocID() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue$InternalIDAllocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"allocID", (String)"");
            }
            int n = 0;
            while (n < usedIDs.length && usedIDs[n] == -1L) {
                ++n;
            }
            if (n >= usedIDs.length) {
                long[] lArray = new long[usedIDs.length << 1];
                System.arraycopy(lArray, 0, usedIDs, 0, usedIDs.length);
                usedIDs = lArray;
            }
            long l = usedIDs[n];
            do {
                if (currentBit > 0L) {
                    currentBit <<= 1;
                    ++currentBitNumber;
                    continue;
                }
                currentBit = 1L;
                currentBitNumber = 0;
            } while ((l & currentBit) != 0L);
            InternalIDAllocator.usedIDs[n] = l | currentBit;
            int n2 = n << 6 | currentBitNumber;
            System.out.println(n2);
            int n3 = -2 - n2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue$InternalIDAllocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"allocID", (int)n3);
            }
            return n3;
        }

        public static void returnID(int n) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue$InternalIDAllocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"returnID", (String)"returnedID");
            }
            int n2 = -2 - n;
            int n3 = n2 >> 6;
            int n4 = n2 & 0x3F;
            long l = 1L;
            int n5 = n3;
            usedIDs[n5] = usedIDs[n5] & ((l <<= n4) ^ 0xFFFFFFFFFFFFFFFFL);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue$InternalIDAllocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"returnID");
            }
        }

        public static boolean isInternal(int n) {
            int n2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue$InternalIDAllocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"isInternal", (String)"ID");
            }
            int n3 = n > -2 ? 0 : ((n2 = -2 - n) >> 6 < usedIDs.length ? 1 : 0);
            n2 = n3;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue$InternalIDAllocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"isInternal", n2 != 0);
            }
            return n2 != 0;
        }

        public static void clearIDs() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue$InternalIDAllocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"clearIDs", (String)"");
            }
            Arrays.fill(usedIDs, 0L);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleQueue$InternalIDAllocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"clearIDs");
            }
        }
    }
}

