/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import com.tivoli.tec.event_delivery.EDException;
import com.tivoli.tec.event_delivery.TECAgent;
import com.tivoli.tec.event_delivery.TECEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.ListElement;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.AlertUtil;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.ScriptQElement;
import org.eclipse.aperi.server.ScriptSubmitter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.StatDataWriter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.guireq.SmtpSettings;
import org.eclipse.aperi.server.guireq.SnmpDestination;
import org.eclipse.aperi.server.util.smtp.Email;
import org.eclipse.aperi.server.util.smtp.SmtpTransmitter;
import org.eclipse.aperi.server.util.snmp.SnmpUtil;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpTrapSession;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class Alerter
extends Thread {
    private static ServiceQueue alertQueue;
    private static Alerter alerter;
    private static PrintWriter logWriter;
    private static final int STOP_WAIT_TIME = 300000;
    private static final int MIN_EVENT_CATEGORY = 1;
    private static final int MIN_EVENT_ID = 64;
    private static final int ID_ALLOC_SIZE = 64;
    private static int currentID;
    private static SnmpVarBind serverLocation;
    private static String tecBufEvtPath;
    private static final OID SERVER_OID;
    private static final OID ALERT_NAME_OID;
    public static final int[] ALERT_TYPE_OID;
    public static final String ALERT_TYPE_SLOT = "alertType";
    private SnmpDestination[] savedSnmp;
    private Snmp snmpList;
    private boolean snmpInitialized;
    private Connection dbc;
    private StringBuffer msgBuffer = new StringBuffer(512);
    private long osLogHandle;
    private TECAgent tecAgent;
    private String tecServer;
    private int tecPort;
    private TAlertLog alAccessor;
    private TResFS fsAccessor;
    private Alert alert;
    private AlertDefinition alertDef;
    private boolean alertError;
    private byte shutdownMode = 0;
    private File tempDir = new File(Server.TEMP_DIR);
    private int failedTecAttempts;
    private int failedSmtpAttempts;

    static {
        currentID = 1;
        SERVER_OID = SnmpUtil.tivoliSRMOID(new int[]{1, 1, 1});
        ALERT_NAME_OID = SnmpUtil.tivoliSRMOID(new int[]{1, 1, 2});
        ALERT_TYPE_OID = new int[]{1, 1, 3};
    }

    public static void queueAlert(Alert alert) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queueAlert", (String)"alert");
        }
        alertQueue.add((ListElement)alert, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queueAlert");
        }
    }

    public static void deleteAlert(Connection connection, int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteAlert", (String)"dbc, alertID, commit");
        }
        StorageRepositoryAccessor storageRepositoryAccessor = new StorageRepositoryAccessor(connection);
        String string = "(SELECT alert_log_id FROM t_alert_log where alert_id = " + Integer.toString(n) + ")";
        String string2 = " WHERE attribute_id in " + string + " AND attribute_type = " + 140;
        storageRepositoryAccessor.delete("t_res_attribute", string2, bl);
        string2 = " WHERE alert_id = " + Integer.toString(n);
        storageRepositoryAccessor.delete("t_alert_email", string2, false);
        storageRepositoryAccessor.delete("t_alert_log", string2, false);
        storageRepositoryAccessor.delete("t_alert_definition", string2, bl);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteAlert");
        }
    }

    protected static void startThreads(ThreadGroup threadGroup) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"startThreads", (String)"serverThreadGroup");
        }
        String string = MessageLog.getMessageNoID((String)"ALR1201L", (Object)Server.getServerHostName());
        serverLocation = new SnmpVarBind(SERVER_OID, (Serializable)new OctetString(string, true));
        logWriter = MessageLog.getThreadLog();
        alertQueue = new ServiceQueue();
        ScriptSubmitter.init(threadGroup);
        alerter = new Alerter(threadGroup);
        alerter.start();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"startThreads");
        }
    }

    protected static void stopThreads(byte by) {
        block18: {
            long l;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"stopThreads", (String)"pShutdownMode");
            }
            if (alerter == null) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"stopThreads");
                }
                return;
            }
            Alerter.alerter.shutdownMode = by;
            alertQueue.setState(by);
            switch (by) {
                case 1: {
                    l = 0L;
                    break;
                }
                case 2: {
                    l = 300000L;
                    break;
                }
                default: {
                    l = 1L;
                }
            }
            try {
                alerter.join(l);
            }
            catch (InterruptedException interruptedException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block18;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"stopThreads", (Throwable)interruptedException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"stopThreads");
        }
    }

    private Alerter(ThreadGroup threadGroup) {
        super(threadGroup, "Alerter");
        tecBufEvtPath = String.valueOf(System.getProperty("user.dir", "")) + File.separator + "tec" + File.separator + "cache";
    }

    public void run() {
        block17: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
            }
            while ((this.alert = (Alert)alertQueue.get()) != null) {
                this.alertError = false;
                this.alertDef = this.alert.getAlertDefinition();
                if (this.alertDef.aldSALog) {
                    this.logAlert();
                }
                if (this.alertDef.aldEmail) {
                    this.sendEmail();
                }
                if (this.alertDef.aldSnmpTrap) {
                    this.sendTrap();
                }
                if (this.alertDef.aldOsLog) {
                    this.osLog();
                }
                if (this.alertDef.aldTecEvent) {
                    this.sendTecEvent();
                }
                if (!this.shouldRunAgentJob()) continue;
                this.runAgentJob();
            }
            this.close();
            if (this.shutdownMode == 0) {
                this.shutdownMode = 1;
            }
            ScriptSubmitter.queue.setState(this.shutdownMode);
            try {
                ScriptSubmitter.thread.join();
            }
            catch (InterruptedException interruptedException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block17;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)interruptedException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }

    private int nextID() throws GeneralException {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"nextID", (String)"");
        }
        if ((currentID & 0x3F) == 1) {
            try {
                currentID = SQLUtil.getIdentifier(6, 64, this.dbc);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"nextID", (Throwable)sQLException);
                }
                String string = SQLUtil.getSQLExceptionMsg("SRV0100E", sQLException, null);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"nextID");
                }
                throw new GeneralException(string);
            }
        }
        int n2 = n = currentID++;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"nextID", (int)n2);
        }
        return n2;
    }

    private boolean makeTempFile(String[] stringArray, int n, StatDataWriter statDataWriter, boolean bl) {
        boolean bl2;
        block34: {
            String string;
            Object object;
            Object object2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"makeTempFile", (String)"array, i, writer, forWindows");
            }
            File file = null;
            try {
                file = File.createTempFile("ALR", null, this.tempDir);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"makeTempFile", (Throwable)iOException);
                }
                object2 = new Object[]{iOException.getMessage()};
                object = new LocalizableException("GEN0037E", object2);
                this.handleException((Exception)object);
            }
            if (file == null) {
                boolean bl3 = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeTempFile", (boolean)bl3);
                }
                return bl3;
            }
            stringArray[n] = string = file.getPath();
            object2 = null;
            try {
                object2 = new FileWriter(string);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"makeTempFile", (Throwable)iOException);
                }
                Object[] objectArray = new Object[]{iOException.getMessage()};
                LocalizableException localizableException = new LocalizableException("GEN0037E", objectArray);
                this.handleException((Exception)((Object)localizableException));
            }
            if (object2 == null) {
                boolean bl4 = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"makeTempFile", (boolean)bl4);
                }
                return bl4;
            }
            object = new BufferedWriter((Writer)object2);
            bl2 = false;
            boolean bl5 = false;
            try {
                statDataWriter.writeDataset(n, (BufferedWriter)object, bl);
                bl5 = true;
                ((BufferedWriter)object).close();
                bl2 = true;
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"makeTempFile", (Throwable)iOException);
                }
                String string2 = MessageLog.getMessageWithException((String)"SRV0065E", (Exception)iOException, (Object)string);
                GeneralException generalException = new GeneralException(string2);
                this.handleException((Exception)((Object)generalException));
            }
            if (!bl5) {
                try {
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block34;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"makeTempFile", (Throwable)iOException);
                }
            }
        }
        boolean bl6 = bl2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeTempFile", (boolean)bl6);
        }
        return bl6;
    }

    private void submitScript(AlertLog alertLog) {
        WindowsScript windowsScript;
        String[] stringArray;
        int n;
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"submitScript", (String)"record");
        }
        alertLog.alScriptComputerID = -1;
        if (this.alertDef.aldScriptComputerID < 0 || Util.isEmpty((String)this.alertDef.aldScriptName)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"submitScript");
            }
            return;
        }
        AgentManager.AgentAddress agentAddress = null;
        RunScriptReq runScriptReq = new RunScriptReq();
        if (this.alertDef.aldScriptComputerID > 0) {
            runScriptReq.setComputerID(this.alertDef.aldScriptComputerID);
        } else {
            int n2 = this.alert.getComputerID();
            if (n2 <= 0) {
                LocalizableException localizableException = new LocalizableException("SRV0139E", null);
                this.handleException((Exception)((Object)localizableException));
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"submitScript");
                }
                return;
            }
            agentAddress = Server.agentMgr.getAgent(n2);
            if (agentAddress == null) {
                if (this.alert.getResourceType() != 3) {
                    Object[] objectArray = new Object[]{new Integer(this.alert.getResourceType()), new Integer(n2)};
                    LocalizableException localizableException = new LocalizableException("SRV0157E", objectArray);
                    this.handleException((Exception)((Object)localizableException));
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"submitScript");
                    }
                    return;
                }
                object = null;
                try {
                    if (this.fsAccessor == null) {
                        this.fsAccessor = new TResFS(this.dbc);
                        this.fsAccessor.prepSelectScanningCompID();
                    }
                    n2 = this.fsAccessor.selectScanningCompID(this.alert.getResourceID());
                }
                catch (LocalizableException localizableException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"submitScript", (Throwable)localizableException);
                    }
                    object = localizableException;
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"submitScript", (Throwable)generalException);
                    }
                    this.repositoryClose();
                    object = generalException;
                }
                if (object != null) {
                    this.handleException((Exception)object);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"submitScript");
                    }
                    return;
                }
            }
            runScriptReq.setComputerID(n2);
        }
        ConfigSettings configSettings = Server.getSettings();
        runScriptReq.setRetainDays(configSettings.csRetainDays);
        runScriptReq.setRetention(configSettings.csRetainCopies);
        object = this.alert.getParameters();
        int n3 = ((String[])object).length - 1;
        try {
            int[] nArray = AlertConditionManager.getScriptParameterList((short)this.alertDef.aldCondition);
            int n4 = nArray == null || object == null ? 1 : nArray.length + 1;
            runScriptReq.scrArgv = new String[n4];
            runScriptReq.scrArgv[0] = this.alertDef.aldScriptName;
            n = 1;
            while (n < n4) {
                if (nArray[n - 1] <= n3) {
                    runScriptReq.scrArgv[n] = object[nArray[n - 1]];
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"submitScript", (Throwable)arrayIndexOutOfBoundsException);
            }
            Object[] objectArray = new Object[]{new Integer(this.alertDef.aldCondition)};
            LocalizableException localizableException = new LocalizableException("SRV0141E", objectArray);
            this.handleException((Exception)((Object)localizableException));
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"submitScript");
            }
            return;
        }
        if (agentAddress == null && (agentAddress = Server.agentMgr.getAgent(runScriptReq.getComputerID())) == null) {
            Object[] objectArray = new Object[]{String.valueOf(runScriptReq.getComputerID())};
            LocalizableException localizableException = new LocalizableException("SRV0040E", objectArray);
            this.handleException((Exception)((Object)localizableException));
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"submitScript");
            }
            return;
        }
        n = Constants.isWindows((short)agentAddress.osType) ? 1 : 0;
        StatDataWriter statDataWriter = this.alert.statWriter;
        if (statDataWriter == null) {
            stringArray = new String[1];
        } else {
            int n5 = statDataWriter.getNDatasets() + 1;
            stringArray = new String[n5];
            boolean bl = true;
            int n6 = 1;
            while (n6 < n5 && bl) {
                if (this.makeTempFile(stringArray, n6, statDataWriter, n != 0)) {
                    ++n6;
                    continue;
                }
                bl = false;
            }
            if (!bl) {
                while (n6 > 0) {
                    if (stringArray[n6] != null) {
                        File file = new File(stringArray[n6]);
                        file.delete();
                    }
                    --n6;
                }
                MessageLog.logMessage((String)"SRV0140E", (Object)this.alertDef.aldCreator, (Object)this.alertDef.getAldName());
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"submitScript");
                }
                return;
            }
        }
        runScriptReq.setRunNumber(alertLog.alAlertLogID);
        runScriptReq.setSchedRunNumber(alertLog.alAlertLogID);
        runScriptReq.setSchedCreator(this.alertDef.aldCreator);
        runScriptReq.setSchedName(this.alertDef.getAldName());
        runScriptReq.setJobName("alert");
        alertLog.alScriptLogFile = JobUtils.generateLogFileName((RunReq)runScriptReq, null);
        alertLog.alScriptComputerID = runScriptReq.getComputerID();
        alertLog.alScriptName = this.alertDef.aldScriptName;
        StringBuffer stringBuffer = new StringBuffer(120);
        if (Constants.isWindows((short)agentAddress.osType)) {
            windowsScript = JobUtil.resolveWindowsScript((String)this.alertDef.aldScriptName, (StringBuffer)stringBuffer);
            if (windowsScript != null) {
                if (stringBuffer.length() > 0) {
                    runScriptReq.scrExtension = stringBuffer.toString();
                }
                stringBuffer.setLength(0);
                stringBuffer.append(JobUtil.scriptsDir);
                stringBuffer.append(File.separatorChar);
                stringBuffer.append(windowsScript.wsResolvedName);
                stringArray[0] = stringBuffer.toString();
            }
        } else {
            stringBuffer.append(JobUtil.scriptsDir);
            stringBuffer.append(File.separatorChar);
            if (JobUtil.resolveUnixScript((String)this.alertDef.aldScriptName, (StringBuffer)stringBuffer) != null) {
                stringArray[0] = stringBuffer.toString();
            }
        }
        windowsScript = new Request();
        windowsScript.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
        windowsScript.subType = "org.eclipse.aperi.agent.handler.script.ScriptHandlerFactory";
        windowsScript.serviceName = RequestTypeManager.getInternalName((String)windowsScript.typeCode);
        windowsScript.requestData = runScriptReq;
        ScriptQElement scriptQElement = new ScriptQElement();
        scriptQElement.sqRequest = windowsScript;
        scriptQElement.sqAlertLogID = alertLog.alAlertLogID;
        scriptQElement.sqRetryCounter = 2;
        scriptQElement.sqFiles = stringArray;
        ScriptSubmitter.queue.add(scriptQElement, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"submitScript");
        }
    }

    private void logAlert() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"logAlert", (String)"");
        }
        if (this.dbc == null) {
            this.repositoryPrep();
        }
        if (this.alAccessor != null) {
            AlertLog alertLog = AlertUtil.getAlertLog(this.alert);
            try {
                alertLog.alAlertLogID = this.nextID();
                this.submitScript(alertLog);
                if (this.alAccessor != null) {
                    this.alAccessor.save(alertLog, this.alertDef.accumulateAlertLog());
                }
                if (this.alert.hasAffectedResources()) {
                    TResAttr tResAttr = new TResAttr(this.dbc);
                    tResAttr.setAffectedResources(alertLog.alAlertLogID, this.alert.getAffectedResources(), (short)1, (short)140);
                    this.alert.setAffectedHosts(tResAttr.getAffectedHosts(alertLog.alAlertLogID));
                }
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"logAlert", (Throwable)generalException);
                }
                this.handleException((Exception)((Object)generalException));
                this.repositoryClose();
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"logAlert");
        }
    }

    private void repositoryPrep() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"repositoryPrep", (String)"");
        }
        try {
            this.dbc = Server.getConnection();
            if (this.dbc == null) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"repositoryPrep");
                }
                throw new GeneralException(MessageLog.getMessage((String)"SRV0089E", null));
            }
            this.alAccessor = new TAlertLog(this.dbc);
            this.alAccessor.prepSave();
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"repositoryPrep", (Throwable)generalException);
            }
            this.handleException((Exception)((Object)generalException));
            this.repositoryClose();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"repositoryPrep");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendEmail() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendEmail", (String)"");
        }
        SmtpTransmitter smtpTransmitter = null;
        Email email = null;
        ConfigSettings configSettings = Server.getSettings();
        if (configSettings.csSmtp.ssServer != null) {
            try {
                block24: {
                    try {
                        if (this.failedSmtpAttempts == 0 || this.failedSmtpAttempts == 10) {
                            this.failedSmtpAttempts = 0;
                            smtpTransmitter = new SmtpTransmitter(configSettings.csSmtp.ssServer, configSettings.csSmtp.ssPort);
                            email = AlertUtil.getEmail(this.alert);
                            if (SQLUtil.isNullString(this.alertDef.aldEmailDef.aleSubject)) {
                                email.subject = "Alert: " + email.subject;
                            }
                            if (SQLUtil.isNullString(this.alertDef.aldEmailDef.aleText)) {
                                email.text = this.prependAlertName(email.text, false);
                            }
                            smtpTransmitter.sendMail(email);
                            break block24;
                        }
                        Object[] objectArray = new Object[]{new Integer(10 - this.failedSmtpAttempts), MessageLog.getMessageNoID((String)"SRV0783L"), configSettings.csSmtp.ssServer, new Integer(configSettings.csSmtp.ssPort)};
                        MessageLog.logMessage((String)"SRV0780W", (Object[])objectArray);
                        ++this.failedSmtpAttempts;
                    }
                    catch (LocalizableException localizableException) {
                        ++this.failedSmtpAttempts;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"sendEmail", (Throwable)localizableException);
                        }
                        this.handleException((Exception)((Object)localizableException));
                    }
                    catch (Exception exception) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"sendEmail", (Throwable)exception);
                        }
                        this.handleException(exception);
                    }
                }
                Object var5_9 = null;
                if (smtpTransmitter != null) {
                    smtpTransmitter.close();
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (smtpTransmitter != null) {
                    smtpTransmitter.close();
                }
                throw throwable;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendEmail");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void shutdownNotification(String string, String string2, Object[] objectArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"shutdownNotification", (String)"subjectMsgID, bodyMsgID, parms");
        }
        SmtpTransmitter smtpTransmitter = null;
        ConfigSettings configSettings = Server.getSettings();
        if (configSettings != null && configSettings.csSmtp.ssServer != null && configSettings.csSmtp.ssSrmAdmin != null) {
            String string3 = "localhost";
            try {
                string3 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {}
            int n = 1;
            if (objectArray != null) {
                n += objectArray.length;
            }
            Object[] objectArray2 = new Object[n];
            objectArray2[0] = string3;
            if (objectArray != null) {
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
            }
            String string4 = MessageLog.getMessageNoID((String)string);
            String string5 = MessageLog.getMessageNoID((String)string2, (Object[])objectArray2);
            String string6 = MessageLog.getMessageNoID((String)"ALR1201L", (Object)string3);
            Email email = new Email(string4, string5, string6, configSettings.csSmtp.ssReplyTo, configSettings.csSmtp.ssReturn, configSettings.csSmtp.ssDfltDomain);
            SmtpSettings smtpSettings = configSettings.csSmtp;
            int n2 = 0;
            while (n2 < smtpSettings.ssSrmAdmin.length) {
                email.addRecipient(smtpSettings.ssSrmAdmin[n2]);
                ++n2;
            }
            try {
                try {
                    smtpTransmitter = new SmtpTransmitter(configSettings.csSmtp.ssServer, configSettings.csSmtp.ssPort);
                    smtpTransmitter.sendMail(email);
                }
                catch (LocalizableException localizableException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"shutdownNotification", (Throwable)localizableException);
                    }
                    localizableException.print();
                }
                Object var14_17 = null;
                if (smtpTransmitter != null) {
                    smtpTransmitter.close();
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (smtpTransmitter != null) {
                    smtpTransmitter.close();
                }
                throw throwable;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"shutdownNotification");
        }
    }

    private void sendTrap() {
        block28: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"sendTrap", (String)"");
            }
            ConfigSettings configSettings = Server.getSettings();
            if (configSettings.csSnmp != this.savedSnmp) {
                this.snmpPrep(configSettings);
            }
            if (this.snmpList != null) {
                try {
                    Object object;
                    SnmpTrap snmpTrap = AlertUtil.getTrapPdu(this.alert);
                    if (!(this.alert instanceof FabricAlert)) {
                        object = String.valueOf(this.alertDef.aldCreator) + '.' + this.alertDef.getAldName();
                        snmpTrap.addVarBind(ALERT_NAME_OID, (Serializable)new OctetString((String)object, true));
                        snmpTrap.addVarBind(serverLocation);
                    }
                    object = this.snmpList;
                    while (object != null) {
                        ((Snmp)object).send(snmpTrap);
                        object = ((Snmp)object).next;
                    }
                }
                catch (LocalizableException localizableException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"sendTrap", (Throwable)localizableException);
                    }
                    this.handleException((Exception)((Object)localizableException));
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"sendTrap", (Throwable)iOException);
                    }
                    this.handleException((Exception)new NestableException("GEN0108E", null, (Exception)iOException));
                }
                catch (NullPointerException nullPointerException) {
                    Class<?> clazz;
                    Class<?> clazz2;
                    if (!TraceLogger.enableTrace) break block28;
                    String string = "Unable to create the SNMP trap. The trap's enterprise is null.";
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz2.getName(), (String)"sendTrap", (Throwable)nullPointerException);
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"sendTrap", (String)string);
                }
                catch (Exception exception) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"sendTrap", (Throwable)exception);
                    }
                    this.handleException((Exception)new NestableException("GEN0108E", null, exception));
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendTrap");
        }
    }

    private void sendTecEvent() {
        block19: {
            boolean bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"sendTecEvent", (String)"");
            }
            ConfigSettings configSettings = Server.getSettings();
            boolean bl2 = bl = configSettings.csTecServer != this.tecServer || configSettings.csTecPort != this.tecPort;
            if (bl) {
                this.tecPrep(configSettings);
            }
            if (this.tecAgent != null) {
                int n = 0;
                try {
                    TECEvent tECEvent = AlertUtil.getTecEvent(this.alert);
                    n = this.tecAgent.sendEvent(tECEvent.toString(true));
                }
                catch (LocalizableException localizableException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"sendTecEvent", (Throwable)localizableException);
                    }
                    Object[] objectArray = new Object[]{new Integer(n)};
                    this.handleException((Exception)new NestableException("SRV0206E", objectArray, (Exception)((Object)localizableException)));
                }
                catch (NullPointerException nullPointerException) {
                    Class<?> clazz;
                    Class<?> clazz2;
                    if (!TraceLogger.enableTrace || !TraceLogger.enableTrace) break block19;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.server.FabricAlert");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz2.getName(), (String)"getTecEvent", (Throwable)nullPointerException);
                    String string = "Unable to create TEC event. The TEC event class is null.";
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"sendTrap", (String)string);
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{new Integer(n)};
                    this.handleException((Exception)new NestableException("SRV0206E", objectArray, exception));
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendTecEvent");
        }
    }

    private void snmpPrep(ConfigSettings configSettings) {
        Object object;
        SnmpDestination snmpDestination;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"snmpPrep", (String)"settings");
        }
        SnmpDestination[] snmpDestinationArray = this.savedSnmp;
        this.savedSnmp = configSettings.csSnmp;
        if (snmpDestinationArray != null) {
            int n = 1;
            while (n >= 0) {
                snmpDestination = snmpDestinationArray[n];
                object = configSettings.csSnmp[n];
                if (snmpDestination.csSnmpPort != ((SnmpDestination)object).csSnmpPort || !snmpDestination.csSnmpServer.equalsIgnoreCase(((SnmpDestination)object).csSnmpServer)) break;
                --n;
            }
            if (n < 0) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"snmpPrep");
                }
                return;
            }
        }
        Snmp snmp = this.snmpList;
        while (snmp != null) {
            snmp.close();
            snmp = snmp.next;
        }
        this.snmpList = null;
        int n = 1;
        while (n >= 0) {
            snmpDestination = configSettings.csSnmp[n];
            if (!Util.isEmpty((String)snmpDestination.csSnmpServer)) {
                object = new Snmp(snmpDestination);
                this.snmpList = ((Snmp)object).add(this.snmpList);
            }
            --n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"snmpPrep");
        }
    }

    private void tecPrep(ConfigSettings configSettings) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"tecPrep", (String)"settings");
        }
        if (this.tecAgent != null) {
            this.tecAgent.disconnect();
            this.tecAgent = null;
        }
        if (configSettings.csTecServer != null) {
            try {
                String string = "ServerLocation=" + configSettings.csTecServer + "\nServerPort=" + configSettings.csTecPort + "\nBufferEvents=YES" + "\nBufEvtPath=" + tecBufEvtPath + "\n";
                this.tecServer = configSettings.csTecServer;
                this.tecPort = configSettings.csTecPort;
                if (this.failedTecAttempts == 0 || this.failedTecAttempts == 10) {
                    this.failedTecAttempts = 0;
                    this.tecAgent = new TECAgent((Reader)new StringReader(string), 0, false);
                } else {
                    Object[] objectArray = new Object[]{new Integer(10 - this.failedTecAttempts), MessageLog.getMessageNoID((String)"SRV0782L"), this.tecServer, new Integer(this.tecPort)};
                    MessageLog.logMessage((String)"SRV0780W", (Object[])objectArray);
                    ++this.failedTecAttempts;
                }
            }
            catch (EDException eDException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"tecPrep", (Throwable)eDException);
                }
                this.handleException((Exception)((Object)eDException));
            }
            catch (Exception exception) {
                ++this.failedTecAttempts;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"tecPrep", (Throwable)exception);
                }
                this.handleException((Exception)new NestableException("SRV0205E", null, exception));
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"tecPrep");
        }
    }

    private void osLog() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"osLog", (String)"");
        }
        try {
            if (this.osLogHandle == 0L) {
                this.osLogHandle = this.osLogOpen(Server.instanceID);
            }
            String string = this.prependAlertName(AlertUtil.getLogMsg(this.alert), true);
            int n = this.alertDef.aldProductID + 1;
            int n2 = this.alertDef.aldCondition + 64;
            this.osLogAlert(this.osLogHandle, string, this.alertDef.aldOsLogSeverity, (short)n, n2, this.alertDef.aldSyslogFacility);
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"osLog", (Throwable)localizableException);
            }
            this.handleException((Exception)((Object)localizableException));
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"osLog");
        }
    }

    private String prependAlertName(String string, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prependAlertName", (String)"rawMsg, includeMsgID");
        }
        Object[] objectArray = new Object[]{this.alertDef.aldCreator, this.alertDef.getAldName()};
        String string2 = MessageLog.getMessageNoID((String)"ALR0000W", (Object[])objectArray);
        this.msgBuffer.setLength(0);
        if (bl) {
            this.msgBuffer.append(string.substring(0, 10));
        }
        this.msgBuffer.append(string2);
        this.msgBuffer.append(' ');
        if (bl) {
            this.msgBuffer.append(string.substring(10));
        } else {
            this.msgBuffer.append(string);
        }
        String string3 = this.msgBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prependAlertName", (Object)string3);
        }
        return string3;
    }

    private native long osLogOpen(int var1) throws LocalizableException;

    private native void osLogAlert(long var1, String var3, byte var4, short var5, int var6, byte var7) throws LocalizableException;

    private native void osLogClose(long var1);

    private boolean shouldRunAgentJob() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"shouldRunAgentJob", (String)"");
        }
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"shouldRunAgentJob", (boolean)bl);
        }
        return bl;
    }

    private void runAgentJob() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"runAgentJob", (String)"");
        }
        ScheduleQueue.routine.run(this.alertDef.aldAlertID, this.alert.getComputerID(), this.alert.jobData, currentID - 1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"runAgentJob");
        }
    }

    private void close() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"");
        }
        while (this.snmpList != null) {
            this.snmpList.session.close();
            this.snmpList = this.snmpList.next;
        }
        if (this.tecAgent != null) {
            this.tecAgent.disconnect();
        }
        if (this.osLogHandle != 0L) {
            this.osLogClose(this.osLogHandle);
        }
        this.repositoryClose();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close");
        }
    }

    private void repositoryClose() {
        block18: {
            block17: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"repositoryClose", (String)"");
                }
                if (this.alAccessor != null) {
                    try {
                        this.alAccessor.closeSave();
                    }
                    catch (GeneralException generalException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block17;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"repositoryClose", (Throwable)generalException);
                    }
                }
            }
            if (this.fsAccessor != null) {
                try {
                    this.fsAccessor.closeSelect();
                }
                catch (GeneralException generalException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block18;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"repositoryClose", (Throwable)generalException);
                }
            }
        }
        if (this.dbc != null) {
            Server.returnConnection(this.dbc);
        }
        this.dbc = null;
        this.alAccessor = null;
        this.fsAccessor = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"repositoryClose");
        }
    }

    private void handleException(Exception exception) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleException", (String)"e");
        }
        if (!this.alertError) {
            this.alertError = true;
            MessageLog.logMessage((String)"SRV0090E", (Object)this.alertDef.aldCreator, (Object)this.alertDef.getAldName());
            logWriter.println("               " + AlertUtil.getLogMsg(this.alert));
        }
        logWriter.println(exception.getMessage());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Alerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleException");
        }
    }

    private class Snmp {
        Snmp next;
        SnmpTrapSession session;
        SnmpDestination destination;
        int failedSnmpAttempts = 0;

        public Snmp(SnmpDestination snmpDestination) {
            this.destination = snmpDestination;
        }

        public Snmp add(Snmp snmp) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"add", (String)"list");
            }
            this.next = snmp;
            snmp = this;
            Snmp snmp2 = this;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"add", (Object)snmp2);
            }
            return snmp2;
        }

        public void send(SnmpTrap snmpTrap) throws IOException {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"send", (String)"trap");
            }
            if (this.session != null || this.open()) {
                snmpTrap.communityString = new OctetString(this.destination.csSnmpCommunity, true);
                this.session.send(snmpTrap);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"send");
            }
        }

        public void close() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"");
            }
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"close");
            }
        }

        private boolean open() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"open", (String)"");
            }
            try {
                if (!Alerter.this.snmpInitialized) {
                    SnmpV1API.initialize((int)-1);
                    Alerter.this.snmpInitialized = true;
                }
                if (this.failedSnmpAttempts == 0 || this.failedSnmpAttempts == 10) {
                    this.failedSnmpAttempts = 0;
                    this.session = SnmpTrapSession.open((String)this.destination.csSnmpServer, (int)this.destination.csSnmpPort);
                } else {
                    Object[] objectArray = new Object[]{new Integer(10 - this.failedSnmpAttempts), MessageLog.getMessageNoID((String)"SRV0781L"), this.destination.csSnmpServer, new Integer(this.destination.csSnmpPort)};
                    MessageLog.logMessage((String)"SRV0780W", (Object[])objectArray);
                    ++this.failedSnmpAttempts;
                }
                boolean bl = true;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"open", (boolean)bl);
                }
                return bl;
            }
            catch (SnmpUnknownHostException snmpUnknownHostException) {
                ++this.failedSnmpAttempts;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"open", (Throwable)snmpUnknownHostException);
                }
                Object[] objectArray = new Object[]{this.destination.csSnmpServer, String.valueOf(this.destination.csSnmpPort)};
                Alerter.this.handleException((Exception)new NestableException("SRV0209E", objectArray, (Exception)((Object)snmpUnknownHostException)));
            }
            catch (SnmpSocketException snmpSocketException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"open", (Throwable)snmpSocketException);
                }
                Object[] objectArray = new Object[]{this.destination.csSnmpServer, String.valueOf(this.destination.csSnmpPort)};
                Alerter.this.handleException((Exception)new NestableException("SRV0210E", objectArray, (Exception)((Object)snmpSocketException)));
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"open", (Throwable)exception);
                }
                Alerter.this.handleException((Exception)new NestableException("SRV0204E", null, exception));
            }
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alerter$Snmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"open", (boolean)bl);
            }
            return bl;
        }
    }
}

