/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alerts;

import java.sql.Connection;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.alerts.StormAlerter;
import org.eclipse.aperi.server.jobs.Ping;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class PingAlerter
extends StormAlerter {
    AgentManager agentMgr = Server.getAgentManager();
    Ping.PingStats statsList;
    int alertID;

    public PingAlerter(Connection connection, Ping.PingStats pingStats, int n) {
        super(connection, -1);
        this.statsList = pingStats;
        this.alertID = n;
    }

    public void alert() throws LocalizableException {
        Object object;
        block21: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.PingAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"alert", (String)"");
            }
            try {
                object = new TAlertDefinition(this.dbc);
                ((TAlertDefinition)object).prepSelectByID(false, true);
                this.alertDef = ((TAlertDefinition)object).getByID(this.alertID);
                ((TAlertDefinition)object).closeSelect();
                if (this.alertDef != null) break block21;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.alerts.PingAlerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"alert");
                }
                return;
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.alerts.PingAlerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"alert", (Throwable)generalException);
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.alerts.PingAlerter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"alert");
                }
                throw new NestableException("STS0053W", null, (Exception)((Object)generalException));
            }
        }
        object = this.statsList;
        while (object != null) {
            if (((Ping.PingStats)object).unreachableCount > this.alertDef.aldThresholdValue) {
                this.initParms();
                this.setHostName(((Ping.PingStats)object).computerID);
                this.alertParms[1] = this.hostName;
                this.setParmFromMsg(11, "STS0054I");
                this.setNumParm(2, this.alertDef.aldThresholdValue, (String)null);
                this.setNumParm(3, ((Ping.PingStats)object).unreachableCount, (String)null);
                this.setParmFromMsg(10, "ALR1077W");
                this.genAlert(((Ping.PingStats)object).computerID, (short)1, 16, ((Ping.PingStats)object).unreachableCount, -1);
                ((Ping.PingStats)object).alertExists = true;
            } else if (((Ping.PingStats)object).alertExists) {
                this.setComputer(((Ping.PingStats)object).computerID);
                this.clearAlert(((Ping.PingStats)object).computerID, (short)1);
                ((Ping.PingStats)object).alertExists = false;
            }
            object = ((Ping.PingStats)object).next;
        }
        this.close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.PingAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"alert");
        }
    }
}

