/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler;

import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.SecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.SystemSecurityContext;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class DeviceRequestHndlr
implements RequestHandler {
    public static void initDeviceServerComm(DeviceRequest deviceRequest) {
        DeviceServerManager deviceServerManager;
        org.eclipse.aperi.infrastructure.database.objects.Server server;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.DeviceRequestHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initDeviceServerComm", (String)"request");
        }
        if ((server = (deviceServerManager = Server.getDeviceServerManager()).getDeviceServer()) != null) {
            String string = server.getPassword();
            try {
                string = SRMCrypto.decrypt((String)string);
            }
            catch (Exception exception) {
                exception.printStackTrace(MessageLog.getThreadLog());
            }
            try {
                if (SecurityContext.getDefaultContext() == null) {
                    SecurityContext.setDefaultContext((SecurityContext)new SystemSecurityContext());
                }
                MiddlewareCrypto.initialize((char[])string.toCharArray());
                deviceRequest.deviceServerID = server.getServerId();
                deviceRequest.deviceServerHost = server.getServerName();
                deviceRequest.deviceServerPort = server.getPortNumber();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(MessageLog.getThreadLog());
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.DeviceRequestHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initDeviceServerComm");
        }
    }

    public abstract int deviceAPI(DeviceRequest var1, Response var2);

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.DeviceRequestHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        DeviceRequest deviceRequest = (DeviceRequest)request;
        Response response = new Response(0, null);
        DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
        try {
            this.deviceAPI(deviceRequest, response);
        }
        catch (RuntimeException runtimeException) {
            response.errorMessage = runtimeException.getLocalizedMessage();
            response.status = (short)12;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.DeviceRequestHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response;
    }
}

