/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.agent;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.CuStatDef;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.EntityWWPN;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.ExtAccess;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.LunWWN;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.common.SSummaryHist;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.EnclosureAccessor;
import org.eclipse.aperi.repository.FilerSaver;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TFoundFilesystem;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResChunk;
import org.eclipse.aperi.repository.table.TResChunkCollection;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResController;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResEntityWWPN;
import org.eclipse.aperi.repository.table.TResExport;
import org.eclipse.aperi.repository.table.TResExtCtrlr;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResLunWWN;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TResStorExtent;
import org.eclipse.aperi.repository.table.TResVolGroup;
import org.eclipse.aperi.repository.table.TStatCompHist;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.repository.table.TStatDisk;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.repository.table.TStatSpaceHist;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.alerts.ProbeAlerter;
import org.eclipse.aperi.server.handler.gui.GroupDefHndlr;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeResultsHndlr
implements RequestHandler {
    private Response warningResponse;
    private Connection dbc;
    private Settings settings;
    private Computer computer;
    private Computer oldComputer;
    private TStatComputer cmpAccessor;
    private EnclosureAccessor encAccessor;
    private TResDevice devAccessor;
    private TResChunk chkAccessor;
    private TResChunkCollection colAccessor;
    private TResLogicalDisk ldAccessor;
    private TResFS fsAccessor;
    private TResShare shAccessor;
    private TResCluster clAccessor;
    private TComputer tCmpAccessor;
    private TResComputer tResCmpAccessor;
    private TGroup2Res tGrp2ResAccessor;
    private Share shareBuffer = new Share();
    private LogicalDisk lDiskBuffer = new LogicalDisk();
    private Filesystem fsBuffer = new Filesystem();
    private long probeTime;
    private Share missingDeviceList;
    private Share missingFSList;
    private Share removeFSList;
    private int[] lockedDeviceTable;
    private boolean updateScheduler;
    private boolean runDiscovery;
    private boolean isDelete;
    private boolean isDiskArray;
    private boolean isVirtualServer;
    private static final long MILLIS_PER_DAY = 86400000L;
    private int previousClusterID = 0;
    private boolean isStorageSubsystem = false;

    public ProbeResultsHndlr() {
    }

    public ProbeResultsHndlr(Connection connection) {
        this.dbc = connection;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        Object object;
        Class<?> clazz;
        Response response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!transceiver.transmitResponse(request, response = Response.getResponse((short)0, null, (byte)0))) {
            response.returnResponse();
            Response response2 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", response2);
            }
            return response2;
        }
        Response response3 = Response.getResponse((short)0, null);
        response.returnResponse();
        request.requestData = (Serializable)transceiver.receiveData(request);
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.common.Computer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response3)) {
            Response response4 = response3;
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response4);
            }
            return response4;
        }
        this.dbc = Server.getConnection();
        if (this.dbc == null) {
            Server.setResponseError(response3, "GEN0050E");
            Response response5 = response3;
            if (TraceLogger.enableTrace) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz5.getName(), (String)"handle", (Object)response5);
            }
            return response5;
        }
        this.warningResponse = response3;
        Computer computer = (Computer)request.requestData;
        computer.unpack();
        try {
            try {
                TStatComputer tStatComputer;
                NameList nameList;
                block36: {
                    object = computer.cmpNasFiler;
                    while (true) {
                        if (object == null) {
                            if (computer.cmpOSVersion == null) break;
                            this.saveResults(computer);
                            break block36;
                        }
                        ((NasFiler)object).nfParentComputerID = computer.cmpID;
                        ((NasFiler)object).nfComputer.cmpParentID = computer.cmpID;
                        object = ((NasFiler)object).nfNext;
                    }
                    this.initializeFlags();
                    if (computer.cmpDomain != null) {
                        object = new TResDomain(this.dbc);
                        ((TResDomain)object).getIDs(computer.cmpDomain);
                        computer.cmpDomainID = computer.cmpDomain.domID;
                    }
                }
                object = null;
                if (computer.cmpNasFiler != null) {
                    int n = computer.cmpDomainID > 0 ? computer.cmpDomainID : computer.cmpID;
                    object = new FilerSaver(this.dbc, n);
                    ((FilerSaver)object).saveProbeData(computer);
                }
                if (computer.cmpCluster != null) {
                    this.expireVSs(this.dbc, computer, (FilerSaver)object);
                }
                if (this.previousClusterID != 0 && (nameList = (tStatComputer = new TStatComputer(this.dbc)).selectAgentsInCluster(this.previousClusterID)) == null) {
                    object = new FilerSaver(this.dbc, this.previousClusterID);
                    TResShare tResShare = new TResShare(this.dbc);
                    Share share = tResShare.getRemovedResources(this.previousClusterID, (short)99, ((FilerSaver)object).getProbeTime());
                    ((FilerSaver)object).removeFilers(share, false);
                    this.clAccessor = new TResCluster(this.dbc);
                    this.clAccessor.cleanupCluster(this.previousClusterID);
                }
            }
            catch (StorageException storageException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz6;
                    try {
                        clazz6 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz6.getName(), (String)"handle", (Throwable)storageException);
                }
                Server.setResponseError(response3, (Exception)((Object)storageException));
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            ViewReportTablesUpdater viewReportTablesUpdater = new ViewReportTablesUpdater();
            viewReportTablesUpdater.updateViewTables(new int[]{computer.cmpID}, (short)1);
            throw throwable;
        }
        {
            Object var11_18 = null;
        }
        ViewReportTablesUpdater viewReportTablesUpdater = new ViewReportTablesUpdater();
        viewReportTablesUpdater.updateViewTables(new int[]{computer.cmpID}, (short)1);
        Server.returnConnection(this.dbc);
        this.dbc = null;
        if (this.updateScheduler) {
            ScheduleQueue.routine.rebuild();
        }
        if (this.runDiscovery) {
            response3.responseData = "DISCOVERY";
        }
        object = response3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz7.getName(), (String)"handle", (Object)object);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveResults(Computer computer) throws StorageException {
        boolean bl;
        block13: {
            Class<?> clazz;
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)"saveResults", (String)"computer");
            }
            this.computer = computer;
            this.isDelete = false;
            this.initialize();
            boolean bl2 = false;
            try {
                if (ProbeResultsHndlr.lockComputer(computer, this.warningResponse)) {
                    bl2 = true;
                    this.getSettings();
                    this.clusterProcessing();
                    if (this.isDiskArray) {
                        this.updateSVCDiskIdentity();
                        this.updateSSLUNIdentity();
                    }
                    this.saveComputerStats();
                    this.saveVolgroups();
                    this.saveVolGroupStats();
                    this.saveDevices();
                    this.getMissingDevices();
                    this.saveStorExtents();
                    this.saveCtlrDevAccess();
                    this.lockDevices();
                    this.saveLogicalDisks();
                    if (!this.isDiskArray) {
                        this.saveFilesystems();
                        this.saveFSHist();
                        this.saveExports();
                        this.saveLdapTrees();
                        this.removeObsoleteLdapTrees();
                        this.gatherObsoleteFilesystems();
                    } else {
                        this.saveLunWWNs();
                        this.saveEntityWWPNs();
                    }
                    this.removeObsoleteLogicalDisks();
                    this.removeObsoleteDevices();
                    this.saveComputerHist();
                    this.analyzeAlerts();
                    if (!this.isDiskArray) {
                        this.removeObsoleteFilesystems();
                    }
                    this.cleanClusterMembership();
                    computer.cmpProbeStatus = (byte)2;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.doCleanup(bl2, computer);
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.doCleanup(bl2, computer);
                bl = this.updateScheduler;
                if (!TraceLogger.enableTrace) break block13;
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveResults", (boolean)bl);
        }
        return bl;
    }

    private void doCleanup(boolean bl, Computer computer) {
        block12: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"doCleanup", (String)"processed, computer, svcCleanup");
            }
            if (bl) {
                this.unLockDevices();
            }
            ProbeResultsHndlr.unLockComputer(computer);
            if (bl) {
                try {
                    this.encAccessor.update(computer);
                }
                catch (GeneralException generalException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block12;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"doCleanup", (Throwable)generalException);
                }
            }
        }
        this.cleanup();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"doCleanup");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveNasProbeResults(Computer var1_1) throws StorageException {
        block19: {
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry((String)v0.getName(), (String)"saveNasProbeResults", (String)"computer");
            }
            this.computer = var1_1;
            this.isDelete = false;
            this.initialize();
            var2_2 = false;
            try {
                if (ProbeResultsHndlr.lockComputer(var1_1, this.warningResponse)) {
                    var2_2 = true;
                    this.saveComputerStats();
                    this.updateFilesystemStats();
                    this.saveNewFilesystems();
                    this.analyzeAlerts();
                    var1_1.cmpProbeStatus = (byte)2;
                }
            }
            catch (Throwable var4_3) {
                block17: {
                    var3_4 = null;
                    ProbeResultsHndlr.unLockComputer(var1_1);
                    if (var2_2) {
                        try {
                            this.encAccessor.update(var1_1);
                        }
                        catch (GeneralException var5_6) {
                            if (!TraceLogger.enableTrace) break block17;
                            try {
                                v2 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                            }
                            catch (ClassNotFoundException v3) {
                                throw new NoClassDefFoundError(v3.getMessage());
                            }
                            TraceLogger.exception((String)v2.getName(), (String)"saveNasProbeResults", (Throwable)var5_6);
                        }
                    }
                }
                this.cleanup();
                throw var4_3;
            }
            {
                var3_5 = null;
            }
            ProbeResultsHndlr.unLockComputer(var1_1);
            if (!var2_2) break block19;
            ** try [egrp 2[TRYBLOCK] [3 : 108->122)] { 
lbl46:
            // 1 sources

            this.encAccessor.update(var1_1);
            break block19;
lbl49:
            // 1 sources

            catch (GeneralException var5_7) {
                if (!TraceLogger.enableTrace) break block19;
                try {}
                catch (ClassNotFoundException v4) {
                    throw new NoClassDefFoundError(v4.getMessage());
                }
                TraceLogger.exception((String)Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr").getName(), (String)"saveNasProbeResults", (Throwable)var5_7);
            }
        }
        this.cleanup();
        if (TraceLogger.enableTrace) {
            try {
                v5 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v6) {
                throw new NoClassDefFoundError(v6.getMessage());
            }
            TraceLogger.exit((String)v5.getName(), (String)"saveNasProbeResults");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteComputer(int n, int n2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteComputer", (String)"computerID, productCode");
        }
        boolean bl = false;
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        boolean bl2 = true;
        if (n2 == -1) {
            bl2 = false;
        }
        this.dbc = Server.getConnection();
        if (this.dbc != null) {
            this.computer = new Computer();
            this.computer.cmpID = n;
            this.computer.cmpOSType = n2 == 0 || n2 == 1 ? (short)1 : (short)11;
            this.isDelete = true;
            this.initialize();
            try {
                block22: {
                    try {
                        if (this.encAccessor.getComputerStats(this.computer, mutableBoolean)) {
                            this.getSettings();
                            this.getMissingDevices();
                            this.removeStorExtents();
                            this.removeVolGroups();
                            if (bl2) {
                                this.lockDevices();
                            }
                            this.removeObsoleteLdapTrees();
                            this.gatherObsoleteFilesystems();
                            if (bl2) {
                                this.removeObsoleteLogicalDisks();
                                this.removeObsoleteDevices();
                            }
                            if (bl2) {
                                this.removeObsoleteFilesystems();
                            } else {
                                this.deleteFilesystemStats();
                            }
                            this.removeNasFilers(bl2);
                            this.deleteOtherStuff(bl2);
                        }
                        bl = true;
                    }
                    catch (GeneralException generalException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block22;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"deleteComputer", (Throwable)generalException);
                    }
                }
                Object var7_10 = null;
                if (bl2) {
                    this.unLockDevices();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (bl2) {
                    this.unLockDevices();
                }
                throw throwable;
            }
            Server.returnConnection(this.dbc);
        }
        boolean bl3 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteComputer", (boolean)bl3);
        }
        return bl3;
    }

    public boolean deleteRelationships(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteRelationships", (String)"computerID");
        }
        boolean bl = false;
        try {
            this.computer = new Computer();
            this.computer.cmpID = n;
            this.isDelete = true;
            this.initialize();
            this.getSettings();
            this.removeNasFilers(true);
            StorageRepositoryAccessor storageRepositoryAccessor = new StorageRepositoryAccessor(this.dbc);
            storageRepositoryAccessor.deleteByComputer("t_alert_log", n);
            bl = true;
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteRelationships", (Throwable)generalException);
            }
            MessageLog.logException((StorageException)((Object)generalException));
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteRelationships", (boolean)bl2);
        }
        return bl2;
    }

    private void deleteFilesystemStats() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteFilesystemStats", (String)"");
        }
        Filesystem filesystem = null;
        Share share = this.removeFSList;
        while (share != null) {
            if (share.shResource != null) {
                Filesystem filesystem2 = (Filesystem)share.shResource;
                filesystem2.fsNext = filesystem;
                filesystem = filesystem2;
            }
            share = share.shNext;
        }
        if (filesystem != null) {
            this.fsAccessor.deleteFS(filesystem, false);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteFilesystemStats");
        }
    }

    private void initialize() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initialize", (String)"");
        }
        this.initializeFlags();
        try {
            this.probeTime = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initialize", (Throwable)exception);
            }
            return;
        }
        this.isDiskArray = Constants.isDiskArray((short)this.computer.cmpOSType);
        this.isVirtualServer = Constants.isVirtualServer((int)this.computer.cmpOSType);
        if (this.isDiskArray) {
            this.cmpAccessor = null;
            this.encAccessor = new TResDiskArray(this.dbc);
        } else {
            this.cmpAccessor = new TStatComputer(this.dbc);
            this.encAccessor = this.cmpAccessor;
        }
        this.chkAccessor = new TResChunk(this.dbc);
        this.colAccessor = new TResChunkCollection(this.dbc);
        this.ldAccessor = new TResLogicalDisk(this.dbc);
        this.shAccessor = new TResShare(this.dbc);
        this.fsAccessor = new TResFS(this.dbc);
        this.devAccessor = new TResDevice(this.dbc);
        this.clAccessor = new TResCluster(this.dbc);
        this.tResCmpAccessor = new TResComputer(this.dbc);
        this.tGrp2ResAccessor = new TGroup2Res(this.dbc);
        this.previousClusterID = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initialize");
        }
    }

    private void initializeFlags() {
        this.updateScheduler = false;
        this.runDiscovery = false;
    }

    public static boolean lockComputer(Computer computer, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"lockComputer", (String)"computer, msgResponse");
        }
        byte by = Constants.isNasBox((short)computer.cmpOSType) ? (byte)1 : 2;
        LockManager.lock((short)2, (String)"Computer", (String)Integer.toString(computer.cmpID), (byte)by, (boolean)true);
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"lockComputer", (boolean)bl);
        }
        return bl;
    }

    public static void unLockComputer(Computer computer) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"unLockComputer", (String)"computer");
        }
        LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(computer.cmpID));
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"unLockComputer");
        }
    }

    private void getSettings() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSettings", (String)"");
        }
        TStormSettings tStormSettings = new TStormSettings(this.dbc);
        this.settings = tStormSettings.getSettings();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSettings");
        }
    }

    private void saveComputerStats() throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveComputerStats", (String)"");
        }
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        if (this.computer.cmpDomain != null) {
            object = new TResDomain(this.dbc);
            this.runDiscovery = ((TResDomain)object).getIDs(this.computer.cmpDomain);
        }
        this.computer.cmpProbeStatus = 0;
        this.computer.cmpLastProbeTime = this.probeTime;
        this.oldComputer = new Computer();
        this.oldComputer.cmpID = this.computer.cmpID;
        if (!this.encAccessor.getComputerStats(this.oldComputer, mutableBoolean)) {
            this.oldComputer = null;
            this.computer.cmpGroupID = this.isDiskArray ? 8 : 4;
            this.encAccessor.insert(this.computer);
            this.updateScheduler = true;
        } else {
            if (!mutableBoolean.value) {
                this.oldComputer = null;
            }
            if (Constants.isNasBox((short)this.computer.cmpOSType) && !Constants.supportsFullProbe((short)this.computer.cmpOSType)) {
                object = new HashMap();
                LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
                while (logicalDisk != null) {
                    ((HashMap)object).put(logicalDisk.ldFilesystem.fsMountPoint, null);
                    logicalDisk = logicalDisk.ldNext;
                }
                LogicalDisk logicalDisk2 = logicalDisk = this.fsAccessor.getByComputerID(this.computer.cmpID);
                while (logicalDisk2 != null) {
                    if (!((HashMap)object).containsKey(logicalDisk2.fsMountPoint)) {
                        this.computer.cmpFilesystemFreeSpace += logicalDisk2.fsFreeSpace;
                    }
                    logicalDisk2 = logicalDisk2.fsNext;
                }
            }
            if (Constants.licensedAsNAS((short)this.computer.cmpOSType) && this.computer.cmpDomainID <= 0 && this.oldComputer.cmpDomainID > 0) {
                this.computer.cmpDomain = new Domain();
                this.computer.cmpDomain.domID = this.oldComputer.cmpDomainID;
            }
            this.encAccessor.update(this.computer);
        }
        this.computer.cmpProbeStatus = 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveComputerStats");
        }
    }

    private void saveVolGroupStats() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveVolGroupStats", (String)"");
        }
        VolGroup volGroup = null;
        TStatSpaceHist tStatSpaceHist = new TStatSpaceHist(this.dbc);
        SSummaryHist sSummaryHist = new SSummaryHist();
        CuStatDef cuStatDef = new CuStatDef();
        cuStatDef.sdDailyRetention = this.settings.seDiskDailyHist;
        cuStatDef.sdWeeklyRetention = this.settings.seDiskWeeklyHist;
        cuStatDef.sdMonthlyRetention = this.settings.seDiskMonthlyHist;
        tStatSpaceHist.prepFSHistSave();
        volGroup = this.computer.cmpVolGroup;
        while (volGroup != null) {
            sSummaryHist.sumFilesystemID = volGroup.vgID;
            sSummaryHist.sumFreeSpace = volGroup.vgFreeSpace;
            sSummaryHist.sumUsedSpace = volGroup.vgTotalSpace - volGroup.vgFreeSpace;
            sSummaryHist.sumTotalSize = volGroup.vgTotalSpace;
            sSummaryHist.sumFileCount = volGroup.vgDisks;
            sSummaryHist.sumScanTime = this.probeTime;
            tStatSpaceHist.saveHist(cuStatDef, sSummaryHist);
            volGroup = volGroup.vgNext;
        }
        tStatSpaceHist.closeHistSave();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveVolGroupStats");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void saveStorExtents() throws GeneralException {
        if (TraceLogger.enableTrace) {
            try {
                v0 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            TraceLogger.entry((String)v0.getName(), (String)"saveStorExtents", (String)"");
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = new TResStorExtent(this.dbc);
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = false;
        var2_2 = var5_5.getStorExtentByComputer(this.computer.cmpID);
        if (this.computer.cmpRank != null) ** GOTO lbl50
        if (var2_2 != null) {
            var5_5.deleteStorExtents(var2_2);
        }
        if (TraceLogger.enableTrace) {
            try {
                v2 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v3) {
                throw new NoClassDefFoundError(v3.getMessage());
            }
            TraceLogger.exit((String)v2.getName(), (String)"saveStorExtents");
        }
        return;
lbl-1000:
        // 1 sources

        {
            var8_8 = false;
            var1_1 = this.computer.cmpRank;
            while (var1_1 != null) {
                var1_1.rankProbeTime = this.probeTime;
                if (var1_1.rankComputerID == var2_2.rankComputerID && var1_1.rankName.equalsIgnoreCase(var2_2.rankName)) {
                    var1_1.rankID = var2_2.rankID;
                    var8_8 = true;
                    if (!var1_1.equals((Object)var2_2)) {
                        var1_1.rankFlag = (short)2;
                        ++var7_7;
                        break;
                    }
                    var1_1.rankFlag = 0;
                    break;
                }
                var1_1 = var1_1.rankNext;
            }
            if (!var8_8) {
                var4_4 = var2_2.rankNext;
                var2_2.rankNext = var3_3;
                var3_3 = var2_2;
            } else {
                var4_4 = var2_2.rankNext;
            }
            var2_2 = var4_4;
lbl50:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl51:
        // 1 sources

        var1_1 = this.computer.cmpRank;
        while (var1_1 != null) {
            if (var1_1.rankID == -1) {
                ++var6_6;
            }
            var1_1 = var1_1.rankNext;
        }
        if (var6_6 > 0 || var7_7 > 0) {
            var5_5.saveStorExtents(this.computer.cmpRank, var6_6);
        }
        if (var3_3 != null) {
            var5_5.deleteStorExtents(var3_3);
        }
        if (TraceLogger.enableTrace) {
            try {
                v4 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v5) {
                throw new NoClassDefFoundError(v5.getMessage());
            }
            TraceLogger.exit((String)v4.getName(), (String)"saveStorExtents");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void saveVolgroups() throws GeneralException {
        if (TraceLogger.enableTrace) {
            try {
                v0 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            TraceLogger.entry((String)v0.getName(), (String)"saveVolgroups", (String)"");
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = new TResVolGroup(this.dbc);
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = false;
        var2_2 = var5_5.getVolGroupByCmp(this.computer.cmpID);
        if (this.computer.cmpVolGroup != null) ** GOTO lbl50
        if (var2_2 != null) {
            var5_5.deleteVolGroups(var2_2);
        }
        if (TraceLogger.enableTrace) {
            try {
                v2 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v3) {
                throw new NoClassDefFoundError(v3.getMessage());
            }
            TraceLogger.exit((String)v2.getName(), (String)"saveVolgroups");
        }
        return;
lbl-1000:
        // 1 sources

        {
            var8_8 = false;
            var1_1 = this.computer.cmpVolGroup;
            while (var1_1 != null) {
                var1_1.vgProbeTime = this.probeTime;
                if (var1_1.vgComputerID == var2_2.vgComputerID && var1_1.vgName.equalsIgnoreCase(var2_2.vgName)) {
                    var1_1.vgID = var2_2.vgID;
                    var8_8 = true;
                    if (!var1_1.equals((Object)var2_2)) {
                        var1_1.vgFlag = (short)2;
                        ++var7_7;
                        break;
                    }
                    var1_1.vgFlag = 0;
                    break;
                }
                var1_1 = var1_1.vgNext;
            }
            if (!var8_8) {
                var4_4 = var2_2.vgNext;
                var2_2.vgNext = var3_3;
                var3_3 = var2_2;
            } else {
                var4_4 = var2_2.vgNext;
            }
            var2_2 = var4_4;
lbl50:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl51:
        // 1 sources

        var1_1 = this.computer.cmpVolGroup;
        while (var1_1 != null) {
            if (var1_1.vgID == -1) {
                ++var6_6;
                var1_1.vgDiscoveredTime = this.probeTime;
            }
            var1_1 = var1_1.vgNext;
        }
        if (var6_6 > 0 || var7_7 > 0) {
            var5_5.saveVolGroups(this.computer.cmpVolGroup, var6_6);
        }
        this.propagateVolGroupIDS();
        if (var3_3 != null) {
            var5_5.deleteVolGroups(var3_3);
        }
        if (TraceLogger.enableTrace) {
            try {
                v4 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v5) {
                throw new NoClassDefFoundError(v5.getMessage());
            }
            TraceLogger.exit((String)v4.getName(), (String)"saveVolgroups");
        }
    }

    private void propagateVolGroupIDS() {
        Device device;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"propagateVolGroupIDS", (String)"");
        }
        VolGroup volGroup = null;
        Disk disk = null;
        volGroup = this.computer.cmpVolGroup;
        while (volGroup != null) {
            if (volGroup.vgDevices != null) {
                int n = 0;
                while (n < volGroup.vgDevices.length) {
                    device = volGroup.vgDevices[n];
                    if (device instanceof Disk) {
                        disk = (Disk)this.computer.cmpDevice;
                        while (disk != null) {
                            if (device.devSerialNumber.equals(disk.devSerialNumber)) {
                                disk.dskVolgroupID = volGroup.vgID;
                            }
                            disk = (Disk)disk.devNext;
                        }
                    }
                    ++n;
                }
            }
            if (this.computer.cmpRank != null) {
                Rank rank = this.computer.cmpRank;
                while (rank != null) {
                    if (rank.rankVolGroupID == Integer.valueOf(volGroup.vgName.substring(2))) {
                        rank.rankVolGroupID = volGroup.vgID;
                    }
                    rank = rank.rankNext;
                }
            }
            volGroup = volGroup.vgNext;
        }
        if (this.computer.cmpLogicalDisk != null) {
            LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
            while (logicalDisk != null) {
                if (logicalDisk.ldVgroup != null) {
                    logicalDisk.ldVolgroupID = logicalDisk.ldVgroup.vgID;
                }
                device = logicalDisk.ldNextMirror;
                while (device != null) {
                    if (device.ldVgroup != null) {
                        device.ldVolgroupID = device.ldVgroup.vgID;
                    }
                    device = device.ldNextMirror;
                }
                logicalDisk = logicalDisk.ldNext;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"propagateVolGroupIDS");
        }
    }

    private void removeVolGroups() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeVolGroups", (String)"");
        }
        TResVolGroup tResVolGroup = new TResVolGroup(this.dbc);
        tResVolGroup.deleteVGByComputer(this.computer.cmpID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeVolGroups");
        }
    }

    private void removeStorExtents() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeStorExtents", (String)"");
        }
        TResExtCtrlr tResExtCtrlr = new TResExtCtrlr(this.dbc);
        TResStorExtent tResStorExtent = new TResStorExtent(this.dbc);
        Rank rank = tResStorExtent.getStorExtentByComputer(this.computer.cmpID);
        tResExtCtrlr.deleteExtCtrlr(rank);
        tResStorExtent.deleteStorExtents(this.computer.cmpID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeStorExtents");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveDevices() throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveDevices", (String)"");
        }
        if (this.computer.cmpOSType == 10) {
            this.devAccessor.saveNetAppDevices(this.computer.cmpDevice, this.computer.cmpSerialNumber);
        } else {
            this.devAccessor.saveDevices(this.computer.cmpDevice);
        }
        TResShare tResShare = new TResShare(this.dbc);
        try {
            tResShare.prepSave();
            this.devAccessor.prepBumpUseCount();
            this.shareBuffer.shResourceType = (short)10;
            this.shareBuffer.shComputerID = this.computer.cmpID;
            this.shareBuffer.shScanTime = this.probeTime;
            this.shareBuffer.shRemovedTime = 0L;
            this.shareBuffer.shPath = " ";
            object = this.computer.cmpDevice;
            while (object != null) {
                boolean bl;
                this.shareBuffer.shResource = object;
                this.shareBuffer.shResourceID = ((Device)object).devID;
                boolean bl2 = bl = (((Device)object).devFlags & 4) != 0;
                if (tResShare.saveShare(this.shareBuffer, bl)) {
                    ((Device)object).devFlags = (short)(((Device)object).devFlags | 4);
                    this.devAccessor.bumpUseCount((Device)object, 1);
                }
                tResShare.commit();
                object = ((Device)object).devNext;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            tResShare.closeSave();
            this.devAccessor.closeUpdate();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        tResShare.closeSave();
        this.devAccessor.closeUpdate();
        object = new TStatDiskHist(this.dbc);
        ((TStatDiskHist)object).saveDailyHist(this.settings, this.computer.cmpDevice, this.probeTime);
        this.propagateDeviceIDs();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveDevices");
        }
    }

    private void getMissingDevices() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMissingDevices", (String)"");
        }
        TStatDisk tStatDisk = new TStatDisk(this.dbc);
        this.missingDeviceList = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)10, this.probeTime);
        if (this.missingDeviceList != null) {
            tStatDisk.prepUpdateVolGroupID();
            this.devAccessor.prepGetDevByID(false);
            Share share = this.missingDeviceList;
            while (share != null) {
                share.shResource = this.devAccessor.getDevByID(share.shResourceID);
                tStatDisk.updateVolGroupID(share.shResourceID, -1);
                share = share.shNext;
            }
            this.devAccessor.closeSelect();
            tStatDisk.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMissingDevices");
        }
    }

    private void propagateDeviceIDs() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"propagateDeviceIDs", (String)"");
        }
        Device device = this.computer.cmpDevice;
        while (device != null) {
            if (device.isFixedDisk()) {
                Disk disk = (Disk)device;
                Chunk chunk = disk.dskChunk;
                while (chunk != null) {
                    chunk.chkDiskID = disk.devID;
                    chunk = chunk.chkNextOnDisk;
                }
            }
            device = device.devNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"propagateDeviceIDs");
        }
    }

    private void removeObsoleteDevices() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeObsoleteDevices", (String)"");
        }
        if (this.missingDeviceList == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"removeObsoleteDevices");
            }
            return;
        }
        long l = (long)this.settings.seKeepRemovedDev * 86400000L;
        long l2 = this.probeTime - l;
        Share share = null;
        Share share2 = null;
        Share share3 = null;
        while (this.missingDeviceList != null) {
            Share share4 = this.missingDeviceList;
            this.missingDeviceList = share4.shNext;
            if (share4.shRemovedTime <= 86400000L) {
                share4.shRemovedTime = this.probeTime;
            }
            if (share4.shResource == null || share4.shRemovedTime < l2 || this.isDelete) {
                share4.shNext = share;
                share = share4;
                continue;
            }
            if (share4.shRemovedTime == this.probeTime) {
                share4.shNext = share2;
                share2 = share4;
                continue;
            }
            share4.shNext = share3;
            share3 = share4;
        }
        if (share2 != null) {
            this.flagMissingResources(share2);
        }
        if (share != null) {
            this.removeDevices(share);
        }
        this.missingDeviceList = share2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeObsoleteDevices");
        }
    }

    private Share concatLists(Share share, Share share2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"concatLists", (String)"a, b");
        }
        if (share == null) {
            Share share3 = share2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)share3);
            }
            return share3;
        }
        if (share2 == null) {
            Share share4 = share;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)share4);
            }
            return share4;
        }
        Share share5 = share;
        while (share5.shNext != null) {
            share5 = share5.shNext;
        }
        share5.shNext = share2;
        Share share6 = share;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)share6);
        }
        return share6;
    }

    private void flagMissingResources(Share share) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"flagMissingResources", (String)"shList");
        }
        this.shAccessor.prepUpdate();
        Share share2 = share;
        while (share2 != null) {
            this.shAccessor.updateShare(share2);
            share2 = share2.shNext;
        }
        this.shAccessor.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"flagMissingResources");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeDevices(Share share) throws GeneralException {
        Device device;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeDevices", (String)"shList");
        }
        Device device2 = null;
        Share share2 = share;
        while (share2 != null) {
            if (share2.shResource != null) {
                device = (Device)share2.shResource;
                if (device.devUseCount <= 1) {
                    device.devNext = device2;
                    device2 = device;
                }
            }
            share2 = share2.shNext;
        }
        if (device2 != null) {
            this.devAccessor.deleteDevices(device2);
        }
        try {
            this.shAccessor.prepDelete();
            this.devAccessor.prepBumpUseCount();
            share2 = share;
            while (share2 != null) {
                if (share2.shResource != null) {
                    device = (Device)share2.shResource;
                    if (device.devUseCount > 1) {
                        this.devAccessor.bumpUseCount(device, -1);
                    }
                }
                this.shAccessor.deleteShare(share2);
                share2 = share2.shNext;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.shAccessor.closeDelete();
            this.devAccessor.closeUpdate();
            throw throwable;
        }
        this.shAccessor.closeDelete();
        this.devAccessor.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeDevices");
        }
    }

    private void saveCtlrDevAccess() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveCtlrDevAccess", (String)"");
        }
        Controller controller = null;
        Controller controller2 = null;
        Controller controller3 = null;
        Controller controller4 = null;
        DevAccess devAccess = null;
        DevAccess devAccess2 = null;
        DevAccess devAccess3 = null;
        ExtAccess extAccess = null;
        ExtAccess extAccess2 = null;
        TResDevAccess tResDevAccess = new TResDevAccess(this.dbc);
        TResExtCtrlr tResExtCtrlr = new TResExtCtrlr(this.dbc);
        TResController tResController = new TResController(this.dbc);
        TResEntityWWPN tResEntityWWPN = new TResEntityWWPN(this.dbc);
        Controller controller5 = tResController.getControllers(this.computer.cmpID);
        Controller controller6 = this.computer.cmpController;
        Controller controller7 = controller5;
        while (controller6 != null && controller7 != null) {
            Controller controller8;
            int n = controller6.compareKeys(controller7);
            if (n < 0) {
                controller8 = controller6.ctlrNext;
                controller = this.addToList(controller6, controller);
                controller6 = controller8;
                continue;
            }
            if (n > 0) {
                controller8 = controller7.ctlrNext;
                controller2 = this.addToList(controller7, controller2);
                controller7 = controller8;
                continue;
            }
            controller6.ctlrID = controller7.ctlrID;
            controller8 = controller6.ctlrNext;
            if (controller6.equals((Object)controller7)) {
                controller4 = this.addToList(controller6, controller4);
            } else {
                controller3 = this.addToList(controller6, controller3);
            }
            controller6 = controller8;
            controller7 = controller7.ctlrNext;
        }
        controller = this.concatLists(controller6, controller);
        controller2 = this.concatLists(controller7, controller2);
        if (controller != null) {
            tResController.insertControllers(this.computer.cmpID, controller);
        }
        if (controller3 != null) {
            tResController.updateControllers(this.computer.cmpID, controller3);
        }
        if (controller2 != null) {
            tResDevAccess.deleteDevAccess(controller2);
            tResExtCtrlr.deleteExtCtrlr(controller2);
            controller6 = controller2;
            while (controller6 != null) {
                tResEntityWWPN.deleteByEntity_ID(controller6.ctlrID);
                controller6 = controller6.ctlrNext;
            }
            tResEntityWWPN.closeDelete();
            tResController.deleteControllers(this.computer.cmpID, controller2);
        }
        controller3 = this.concatLists(controller4, controller3);
        EntityWWPN entityWWPN = null;
        EntityWWPN entityWWPN2 = null;
        boolean bl = false;
        String string = null;
        String string2 = null;
        if (controller3 != null) {
            controller6 = controller3;
            while (controller6 != null) {
                entityWWPN = tResEntityWWPN.getEntityWWPNs(controller6.ctlrID);
                EntityWWPN entityWWPN3 = controller6.ctlrWWPNs;
                EntityWWPN entityWWPN4 = entityWWPN;
                while (entityWWPN4 != null) {
                    bl = false;
                    string2 = entityWWPN4.sWWPN;
                    EntityWWPN entityWWPN5 = entityWWPN3;
                    EntityWWPN entityWWPN6 = entityWWPN3;
                    while (entityWWPN6 != null) {
                        string = entityWWPN6.sWWPN;
                        if (string2 != null && string != null && string2.equals(string)) {
                            bl = true;
                            if (entityWWPN6.equals(entityWWPN3)) {
                                entityWWPN3 = entityWWPN3.entityWWPNNext;
                                break;
                            }
                            entityWWPN5.entityWWPNNext = entityWWPN6.entityWWPNNext;
                            break;
                        }
                        entityWWPN5 = entityWWPN6;
                        entityWWPN6 = entityWWPN6.entityWWPNNext;
                    }
                    if (!bl) {
                        entityWWPN4.entityWWPNNext = entityWWPN2;
                        entityWWPN2 = entityWWPN4;
                    }
                    entityWWPN4 = entityWWPN4.entityWWPNNext;
                }
                EntityWWPN entityWWPN7 = entityWWPN2;
                while (entityWWPN7 != null) {
                    tResEntityWWPN.deleteByEntity_ID(controller6.ctlrID);
                    entityWWPN7 = entityWWPN7.entityWWPNNext;
                }
                entityWWPN7 = entityWWPN3;
                while (entityWWPN7 != null) {
                    if (this.computer.cmpOSType == 21) {
                        tResEntityWWPN.insert(controller6.ctlrID, (byte)3, entityWWPN7.sWWPN);
                    } else {
                        tResEntityWWPN.insert(controller6.ctlrID, (byte)1, entityWWPN7.sWWPN);
                    }
                    entityWWPN7 = entityWWPN7.entityWWPNNext;
                }
                controller6 = controller6.ctlrNext;
            }
            tResEntityWWPN.closeDelete();
            tResEntityWWPN.closeInsert();
            tResEntityWWPN.closeSelect();
        }
        if (controller3 != null) {
            tResDevAccess.prepSelectByCtlr();
            controller6 = controller3;
            while (controller6 != null) {
                this.setDevAccessIDs(controller6);
                DevAccess devAccess4 = tResDevAccess.getDevAccess(controller6.ctlrID);
                DevAccess devAccess5 = controller6.ctlrDevices;
                DevAccess devAccess6 = devAccess4;
                while (devAccess5 != null && devAccess6 != null) {
                    DevAccess devAccess7;
                    if (devAccess5.daTarget < devAccess6.daTarget || devAccess5.daTarget == devAccess6.daTarget && devAccess5.daLUN < devAccess6.daLUN) {
                        devAccess7 = devAccess5.daNextDevice;
                        devAccess = this.addToList(devAccess5, devAccess);
                        devAccess5 = devAccess7;
                        continue;
                    }
                    if (devAccess5.daTarget > devAccess6.daTarget || devAccess5.daTarget == devAccess6.daTarget && devAccess5.daLUN > devAccess6.daLUN) {
                        devAccess7 = devAccess6.daNextDevice;
                        devAccess2 = this.addToList(devAccess6, devAccess2);
                        devAccess6 = devAccess7;
                        continue;
                    }
                    devAccess7 = devAccess5.daNextDevice;
                    if (!devAccess5.equals((Object)devAccess6)) {
                        devAccess3 = this.addToList(devAccess5, devAccess3);
                    }
                    devAccess5 = devAccess7;
                    devAccess6 = devAccess6.daNextDevice;
                }
                devAccess = this.concatLists(devAccess5, devAccess);
                devAccess2 = this.concatLists(devAccess6, devAccess2);
                controller6 = controller6.ctlrNext;
            }
            tResDevAccess.closeSelect();
        }
        controller6 = controller;
        while (controller6 != null) {
            this.setDevAccessIDs(controller6);
            devAccess = this.concatLists(controller6.ctlrDevices, devAccess);
            EntityWWPN entityWWPN8 = controller6.ctlrWWPNs;
            while (entityWWPN8 != null) {
                if (this.computer.cmpOSType == 21) {
                    tResEntityWWPN.insert(controller6.ctlrID, (byte)3, entityWWPN8.sWWPN);
                } else {
                    tResEntityWWPN.insert(controller6.ctlrID, (byte)1, entityWWPN8.sWWPN);
                }
                entityWWPN8 = entityWWPN8.entityWWPNNext;
            }
            controller6 = controller6.ctlrNext;
        }
        tResEntityWWPN.closeInsert();
        if (devAccess != null) {
            tResDevAccess.insertDevAccess(devAccess);
        }
        if (devAccess3 != null) {
            tResDevAccess.updateDevAccess(devAccess3);
        }
        if (devAccess2 != null) {
            tResDevAccess.deleteDevAccess(devAccess2);
        }
        if (controller3 != null) {
            tResExtCtrlr.prepSelectByCtlr();
            controller6 = controller3;
            while (controller6 != null) {
                boolean bl2;
                this.setExtAccessIDs(controller6);
                ExtAccess extAccess3 = tResExtCtrlr.getExtAccess(controller6.ctlrID);
                ExtAccess extAccess4 = controller6.ctlrExtents;
                ExtAccess extAccess5 = extAccess3;
                while (extAccess4 != null) {
                    bl2 = false;
                    while (extAccess5 != null && !bl2) {
                        if (extAccess4.eaRankID == extAccess5.eaRankID) {
                            bl2 = true;
                            continue;
                        }
                        extAccess5 = extAccess5.eaNextExtent;
                    }
                    ExtAccess extAccess6 = extAccess4.eaNextExtent;
                    if (!bl2) {
                        extAccess = this.addToList(extAccess4, extAccess);
                    }
                    extAccess4 = extAccess6;
                }
                extAccess3 = tResExtCtrlr.getExtAccess(controller6.ctlrID);
                extAccess4 = controller6.ctlrExtents;
                extAccess5 = extAccess3;
                while (extAccess5 != null) {
                    bl2 = false;
                    while (extAccess4 != null && !bl2) {
                        if (extAccess5.eaRankID == extAccess4.eaRankID) {
                            bl2 = true;
                            continue;
                        }
                        extAccess4 = extAccess4.eaNextExtent;
                    }
                    if (!bl2) {
                        extAccess2 = this.addToList(extAccess5, extAccess2);
                    }
                    extAccess5 = extAccess5.eaNextExtent;
                }
                controller6 = controller6.ctlrNext;
            }
            tResExtCtrlr.closeSelect();
        }
        controller6 = controller;
        while (controller6 != null) {
            this.setExtAccessIDs(controller6);
            extAccess = this.concatLists(controller6.ctlrExtents, extAccess);
            controller6 = controller6.ctlrNext;
        }
        if (extAccess != null) {
            tResExtCtrlr.insertExtCtrlr(extAccess);
        }
        if (extAccess2 != null) {
            tResExtCtrlr.deleteExtAccess(extAccess2);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveCtlrDevAccess");
        }
    }

    private Controller addToList(Controller controller, Controller controller2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addToList", (String)"ctlr, ctlrList");
        }
        controller.ctlrNext = controller2;
        Controller controller3 = controller2 = controller;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToList", (Object)controller3);
        }
        return controller3;
    }

    private Controller concatLists(Controller controller, Controller controller2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"concatLists", (String)"a, b");
        }
        if (controller == null) {
            Controller controller3 = controller2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)controller3);
            }
            return controller3;
        }
        if (controller2 == null) {
            Controller controller4 = controller;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)controller4);
            }
            return controller4;
        }
        Controller controller5 = controller;
        while (controller5.ctlrNext != null) {
            controller5 = controller5.ctlrNext;
        }
        controller5.ctlrNext = controller2;
        Controller controller6 = controller;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)controller6);
        }
        return controller6;
    }

    private DevAccess addToList(DevAccess devAccess, DevAccess devAccess2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addToList", (String)"da, daList");
        }
        devAccess.daNextDevice = devAccess2;
        DevAccess devAccess3 = devAccess2 = devAccess;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToList", (Object)devAccess3);
        }
        return devAccess3;
    }

    private ExtAccess addToList(ExtAccess extAccess, ExtAccess extAccess2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addToList", (String)"ea, eaList");
        }
        extAccess.eaNextExtent = extAccess2;
        ExtAccess extAccess3 = extAccess2 = extAccess;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToList", (Object)extAccess3);
        }
        return extAccess3;
    }

    private DevAccess concatLists(DevAccess devAccess, DevAccess devAccess2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"concatLists", (String)"a, b");
        }
        if (devAccess == null) {
            DevAccess devAccess3 = devAccess2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)devAccess3);
            }
            return devAccess3;
        }
        if (devAccess2 == null) {
            DevAccess devAccess4 = devAccess;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)devAccess4);
            }
            return devAccess4;
        }
        DevAccess devAccess5 = devAccess;
        while (devAccess5.daNextDevice != null) {
            devAccess5 = devAccess5.daNextDevice;
        }
        devAccess5.daNextDevice = devAccess2;
        DevAccess devAccess6 = devAccess;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)devAccess6);
        }
        return devAccess6;
    }

    private ExtAccess concatLists(ExtAccess extAccess, ExtAccess extAccess2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"concatLists", (String)"ea_a, ea_b");
        }
        if (extAccess == null) {
            ExtAccess extAccess3 = extAccess2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)extAccess3);
            }
            return extAccess3;
        }
        if (extAccess2 == null) {
            ExtAccess extAccess4 = extAccess;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)extAccess4);
            }
            return extAccess4;
        }
        ExtAccess extAccess5 = extAccess;
        while (extAccess5.eaNextExtent != null) {
            extAccess5 = extAccess5.eaNextExtent;
        }
        extAccess5.eaNextExtent = extAccess2;
        ExtAccess extAccess6 = extAccess;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)extAccess6);
        }
        return extAccess6;
    }

    private void setDevAccessIDs(Controller controller) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setDevAccessIDs", (String)"ctlr");
        }
        DevAccess devAccess = controller.ctlrDevices;
        while (devAccess != null) {
            devAccess.daControllerID = controller.ctlrID;
            devAccess.daDeviceID = devAccess.daDevice.devID;
            devAccess = devAccess.daNextDevice;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setDevAccessIDs");
        }
    }

    private void setExtAccessIDs(Controller controller) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setExtAccessIDs", (String)"ctlr");
        }
        ExtAccess extAccess = controller.ctlrExtents;
        while (extAccess != null) {
            extAccess.eaControllerID = controller.ctlrID;
            extAccess.eaRankID = extAccess.eaRank.rankID;
            extAccess = extAccess.eaNextExtent;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setExtAccessIDs");
        }
    }

    private void lockDevices() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"lockDevices", (String)"");
        }
        int n = 0;
        Device device = this.computer.cmpDevice;
        while (device != null) {
            if (device.isFixedDisk()) {
                ++n;
            }
            device = device.devNext;
        }
        Share share = this.missingDeviceList;
        while (share != null) {
            if (share.shResource != null && (device = (Device)share.shResource).isFixedDisk()) {
                ++n;
            }
            share = share.shNext;
        }
        this.lockedDeviceTable = new int[n];
        int n2 = 0;
        device = this.computer.cmpDevice;
        while (device != null) {
            if (device.isFixedDisk()) {
                this.lockedDeviceTable[n2++] = device.devID;
            }
            device = device.devNext;
        }
        Share share2 = this.missingDeviceList;
        while (share2 != null) {
            if (share2.shResource != null && (device = (Device)share2.shResource).isFixedDisk()) {
                this.lockedDeviceTable[n2++] = device.devID;
            }
            share2 = share2.shNext;
        }
        Arrays.sort(this.lockedDeviceTable);
        LockManager.lock((short)0, (String)"History", (String)"DiskHist", (byte)2, (boolean)true);
        n2 = 0;
        while (n2 < n) {
            int n3 = this.lockedDeviceTable[n2];
            LockManager.lock((short)0, (String)"Device", (String)String.valueOf(n3), (byte)1, (boolean)true);
            ++n2;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"lockDevices");
        }
    }

    private void saveLogicalDisks() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveLogicalDisks", (String)"");
        }
        this.getPhysicalSpaceIDs();
        this.assignLogicalDiskIDs();
        this.saveLogicalDiskShares();
        this.saveNewLogicalDisks();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveLogicalDisks");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveLunWWNs() throws GeneralException {
        TResLunWWN tResLunWWN = new TResLunWWN(this.dbc);
        try {
            tResLunWWN.deleteByComputer(this.computer.cmpID);
            tResLunWWN.prepInsert();
            LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
            while (logicalDisk != null) {
                tResLunWWN.insert(this.computer.cmpID, logicalDisk);
                logicalDisk = logicalDisk.ldNext;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            tResLunWWN.closeDelete();
            tResLunWWN.closeInsert();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        tResLunWWN.closeDelete();
        tResLunWWN.closeInsert();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveEntityWWPNs() throws GeneralException {
        TResEntityWWPN tResEntityWWPN = new TResEntityWWPN(this.dbc);
        EntityWWPN entityWWPN = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            EntityWWPN entityWWPN2;
            EntityWWPN entityWWPN3 = tResEntityWWPN.getEntityWWPNs(this.computer.cmpID);
            EntityWWPN entityWWPN4 = this.computer.cmpEntityWWPN;
            EntityWWPN entityWWPN5 = entityWWPN3;
            while (true) {
                if (entityWWPN5 == null) break;
                bl = false;
                string2 = entityWWPN5.sWWPN;
                EntityWWPN entityWWPN6 = entityWWPN4;
                entityWWPN2 = entityWWPN4;
                while (entityWWPN2 != null) {
                    string = entityWWPN2.sWWPN;
                    if (string2 != null && string != null && string2.equals(string)) {
                        bl = true;
                        if (entityWWPN2.equals(entityWWPN4)) {
                            entityWWPN2 = entityWWPN4 = entityWWPN4.entityWWPNNext;
                            entityWWPN6 = entityWWPN4;
                            break;
                        }
                        entityWWPN6.entityWWPNNext = entityWWPN2.entityWWPNNext;
                        break;
                    }
                    entityWWPN6 = entityWWPN2;
                    entityWWPN2 = entityWWPN2.entityWWPNNext;
                }
                if (!bl) {
                    entityWWPN5.entityWWPNNext = entityWWPN;
                    entityWWPN = entityWWPN5;
                }
                entityWWPN5 = entityWWPN5.entityWWPNNext;
            }
            entityWWPN2 = entityWWPN;
            while (true) {
                if (entityWWPN2 == null) {
                    entityWWPN2 = entityWWPN4;
                    break;
                }
                tResEntityWWPN.deleteByEntity_ID(this.computer.cmpID);
                entityWWPN2 = entityWWPN2.entityWWPNNext;
            }
            while (entityWWPN2 != null) {
                if (this.computer.cmpOSType == 21) {
                    tResEntityWWPN.insert(this.computer.cmpID, (byte)2, entityWWPN2.sWWPN);
                } else {
                    tResEntityWWPN.insert(this.computer.cmpID, (byte)1, entityWWPN2.sWWPN);
                }
                entityWWPN2 = entityWWPN2.entityWWPNNext;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            tResEntityWWPN.closeDelete();
            tResEntityWWPN.closeInsert();
            tResEntityWWPN.closeSelect();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        tResEntityWWPN.closeDelete();
        tResEntityWWPN.closeInsert();
        tResEntityWWPN.closeSelect();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getPhysicalSpaceIDs() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPhysicalSpaceIDs", (String)"");
        }
        try {
            this.chkAccessor.prepSelectByLocation();
            this.colAccessor.prepSelectByLogicalDisk();
            if (this.isDiskArray) {
                this.ldAccessor.prepSelectBySVID();
            } else {
                this.ldAccessor.prepSelectByID();
            }
            this.fsAccessor.prepSelectByMountPoint();
            LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
            while (logicalDisk != null) {
                if (logicalDisk.ldType != 7 && logicalDisk.ldType != 4) {
                    if (logicalDisk.ldNextMirror == null) {
                        if (!this.getLogicalDiskSpace(logicalDisk)) {
                            logicalDisk.ldNewLogicalDisk = true;
                        }
                    } else {
                        LogicalDisk logicalDisk2 = logicalDisk.ldNextMirror;
                        while (logicalDisk2 != null) {
                            if (!this.getLogicalDiskSpace(logicalDisk2)) {
                                logicalDisk.ldNewLogicalDisk = true;
                                break;
                            }
                            logicalDisk2 = logicalDisk2.ldNextMirror;
                        }
                    }
                    if (!logicalDisk.ldNewLogicalDisk && !this.getLogicalDisk(logicalDisk)) {
                        logicalDisk.ldNewLogicalDisk = true;
                    }
                }
                logicalDisk = logicalDisk.ldNext;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.chkAccessor.closeSelect();
            this.colAccessor.closeSelect();
            this.ldAccessor.closeSelect();
            this.fsAccessor.closeSelect();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.chkAccessor.closeSelect();
        this.colAccessor.closeSelect();
        this.ldAccessor.closeSelect();
        this.fsAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPhysicalSpaceIDs");
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean getLogicalDiskSpace(LogicalDisk var1_1) throws GeneralException {
        if (TraceLogger.enableTrace) {
            try {
                v0 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            TraceLogger.entry((String)v0.getName(), (String)"getLogicalDiskSpace", (String)"lDisk");
        }
        var1_1.ldID = -1;
        if (var1_1.ldCollectionList == null) {
            var6_2 = false;
            if (TraceLogger.enableTrace) {
                try {
                    v2 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException v3) {
                    throw new NoClassDefFoundError(v3.getMessage());
                }
                TraceLogger.exit((String)v2.getName(), (String)"getLogicalDiskSpace", (boolean)var6_2);
            }
            return var6_2;
        }
        var2_8 = var1_1.ldCollectionList;
        while (var2_8 != null) {
            var4_9 = var2_8.ccChunkList;
            var5_10 = this.chkAccessor.getChunksByLocation(var4_9);
            while (var4_9 != null && var5_10 != null) {
                if (!var4_9.equals((Object)var5_10)) {
                    var6_3 = false;
                    if (TraceLogger.enableTrace) {
                        try {
                            v4 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                        }
                        catch (ClassNotFoundException v5) {
                            throw new NoClassDefFoundError(v5.getMessage());
                        }
                        TraceLogger.exit((String)v4.getName(), (String)"getLogicalDiskSpace", (boolean)var6_3);
                    }
                    return var6_3;
                }
                var4_9.chkCollectionID = var5_10.chkCollectionID;
                var4_9.chkLogicalDiskID = var5_10.chkLogicalDiskID;
                var4_9 = var4_9.chkNextInCollection;
                var5_10 = var5_10.chkNextInCollection;
            }
            if (var4_9 != null || var5_10 != null) {
                var6_4 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v6 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException v7) {
                        throw new NoClassDefFoundError(v7.getMessage());
                    }
                    TraceLogger.exit((String)v6.getName(), (String)"getLogicalDiskSpace", (boolean)var6_4);
                }
                return var6_4;
            }
            var4_9 = var2_8.ccChunkList;
            if (var1_1.ldID == -1) {
                var1_1.ldID = var4_9.chkLogicalDiskID;
            } else if (var1_1.ldID != var4_9.chkLogicalDiskID) {
                var6_5 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v8 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException v9) {
                        throw new NoClassDefFoundError(v9.getMessage());
                    }
                    TraceLogger.exit((String)v8.getName(), (String)"getLogicalDiskSpace", (boolean)var6_5);
                }
                return var6_5;
            }
            var2_8.ccID = var4_9.chkCollectionID;
            var2_8.ccLogicalDiskID = var4_9.chkLogicalDiskID;
            var2_8 = var2_8.ccNext;
        }
        var3_11 = this.colAccessor.getCollections(var1_1);
        if (var3_11 != null) ** GOTO lbl104
        var6_6 = false;
        if (TraceLogger.enableTrace) {
            try {
                v10 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v11) {
                throw new NoClassDefFoundError(v11.getMessage());
            }
            TraceLogger.exit((String)v10.getName(), (String)"getLogicalDiskSpace", (boolean)var6_6);
        }
        return var6_6;
lbl-1000:
        // 1 sources

        {
            var6_7 = var3_11.ccID;
            var2_8 = var1_1.ldCollectionList;
            while (var2_8 != null && var2_8.ccID != var6_7) {
                var2_8 = var2_8.ccNext;
            }
            if (var2_8 == null) {
                var7_12 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v12 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException v13) {
                        throw new NoClassDefFoundError(v13.getMessage());
                    }
                    TraceLogger.exit((String)v12.getName(), (String)"getLogicalDiskSpace", (boolean)var7_12);
                }
                return var7_12;
            }
            if (var2_8.ccType != var3_11.ccType || var2_8.ccStripingSize != var3_11.ccStripingSize) {
                var7_13 = false;
                if (TraceLogger.enableTrace) {
                    try {
                        v14 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException v15) {
                        throw new NoClassDefFoundError(v15.getMessage());
                    }
                    TraceLogger.exit((String)v14.getName(), (String)"getLogicalDiskSpace", (boolean)var7_13);
                }
                return var7_13;
            }
            var3_11 = var3_11.ccNext;
lbl104:
            // 2 sources

            ** while (var3_11 != null)
        }
lbl105:
        // 1 sources

        var6_7 = 1;
        if (TraceLogger.enableTrace) {
            try {
                v16 = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException v17) {
                throw new NoClassDefFoundError(v17.getMessage());
            }
            TraceLogger.exit((String)v16.getName(), (String)"getLogicalDiskSpace", (boolean)var6_7);
        }
        return (boolean)var6_7;
    }

    private boolean getLogicalDisk(LogicalDisk logicalDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLogicalDisk", (String)"primaryLDisk");
        }
        boolean bl = true;
        LogicalDisk logicalDisk2 = logicalDisk.ldNextMirror;
        while (logicalDisk2 != null) {
            if (!this.cmpLDiskToRepository(logicalDisk2)) {
                boolean bl2 = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getLogicalDisk", (boolean)bl2);
                }
                return bl2;
            }
            if (bl) {
                bl = false;
                logicalDisk.ldID = this.lDiskBuffer.ldParentLogicalDiskID;
            } else if (logicalDisk.ldID != this.lDiskBuffer.ldParentLogicalDiskID) {
                boolean bl3 = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getLogicalDisk", (boolean)bl3);
                }
                return bl3;
            }
            logicalDisk2 = logicalDisk2.ldNextMirror;
        }
        boolean bl4 = this.cmpLDiskToRepository(logicalDisk);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLogicalDisk", (boolean)bl4);
        }
        return bl4;
    }

    private boolean cmpLDiskToRepository(LogicalDisk logicalDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cmpLDiskToRepository", (String)"probeLDisk");
        }
        this.lDiskBuffer.ldID = logicalDisk.ldID;
        if (this.ldAccessor.getLogicalDisk(this.lDiskBuffer, false) && logicalDisk.equals((Object)this.lDiskBuffer)) {
            logicalDisk.ldUseCount = this.lDiskBuffer.ldUseCount;
            logicalDisk.ldSnapSourceID = this.lDiskBuffer.ldSnapSourceID;
            logicalDisk.ldOldFlags = this.lDiskBuffer.getFlags();
            logicalDisk.ldOldVolgroupID = this.lDiskBuffer.ldVolgroupID;
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"cmpLDiskToRepository", (boolean)bl);
            }
            return bl;
        }
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cmpLDiskToRepository", (boolean)bl);
        }
        return bl;
    }

    private void assignLogicalDiskIDs() throws GeneralException {
        LogicalDisk logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"assignLogicalDiskIDs", (String)"");
        }
        int n = 0;
        LogicalDisk logicalDisk2 = this.computer.cmpLogicalDisk;
        while (logicalDisk2 != null) {
            if (logicalDisk2.ldNewLogicalDisk) {
                n += this.countResources(logicalDisk2);
                logicalDisk = logicalDisk2.ldNextMirror;
                while (logicalDisk != null) {
                    n += this.countResources(logicalDisk);
                    logicalDisk = logicalDisk.ldNextMirror;
                }
            }
            logicalDisk2 = logicalDisk2.ldNext;
        }
        if (n > 0) {
            n = TResLogicalDisk.getIdentifier(1, n, this.dbc);
            logicalDisk2 = this.computer.cmpLogicalDisk;
            while (logicalDisk2 != null) {
                if (logicalDisk2.ldNewLogicalDisk) {
                    n = this.setIDs(logicalDisk2, n);
                    logicalDisk = logicalDisk2.ldNextMirror;
                    while (logicalDisk != null) {
                        n = this.setIDs(logicalDisk, n);
                        logicalDisk.ldParentLogicalDiskID = logicalDisk2.ldID;
                        logicalDisk = logicalDisk.ldNextMirror;
                    }
                }
                logicalDisk2 = logicalDisk2.ldNext;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"assignLogicalDiskIDs");
        }
    }

    private int countResources(LogicalDisk logicalDisk) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"countResources", (String)"lDisk");
        }
        int n = 1;
        ChunkCollection chunkCollection = logicalDisk.ldCollectionList;
        while (chunkCollection != null) {
            ++n;
            chunkCollection = chunkCollection.ccNext;
        }
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"countResources", (int)n2);
        }
        return n2;
    }

    private int setIDs(LogicalDisk logicalDisk, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setIDs", (String)"lDisk, identifier");
        }
        logicalDisk.ldID = n++;
        logicalDisk.ldParentLogicalDiskID = -1;
        ChunkCollection chunkCollection = logicalDisk.ldCollectionList;
        while (chunkCollection != null) {
            chunkCollection.ccLogicalDiskID = logicalDisk.ldType == 12 ? -1 : logicalDisk.ldID;
            chunkCollection.ccID = n++;
            Chunk chunk = chunkCollection.ccChunkList;
            while (chunk != null) {
                chunk.chkLogicalDiskID = logicalDisk.ldType == 12 ? -1 : logicalDisk.ldID;
                chunk.chkCollectionID = chunkCollection.ccID;
                chunk = chunk.chkNextInCollection;
            }
            chunkCollection = chunkCollection.ccNext;
        }
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setIDs", (int)n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveLogicalDiskShares() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveLogicalDiskShares", (String)"");
        }
        this.shareBuffer.shResourceType = (short)11;
        this.shareBuffer.shComputerID = this.computer.cmpID;
        this.shareBuffer.shScanTime = this.probeTime;
        this.shareBuffer.shRemovedTime = 0L;
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        try {
            this.shAccessor.prepSave();
            LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
            while (logicalDisk != null) {
                if (logicalDisk.ldType != 7 && logicalDisk.ldType != 4) {
                    this.saveLogicalDiskShare(logicalDisk, mutableBoolean);
                    LogicalDisk logicalDisk2 = logicalDisk.ldNextMirror;
                    while (logicalDisk2 != null) {
                        this.saveLogicalDiskShare(logicalDisk2, mutableBoolean);
                        logicalDisk2 = logicalDisk2.ldNextMirror;
                    }
                }
                logicalDisk = logicalDisk.ldNext;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.shAccessor.closeSave();
            if (mutableBoolean.value) {
                this.ldAccessor.closeUpdate();
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.shAccessor.closeSave();
        if (mutableBoolean.value) {
            this.ldAccessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveLogicalDiskShares");
        }
    }

    private void saveLogicalDiskShare(LogicalDisk logicalDisk, MutableBoolean mutableBoolean) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveLogicalDiskShare", (String)"lDisk, prepared");
        }
        this.shareBuffer.shResourceID = logicalDisk.ldID;
        this.shareBuffer.shPath = logicalDisk.ldPath;
        this.shareBuffer.shName = logicalDisk.ldName;
        boolean bl = this.shAccessor.saveShare(this.shareBuffer, logicalDisk.ldNewLogicalDisk);
        if (logicalDisk.ldNewLogicalDisk) {
            logicalDisk.setSnapSourceID();
        } else {
            boolean bl2;
            int n = logicalDisk.ldSnapSourceID;
            logicalDisk.setSnapSourceID();
            if (bl) {
                logicalDisk.ldUseCount = (short)(logicalDisk.ldUseCount + 1);
                bl2 = true;
            } else {
                boolean bl3 = bl2 = logicalDisk.getFlags() != logicalDisk.ldOldFlags || logicalDisk.ldSnapSourceID != n || logicalDisk.ldVolgroupID != logicalDisk.ldOldVolgroupID;
            }
            if (bl2) {
                if (!mutableBoolean.value) {
                    if (this.isDiskArray) {
                        this.ldAccessor.prepUpdateSVAttributes();
                    } else {
                        this.ldAccessor.prepUpdateAttributes();
                    }
                    mutableBoolean.value = true;
                }
                this.ldAccessor.updateAttributes(logicalDisk);
            }
        }
        this.shAccessor.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveLogicalDiskShare");
        }
    }

    private void saveNewLogicalDisks() throws GeneralException {
        LogicalDisk logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveNewLogicalDisks", (String)"");
        }
        HashSet<ChunkCollection> hashSet = new HashSet<ChunkCollection>();
        if (this.isDiskArray) {
            this.ldAccessor.prepInsertSV();
        } else {
            this.ldAccessor.prepInsert();
        }
        LogicalDisk logicalDisk2 = this.computer.cmpLogicalDisk;
        while (logicalDisk2 != null) {
            if (logicalDisk2.ldNewLogicalDisk) {
                logicalDisk2.ldUseCount = 1;
                this.ldAccessor.insertLogicalDisks(logicalDisk2);
            }
            logicalDisk2 = logicalDisk2.ldNext;
        }
        this.ldAccessor.closeInsert();
        this.colAccessor.prepInsert();
        logicalDisk2 = this.computer.cmpLogicalDisk;
        while (logicalDisk2 != null) {
            if (logicalDisk2.ldNewLogicalDisk) {
                if (logicalDisk2.ldCollectionList != null) {
                    if (!hashSet.contains(logicalDisk2.ldCollectionList)) {
                        this.colAccessor.insertCollections(logicalDisk2.ldCollectionList);
                        hashSet.add(logicalDisk2.ldCollectionList);
                    }
                    if (logicalDisk2.ldType == 12) {
                        this.colAccessor.insertAggregates(logicalDisk2.ldID, logicalDisk2.ldCollectionList.ccID);
                    }
                }
                logicalDisk = logicalDisk2.ldNextMirror;
                while (logicalDisk != null) {
                    this.colAccessor.insertCollections(logicalDisk.ldCollectionList);
                    logicalDisk = logicalDisk.ldNextMirror;
                }
            }
            logicalDisk2 = logicalDisk2.ldNext;
        }
        this.colAccessor.closeInsert();
        this.chkAccessor.prepSave();
        logicalDisk2 = this.computer.cmpLogicalDisk;
        while (logicalDisk2 != null) {
            if (logicalDisk2.ldNewLogicalDisk) {
                this.saveChunks(logicalDisk2.ldCollectionList);
                logicalDisk = logicalDisk2.ldNextMirror;
                while (logicalDisk != null) {
                    this.saveChunks(logicalDisk.ldCollectionList);
                    logicalDisk = logicalDisk.ldNextMirror;
                }
            }
            logicalDisk2 = logicalDisk2.ldNext;
        }
        this.chkAccessor.closeSave();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveNewLogicalDisks");
        }
    }

    private void saveChunks(ChunkCollection chunkCollection) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveChunks", (String)"collection");
        }
        while (chunkCollection != null) {
            this.chkAccessor.saveChunks(chunkCollection.ccChunkList, true, true);
            chunkCollection = chunkCollection.ccNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveChunks");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeObsoleteLogicalDisks() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeObsoleteLogicalDisks", (String)"");
        }
        if (this.isDiskArray) {
            this.updateTStatDisk();
        }
        LogicalDisk logicalDisk = null;
        Share share = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)11, this.probeTime);
        if (share == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"removeObsoleteLogicalDisks");
            }
            return;
        }
        if (this.isDiskArray) {
            this.ldAccessor.prepSelectBySVID();
        } else {
            this.ldAccessor.prepSelectByID();
        }
        Share share2 = share;
        while (share2 != null) {
            if (logicalDisk == null) {
                logicalDisk = new LogicalDisk();
            }
            logicalDisk.ldID = share2.shResourceID;
            if (this.ldAccessor.getLogicalDisk(logicalDisk, false)) {
                // empty if block
            }
            share2.shResource = logicalDisk;
            logicalDisk = null;
            share2 = share2.shNext;
        }
        this.ldAccessor.closeSelect();
        this.chkAccessor.prepDeleteByLogicalDisk();
        this.deleteLogicalDiskDependents(this.chkAccessor, share);
        this.chkAccessor.closeDelete();
        this.colAccessor.prepDeleteByLogicalDisk();
        this.deleteLogicalDiskDependents(this.colAccessor, share);
        this.colAccessor.closeDelete();
        if (this.isDiskArray) {
            this.ldAccessor.prepDeleteSV();
        } else {
            this.ldAccessor.prepDeleteLogicalDisk();
        }
        share2 = share;
        while (share2 != null) {
            if (share2.shResource != null) {
                logicalDisk = (LogicalDisk)share2.shResource;
                if (logicalDisk.ldUseCount <= 1 && logicalDisk.ldParentLogicalDiskID == -1) {
                    this.ldAccessor.deleteLogicalDisk(logicalDisk);
                }
            }
            share2 = share2.shNext;
        }
        this.ldAccessor.closeDelete();
        try {
            if (this.isDiskArray) {
                this.ldAccessor.prepUpdateSVUseCount();
            } else {
                this.ldAccessor.prepUpdateUseCount();
            }
            this.shAccessor.prepDelete();
            share2 = share;
            while (share2 != null) {
                if (share2.shResource != null) {
                    logicalDisk = (LogicalDisk)share2.shResource;
                    if (logicalDisk.ldUseCount > 1) {
                        logicalDisk.ldUseCount = (short)(logicalDisk.ldUseCount - 1);
                        this.ldAccessor.updateUseCount(logicalDisk);
                    }
                }
                this.shAccessor.deleteShare(share2);
                share2 = share2.shNext;
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.ldAccessor.closeUpdate();
            this.shAccessor.closeDelete();
            throw throwable;
        }
        this.ldAccessor.closeUpdate();
        this.shAccessor.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeObsoleteLogicalDisks");
        }
    }

    private void deleteLogicalDiskDependents(StorageRepositoryAccessor storageRepositoryAccessor, Share share) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteLogicalDiskDependents", (String)"repoAccessor, shList");
        }
        Share share2 = share;
        while (share2 != null) {
            if (share2.shResource != null) {
                LogicalDisk logicalDisk = (LogicalDisk)share2.shResource;
                if (logicalDisk.ldUseCount <= 1) {
                    if (logicalDisk.ldNextMirror == null) {
                        storageRepositoryAccessor.deleteByLogicalDisk(logicalDisk);
                    } else {
                        LogicalDisk logicalDisk2 = logicalDisk.ldNextMirror;
                        while (logicalDisk2 != null) {
                            storageRepositoryAccessor.deleteByLogicalDisk(logicalDisk);
                            logicalDisk2 = logicalDisk2.ldNextMirror;
                        }
                    }
                }
            }
            share2 = share2.shNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteLogicalDiskDependents");
        }
    }

    private void updateTStatDisk() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateTStatDisk", (String)"");
        }
        HashMap<String, LogicalDisk> hashMap = new HashMap<String, LogicalDisk>();
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            String string = logicalDisk.ldPath;
            if (this.computer.cmpOSType == 21) {
                int n = logicalDisk.ldPath.indexOf(":");
                if (n > 0) {
                    string = logicalDisk.ldPath.substring(n + 1);
                }
            } else if (this.computer.cmpOSType == 15) {
                string = logicalDisk.ldPath.substring(8);
            } else if (this.computer.cmpOSType == 14) {
                string = logicalDisk.ldTruePath;
            }
            hashMap.put(string, logicalDisk);
            logicalDisk = logicalDisk.ldNext;
        }
        TStatDisk tStatDisk = new TStatDisk(this.dbc);
        NameList nameList = tStatDisk.selectHostLUNs(this.computer);
        tStatDisk = null;
        while (nameList != null) {
            logicalDisk = (LogicalDisk)hashMap.get(nameList.nlName);
            int n = logicalDisk != null ? logicalDisk.ldID : -1;
            if (nameList.nlID2 != n) {
                if (tStatDisk == null) {
                    tStatDisk = new TStatDisk(this.dbc);
                    tStatDisk.prepUpdateLogicalDiskID();
                }
                tStatDisk.updateLogicalDiskID(nameList.nlID, n, true);
            }
            nameList = nameList.nlNext;
        }
        if (tStatDisk != null) {
            tStatDisk.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateTStatDisk");
        }
    }

    private void saveFilesystems() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveFilesystems", (String)"");
        }
        this.getRepoFilesystems();
        this.relocateFilesystems();
        if (this.isVirtualServer) {
            this.resetScanComputer(this.computer.cmpLogicalDisk, this.computer.cmpID, this.computer.cmpNodeHostedID);
        }
        this.assignFilesystemIDs();
        this.updateFilesystemStats();
        this.saveNewFilesystems();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveFilesystems");
        }
    }

    private void getRepoFilesystems() throws GeneralException {
        Filesystem filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getRepoFilesystems", (String)"");
        }
        this.fsAccessor.prepSelectByLogicalDisk();
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null) {
                filesystem = logicalDisk.ldFilesystem;
                filesystem.fsID = -1;
                filesystem.fsLogDiskID = filesystem.fsLogDisk != null ? filesystem.fsLogDisk.ldID : -1;
                if (!logicalDisk.ldNewLogicalDisk && logicalDisk.ldRepoFilesystem == null && logicalDisk.ldID != 0) {
                    logicalDisk.ldRepoFilesystem = this.fsAccessor.getByLogicalDisk(logicalDisk.ldID);
                }
            }
            logicalDisk = logicalDisk.ldNext;
        }
        this.fsAccessor.closeSelect();
        this.fsAccessor.prepSelectByMountPoint();
        logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null) {
                filesystem = logicalDisk.ldFilesystem;
                Filesystem filesystem2 = logicalDisk.ldRepoFilesystem;
                if (filesystem2 == null || !filesystem2.fsMountPoint.equals(filesystem.fsMountPoint) && filesystem2.fsUseCount <= 1 && filesystem2.fsComputerID == this.computer.cmpID) {
                    long l = filesystem.fsCapacity;
                    filesystem.fsComputerID = this.computer.cmpID;
                    this.fsAccessor.getByMountPoint(filesystem);
                    filesystem.fsCapacity = l;
                } else {
                    filesystem.fsID = filesystem2.fsID;
                    filesystem.fsLogicalDiskID = logicalDisk.ldID;
                    filesystem.fsComputerID = filesystem2.fsComputerID;
                    filesystem.fsUseCount = filesystem2.fsUseCount;
                }
            }
            logicalDisk = logicalDisk.ldNext;
        }
        this.fsAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getRepoFilesystems");
        }
    }

    private void relocateFilesystems() throws GeneralException {
        Filesystem filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"relocateFilesystems", (String)"");
        }
        boolean bl = false;
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldRepoFilesystem != null) {
                filesystem = logicalDisk.ldFilesystem;
                Filesystem filesystem2 = logicalDisk.ldRepoFilesystem;
                if (filesystem2.fsUseCount <= 1 && filesystem2.fsComputerID == this.computer.cmpID && !filesystem.fsMountPoint.equals(filesystem2.fsMountPoint)) {
                    if (!bl) {
                        this.fsAccessor.prepUpdateLogicalDisk();
                        bl = true;
                    }
                    filesystem2.fsLogicalDiskID = -1;
                    this.fsAccessor.updateLogicalDisk(filesystem2);
                }
            }
            logicalDisk = logicalDisk.ldNext;
        }
        logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null && logicalDisk.ldFilesystem.fsID != -1) {
                filesystem = logicalDisk.ldFilesystem;
                if (filesystem.fsLogicalDiskID != logicalDisk.ldID) {
                    if (filesystem.fsUseCount <= 1 && filesystem.fsComputerID == this.computer.cmpID) {
                        if (!bl) {
                            this.fsAccessor.prepUpdateLogicalDisk();
                            bl = true;
                        }
                        filesystem.fsLogicalDiskID = logicalDisk.ldID;
                        this.fsAccessor.updateLogicalDisk(filesystem);
                    } else {
                        filesystem.fsID = -1;
                    }
                }
            }
            logicalDisk = logicalDisk.ldNext;
        }
        if (bl) {
            this.fsAccessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"relocateFilesystems");
        }
    }

    private void assignFilesystemIDs() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"assignFilesystemIDs", (String)"");
        }
        int n = 0;
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null && logicalDisk.ldFilesystem.fsID == -1) {
                logicalDisk.ldFilesystem.fsNewFilesystem = true;
                ++n;
            }
            logicalDisk = logicalDisk.ldNext;
        }
        if (n > 0) {
            if (Constants.isNasBox((short)this.computer.cmpOSType)) {
                TFoundFilesystem tFoundFilesystem = new TFoundFilesystem(this.dbc);
                if (tFoundFilesystem.getIDsForProbe(this.computer)) {
                    this.updateScheduler = true;
                }
            } else {
                n = TResFS.getIdentifier(1, n, this.dbc);
                logicalDisk = this.computer.cmpLogicalDisk;
                while (logicalDisk != null) {
                    if (logicalDisk.ldFilesystem != null && logicalDisk.ldFilesystem.fsID == -1) {
                        logicalDisk.ldFilesystem.fsID = n++;
                    }
                    logicalDisk = logicalDisk.ldNext;
                }
                this.updateScheduler = true;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"assignFilesystemIDs");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFilesystemStats() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateFilesystemStats", (String)"");
        }
        this.shareBuffer.shScanTime = this.probeTime;
        this.shareBuffer.shRemovedTime = 0L;
        boolean bl = false;
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null) {
                bl = logicalDisk.ldFilesystem.fsExportName != null;
                break;
            }
            logicalDisk = logicalDisk.ldNext;
        }
        try {
            this.fsAccessor.prepProbeUpdate(bl);
            this.fsAccessor.prepUpdateUseCount();
            this.shAccessor.prepSave();
            this.shareBuffer.shComputerID = this.computer.cmpID;
            this.shareBuffer.shResourceType = (short)3;
            this.shareBuffer.shPath = " ";
            logicalDisk = this.computer.cmpLogicalDisk;
            while (logicalDisk != null) {
                if (logicalDisk.ldFilesystem != null) {
                    Filesystem filesystem = logicalDisk.ldFilesystem;
                    this.shareBuffer.shResourceID = filesystem.fsID;
                    boolean bl2 = this.shAccessor.saveShare(this.shareBuffer, filesystem.fsNewFilesystem);
                    if (!filesystem.fsNewFilesystem) {
                        if (bl2 && !Constants.isNasBox((short)this.computer.cmpOSType)) {
                            filesystem.fsUseCount = (short)(filesystem.fsUseCount + 1);
                            this.fsAccessor.updateUseCount(filesystem);
                        }
                        if (!this.fsAccessor.probeUpdate(filesystem)) {
                            filesystem.fsNewFilesystem = true;
                        }
                    }
                    this.shAccessor.commit();
                }
                logicalDisk = logicalDisk.ldNext;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fsAccessor.closeUpdate();
            this.shAccessor.closeSave();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.fsAccessor.closeUpdate();
        this.shAccessor.closeSave();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateFilesystemStats");
        }
    }

    private void saveNewFilesystems() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveNewFilesystems", (String)"");
        }
        this.fsAccessor.prepInsert();
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null && logicalDisk.ldFilesystem.fsNewFilesystem) {
                Filesystem filesystem = logicalDisk.ldFilesystem;
                filesystem.fsLogicalDiskID = logicalDisk.ldID;
                filesystem.fsComputerID = this.computer.cmpID;
                if (!Constants.isNasBox((short)this.computer.cmpOSType) && !Constants.isVirtualServer((int)this.computer.cmpOSType)) {
                    filesystem.fsScanningCompID = this.computer.cmpID;
                }
                filesystem.fsGroupID = 3;
                filesystem.fsUseCount = 1;
                filesystem.fsScanTime = 0L;
                this.fsAccessor.insert(filesystem);
            }
            logicalDisk = logicalDisk.ldNext;
        }
        this.fsAccessor.closeInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveNewFilesystems");
        }
    }

    private void saveFSHist() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveFSHist", (String)"");
        }
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null) break;
            logicalDisk = logicalDisk.ldNext;
        }
        if (logicalDisk == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"saveFSHist");
            }
            return;
        }
        TStatSpaceHist tStatSpaceHist = new TStatSpaceHist(this.dbc);
        long l = tStatSpaceHist.getMaxFsHistTime(logicalDisk.ldFilesystem.fsID, (byte)0);
        long l2 = this.probeTime - l;
        if (l2 >= 86400000L) {
            CuStatDef cuStatDef = new CuStatDef();
            cuStatDef.sdDailyRetention = this.settings.seFSDailyHist;
            cuStatDef.sdWeeklyRetention = this.settings.seFSWeeklyHist;
            cuStatDef.sdMonthlyRetention = this.settings.seFSMonthlyHist;
            SSummaryHist sSummaryHist = new SSummaryHist();
            sSummaryHist.sumStatisticID = 1;
            sSummaryHist.sumFileCount = -1L;
            tStatSpaceHist.prepFSHistSave();
            logicalDisk = this.computer.cmpLogicalDisk;
            while (logicalDisk != null) {
                Filesystem filesystem = logicalDisk.ldFilesystem;
                if (filesystem != null) {
                    sSummaryHist.sumFilesystemID = filesystem.fsID;
                    sSummaryHist.sumScanTime = this.probeTime;
                    sSummaryHist.sumTotalSize = filesystem.fsCapacity;
                    sSummaryHist.sumFreeSpace = filesystem.fsFreeSpace;
                    sSummaryHist.sumUsedSpace = filesystem.fsUsedSpace;
                    tStatSpaceHist.saveHist(cuStatDef, sSummaryHist);
                }
                logicalDisk = logicalDisk.ldNext;
            }
            tStatSpaceHist.closeHistSave();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveFSHist");
        }
    }

    private void gatherObsoleteFilesystems() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"gatherObsoleteFilesystems", (String)"");
        }
        long l = (long)this.settings.seKeepRemovedFS * 86400000L;
        long l2 = this.probeTime - l;
        this.removeFSList = null;
        Share share = null;
        Share share2 = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)3, this.probeTime);
        if (share2 == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"gatherObsoleteFilesystems");
            }
            return;
        }
        this.fsAccessor.prepSelectByID();
        Share share3 = share2;
        while (share3 != null) {
            share3.shResource = this.fsAccessor.getByID(share3.shResourceID);
            share3 = share3.shNext;
        }
        this.fsAccessor.closeSelect();
        while (share2 != null) {
            share3 = share2;
            share2 = share3.shNext;
            if (share3.shRemovedTime <= 86400000L) {
                share3.shRemovedTime = this.probeTime;
            }
            if (share3.shResource == null || share3.shRemovedTime < l2 || this.fsWasRelocated((Filesystem)share3.shResource) || this.isDelete) {
                share3.shNext = this.removeFSList;
                this.removeFSList = share3;
                continue;
            }
            if (share3.shRemovedTime == this.probeTime) {
                share3.shNext = share;
                share = share3;
                continue;
            }
            share3.shNext = this.missingFSList;
            this.missingFSList = share3;
        }
        if (share != null) {
            this.flagMissingFilesystems(share);
        }
        this.missingFSList = share;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"gatherObsoleteFilesystems");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flagMissingFilesystems(Share share) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"flagMissingFilesystems", (String)"flagShList");
        }
        try {
            this.shAccessor.prepUpdate();
            this.fsAccessor.prepUpdateLogicalDisk();
            Share share2 = share;
            while (share2 != null) {
                this.shAccessor.updateShare(share2);
                if (share2.shResource != null) {
                    Filesystem filesystem = (Filesystem)share2.shResource;
                    int n = this.ldAccessor.getUseCount(filesystem.fsLogicalDiskID);
                    if (n <= 1 && filesystem.fsComputerID == this.computer.cmpID) {
                        filesystem.fsLogicalDiskID = -1;
                        this.fsAccessor.updateLogicalDisk(filesystem);
                    }
                }
                share2 = share2.shNext;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.shAccessor.cleanup();
            this.fsAccessor.closeUpdate();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.shAccessor.cleanup();
        this.fsAccessor.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"flagMissingFilesystems");
        }
    }

    private void removeObsoleteFilesystems() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeObsoleteFilesystems", (String)"");
        }
        if (this.removeFSList == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"removeObsoleteFilesystems");
            }
            return;
        }
        this.resetScanComputer(this.removeFSList);
        this.removeFilesystems(this.removeFSList);
        this.updateScheduler = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeObsoleteFilesystems");
        }
    }

    private void analyzeAlerts() throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"analyzeAlerts", (String)"");
        }
        ProbeAlerter probeAlerter = new ProbeAlerter(this.dbc, this.oldComputer, this.computer, this.missingDeviceList, this.missingFSList);
        probeAlerter.alert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"analyzeAlerts");
        }
    }

    private boolean fsWasRelocated(Filesystem filesystem) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fsWasRelocated", (String)"fs");
        }
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldFilesystem != null && filesystem.fsMountPoint.equals(logicalDisk.ldFilesystem.fsMountPoint)) {
                boolean bl = true;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"fsWasRelocated", (boolean)bl);
                }
                return bl;
            }
            logicalDisk = logicalDisk.ldNext;
        }
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fsWasRelocated", (boolean)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetScanComputer(LogicalDisk logicalDisk, int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"resetScanComputer", (String)"pLD, hostComputer, newScanningCID");
        }
        this.fsAccessor.prepSelectScanningCompID();
        this.fsAccessor.prepUpdateScanComputer();
        try {
            try {
                LogicalDisk logicalDisk2 = logicalDisk;
                while (logicalDisk2 != null) {
                    int n3 = logicalDisk2.ldFilesystem.fsID;
                    int n4 = this.fsAccessor.selectScanningCompID(n3);
                    if (n2 != n4) {
                        this.fsAccessor.updateScanComputer(n, n2, n3);
                        this.updateScheduler = true;
                    }
                    logicalDisk2 = logicalDisk2.ldNext;
                }
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"resetScanComputer", (Throwable)localizableException);
                }
                localizableException.print();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fsAccessor.closeUpdate();
            this.fsAccessor.closeSelect();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        this.fsAccessor.closeUpdate();
        this.fsAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"resetScanComputer");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetScanComputer(Share share) throws GeneralException {
        block16: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"resetScanComputer", (String)"shList");
            }
            boolean bl = false;
            try {
                Share share2 = share;
                while (share2 != null) {
                    if (share2.shResource != null) {
                        Filesystem filesystem = (Filesystem)share2.shResource;
                        if (filesystem.fsUseCount > 1 && filesystem.fsComputerID == this.computer.cmpID) {
                            Share share3;
                            if (!bl) {
                                bl = true;
                                this.shAccessor.prepGetAnotherComputer();
                                this.fsAccessor.prepUpdateScanComputer();
                            }
                            if ((share3 = this.shAccessor.getAnotherComputer(filesystem.fsID, (short)3, filesystem.fsComputerID)) != null) {
                                filesystem.fsComputerID = share3.shComputerID;
                                this.fsAccessor.updateScanComputer(filesystem);
                                this.updateScheduler = true;
                            } else {
                                filesystem.fsUseCount = 1;
                            }
                        }
                    }
                    share2 = share2.shNext;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (bl) {
                    this.shAccessor.closeSelect();
                    this.fsAccessor.closeUpdate();
                }
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (!bl) break block16;
            }
            this.shAccessor.closeSelect();
            this.fsAccessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"resetScanComputer");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeFilesystems(Share share) throws GeneralException {
        Filesystem filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeFilesystems", (String)"shList");
        }
        Filesystem filesystem2 = null;
        Share share2 = share;
        while (share2 != null) {
            if (share2.shResource != null) {
                filesystem = (Filesystem)share2.shResource;
                if (filesystem.fsUseCount <= 1) {
                    filesystem.fsNext = filesystem2;
                    filesystem2 = filesystem;
                }
            }
            share2 = share2.shNext;
        }
        this.shAccessor.closeSelect();
        try {
            this.shAccessor.prepDelete();
            if (filesystem2 != null) {
                this.fsAccessor.deleteFS(filesystem2, true);
            }
            this.fsAccessor.prepUpdateUseCount();
            share2 = share;
            while (share2 != null) {
                if (share2.shResource != null) {
                    filesystem = (Filesystem)share2.shResource;
                    if (filesystem.fsUseCount > 1) {
                        filesystem.fsUseCount = (short)(filesystem.fsUseCount - 1);
                        this.fsAccessor.updateUseCount(filesystem);
                    }
                }
                this.shAccessor.deleteShare(share2);
                share2 = share2.shNext;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.shAccessor.closeDelete();
            this.fsAccessor.closeUpdate();
            throw throwable;
        }
        this.shAccessor.closeDelete();
        this.fsAccessor.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeFilesystems");
        }
    }

    private void saveExports() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveExports", (String)"");
        }
        Export export = null;
        Export export2 = null;
        Export export3 = null;
        TResExport tResExport = new TResExport(this.dbc);
        byte by = -1;
        if (Constants.isNasBox((short)this.computer.cmpOSType) && this.computer.cmpExport != null) {
            by = this.computer.cmpExport.xpProtocol;
        }
        Export export4 = tResExport.selectByComputer(this.computer.cmpID, by);
        while (export4 != null && this.computer.cmpExport != null) {
            Export export5 = export4;
            Export export6 = this.computer.cmpExport;
            int n = export6.xpExportName.compareTo(export5.xpExportName);
            if (n < 0) {
                this.computer.cmpExport = export6.xpNext;
                export2 = this.addToList(export6, export2);
                continue;
            }
            if (n > 0) {
                export4 = export5.xpNext;
                export = this.addToList(export5, export);
                continue;
            }
            this.computer.cmpExport = export6.xpNext;
            export4 = export5.xpNext;
            if (export6.xpProtocol == export5.xpProtocol && export6.xpPath.equals(export5.xpPath)) continue;
            export6.xpExportID = export5.xpExportID;
            export3 = this.addToList(export6, export3);
        }
        export2 = this.concatLists(this.computer.cmpExport, export2);
        export = this.concatLists(export4, export);
        if (Constants.isVirtualServer((int)this.computer.cmpOSType)) {
            Export export7 = export2;
            while (export7 != null) {
                export7.xpComputerID = this.computer.cmpID;
                export7 = export7.xpNext;
            }
            export7 = export3;
            while (export7 != null) {
                export7.xpComputerID = this.computer.cmpID;
                export7 = export7.xpNext;
            }
        }
        tResExport.delete(export);
        tResExport.update(export3);
        tResExport.insert(export2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveExports");
        }
    }

    private Export addToList(Export export, Export export2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addToList", (String)"export, exportList");
        }
        export.xpNext = export2;
        Export export3 = export2 = export;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToList", (Object)export3);
        }
        return export3;
    }

    private Export concatLists(Export export, Export export2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"concatLists", (String)"a, b");
        }
        if (export == null) {
            Export export3 = export2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)export3);
            }
            return export3;
        }
        if (export2 == null) {
            Export export4 = export;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)export4);
            }
            return export4;
        }
        Export export5 = export;
        while (export5.xpNext != null) {
            export5 = export5.xpNext;
        }
        export5.xpNext = export2;
        Export export6 = export;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"concatLists", (Object)export6);
        }
        return export6;
    }

    private void saveLdapTrees() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveLdapTrees", (String)"");
        }
        if (this.computer.cmpLdapTree != null) {
            TResLdapTree tResLdapTree = new TResLdapTree(this.dbc);
            tResLdapTree.save(this.computer.cmpLdapTree);
            tResLdapTree = null;
            this.shareBuffer.shResourceType = (short)66;
            this.shareBuffer.shComputerID = this.computer.cmpID;
            this.shareBuffer.shScanTime = this.probeTime;
            this.shareBuffer.shRemovedTime = 0L;
            this.shareBuffer.shPath = " ";
            this.shAccessor = new TResShare(this.dbc);
            this.shAccessor.prepSave();
            LdapTree ldapTree = this.computer.cmpLdapTree;
            while (ldapTree != null) {
                this.shareBuffer.shResource = ldapTree;
                this.shareBuffer.shResourceID = ldapTree.ltTreeID;
                this.shAccessor.saveShare(this.shareBuffer, false);
                this.shAccessor.commit();
                ldapTree = ldapTree.ltNext;
            }
            this.shAccessor.closeSave();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveLdapTrees");
        }
    }

    private void removeObsoleteLdapTrees() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeObsoleteLdapTrees", (String)"");
        }
        Share share = null;
        Share share2 = null;
        share = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)66, this.probeTime);
        if (share != null) {
            share2 = this.isDelete ? share : this.shAccessor.setRemovedTime(share, this.probeTime, this.settings.seKeepRemovedFS);
        }
        if (share2 != null) {
            this.removeTreeShares(share2);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeObsoleteLdapTrees");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeTreeShares(Share share) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeTreeShares", (String)"removeList");
        }
        this.shAccessor.prepDelete();
        this.shAccessor.prepGetAnotherComputer();
        try {
            Share share2 = share;
            while (share2 != null) {
                Object var4_4;
                try {
                    LockManager.lock((short)0, (String)"LdapTree", (String)Integer.toString(share2.shResourceID), (byte)1, (boolean)true);
                    Share share3 = this.shAccessor.getAnotherComputer(share2.shResourceID, (short)66, this.computer.cmpID);
                    if (share3 != null) {
                        this.setComputerForTree(share2.shResourceID, share3.shComputerID);
                    } else {
                        this.removeTree(share2.shResourceID);
                    }
                    this.shAccessor.deleteShare(share2);
                }
                catch (Throwable throwable) {
                    var4_4 = null;
                    LockManager.unLock((short)0, (String)"LdapTree", (String)Integer.toString(share2.shResourceID));
                    throw throwable;
                }
                {
                    var4_4 = null;
                }
                LockManager.unLock((short)0, (String)"LdapTree", (String)Integer.toString(share2.shResourceID));
                share2 = share2.shNext;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.shAccessor.closeSelect();
            this.shAccessor.closeDelete();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.shAccessor.closeSelect();
        this.shAccessor.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeTreeShares");
        }
    }

    private void setComputerForTree(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setComputerForTree", (String)"treeID, computerID");
        }
        TResLdapTree tResLdapTree = new TResLdapTree(this.dbc);
        tResLdapTree.updateComputerID(n, n2, this.computer.cmpID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setComputerForTree");
        }
    }

    private void removeTree(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeTree", (String)"treeID");
        }
        TResShare tResShare = new TResShare(this.dbc);
        Share share = tResShare.getRemovedResources(n, (short)1, 0L);
        tResShare = null;
        FilerSaver filerSaver = new FilerSaver(this.dbc, -1);
        filerSaver.removeFilers(share, true);
        filerSaver = null;
        StorageRepositoryAccessor storageRepositoryAccessor = new StorageRepositoryAccessor(this.dbc);
        storageRepositoryAccessor.deleteByIdColumn("t_res_domain", "tree_id", n);
        storageRepositoryAccessor.deleteByIdColumn("t_res_ldap_tree", "tree_id", n);
        storageRepositoryAccessor.deleteByIdColumn("t_res_share", "computer_id", n);
        this.updateScheduler = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeTree");
        }
    }

    private void removeNasFilers(boolean bl) throws GeneralException {
        int n;
        FilerSaver filerSaver;
        int n2;
        Object object;
        Object object2;
        Object object3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeNasFilers", (String)"removeAll");
        }
        if (Constants.isNasBox((short)this.computer.cmpOSType) || Constants.isDiskArray((short)this.computer.cmpOSType) || Constants.isVirtualServer((int)this.computer.cmpOSType)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"removeNasFilers");
            }
            return;
        }
        Share share = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)78, this.probeTime);
        Share share2 = null;
        if (this.computer.cmpClusterID != 0 && (object3 = ((TStatComputer)(object2 = new TStatComputer(this.dbc))).selectAgentsInCluster(this.computer.cmpClusterID)) != null && ((NameList)object3).nlNext == null) {
            object = new int[]{99};
            share2 = this.shAccessor.getByCompAndResType(this.computer.cmpClusterID, (int[])object);
        }
        if ((object2 = this.concatLists(share, share2)) != null) {
            object3 = new FilerSaver(this.dbc, this.computer.cmpID);
            ((FilerSaver)object3).removeFilers((Share)object2, false);
        }
        if (Constants.isWindows((short)this.computer.cmpOSType) && (object = (Object)this.shAccessor.getRemovedResources(n2 = this.computer.cmpID, (short)1, this.probeTime)) != null) {
            filerSaver = new FilerSaver(this.dbc, n2);
            filerSaver.removeFilers((Share)object, false);
            this.shAccessor.deleteByCompAndResType(n2, new int[]{1, 68});
        }
        if (!Constants.isWindows((short)this.computer.cmpOSType)) {
            n = this.computer.cmpID;
        } else {
            if (this.cmpAccessor.domainHasOtherOSAgents(this.computer.cmpDomainID, this.computer.cmpID)) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"removeNasFilers");
                }
                return;
            }
            n = this.computer.cmpDomainID;
        }
        object = this.shAccessor.getRemovedResources(n, (short)1, this.probeTime);
        if (object != null) {
            filerSaver = new FilerSaver(this.dbc, n);
            filerSaver.removeFilers((Share)object, false);
            this.shAccessor.deleteByCompAndResType(n, new int[]{1, 68});
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeNasFilers");
        }
    }

    private void removeVirtualServers(Computer computer, FilerSaver filerSaver) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeVirtualServers", (String)"cmp, filerSaver");
        }
        int n = this.cmpAccessor.getClusterID(computer);
        Share share = this.shAccessor.getRemovedResources(n, (short)99, this.probeTime);
        filerSaver.removeFilers(share, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeVirtualServers");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveComputerHist() throws GeneralException {
        block10: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"saveComputerHist", (String)"");
            }
            if (this.computer.cmpHistory == null) break block10;
            try {
                Object object = this.computer.cmpHistory;
                while (true) {
                    block11: {
                        if (object != null) break block11;
                        LockManager.lock((short)0, (String)"History", (String)"CompHist", (byte)2, (boolean)true);
                        object = new TStatCompHist(this.dbc);
                        ((TStatCompHist)object).save(this.computer.cmpHistory);
                        break;
                    }
                    ((CompHist)object).chComputerID = this.computer.cmpID;
                    object = ((CompHist)object).chNext;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                LockManager.unLock((short)0, (String)"History", (String)"CompHist");
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            LockManager.unLock((short)0, (String)"History", (String)"CompHist");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveComputerHist");
        }
    }

    private void deleteOtherStuff(boolean bl) throws GeneralException {
        RepositoryAccessor repositoryAccessor;
        StorageRepositoryAccessor storageRepositoryAccessor;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteOtherStuff", (String)"removeAll");
        }
        if (bl) {
            storageRepositoryAccessor = new TResDevAccess(this.dbc);
            ((TResDevAccess)storageRepositoryAccessor).deleteByComputer(this.computer.cmpID);
        }
        storageRepositoryAccessor = new StorageRepositoryAccessor(this.dbc);
        if (bl) {
            if (this.isDiskArray) {
                repositoryAccessor = new TResEntityWWPN(this.dbc);
                if (this.computer.cmpOSType == 21) {
                    EntityWWPN entityWWPN;
                    if (this.computer.cmpEntityWWPN == null) {
                        this.computer.cmpEntityWWPN = entityWWPN = ((TResEntityWWPN)repositoryAccessor).getEntityWWPNs(this.computer.cmpID);
                    }
                    this.updateExistingStorageSystemLUNs((byte)0);
                    entityWWPN = null;
                    TResController tResController = new TResController(this.dbc);
                    EntityWWPN entityWWPN2 = entityWWPN = tResController.getControllers(this.computer.cmpID);
                    while (entityWWPN2 != null) {
                        storageRepositoryAccessor.deleteByIdColumn("t_res_entity_wwpn", "entity_id", entityWWPN2.ctlrID);
                        entityWWPN2 = entityWWPN2.ctlrNext;
                    }
                } else {
                    EntityWWPN entityWWPN = ((TResEntityWWPN)repositoryAccessor).getEntityWWPNs(this.computer.cmpID);
                    boolean bl2 = false;
                    int n = -1;
                    EntityWWPN entityWWPN3 = entityWWPN;
                    while (entityWWPN3 != null) {
                        n = ((TResEntityWWPN)repositoryAccessor).getEntityIdByWWPN((byte)3, entityWWPN3.sWWPN);
                        if (n != -1) {
                            bl2 = true;
                            break;
                        }
                        entityWWPN3 = entityWWPN3.entityWWPNNext;
                    }
                    if (bl2) {
                        this.updateSavedSVCDiskIdentity(n, (byte)2);
                    }
                }
                storageRepositoryAccessor.deleteByComputer("t_res_entity_wwpn", this.computer.cmpID);
                storageRepositoryAccessor.deleteByComputer("t_res_disk_group", this.computer.cmpID);
            } else {
                storageRepositoryAccessor.deleteByComputer("t_res_export", this.computer.cmpID);
                storageRepositoryAccessor.deleteByComputer("t_stat_ping_hist", this.computer.cmpID);
                storageRepositoryAccessor.deleteByComputer("t_stat_comp_hist", this.computer.cmpID);
                storageRepositoryAccessor.deleteByComputer("t_res_comp_user", this.computer.cmpID);
                storageRepositoryAccessor.deleteByComputer("t_res_user_group", this.computer.cmpID);
                storageRepositoryAccessor.deleteByComputer("t_res_directory", this.computer.cmpID);
            }
            storageRepositoryAccessor.deleteByComputer("t_res_controller", this.computer.cmpID);
        }
        if (bl) {
            storageRepositoryAccessor.deleteByFilesystem("t_stat_fs_hist", this.computer.cmpID);
        }
        storageRepositoryAccessor.deleteByFilesystem("t_stat_group_hist", this.computer.cmpID);
        storageRepositoryAccessor.deleteByFilesystem("t_stat_space_hist", this.computer.cmpID);
        storageRepositoryAccessor.deleteByFilesystem("t_stat_time_hist", this.computer.cmpID);
        storageRepositoryAccessor.deleteByFilesystem("t_stat_user_hist", this.computer.cmpID);
        storageRepositoryAccessor.deleteByFilesystem("t_stat_ftype_hist", this.computer.cmpID);
        storageRepositoryAccessor.deleteByFilesystem("t_stat_user", this.computer.cmpID);
        storageRepositoryAccessor.deleteByFilesystem("t_stat_group", this.computer.cmpID);
        if (bl) {
            storageRepositoryAccessor.deleteByDisk("t_stat_disk_hist", this.computer.cmpID);
        }
        if (Constants.isNasBox((short)this.computer.cmpOSType)) {
            this.fsAccessor.resetNasScanComputer(this.computer.cmpID);
        } else if (Constants.isDiskArray((short)this.computer.cmpOSType)) {
            repositoryAccessor = new TResDiskArray(this.dbc);
            ((TResDiskArray)repositoryAccessor).resetProbingComputer(this.computer.cmpID);
        } else {
            this.fsAccessor.resetScanComputer(this.computer.cmpID);
            repositoryAccessor = new TResDiskArray(this.dbc);
            ((TResDiskArray)repositoryAccessor).resetAllProbingComputers(this.computer.cmpID);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteOtherStuff");
        }
    }

    private void unLockDevices() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"unLockDevices", (String)"");
        }
        LockManager.unLock((short)0, (String)"History", (String)"DiskHist");
        if (this.lockedDeviceTable != null) {
            int n = 0;
            while (n < this.lockedDeviceTable.length) {
                LockManager.unLock((short)0, (String)"Device", (String)String.valueOf(this.lockedDeviceTable[n]));
                ++n;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"unLockDevices");
        }
    }

    private void cleanup() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanup", (String)"");
        }
        this.warningResponse = null;
        this.settings = null;
        this.computer = null;
        this.oldComputer = null;
        this.shareBuffer.shResource = null;
        this.shareBuffer.shPath = null;
        this.cmpAccessor = null;
        this.devAccessor = null;
        this.chkAccessor = null;
        this.colAccessor = null;
        this.ldAccessor = null;
        this.fsAccessor = null;
        this.shAccessor = null;
        this.clAccessor = null;
        this.tResCmpAccessor = null;
        this.tGrp2ResAccessor = null;
        this.missingDeviceList = null;
        this.missingFSList = null;
        this.removeFSList = null;
        this.lockedDeviceTable = null;
        this.isVirtualServer = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanup");
        }
    }

    private void clusterProcessing() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"clusterProcessing", (String)"");
        }
        if (this.computer.cmpCluster == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"clusterProcessing");
            }
            return;
        }
        Cluster cluster = this.computer.cmpCluster;
        Cluster cluster2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            NameList nameList = new NameList();
            nameList.nlID = this.computer.cmpID;
            nameList.nlInfo = 1;
            cluster.clusterID = this.cmpAccessor.getClusterID(this.computer);
            cluster2 = this.clAccessor.getClusterByName(cluster.clusterName, cluster.domain_name);
            bl2 = cluster2 != null;
            bl = bl2 && cluster.clusterID == cluster2.clusterID;
            boolean bl4 = bl3 = bl2 && cluster.clusterID > 0 && cluster.clusterID != cluster2.clusterID;
            if (bl3) {
                this.tGrp2ResAccessor.addRemoveResources(cluster2.clusterID, (short)99, null, nameList, false);
            }
            if (bl) {
                this.clAccessor.update(cluster, false);
            } else {
                if (bl2) {
                    cluster.clusterID = cluster2.clusterID;
                    this.clAccessor.update(cluster, false);
                    try {
                        this.tGrp2ResAccessor.addRemoveResources(cluster2.clusterID, (short)99, nameList, null, false);
                    }
                    catch (StorageException storageException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"clusterProcessing", (Throwable)storageException);
                        }
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"clusterProcessing");
                        }
                        throw storageException;
                    }
                }
                try {
                    cluster = this.clAccessor.insert(cluster);
                    GroupDefinition groupDefinition = new GroupDefinition();
                    groupDefinition.creator = "Default";
                    groupDefinition.groupType = (short)99;
                    groupDefinition.ID = cluster.clusterID;
                    groupDefinition.members = nameList;
                    groupDefinition.setName(String.valueOf(cluster.clusterName) + "-" + cluster.domain_name);
                    GroupDefHndlr groupDefHndlr = new GroupDefHndlr();
                    groupDefHndlr.createGroupWithMembers(groupDefinition, "Cluster Reporting Group");
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"clusterProcessing", (Throwable)generalException);
                    }
                    this.clAccessor.cleanupCluster(cluster.clusterID);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"clusterProcessing");
                    }
                    throw generalException;
                }
            }
            this.computer.cmpClusterID = cluster.clusterID;
        }
        catch (StorageException storageException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"clusterProcessing", (Throwable)storageException);
            }
            MessageLog.logException((StorageException)storageException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"clusterProcessing");
        }
    }

    private void cleanClusterMembership() throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanClusterMembership", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"cleanClusterMembership");
            }
            return;
        }
        if (this.computer.cmpCluster == null && this.oldComputer.cmpClusterID > 0) {
            NameList nameList = new NameList();
            nameList.nlID = this.computer.cmpID;
            nameList.nlInfo = 1;
            this.tGrp2ResAccessor.addRemoveResources(this.oldComputer.cmpClusterID, (short)99, null, nameList, false);
            this.cmpAccessor.updateClusterMembership(this.computer);
        }
        if (this.oldComputer.cmpClusterID != this.computer.cmpClusterID && !Constants.isVirtualServer((int)this.computer.cmpOSType)) {
            this.previousClusterID = this.oldComputer.cmpClusterID;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanClusterMembership");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateVSScanTime(Connection connection, Computer computer, long l) throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateVSScanTime", (String)"dbc, c, filerProbeTime");
        }
        RepositoryAccessor repositoryAccessor = null;
        try {
            if (computer.cmpCluster != null) {
                repositoryAccessor = new TResShare(connection);
                ((TResShare)repositoryAccessor).prepUpdate();
                Share share = new Share();
                share.shScanTime = l;
                share.shResourceType = (short)99;
                share.shComputerID = computer.cmpCluster.clusterID;
                TResComputer tResComputer = new TResComputer(connection);
                Iterator iterator = computer.cmpCluster.virtualServers.iterator();
                while (iterator.hasNext()) {
                    try {
                        int n;
                        share.shResourceID = n = tResComputer.selectCID((String)iterator.next());
                        ((TResShare)repositoryAccessor).updateShare(share);
                    }
                    catch (GeneralException generalException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) continue;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"updateVSScanTime", (Throwable)generalException);
                    }
                }
                repositoryAccessor.commit();
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            repositoryAccessor.closeUpdate();
            throw throwable;
        }
        repositoryAccessor.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateVSScanTime");
        }
    }

    private void expireVSs(Connection connection, Computer computer, FilerSaver filerSaver) throws StorageException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"expireVSs", (String)"dbc, c, filerSaver");
        }
        if (filerSaver == null) {
            filerSaver = new FilerSaver(connection, computer.cmpDomainID);
            filerSaver.setProbeTime(this.probeTime);
        }
        filerSaver.updateVSProbeTime(computer.cmpCluster);
        filerSaver.handleMissingVSs(computer.cmpCluster.clusterID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"expireVSs");
        }
    }

    public int updateSSLUNIdentity() {
        int n = 0;
        n = this.computer.cmpOSType == 21 ? this.updateExistingStorageSystemLUNs((byte)1) : this.updateNewStorageSystemLUNs();
        return n;
    }

    public int updateExistingStorageSystemLUNs(byte by) {
        int n;
        block22: {
            n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"updateExistingStorageSystemLUNs", null);
            }
            try {
                TResDiskArray tResDiskArray = new TResDiskArray(this.dbc);
                NameList nameList = tResDiskArray.getStorageSystems();
                this.ldAccessor.prepUpdateLUNIdentity();
                NameList nameList2 = nameList;
                while (nameList2 != null) {
                    LunWWN lunWWN;
                    TResLunWWN tResLunWWN = new TResLunWWN(this.dbc);
                    LunWWN lunWWN2 = lunWWN = tResLunWWN.SelectByComputerId(nameList2.nlID);
                    while (lunWWN2 != null) {
                        EntityWWPN entityWWPN = this.computer.cmpEntityWWPN;
                        while (entityWWPN != null) {
                            block21: {
                                if (lunWWN2.lwWWN.compareToIgnoreCase(entityWWPN.sWWPN) == 0) {
                                    try {
                                        n = this.ldAccessor.updateLUNIdentity(lunWWN2.lwLunID, by);
                                        break;
                                    }
                                    catch (GeneralException generalException) {
                                        Class<?> clazz;
                                        n = -1;
                                        if (!this.isDelete) {
                                            MessageLog.logMessage((String)"SRV0198E", (Object)this.computer.cmpNasFiler.nfAlias);
                                        }
                                        if (!TraceLogger.enableTrace) break block21;
                                        try {
                                            clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        TraceLogger.exception((String)clazz.getName(), (String)"updateExistingStorageSystemLUNs", (Throwable)generalException);
                                    }
                                }
                            }
                            entityWWPN = entityWWPN.entityWWPNNext;
                        }
                        lunWWN2 = lunWWN2.lwNext;
                    }
                    tResLunWWN.closeSelect();
                    nameList2 = nameList2.nlNext;
                }
                this.ldAccessor.closeUpdate();
                tResDiskArray.closeSelect();
                if (!this.isDelete && n > 0) {
                    MessageLog.logMessage((String)"SRV0197I", (Object)this.computer.cmpNasFiler.nfAlias);
                }
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                if (!this.isDelete) {
                    MessageLog.logMessage((String)"SRV0198E", (Object)this.computer.cmpNasFiler.nfAlias);
                }
                if (!TraceLogger.enableTrace) break block22;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateExistingStorageSystemLUNs", (Throwable)generalException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateExistingStorageSystemLUNs");
        }
        return n;
    }

    public int updateNewStorageSystemLUNs() {
        int n;
        block20: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"updateNewStorageSystemLUNs", null);
            }
            boolean bl = false;
            LogicalDisk logicalDisk = null;
            n = 0;
            int n2 = -1;
            String string = null;
            HashMap hashMap = new HashMap();
            try {
                EntityWWPN entityWWPN;
                LunWWN lunWWN;
                TResDiskArray tResDiskArray = new TResDiskArray(this.dbc);
                EntityWWPN entityWWPN2 = tResDiskArray.getSVCNodeWWPNs();
                TResEntityWWPN tResEntityWWPN = new TResEntityWWPN(this.dbc);
                TResComputer tResComputer = new TResComputer(this.dbc);
                if (entityWWPN2 == null) {
                    return n;
                }
                logicalDisk = this.computer.cmpLogicalDisk;
                while (logicalDisk != null) {
                    bl = false;
                    lunWWN = null;
                    lunWWN = logicalDisk.ldLunWWNs;
                    while (lunWWN != null) {
                        entityWWPN = entityWWPN2;
                        while (entityWWPN != null) {
                            if (lunWWN.lwWWN.compareToIgnoreCase(entityWWPN.sWWPN) == 0) {
                                logicalDisk.lun_identity = 1;
                                bl = true;
                                ++n;
                                n2 = tResEntityWWPN.getEntityIdByWWPN((byte)2, entityWWPN.sWWPN);
                                tResComputer.prepSelectLocalHostname();
                                string = tResComputer.fetchName(n2);
                                if (hashMap.containsKey(string)) break;
                                hashMap.put(string, null);
                                break;
                            }
                            entityWWPN = entityWWPN.entityWWPNNext;
                        }
                        if (bl) break;
                        lunWWN = lunWWN.lwNext;
                    }
                    logicalDisk = logicalDisk.ldNext;
                }
                if (n > 0) {
                    lunWWN = hashMap.keySet();
                    entityWWPN = lunWWN.iterator();
                    String string2 = "";
                    int n3 = lunWWN.size();
                    if (n3 > 1) {
                        int n4 = 1;
                        while (entityWWPN.hasNext()) {
                            string2 = String.valueOf(string2) + (String)entityWWPN.next();
                            if (++n4 >= n3) continue;
                            string2 = String.valueOf(string2) + ", ";
                        }
                    } else if (n3 == 1) {
                        string2 = String.valueOf(string2) + (String)entityWWPN.next();
                    }
                    MessageLog.logMessage((String)"SRV0197I", (Object)string2);
                }
                tResDiskArray.closeSelect();
                tResEntityWWPN.closeSelect();
                tResComputer.closeSelect();
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                MessageLog.logMessage((String)"SRV0198E", (Object)hashMap.toString());
                if (!TraceLogger.enableTrace) break block20;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateNewStorageSystemLUNs", (Throwable)generalException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateNewStorageSystemLUNs");
        }
        return n;
    }

    private void updateSavedSVCDiskIdentity(int n, byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateSavedSVCDiskIdentity", null);
        }
        TStatDisk tStatDisk = new TStatDisk(this.dbc);
        tStatDisk.updateSVCDiskIdentity(n, by);
        tStatDisk.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateSavedSVCDiskIdentity", null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSVCDiskIdentity() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateSVCDiskIdentity", null);
        }
        byte by = -1;
        int n = -1;
        TResEntityWWPN tResEntityWWPN = new TResEntityWWPN(this.dbc);
        try {
            if (this.computer.cmpOSType == 21) {
                by = 1;
                Controller controller = this.computer.cmpController;
                block7: while (controller != null) {
                    EntityWWPN entityWWPN = controller.ctlrWWPNs;
                    while (true) {
                        if (entityWWPN == null) {
                            controller = controller.ctlrNext;
                            continue block7;
                        }
                        n = tResEntityWWPN.getEntityIdByWWPN(by, entityWWPN.sWWPN);
                        if (n != -1) {
                            Iterator iterator = controller.ctlrDisks.iterator();
                            while (iterator.hasNext()) {
                                Disk disk = (Disk)iterator.next();
                                disk.dskIdentity = 1;
                            }
                        }
                        entityWWPN = entityWWPN.entityWWPNNext;
                    }
                }
            } else {
                by = 3;
                EntityWWPN entityWWPN = this.computer.cmpEntityWWPN;
                while (entityWWPN != null) {
                    n = tResEntityWWPN.getEntityIdByWWPN(by, entityWWPN.sWWPN);
                    if (n != -1) {
                        this.updateSavedSVCDiskIdentity(n, (byte)1);
                    }
                    entityWWPN = entityWWPN.entityWWPNNext;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            tResEntityWWPN.closeSelect();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        tResEntityWWPN.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateSVCDiskIdentity", null);
        }
    }
}

