/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.Script;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListSaver;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TScript;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiScriptHndlr
implements RequestHandler,
ThrowAway {
    private Connection dbc;
    private Response response;
    private Script newScript;
    public static final String SCRIPT_JOB_TYPE = "SCRIPT";
    public static final String SCRIPT_JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0106L");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.common.Script");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
            this.newScript = (Script)request.requestData;
            this.dbc = Server.getConnection();
            if (this.dbc == null) {
                this.response.status = (short)12;
            } else {
                block25: {
                    String string;
                    boolean bl = this.newScript.isEmpty();
                    if (this.newScript.ID <= 0) {
                        string = null;
                    } else {
                        string = Integer.toString(this.newScript.ID);
                        byte by = bl ? (byte)2 : 1;
                        LockManager.lock((short)0, (String)SCRIPT_JOB_TYPE, (String)string, (byte)by, (boolean)true);
                    }
                    try {
                        block24: {
                            try {
                                if (bl) {
                                    this.response.responseData = this.retrieve();
                                    break block24;
                                }
                                this.save();
                                this.response.responseData = this.newScript;
                            }
                            catch (GeneralException generalException) {
                                if (TraceLogger.enableTrace) {
                                    Class<?> clazz3;
                                    try {
                                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    TraceLogger.exception((String)clazz3.getName(), (String)"handle", (Throwable)generalException);
                                }
                                if (this.response.status <= 4) {
                                    this.response.status = (short)12;
                                }
                                this.response.errorMessage = generalException.getMessage();
                            }
                        }
                        Object var6_10 = null;
                        if (string == null) break block25;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        if (string != null) {
                            LockManager.unLock((short)0, (String)SCRIPT_JOB_TYPE, (String)string);
                        }
                        Server.returnConnection(this.dbc);
                        throw throwable;
                    }
                    LockManager.unLock((short)0, (String)SCRIPT_JOB_TYPE, (String)string);
                }
                Server.returnConnection(this.dbc);
            }
        }
        Response response = this.response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private Serializable retrieve() throws GeneralException {
        TScript tScript;
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"retrieve", (String)"");
        }
        if (this.newScript.ID > 0) {
            object = new TSchedule(this.dbc);
            ((TSchedule)object).retrieve((ScheduleHeader)this.newScript, SCRIPT_JOB_TYPE_LABEL);
            int n = this.newScript.ID;
            tScript = new TScript(this.dbc);
            this.newScript.scrName = tScript.select(n);
            TStatComputer tStatComputer = new TStatComputer(this.dbc);
            this.newScript.scrComputers = tStatComputer.queryDependents(n);
            TResAttr tResAttr = new TResAttr(this.dbc);
            this.newScript.scrAllComputers = NameListSaver.allObjectsSelected(tResAttr, n, (short)67);
            this.newScript.scrComputerGroups = tResAttr.queryDependents("t_group", "group_id", n, (short)0);
            TAlertDefinition tAlertDefinition = new TAlertDefinition(this.dbc);
            tAlertDefinition.prepSelectByID(false, false);
            this.newScript.scrAlert = tAlertDefinition.getByID(n);
            tAlertDefinition.closeSelect();
        }
        object = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "scripts";
        File file = new File((String)object);
        this.newScript.nameArray = file.list();
        if (this.newScript.nameArray == null) {
            this.newScript.nameArray = new String[0];
        }
        tScript = this.newScript;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"retrieve", (Object)tScript);
        }
        return tScript;
    }

    private void save() throws GeneralException {
        NameList[] nameListArray;
        RepositoryAccessor repositoryAccessor;
        RepositoryAccessor repositoryAccessor2;
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"");
        }
        TScript tScript = null;
        String string = null;
        Script script = new Script(67);
        if (this.newScript.ID <= 0) {
            this.newScript.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            bl = false;
        } else {
            repositoryAccessor2 = new RaceConditionChecker(this.dbc, "t_schedule", TSchedule.ID_COLUMN_NAME, (CreateHeader)this.newScript, SCRIPT_JOB_TYPE_LABEL);
            ((RaceConditionChecker)repositoryAccessor2).check();
            string = ((RaceConditionChecker)repositoryAccessor2).message;
            bl = !((RaceConditionChecker)repositoryAccessor2).wasDeleted;
            repositoryAccessor2 = null;
            if (bl) {
                tScript = new TScript(this.dbc);
                script.scrName = tScript.select(this.newScript.ID);
                repositoryAccessor = new TResAttr(this.dbc);
                ((TResAttr)repositoryAccessor).prepQueryByAttr();
                nameListArray = new ResourceAttribute();
                nameListArray.raAttributeID = this.newScript.ID;
                nameListArray.raAttributeType = (short)67;
                nameListArray.raResourceType = 1;
                script.scrComputers = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = 0;
                script.scrComputerGroups = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray);
                nameListArray.raResourceType = (short)13;
                script.scrAllComputers = ((TResAttr)repositoryAccessor).getResAttr((ResourceAttribute)nameListArray) != null;
                repositoryAccessor.closeSelect();
            }
        }
        this.newScript.alertID = this.newScript.ID;
        repositoryAccessor2 = new TAlertDefinition(this.dbc);
        if (bl) {
            ((TAlertDefinition)repositoryAccessor2).deleteByID(this.newScript.ID);
        }
        ((TAlertDefinition)repositoryAccessor2).insert((CreateHeader)this.newScript, this.newScript.scrAlert);
        repositoryAccessor = new TSchedule(this.dbc);
        if (bl) {
            ((TSchedule)repositoryAccessor).deleteByID(this.newScript.ID, SCRIPT_JOB_TYPE_LABEL);
            if (!this.newScript.scrName.equals(script.scrName)) {
                tScript.update(this.newScript);
            }
        } else {
            tScript = new TScript(this.dbc);
            tScript.insert(this.newScript);
        }
        ScheduleQueue.routine.getHighRunNumber((ScheduleHeader)this.newScript);
        ((TSchedule)repositoryAccessor).insert((ScheduleHeader)this.newScript, SCRIPT_JOB_TYPE_LABEL);
        nameListArray = new NameList[]{this.newScript.scrComputers, this.newScript.scrComputerGroups};
        NameList[] nameListArray2 = new NameList[]{script.scrComputers, script.scrComputerGroups};
        NameListSaver nameListSaver = new NameListSaver(this.dbc, this.response);
        nameListSaver.saveAllObjectsSelected(this.newScript.scrAllComputers, this.newScript.ID, (short)67);
        nameListSaver.save((CreateHeader)this.newScript, SCRIPT_JOB_TYPE_LABEL, (short)67, this.newScript.ID, nameListArray, nameListArray2, this.createTablesMap(), bl);
        if (bl) {
            ScheduleQueue.routine.addEdit((ScheduleHeader)this.newScript);
        } else {
            ScheduleQueue.routine.addCreate((ScheduleHeader)this.newScript);
        }
        if (string != null) {
            this.response.status = (short)4;
            this.response.errorMessage = string;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    private Map createTablesMap() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"createTablesMap", (String)"");
        }
        HashMap hashMap = new HashMap();
        this.fillMap(hashMap, (short)1, "t_stat_computer", "computer_id");
        this.fillMap(hashMap, (short)0, "t_group", "group_id");
        HashMap hashMap2 = hashMap;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"createTablesMap", hashMap2);
        }
        return hashMap2;
    }

    private void fillMap(Map map, short s, String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fillMap", (String)"map, resourceType, tableName, idColumnName");
        }
        MutableInteger mutableInteger = new MutableInteger((int)s);
        String[] stringArray = new String[]{string, string2};
        map.put(mutableInteger, stringArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fillMap");
        }
    }
}

