/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TScript;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.GuiScriptHndlr;

public class ScriptDeleteHndlr
implements RequestHandler,
ThrowAway {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.ScriptDeleteHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response2 = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.common.NameList");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (RequestChecker.isDesiredType(clazz, (Request)request, (Response)response2)) {
            response = (NameList)request.requestData;
            Connection connection = Server.getConnection();
            if (connection == null) {
                response2.status = (short)12;
            } else {
                String string = GuiScriptHndlr.SCRIPT_JOB_TYPE_LABEL;
                String string2 = "SCRIPT";
                String string3 = Integer.toString(response.nlID);
                try {
                    try {
                        LockManager.lock((short)0, (String)string2, (String)string3, (byte)1, (boolean)true);
                        TSchedule tSchedule = new TSchedule(connection);
                        ScheduleHeader scheduleHeader = new ScheduleHeader();
                        scheduleHeader.ID = response.nlID;
                        tSchedule.retrieve(scheduleHeader, string);
                        if (scheduleHeader.alertID > 0) {
                            Alerter.deleteAlert(connection, scheduleHeader.alertID, false);
                        }
                        TScript tScript = new TScript(connection);
                        tScript.delete(response.nlID);
                        tSchedule.deleteByID(response.nlID, string, true);
                        tSchedule.commit();
                    }
                    catch (GeneralException generalException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.ScriptDeleteHndlr");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz3.getName(), (String)"handle", (Throwable)generalException);
                        }
                        Server.setResponseError(response2, (Exception)((Object)generalException));
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    LockManager.unLock((short)0, (String)string2, (String)string3);
                    Server.returnConnection(connection);
                    throw throwable;
                }
                {
                    Object var12_15 = null;
                }
                LockManager.unLock((short)0, (String)string2, (String)string3);
                Server.returnConnection(connection);
                ScheduleQueue.routine.addDelete(response.nlID);
            }
        }
        response = response2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.ScriptDeleteHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response);
        }
        return response;
    }
}

