/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import java.util.Hashtable;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.disk.GUIEntityFactory;

public class SubsystemInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        GUIRequestData gUIRequestData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (gUIRequestData.getActionId() == 0) {
                this.getAllStorageSubsystems(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 1) {
                this.getSubsystemPorts(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 2) {
                this.getHostPortsBySubsystem(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 3) {
                this.getStoragePoolsBySubsytstem(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 4) {
                this.getIOGroupsBySVC(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 5) {
                this.getMDiskGroupsBySVC(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 6) {
                this.getUnmanagedMDisksBySVC(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 7) {
                this.getSupportedRaidLevels(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 8) {
                this.getMaxVolumes(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 9) {
                this.getAssignedHostPortsBySubsystem(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 10) {
                this.setStorageSubsystemAttributes(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 12) {
                this.getStorageSubsystemCapabilities(gUIRequestData, response);
            }
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"handle", (Throwable)exception);
            }
            response.status = (short)12;
            if (exception instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)exception).getLocalizedMessage();
            } else {
                String[] stringArray = new String[]{};
                String string = exception.getMessage();
                if (string != null) {
                    stringArray = new String[]{string};
                }
                response.errorMessage = new SRMMessage("HWN021503E", stringArray).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private void getAllStorageSubsystems(GUIRequestData gUIRequestData, Response response) throws Exception {
        response.responseData = this.entityFactory.getAllStorageSubsystems();
    }

    private void getSubsystemPorts(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getSubsystemPorts", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getSubsystemPorts(string);
    }

    private void getHostPortsBySubsystem(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getHostPortsBySubsystem", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getHostPortsBySubsystem(string);
    }

    private void getStoragePoolsBySubsytstem(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getStoragePoolsBySubsytstem", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getStoragePoolsBySubsytstem(string);
    }

    private void getIOGroupsBySVC(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getIOGroupsBySVC", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getIOGroupsBySVC(string);
    }

    private void getMDiskGroupsBySVC(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getMDiskGroupsBySVC", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getMDiskGroupsBySVC(string);
    }

    private void getUnmanagedMDisksBySVC(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getUnmanagedMDisksBySVC", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getUnmanagedMDisksBySVC(string);
    }

    private void getSupportedRaidLevels(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getSupportedRaidLevels", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getSupportedRaidLevels(string);
    }

    private void getMaxVolumes(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getMaxVolumes", (String)("subsystemId: " + string));
        response.responseData = new Long(this.entityFactory.getMaxVolumes(string));
    }

    private void getAssignedHostPortsBySubsystem(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getAssignedHostPortsBySubsystem", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getAssignedHostPortsBySubsystem(string);
    }

    private void setStorageSubsystemAttributes(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"setStorageSubsystemAttributes", (String)("subsystemId: " + string));
        Hashtable hashtable = (Hashtable)gUIRequestData.getParameter("subsystem.attrs");
        response.responseData = new Integer(this.entityFactory.setStorageSubsystemAttributes(string, hashtable));
    }

    private void getStorageSubsystemCapabilities(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getHostsBySubsystem", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getCapabilities(string);
    }
}

