/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.SchIntervalNode;
import org.eclipse.aperi.scheduler.ScheduleBuild;
import org.eclipse.aperi.scheduler.ScheduleSubmit;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobComplete;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlrThread;
import org.eclipse.aperi.server.handler.scheduler.SchDeviceJobDoneHandler;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class DeviceJobHndlr
extends DeviceRequestHndlr {
    private static Object mutex = new Object();
    private static final String INSERT_RUNS = "insert into t_runs (time_stamp, schedule_id, run_number, number_jobs) values (?,?,?,?)";

    public Response handle(Request request, Transceiver transceiver) {
        DeviceRequest deviceRequest = (DeviceRequest)request;
        Response response = new Response(0, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        DeviceJobHndlr.initDeviceServerComm(deviceRequest);
        if (!this.submitJob(deviceRequest, response, transceiver)) {
            response.status = (short)12;
        }
        Response response2 = new Response(0, null);
        response2.status = (short)-99;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response2;
    }

    private boolean submitJob(DeviceRequest deviceRequest, Response response, Transceiver transceiver) {
        boolean bl = DeviceJobHndlr.createNewScheduledJob(deviceRequest, response);
        if (!bl) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"submitJob", (boolean)false);
            }
            return false;
        }
        DeviceJobHndlrThread deviceJobHndlrThread = new DeviceJobHndlrThread((Request)deviceRequest, transceiver, this);
        Thread thread = new Thread((Runnable)deviceJobHndlrThread, this.getClass().getName());
        thread.start();
        return true;
    }

    public static void setDeviceJobID(DeviceRequest deviceRequest) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setDeviceJobID", (String)"dr");
        }
        DeviceJobHndlr.updateTRuns(deviceRequest.dataScheduleID, deviceRequest.dataScheduleRunNbr, deviceRequest.deviceRunNbr, deviceRequest.deviceServerID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setDeviceJobID");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateTSchedule(int n, int n2) {
        boolean bl;
        block12: {
            bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"updateTSchedule", (String)"SID, highRun");
            }
            StringBuffer stringBuffer = new StringBuffer(75);
            stringBuffer.append("update t_schedule set high_run_number = ");
            stringBuffer.append(n2);
            stringBuffer.append(" where schedule_id = ");
            stringBuffer.append(n);
            Connection connection = Server.getConnection();
            try {
                try {
                    Statement statement = connection.createStatement();
                    statement.executeUpdate(stringBuffer.toString());
                    statement.close();
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    bl = false;
                    Object[] objectArray = new Object[]{"update", "t_schedule", "DeviceJobHndlr.updateTSchedule"};
                    String string = SQLUtil.getSQLExceptionMsg("JSS0008E", sQLException, objectArray);
                    ScheduleSubmit.logWriter.println(string);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (connection != null) {
                    Server.returnConnection(connection);
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (connection == null) break block12;
            }
            Server.returnConnection(connection);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateTSchedule", (boolean)bl);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int completeDeviceJob(IJobMgmtService iJobMgmtService, AsyncResult asyncResult, String string, int n, int n2, int n3) {
        AsyncResult asyncResult2 = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"completeDeviceJob", (String)"tar, deviceMethod, SID, SidRunNbr, deviceServerID");
        }
        if (asyncResult == null) {
            MessageLog.logMessage((String)"SRV0710E", (Object)"AsyncResult");
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"completeDeviceJob", (String)"AsyncResult is null.");
            }
            return 8;
        }
        int n4 = Integer.parseInt(asyncResult.getJobId());
        DeviceJobHndlr.updateTRuns(n, n2, n4, n3);
        try {
            block36: {
                block37: {
                    try {
                        Class<?> clazz;
                        asyncResult2 = iJobMgmtService.waitForJobToComplete(asyncResult.getJobId());
                        if (asyncResult2 != null) break block36;
                        MessageLog.logMessage((String)"SRV0710E", (Object)"waitForJobToComplete()");
                        if (!TraceLogger.enableTrace) break block37;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"completeDeviceJob", (String)"waitForJobToComplete() returns null.");
                    }
                    catch (Exception exception) {
                        MessageLog.logException((String)"SRV0771E", (Exception)exception, (Object)string);
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"completeDeviceJob", (int)8);
                        }
                        exception.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        MessageLog.logException((String)"SRV0771E", (Exception)new Exception(throwable), (Object)string);
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"completeDeviceJob", (int)8);
                        }
                        throwable.printStackTrace();
                    }
                }
                Object var9_8 = null;
                DeviceJobHndlr.updateTRunJobs(n, n2, n4, n3);
                return 8;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            DeviceJobHndlr.updateTRunJobs(n, n2, n4, n3);
            throw throwable;
        }
        DeviceJobHndlr.updateTRunJobs(n, n2, n4, n3);
        Exception exception = DeviceJobHndlr.getAnyException(asyncResult2);
        if (exception != null) {
            MessageLog.logException((String)"SRV0451E", (Exception)exception, (Object)string);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"completeDeviceJob", (int)8);
            }
            return 8;
        }
        DeviceJobHndlr.logResults(asyncResult2);
        int n5 = asyncResult2.getRc();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"completeDeviceJob", (String)("After waitForJobToComplete() tarDone.getRc() = " + n5));
        }
        int n6 = 8;
        if (n5 > 0) {
            n6 = 8;
        } else if (n5 < 0) {
            n6 = 4;
        } else if (n5 == 0) {
            n6 = 0;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"completeDeviceJob", (int)n6);
        }
        return n6;
    }

    private static Exception getAnyException(AsyncResult asyncResult) {
        Exception exception = null;
        AsyncResult[] asyncResultArray = asyncResult.getSubJobResults();
        if (asyncResultArray != null) {
            int n = 0;
            while (n < asyncResultArray.length) {
                exception = DeviceJobHndlr.getAnyException(asyncResultArray[n]);
                if (exception != null) break;
                ++n;
            }
        }
        if (exception == null) {
            return asyncResult.getReturnException();
        }
        return exception;
    }

    private static void logResults(AsyncResult asyncResult) {
        AsyncResult[] asyncResultArray;
        PrintWriter printWriter = MessageLog.getThreadLog();
        String string = asyncResult.getMessage();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"logResults", (String)"tar");
        }
        if (string != null) {
            printWriter.write(string);
            printWriter.write("\n");
        }
        if ((asyncResultArray = asyncResult.getSubJobResults()) != null) {
            int n = 0;
            while (n < asyncResultArray.length) {
                string = asyncResultArray[n].getMessage();
                if (string != null) {
                    printWriter.write(string);
                    printWriter.write("\n");
                }
                ++n;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"logResults");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateTRuns(int n, int n2, int n3, int n4) {
        boolean bl;
        block12: {
            bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"updateTRuns", (String)"SID, SidRunNbr, deviceJobID");
            }
            StringBuffer stringBuffer = new StringBuffer(75);
            stringBuffer.append("update t_runs set device_server_run_id = ");
            stringBuffer.append(n3);
            stringBuffer.append(", device_server_id = ");
            stringBuffer.append(n4);
            stringBuffer.append(" where schedule_id = ");
            stringBuffer.append(n);
            stringBuffer.append(" and run_number = ");
            stringBuffer.append(n2);
            Connection connection = Server.getConnection();
            try {
                try {
                    Statement statement = connection.createStatement();
                    statement.executeUpdate(stringBuffer.toString());
                    statement.close();
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    bl = false;
                    Object[] objectArray = new Object[]{"update", "t_runs", "DeviceJobHndlr.updateTRuns"};
                    String string = SQLUtil.getSQLExceptionMsg("JSS0008E", sQLException, objectArray);
                    ScheduleSubmit.logWriter.println(string);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (connection != null) {
                    Server.returnConnection(connection);
                }
                throw throwable;
            }
            {
                Object var11_13 = null;
                if (connection == null) break block12;
            }
            Server.returnConnection(connection);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateTRuns", (boolean)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateTRunJobs(int n, int n2, int n3, int n4) {
        boolean bl;
        block12: {
            bl = true;
            StringBuffer stringBuffer = new StringBuffer(75);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"updateTRunJobs", (String)"SID, SidRunNbr, deviceJobID, deviceServerID");
            }
            stringBuffer.append("update t_run_jobs set schedule_id = ");
            stringBuffer.append(n);
            stringBuffer.append(", sid_run_number = ");
            stringBuffer.append(n2);
            stringBuffer.append(", computer_id = ");
            stringBuffer.append(n4);
            stringBuffer.append(" where device_server_run_id = ");
            stringBuffer.append(n3);
            Connection connection = Server.getConnection();
            try {
                try {
                    Statement statement = connection.createStatement();
                    statement.executeUpdate(stringBuffer.toString());
                    statement.close();
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    bl = false;
                    Object[] objectArray = new Object[]{"update", "t_run_jobs", "DeviceJobHndlr.updateTRunJobs"};
                    String string = SQLUtil.getSQLExceptionMsg("JSS0008E", sQLException, objectArray);
                    ScheduleSubmit.logWriter.println(string);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (connection != null) {
                    Server.returnConnection(connection);
                }
                throw throwable;
            }
            {
                Object var11_13 = null;
                if (connection == null) break block12;
            }
            Server.returnConnection(connection);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateTRunJobs", (boolean)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean insertRun(DeviceRequest deviceRequest) {
        boolean bl;
        block12: {
            bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"insertRun", (String)"dr");
            }
            Connection connection = Server.getConnection();
            try {
                try {
                    PreparedStatement preparedStatement = connection.prepareStatement(INSERT_RUNS);
                    preparedStatement.setLong(1, SQLUtil.getTimestamp(connection).getTime());
                    preparedStatement.setInt(2, deviceRequest.dataScheduleID);
                    preparedStatement.setInt(3, deviceRequest.dataScheduleRunNbr);
                    preparedStatement.setInt(4, 1);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    bl = false;
                    Object[] objectArray = new Object[]{"insert", "t_runs", "DeviceJobHndlr.insertRun"};
                    String string = SQLUtil.getSQLExceptionMsg("JSS0008E", sQLException, objectArray);
                    ScheduleSubmit.logWriter.println(string);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (connection != null) {
                    Server.returnConnection(connection);
                }
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (connection == null) break block12;
            }
            Server.returnConnection(connection);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertRun", (boolean)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitForDeviceJob(Response response, int n, IJobMgmtService iJobMgmtService) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"waitForDeviceJob", (String)"Response, int");
        }
        int n2 = 0;
        if (iJobMgmtService == null) {
            response.errorMessage = MessageLog.getMessage((String)"SRV0451E", (Object)"IJobMgmtService");
            response.status = (short)12;
            n2 = 8;
        }
        String string = Integer.toString(n);
        try {
            try {
                AsyncResult asyncResult = iJobMgmtService.waitForJobToComplete(string);
                response.status = 0;
                response.responseData = asyncResult;
                n2 = 0;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                MessageLog.logException((String)"SRV0770E", (Exception)new Exception(outOfMemoryError.getCause()), (Object)"waitForDeviceJob");
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"waitForDeviceJob", (Throwable)outOfMemoryError);
                }
                n2 = 8;
                response.errorMessage = MessageLog.getMessageNoID((String)"SRV0770E");
                response.status = (short)12;
            }
            catch (Exception exception) {
                MessageLog.logException((String)"SRV0451E", (Exception)exception, (Object)"waitForDeviceJob");
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"waitForDeviceJob", (Throwable)exception);
                }
                response.errorMessage = MessageLog.getMessage((String)"SRV0703E", (Object)"waitForJobToComplete()");
                response.status = (short)12;
                n2 = 8;
            }
            catch (Throwable throwable) {
                MessageLog.logException((String)"SRV0451E", (Exception)new Exception(throwable), (Object)"waitForDeviceJob");
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"waitForDeviceJob", (Throwable)throwable);
                }
                response.errorMessage = MessageLog.getMessage((String)"SRV0703E", (Object)"waitForJobToComplete()");
                response.status = (short)12;
                n2 = 8;
            }
        }
        catch (Throwable throwable) {
            Class<?> clazz;
            Object var6_10 = null;
            DeviceJobHndlr.finishJob(n);
            if (!TraceLogger.enableTrace) throw throwable;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlrThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"waitForDeviceJob", (int)n2);
            throw throwable;
        }
        {
            Object var6_11 = null;
        }
        DeviceJobHndlr.finishJob(n);
        if (!TraceLogger.enableTrace) return;
        try {}
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlrThread").getName(), (String)"waitForDeviceJob", (int)n2);
    }

    public static void finishJob(int n) {
        Request request = new Request();
        DeviceJobComplete deviceJobComplete = new DeviceJobComplete();
        deviceJobComplete.deviceJobID = n;
        request.requestData = deviceJobComplete;
        SchDeviceJobDoneHandler schDeviceJobDoneHandler = new SchDeviceJobDoneHandler();
        schDeviceJobDoneHandler.handle(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createNewScheduledJob(DeviceRequest deviceRequest, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"createNewScheduledJob", (String)"dr, response");
        }
        if (deviceRequest.deviceManager == DeviceRequest.DR_DISK) {
            deviceRequest.dataScheduleID = 113;
        } else if (deviceRequest.deviceManager == DeviceRequest.DR_FABRIC) {
            deviceRequest.dataScheduleID = 114;
        } else if (deviceRequest.deviceManager == DeviceRequest.DR_PM) {
            deviceRequest.dataScheduleID = 115;
        } else if (deviceRequest.deviceManager == DeviceRequest.DR_TAPE) {
            deviceRequest.dataScheduleID = 116;
        } else if (deviceRequest.deviceManager == DeviceRequest.DR_API) {
            deviceRequest.dataScheduleID = 117;
        } else {
            response.errorMessage = MessageLog.getMessage((String)"JSS0100E");
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"createNewScheduledJob", (boolean)false);
            }
            return false;
        }
        SchIntervalNode schIntervalNode = ScheduleBuild.getSchInterval(deviceRequest.dataScheduleID);
        if (schIntervalNode == null) {
            response.errorMessage = MessageLog.getMessage((String)"JSS0101E");
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"createNewScheduledJob", (boolean)false);
            }
            return false;
        }
        Object object = mutex;
        synchronized (object) {
            ++schIntervalNode.highRunNumber;
            deviceRequest.dataScheduleRunNbr = schIntervalNode.highRunNumber;
            DeviceJobHndlr.updateTSchedule(deviceRequest.dataScheduleID, schIntervalNode.highRunNumber);
        }
        if (!DeviceJobHndlr.insertRun(deviceRequest)) {
            response.errorMessage = MessageLog.getMessage((String)"JSS0102E");
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"createNewScheduledJob", (boolean)false);
            }
            return false;
        }
        return true;
    }
}

