/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.table.TFoundComputer;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResStorageVolume;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.handler.server.AlertLogHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertLogResolver
implements AlertLogHndlr.ProductAlertLogHndlr {
    private Connection dbc;

    @Override
    public void getProductData(AlertLogHndlr alertLogHndlr, Map<Short, ExtAlertLog> map, Connection connection) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getProductData", (String)"handler, array, dbc");
        }
        this.dbc = connection;
        ExtAlertLog extAlertLog = map.get((short)1);
        if (extAlertLog != null) {
            this.getDisks(extAlertLog);
            this.getArraysForDisks(extAlertLog);
        }
        if ((extAlertLog = map.get((short)2)) != null) {
            this.getMissingDisks(extAlertLog);
            this.getArraysForDisks(extAlertLog);
        }
        if ((extAlertLog = map.get((short)3)) != null) {
            this.getFilesystems(extAlertLog);
        }
        if ((extAlertLog = map.get((short)6)) != null) {
            this.getFoundComputers(extAlertLog);
        }
        if ((extAlertLog = map.get((short)14)) != null) {
            this.getDiskArrays(extAlertLog);
        }
        if ((extAlertLog = map.get((short)0)) != null) {
            this.getMissingFilers(extAlertLog);
        }
        if ((extAlertLog = map.get((short)16)) != null) {
            this.getSwitchLabels(extAlertLog);
        }
        if ((extAlertLog = map.get((short)15)) != null) {
            this.getFabricLabels(extAlertLog);
        }
        if ((extAlertLog = map.get((short)17)) != null) {
            this.getEndpointLabels(extAlertLog);
        }
        if ((extAlertLog = map.get((short)20)) != null) {
            this.getVolumes(extAlertLog);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getProductData");
        }
    }

    private void getMissingDisks(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMissingDisks", (String)"records");
        }
        TResComputer tResComputer = new TResComputer(this.dbc);
        boolean bl = tResComputer.isStorageSubsystem(extAlertLog.alComputerID);
        TResDevice tResDevice = new TResDevice(this.dbc);
        TResDevAccess tResDevAccess = new TResDevAccess(this.dbc);
        if (!bl) {
            tResDevice.prepGetDevByID(false);
        } else {
            tResDevAccess.prepPathDevSSQuery();
        }
        while (extAlertLog != null) {
            if (!bl) {
                Device device = tResDevice.getDevByID(extAlertLog.alResourceID);
                tResDevice.closeResultSet();
                if (device != null) {
                    String string = !Util.isEmpty((String)device.devSubsystemSerialNumber) ? new StringBuffer(String.valueOf(device.devSubsystemSerialNumber)).append('/').append(device.devSerialNumber).toString() : device.devSerialNumber;
                    extAlertLog.setAlObjectName(new StringBuffer(String.valueOf(device.devManufacturer)).append(' ').append(device.devModel).append(' ').append(string).toString());
                }
            } else {
                extAlertLog.setAlObjectName(tResDevAccess.getPathByDeviceComputer(extAlertLog.alResourceID, extAlertLog.alComputerID));
                tResDevAccess.closeResultSet();
            }
            extAlertLog = extAlertLog.alnExt;
        }
        tResDevice.closeSelect();
        tResDevAccess.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMissingDisks");
        }
    }

    private void getDisks(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDisks", (String)"records");
        }
        TResDevAccess tResDevAccess = new TResDevAccess(this.dbc);
        TResComputer tResComputer = new TResComputer(this.dbc);
        boolean bl = tResComputer.isStorageSubsystem(extAlertLog.alComputerID);
        if (!bl) {
            tResDevAccess.prepPathDevCompQuery();
        } else {
            tResDevAccess.prepPathDevSSQuery();
        }
        while (extAlertLog != null) {
            extAlertLog.setAlObjectName(tResDevAccess.getPathByDeviceComputer(extAlertLog.alResourceID, extAlertLog.alComputerID));
            extAlertLog = extAlertLog.alnExt;
        }
        tResDevAccess.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDisks");
        }
    }

    private void getArraysForDisks(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getArraysForDisks", (String)"records");
        }
        Share share = new Share();
        TResDiskArray tResDiskArray = new TResDiskArray(this.dbc);
        tResDiskArray.prepFetchByID();
        while (extAlertLog != null) {
            share.shResourceID = extAlertLog.alComputerID;
            if (tResDiskArray.fetchByID(share)) {
                extAlertLog.alComputer = share.shPath;
            }
            extAlertLog = extAlertLog.alnExt;
        }
        tResDiskArray.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getArraysForDisks");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getDiskArrays(ExtAlertLog extAlertLog) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getDiskArrays", (String)"records");
        }
        TResComputer tResComputer = new TResComputer(this.dbc);
        TResComputer tResComputer2 = new TResComputer(this.dbc);
        DBConnection dBConnection = null;
        try {
            block25: {
                try {
                    tResComputer.prepSelectLocalHostname();
                    tResComputer2.prepSelectName();
                    DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                    dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                    dBConnection.setAutoCommit(true);
                    while (extAlertLog != null) {
                        extAlertLog.setAlObjectName(tResComputer.fetchName(extAlertLog.alResourceID));
                        extAlertLog.alComputer = "";
                        try {
                            new String();
                            DBResultSet dBResultSet = FabricDbAccess.getComputerDetail((DBConnection)dBConnection, (String)String.valueOf(extAlertLog.alComputerID));
                            if (dBResultSet.next()) {
                                extAlertLog.alComputer = dBResultSet.getString("LABEL");
                            }
                        }
                        catch (SQLException sQLException) {}
                        if (extAlertLog.alComputer == null || extAlertLog.alComputer.equals("")) {
                            extAlertLog.alComputer = MessageLog.getMessageNoID((String)"SAG0521I");
                        }
                        extAlertLog = extAlertLog.alnExt;
                    }
                }
                catch (SQLException sQLException) {
                    Class<?> clazz3;
                    if (!TraceLogger.enableTrace) break block25;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"getDiskArrays", (Throwable)sQLException);
                }
                catch (StorageException storageException) {
                    Class<?> clazz4;
                    if (!TraceLogger.enableTrace) break block25;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz4.getName(), (String)"getDiskArrays", (Throwable)storageException);
                }
            }
            Object var7_11 = null;
            this.cleanupSelect(tResComputer);
            this.cleanupSelect(tResComputer2);
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.cleanupSelect(tResComputer);
            this.cleanupSelect(tResComputer2);
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
                dBConnection = null;
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        if (dBConnection != null) {
            dBConnection.close();
        }
        dBConnection = null;
        if (!TraceLogger.enableTrace) return;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getDiskArrays");
    }

    private void cleanupSelect(RepositoryAccessor repositoryAccessor) {
        block10: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"cleanupSelect", (String)"accessor");
            }
            try {
                repositoryAccessor.closeSelect();
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block10;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"cleanupSelect", (Throwable)generalException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanupSelect");
        }
    }

    private void getDomainNames(List list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDomainNames", (String)"list");
        }
        Domain domain = new Domain();
        TResDomain tResDomain = new TResDomain(this.dbc);
        tResDomain.prepFetchByID();
        for (ExtAlertLog extAlertLog : list) {
            domain.domID = extAlertLog.alResourceID;
            tResDomain.fetchByID(domain);
            extAlertLog.setAlObjectName(domain.domName);
        }
        tResDomain.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDomainNames");
        }
    }

    private void getComputerNames(List list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerNames", (String)"list");
        }
        TResComputer tResComputer = new TResComputer(this.dbc);
        tResComputer.prepSelectName();
        for (ExtAlertLog extAlertLog : list) {
            extAlertLog.setAlObjectName(tResComputer.fetchName(extAlertLog.alResourceID));
        }
        tResComputer.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerNames");
        }
    }

    private void getTreeNames(List list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTreeNames", (String)"list");
        }
        TResLdapTree tResLdapTree = new TResLdapTree(this.dbc);
        tResLdapTree.prepFetchByID();
        for (ExtAlertLog extAlertLog : list) {
            extAlertLog.setAlObjectName(tResLdapTree.fetchByID(extAlertLog.alResourceID));
        }
        tResLdapTree.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTreeNames");
        }
    }

    private void getMissingFilers(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMissingFilers", (String)"records");
        }
        LinkedList<ExtAlertLog> linkedList = new LinkedList<ExtAlertLog>();
        LinkedList<ExtAlertLog> linkedList2 = new LinkedList<ExtAlertLog>();
        LinkedList<ExtAlertLog> linkedList3 = new LinkedList<ExtAlertLog>();
        while (extAlertLog != null) {
            if (extAlertLog.alAlertCondition == 66) {
                switch (extAlertLog.alResourceType) {
                    case 25: {
                        linkedList.add(extAlertLog);
                        break;
                    }
                    case 1: {
                        linkedList2.add(extAlertLog);
                        break;
                    }
                    case 66: {
                        linkedList3.add(extAlertLog);
                    }
                }
            } else if (extAlertLog.alResourceType == 1) {
                extAlertLog.alResourceType = (short)-1;
                extAlertLog.alResourceID = -1;
            }
            extAlertLog = extAlertLog.alnExt;
        }
        if (!linkedList.isEmpty()) {
            this.getDomainNames(linkedList);
        }
        if (!linkedList2.isEmpty()) {
            this.getComputerNames(linkedList2);
        }
        if (!linkedList3.isEmpty()) {
            this.getTreeNames(linkedList3);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMissingFilers");
        }
    }

    private void getFilesystems(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFilesystems", (String)"records");
        }
        TResFS tResFS = new TResFS(this.dbc);
        tResFS.prepSelectByID();
        while (extAlertLog != null) {
            Filesystem filesystem = tResFS.getByID(extAlertLog.alResourceID);
            if (filesystem != null) {
                extAlertLog.setAlObjectName(filesystem.fsMountPoint);
            }
            extAlertLog = extAlertLog.alnExt;
        }
        tResFS.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFilesystems");
        }
    }

    private void getFoundComputers(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFoundComputers", (String)"records");
        }
        FoundComputer foundComputer = new FoundComputer();
        TFoundComputer tFoundComputer = new TFoundComputer(this.dbc);
        tFoundComputer.prepSelectByID();
        while (extAlertLog != null) {
            foundComputer.fcID = extAlertLog.alComputerID;
            tFoundComputer.fetchByID(foundComputer);
            extAlertLog.alComputer = TFoundComputer.canonicalName(foundComputer);
            extAlertLog = extAlertLog.alnExt;
        }
        tFoundComputer.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFoundComputers");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getSwitchLabels(ExtAlertLog extAlertLog) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getSwitchLabels", (String)"records");
        }
        DBConnection dBConnection = null;
        try {
            block23: {
                try {
                    DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                    dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                    dBConnection.setAutoCommit(true);
                    TResComputer tResComputer = new TResComputer(this.dbc);
                    tResComputer.prepSelectName();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    TResDiskArray tResDiskArray = new TResDiskArray(this.dbc);
                    tResDiskArray.prepFetchByID();
                    while (true) {
                        Object object;
                        if (extAlertLog == null) {
                            tResDiskArray.closeSelect();
                        }
                        String string = Integer.toString(extAlertLog.alResourceID);
                        String string2 = (String)hashMap.get(string);
                        if (string2 == null) {
                            object = FabricDbAccess.getSwitchDetail((DBConnection)dBConnection, (String)string);
                            if (object != null) {
                                if (object.next()) {
                                    hashMap.put(string, object.getString("LABEL"));
                                } else {
                                    hashMap.put(string, "");
                                }
                            }
                            string2 = (String)hashMap.get(string);
                        }
                        extAlertLog.setAlObjectName(string2);
                        object = (String)hashMap2.get(Integer.toString(extAlertLog.alComputerID));
                        if (object == null) {
                            String string3 = tResComputer.fetchName(extAlertLog.alComputerID);
                            if (string3 == null) {
                                string3 = "";
                            }
                            hashMap2.put(Integer.toString(extAlertLog.alComputerID), string3);
                        }
                        extAlertLog.alComputer = (String)hashMap2.get(Integer.toString(extAlertLog.alComputerID));
                        extAlertLog = extAlertLog.alnExt;
                    }
                }
                catch (Exception exception) {
                    Class<?> clazz3;
                    if (!TraceLogger.enableTrace) break block23;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"getSwitchLabels", (Throwable)exception);
                }
            }
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                dBConnection.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        dBConnection.close();
        if (!TraceLogger.enableTrace) return;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getSwitchLabels");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getFabricLabels(ExtAlertLog extAlertLog) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getFabricLabels", (String)"records");
        }
        DBConnection dBConnection = null;
        try {
            block23: {
                try {
                    DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                    dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                    dBConnection.setAutoCommit(true);
                    TResComputer tResComputer = new TResComputer(this.dbc);
                    tResComputer.prepSelectName();
                    while (true) {
                        if (extAlertLog == null) {
                            tResComputer.closeSelect();
                        }
                        String string = Integer.toString(extAlertLog.alResourceID);
                        short s = extAlertLog.alResourceType;
                        if (s == 114) {
                            DBResultSet dBResultSet = FabricDbAccess.getFabricDetail((DBConnection)dBConnection, (String)string);
                            if (dBResultSet != null && dBResultSet.next()) {
                                extAlertLog.setAlObjectName(dBResultSet.getString("LABEL"));
                            }
                        } else if (s == 127) {
                            extAlertLog.setAlObjectName(FabricDbAccess.getZoneNameForZone((int)extAlertLog.alResourceID));
                        } else if (s == 126) {
                            extAlertLog.setAlObjectName(FabricDbAccess.getZoneSetNameForZoneSet((int)extAlertLog.alResourceID));
                        }
                        extAlertLog.alComputer = tResComputer.fetchName(extAlertLog.alComputerID);
                        extAlertLog = extAlertLog.alnExt;
                    }
                }
                catch (Exception exception) {
                    Class<?> clazz3;
                    if (!TraceLogger.enableTrace) break block23;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"getFabricLabels", (Throwable)exception);
                }
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                dBConnection.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        dBConnection.close();
        if (!TraceLogger.enableTrace) return;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getFabricLabels");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getEndpointLabels(ExtAlertLog extAlertLog) throws GeneralException {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getEndpointLabels", (String)"records");
        }
        DBConnection dBConnection = null;
        try {
            block23: {
                try {
                    DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                    dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                    dBConnection.setAutoCommit(true);
                    TResComputer tResComputer = new TResComputer(this.dbc);
                    tResComputer.prepSelectName();
                    while (extAlertLog != null) {
                        DBResultSet dBResultSet;
                        String string = Integer.toString(extAlertLog.alResourceID);
                        short s = extAlertLog.alResourceType;
                        if (s == 138) {
                            dBResultSet = FabricDbAccess.getNodeDetail((DBConnection)dBConnection, (String)string);
                            if (dBResultSet != null && dBResultSet.next()) {
                                extAlertLog.setAlObjectName(dBResultSet.getString("LABEL"));
                            }
                        } else if (s == 137) {
                            dBResultSet = FabricDbAccess.getPortDetail((DBConnection)dBConnection, (String)string);
                            if (dBResultSet != null && dBResultSet.next()) {
                                extAlertLog.setAlObjectName(dBResultSet.getString("LABEL"));
                            }
                        } else if (s == 139 && (dBResultSet = FabricDbAccess.getPhyPeDetail((DBConnection)dBConnection, (String)string)) != null && dBResultSet.next()) {
                            extAlertLog.setAlObjectName(dBResultSet.getString("LABEL"));
                        }
                        extAlertLog.alComputer = tResComputer.fetchName(extAlertLog.alComputerID);
                        extAlertLog = extAlertLog.alnExt;
                    }
                }
                catch (Exception exception) {
                    Class<?> clazz3;
                    if (!TraceLogger.enableTrace) break block23;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"getEndpointLabels", (Throwable)exception);
                }
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                dBConnection.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        dBConnection.close();
        if (!TraceLogger.enableTrace) return;
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)clazz.getName(), (String)"getEndpointLabels");
    }

    private void getVolumes(ExtAlertLog extAlertLog) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getVolumes", (String)"records");
        }
        TResStorageVolume tResStorageVolume = new TResStorageVolume(this.dbc);
        tResStorageVolume.prepSelectName();
        while (extAlertLog != null) {
            extAlertLog.setAlObjectName(tResStorageVolume.getVolumeName(extAlertLog.alResourceID));
            extAlertLog = extAlertLog.alnExt;
        }
        tResStorageVolume.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.AlertLogResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDisks");
        }
    }
}

