/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.Service;
import org.eclipse.aperi.server.req.ServerStatusResp;

public class ServerStatusHndlr
implements RequestHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.ServerStatusHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, comm");
        }
        ServerStatusResp serverStatusResp = new ServerStatusResp();
        Response response = Response.getResponse((short)0, (Serializable)serverStatusResp);
        serverStatusResp.serverName = Server.name;
        serverStatusResp.startTime = Server.startTime;
        long l = System.currentTimeMillis();
        serverStatusResp.upTime = (int)((l - Server.startTime.getTime()) / 1000L);
        serverStatusResp.dbConnections = Server.connectionPool.getConnectionCount();
        serverStatusResp.dbPoolCount = Server.connectionPool.getPoolElementCount();
        serverStatusResp.jdbcURL = Server.repositoryURL;
        serverStatusResp.jdbcDriver = Server.repositoryDriver;
        serverStatusResp.maxConnections = Server.maxConnections;
        serverStatusResp.totalMemory = (int)Runtime.getRuntime().totalMemory();
        serverStatusResp.connectionCount = Server.connectionCount;
        serverStatusResp.listenerPort = Server.getListenerPort();
        serverStatusResp.computerID = Server.serverIdentity.computer.computerID;
        serverStatusResp.osType = Server.serverIdentity.computer.hwID.osType;
        Iterator iterator = Server.agentMgr.listAgents();
        while (iterator.hasNext()) {
            object = (AgentManager.AgentAddress)iterator.next();
            if (object.computerID <= 0 || object.state == 2) continue;
            serverStatusResp.totalAgents = (short)(serverStatusResp.totalAgents + 1);
            if (object.state == 1) {
                if (object.upgradeRequired != 0) {
                    serverStatusResp.upgradeNeededAgents = (short)(serverStatusResp.upgradeNeededAgents + 1);
                }
                if (object.consecutiveErrors > 0) {
                    serverStatusResp.unreachableAgents = (short)(serverStatusResp.unreachableAgents + 1);
                    continue;
                }
                serverStatusResp.onlineAgents = (short)(serverStatusResp.onlineAgents + 1);
                continue;
            }
            if (object.state == 0) {
                serverStatusResp.offlineAgents = (short)(serverStatusResp.offlineAgents + 1);
                if (object.upgradeRequired == 0) continue;
                serverStatusResp.upgradeNeededAgents = (short)(serverStatusResp.upgradeNeededAgents + 1);
                continue;
            }
            if (object.state != 3) continue;
            serverStatusResp.upgradingAgents = (short)(serverStatusResp.upgradingAgents + 1);
        }
        object = Server.serviceMgr.listServices();
        serverStatusResp.services = new ServerStatusResp.Service[((Service[])object).length];
        int n = 0;
        while (n < ((Service[])object).length) {
            Service service = object[n];
            ServerStatusResp.Service service2 = new ServerStatusResp.Service();
            Service service3 = service;
            synchronized (service3) {
                service2.serviceName = service.serviceName;
                service2.requestType = service.requestType;
                service2.pendingRequests = service.queue.getPending();
                service2.processedRequests = service.queue.getProcessed();
                service2.threadsWaiting = service.queue.getWaiting();
                service2.state = (byte)(service.instance != null ? 1 : 2);
            }
            serverStatusResp.services[n] = service2;
            ++n;
        }
        Response response2 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.server.ServerStatusHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response2);
        }
        return response2;
    }
}

