/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.constants.RequestType;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.StateChangeReq;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.Service;
import org.eclipse.aperi.server.ThreadSafe;

public class StateChangeHndlr
implements RequestHandler,
ThreadSafe {
    public Response handle(Request request, Transceiver transceiver) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.StateChangeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, comm");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.request.StateChangeReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            Response response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.handler.server.StateChangeHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle", (Object)response2);
            }
            return response2;
        }
        StateChangeReq stateChangeReq = (StateChangeReq)request.requestData;
        if (!RequestType.isValid((String)stateChangeReq.serviceProvider)) {
            Server.setResponseError(response, "SRV0034E", String.valueOf(stateChangeReq.serviceProvider));
            Response response3 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.server.StateChangeHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"handle", (Object)response3);
            }
            return response3;
        }
        Service service = Server.serviceMgr.getService(stateChangeReq.serviceProvider);
        if (service == null) {
            Server.setResponseError(response, "SRV0035E", service.serviceName);
            Response response4 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.server.handler.server.StateChangeHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz5.getName(), (String)"handle", (Object)response4);
            }
            return response4;
        }
        boolean bl = stateChangeReq.serviceProvider.equals("org.eclipse.aperi.server.svp.ServerSvp") ? StateChangeHndlr.shutdownServer(stateChangeReq.newState) : (stateChangeReq.newState == 4 ? Server.serviceMgr.startService(service) : Server.serviceMgr.stopService(service, stateChangeReq.newState));
        if (!bl) {
            Server.setResponseError(response, "SRV0036E", service.serviceName);
        }
        Response response5 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz6;
            try {
                clazz6 = Class.forName("org.eclipse.aperi.server.handler.server.StateChangeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz6.getName(), (String)"handle", (Object)response5);
        }
        return response5;
    }

    public static boolean shutdownServer(byte by) {
        return StateChangeHndlr.shutdownServer(by, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutdownServer(byte by, Throwable throwable) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.server.StateChangeHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"shutdownServer", (String)"newState");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.server.Server");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Class<?> clazz3 = clazz;
        synchronized (clazz) {
            if (Server.terminate == 0) {
                Server.fatalError = throwable;
                Server.terminate = by;
                Server.thread.interrupt();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.server.handler.server.StateChangeHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"shutdownServer", (boolean)bl);
            }
            return bl;
        }
    }
}

