/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.jobs.Aggregation;

public abstract class AggregationMap {
    protected Connection dbc;
    protected HashMap parents = new HashMap();
    protected Aggregation networkAggregation;
    protected Aggregation aggregateList = null;
    protected MutableInteger hashKey = new MutableInteger();
    protected Aggregation factory;

    protected AggregationMap(Connection connection) {
        this.dbc = connection;
    }

    protected abstract void aggregate(Aggregation var1);

    protected void aggregateArrayMap(Aggregation aggregation, MutableInteger mutableInteger, HashMap hashMap) {
        Object v;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"aggregateArrayMap", (String)"additive, hashKey, map");
        }
        if ((v = hashMap.get(mutableInteger)) != null) {
            if (v instanceof Aggregation) {
                this.addTo((Aggregation)v, aggregation);
            } else {
                Aggregation[] aggregationArray = (Aggregation[])v;
                int n = 0;
                while (n < aggregationArray.length) {
                    this.addTo(aggregationArray[n], aggregation);
                    ++n;
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"aggregateArrayMap");
        }
    }

    public Aggregation getAggregateList() {
        return this.aggregateList;
    }

    public void clearAggregateList() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"clearAggregateList", (String)"");
        }
        while (this.aggregateList != null) {
            this.aggregateList.clear();
            this.aggregateList = this.aggregateList.agNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"clearAggregateList");
        }
    }

    protected Aggregation getUGAggregationList() {
        Aggregation aggregation;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getUGAggregationList", (String)"");
        }
        Aggregation aggregation2 = this.networkAggregation;
        aggregation2.agNext = null;
        Iterator iterator = this.parents.values().iterator();
        while (iterator.hasNext()) {
            aggregation = (Aggregation)iterator.next();
            aggregation.agNext = aggregation2;
            aggregation2 = aggregation;
        }
        aggregation = aggregation2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getUGAggregationList", (Object)aggregation);
        }
        return aggregation;
    }

    protected void replaceMapValues(HashMap hashMap, HashMap hashMap2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"replaceMapValues", (String)"map, parentMap");
        }
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Aggregation aggregation;
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            if (v instanceof Aggregation) {
                aggregation = this.getAggregation(hashMap2, ((Aggregation)v).agResourceID);
                entry.setValue(aggregation);
                continue;
            }
            Aggregation[] aggregationArray = (Aggregation[])v;
            int n = 0;
            while (n < aggregationArray.length) {
                aggregation = this.getAggregation(hashMap2, aggregationArray[n].agResourceID);
                entry.setValue(aggregation);
                ++n;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"replaceMapValues");
        }
    }

    protected void aggregate(Aggregation aggregation, HashMap hashMap) {
        Aggregation aggregation2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"aggregate", (String)"additive, map");
        }
        if ((aggregation2 = (Aggregation)hashMap.get(this.hashKey)) != null) {
            this.addTo(aggregation2, aggregation);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"aggregate");
        }
    }

    protected void addTo(Aggregation aggregation, Aggregation aggregation2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addTo", (String)"aggregation, additive");
        }
        aggregation.add(aggregation2);
        if (!aggregation.agUpdated) {
            aggregation.agUpdated = true;
            aggregation.agNext = this.aggregateList;
            this.aggregateList = aggregation;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addTo");
        }
    }

    protected Aggregation getAggregation(HashMap hashMap, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getAggregation", (String)"map, id");
        }
        this.factory.agResourceID = n;
        Aggregation aggregation = (Aggregation)hashMap.get(this.factory);
        if (aggregation == null) {
            aggregation = this.factory.newAggregation(n);
            hashMap.put(aggregation, aggregation);
        }
        Aggregation aggregation2 = aggregation;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getAggregation", (Object)aggregation2);
        }
        return aggregation2;
    }

    protected void addAggregationToMap(HashMap hashMap, Aggregation object, int n, int n2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addAggregationToMap", (String)"map, list, listSize, id");
        }
        if (n == 0) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"addAggregationToMap");
            }
            return;
        }
        Aggregation[] aggregationArray = object;
        if (n > 1) {
            Aggregation[] aggregationArray2 = new Aggregation[n];
            int n3 = 0;
            while (n3 < n) {
                aggregationArray2[n3] = object;
                object = object.agNext;
                ++n3;
            }
            aggregationArray = aggregationArray2;
        }
        hashMap.put(new MutableInteger(n2), aggregationArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.AggregationMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addAggregationToMap");
        }
    }
}

