/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.PingHist;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TStatCompHist;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.repository.table.TStatPingHist;
import org.eclipse.aperi.xmsg.MessageLog;

public class HistAvgs {
    private Connection dbc;
    private DiskHistory dskSnapShot = new DiskHistory();
    private CompHist cmpAccumulator = new CompHist();
    private PingHist pngAccumulator = new PingHist();
    private long timestamp;
    private String requestType;
    private byte accumType;
    private byte statType;
    public static final int WEEKLY_AVERAGE = 0;
    public static final int MONTHLY_AVERAGE = 1;

    public HistAvgs(Connection connection) {
        this.dbc = connection;
        try {
            this.timestamp = SQLUtil.getTimestamp(connection).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"HistAvgs", (Throwable)exception);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void average(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"average", (String)"avgType");
        }
        if (n == 0) {
            this.requestType = MessageLog.getMessageNoID((String)"STS0203L");
            this.accumType = (byte)3;
            this.statType = 1;
        } else {
            this.requestType = MessageLog.getMessageNoID((String)"STS0204L");
            this.accumType = (byte)4;
            this.statType = (byte)2;
        }
        MessageLog.logMessage((String)"STS0031I", (Object)this.requestType);
        try {
            try {
                LockManager.lock((short)0, (String)"History", (String)"DiskHist", (byte)1, (boolean)true);
                this.genDiskSnapShots();
                LockManager.lock((short)0, (String)"History", (String)"CompHist", (byte)1, (boolean)true);
                this.genCmpAverages();
                LockManager.lock((short)0, (String)"History", (String)"PingHist", (byte)1, (boolean)true);
                this.genPngAverages();
                MessageLog.logMessage((String)"STS0032I", (Object)this.requestType);
            }
            catch (GeneralException generalException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"average", (Throwable)generalException);
                }
                MessageLog.logMessage((String)"STS0030E", (Object)this.requestType);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"average");
                }
                throw generalException;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LockManager.unLock((short)0, (String)"History", (String)"DiskHist");
            LockManager.unLock((short)0, (String)"History", (String)"CompHist");
            LockManager.unLock((short)0, (String)"History", (String)"PingHist");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        LockManager.unLock((short)0, (String)"History", (String)"DiskHist");
        LockManager.unLock((short)0, (String)"History", (String)"CompHist");
        LockManager.unLock((short)0, (String)"History", (String)"PingHist");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"average");
        }
    }

    private void genDiskSnapShots() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genDiskSnapShots", (String)"");
        }
        TStatDiskHist tStatDiskHist = new TStatDiskHist(this.dbc);
        tStatDiskHist.prepSnapShots();
        while (tStatDiskHist.fetchMostRecent(this.dskSnapShot)) {
            this.dskSnapShot.dkhType = this.statType;
            this.dskSnapShot.dkhTimestamp = this.timestamp;
            tStatDiskHist.insertHist(this.dskSnapShot);
        }
        tStatDiskHist.closeSnapShots();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genDiskSnapShots");
        }
    }

    private void genCmpAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genCmpAverages", (String)"");
        }
        TStatCompHist tStatCompHist = new TStatCompHist(this.dbc);
        tStatCompHist.prepAverages(this.accumType);
        this.cmpAccumulator.chStatisticType = this.accumType;
        while (tStatCompHist.fetch(this.cmpAccumulator)) {
            if (this.cmpAccumulator.chMonitorStart <= 86400000L) continue;
            this.cmpAccumulator.chStatisticType = this.statType;
            tStatCompHist.insert(this.cmpAccumulator);
            this.cmpAccumulator.chMonitorStart = 0L;
            this.cmpAccumulator.chMonitorEnd = 0L;
            this.cmpAccumulator.chDownTime = 0;
            this.cmpAccumulator.chPowerCycles = 0;
            this.cmpAccumulator.chStatisticType = this.accumType;
            tStatCompHist.update(this.cmpAccumulator);
            tStatCompHist.commit();
        }
        tStatCompHist.closeAverages();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genCmpAverages");
        }
    }

    private void genPngAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genPngAverages", (String)"");
        }
        TStatPingHist tStatPingHist = new TStatPingHist(this.dbc);
        tStatPingHist.prepAverages(this.accumType);
        this.pngAccumulator.pngStatisticType = this.accumType;
        while (tStatPingHist.fetch(this.pngAccumulator)) {
            if (this.pngAccumulator.pngMonitorStart <= 86400000L) continue;
            this.pngAccumulator.pngStatisticType = this.statType;
            if (this.pngAccumulator.pngReceived > 0) {
                this.pngAccumulator.pngAvgTransitTime /= (long)this.pngAccumulator.pngReceived;
            }
            tStatPingHist.insert(this.pngAccumulator);
            this.pngAccumulator.pngMonitorStart = 0L;
            this.pngAccumulator.pngMonitorEnd = 0L;
            this.pngAccumulator.pngTransmitted = 0;
            this.pngAccumulator.pngReceived = 0;
            this.pngAccumulator.pngDamaged = 0;
            this.pngAccumulator.pngMinTransitTime = Integer.MAX_VALUE;
            this.pngAccumulator.pngMaxTransitTime = 0;
            this.pngAccumulator.pngAvgTransitTime = 0L;
            this.pngAccumulator.pngStatisticType = this.accumType;
            tStatPingHist.update(this.pngAccumulator);
            tStatPingHist.commit();
        }
        tStatPingHist.closeAverages();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.HistAvgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genPngAverages");
        }
    }
}

