/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.RAStreamBufferMgr;

public class RAFolderOutputStream
extends RAOutputStream {
    FolderArchiveWriter archive;
    private RandomAccessFile randomFile;
    private RAStreamBufferMgr bufferMgr;

    public RAFolderOutputStream(FolderArchiveWriter archive, File file) throws FileNotFoundException, IOException {
        this.archive = archive;
        this.randomFile = new RandomAccessFile(file, "rw");
        try {
            this.randomFile.setLength(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.bufferMgr = new RAStreamBufferMgr(this.randomFile);
    }

    private void flushBuffer() throws IOException {
        this.bufferMgr.flushBuffer();
    }

    public void write(int b) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)b};
        this.bufferMgr.write(writeBuffer, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.bufferMgr.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.bufferMgr.write(b, off, len);
    }

    public void writeInt(int v) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.bufferMgr.write(writeBuffer, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.bufferMgr.write(writeBuffer, 0, 8);
    }

    public long getOffset() throws IOException {
        return this.bufferMgr.getFilePointer();
    }

    public void seek(long localPos) throws IOException {
        this.bufferMgr.seek(localPos);
    }

    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.randomFile.close();
        super.close();
        this.archive.removeStream(this);
    }
}

