/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.cimom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.cimom.CimomWrapperCreator;
import org.eclipse.aperi.discovery.interfaces.CIMEnumerationResponse;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.FakeCIMEnumeration;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.pool.Pool;
import org.eclipse.aperi.util.pool.ResourceCreator;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.client.CIMEnumeration;

public class CIMScanner
extends Thread {
    public static String queueName = "CIM/OM";
    public static Pool cimomWrapperPool = new Pool((ResourceCreator)new CimomWrapperCreator());
    private boolean shutdown = false;
    private Thread thread = null;
    public static final String MESSAGE_NAME = "aperi.logger.message.CIMScanner";
    public static final String TRACE_NAME = "aperi.logger.trace.CIMScanner";
    public static String MSG_FILE = "org.eclipse.aperi.resources.CIMScanner";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public boolean trace = false;
    String className;

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public CIMScanner() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.cimom.CIMScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.className = clazz.getName();
        this.setName(String.valueOf(queueName) + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String string = "CIMScanner.run";
        if (traceLogger != null && traceLogger.isLogging()) {
            this.trace = true;
        }
        if (this.trace) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this.className, string);
        }
        this.thread = Thread.currentThread();
        while (true) {
            Object var12_15;
            StringBuffer stringBuffer;
            if (this.shutdown) {
                if (this.trace) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this.className, string);
                }
                return;
            }
            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": waiting for a job");
            JobInfo jobInfo = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) continue;
            if (jobInfo == null) {
                if (!this.trace) continue;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, ":Error - got a NULL job from the queue");
                continue;
            }
            Query query = (Query)jobInfo.getRequest().getData();
            String string2 = null;
            Request request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
            if (request != null) {
                string2 = request.getScannerId();
            }
            if (this.trace) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(String.valueOf(queueName) + ": invoking " + query.toString() + " on " + jobInfo.getTarget()[0] + " " + jobInfo.getTarget()[1]);
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, stringBuffer.toString());
            }
            jobInfo.getRequest().getData();
            stringBuffer = null;
            try {
                try {
                    block42: {
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("USERID", jobInfo.getTarget().length > 2 ? (jobInfo.getTarget()[2] != null ? jobInfo.getTarget()[2] : "") : "");
                        hashtable.put("PASSWORD", jobInfo.getTarget().length > 3 ? (jobInfo.getTarget()[3] != null ? jobInfo.getTarget()[3] : "") : "");
                        hashtable.put("URL", jobInfo.getTarget()[0]);
                        hashtable.put("NAMESPACE", jobInfo.getTarget()[1]);
                        stringBuffer = (CIMClientWrapper)cimomWrapperPool.getResource(hashtable);
                        if (jobInfo.getTarget().length > 4 && jobInfo.getTarget()[4] != null) {
                            try {
                                long l = Long.parseLong(jobInfo.getTarget()[4]);
                                stringBuffer.setTimeout(l);
                                if (this.trace) {
                                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, "Using CIM timeout value of " + jobInfo.getTarget()[4]);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!this.trace) break block42;
                                traceLogger.text(IRecordType.TYPE_WARN, (Object)this.className, string, "Could not parse CIM timeout value of " + jobInfo.getTarget()[4]);
                            }
                        }
                    }
                    CIMEnumeration cIMEnumeration = null;
                    switch (query.getCmd()) {
                        case 6: {
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.references" + query.getCmd());
                            }
                            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(string2, ProbePerfTracker.CIMOM_REFERENCES);
                            cIMEnumeration = (CIMEnumeration)stringBuffer.references(query.getCOP(), query.getResultClassName(), query.getRole(), true, true, null);
                            TrackProbePerformance.finishedProbeAction(probeAction);
                            break;
                        }
                        case 7: {
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.referenceNames" + query.getCmd());
                            }
                            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(string2, ProbePerfTracker.CIMOM_REFERENCES_NAMES);
                            cIMEnumeration = (CIMEnumeration)stringBuffer.referenceNames(query.getCOP());
                            TrackProbePerformance.finishedProbeAction(probeAction);
                            break;
                        }
                        case 0: {
                            ProbePerfTracker.ProbeAction probeAction;
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.enumerateInstances" + query.getCmd());
                            }
                            if (query.getCOP() != null) {
                                probeAction = TrackProbePerformance.startProbeAction(string2, ProbePerfTracker.CIMOM_ENUMERATOR);
                                cIMEnumeration = (CIMEnumeration)stringBuffer.enumerateInstances(query.getCOP());
                                TrackProbePerformance.finishedProbeAction(probeAction);
                                break;
                            }
                            probeAction = TrackProbePerformance.startProbeAction(string2, ProbePerfTracker.CIMOM_ENUMERATOR);
                            cIMEnumeration = (CIMEnumeration)stringBuffer.enumerateInstances(new CIMObjectPath(query.getClassName()), true, false);
                            TrackProbePerformance.finishedProbeAction(probeAction);
                            break;
                        }
                        case 1: {
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.enumerateInstanceNames" + query.getCmd());
                            }
                            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(string2, ProbePerfTracker.CIMOM_ENUMERATOR_NAMES);
                            cIMEnumeration = (CIMEnumeration)stringBuffer.enumerateInstanceNames(new CIMObjectPath(query.getClassName()));
                            TrackProbePerformance.finishedProbeAction(probeAction);
                            break;
                        }
                        case 2: {
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.associators" + query.getCmd());
                            }
                            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(string2, ProbePerfTracker.CIMOM_ASSOCIATORS);
                            cIMEnumeration = (CIMEnumeration)stringBuffer.associators(query.getCOP(), query.getAssocClassName(), query.getResultClassName(), query.getRole(), query.getResultRole(), false, false, null);
                            TrackProbePerformance.finishedProbeAction(probeAction);
                            break;
                        }
                        case 3: {
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.AssociatorNames" + query.getCmd());
                            }
                            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(string2, ProbePerfTracker.CIMOM_ASSOCIATORS_NAMES);
                            cIMEnumeration = (CIMEnumeration)stringBuffer.associatorNames(query.getCOP(), query.getAssocClassName(), query.getResultClassName(), query.getRole(), query.getResultRole());
                            TrackProbePerformance.finishedProbeAction(probeAction);
                            break;
                        }
                        case 5: {
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.enumerateClassNames" + query.getCmd());
                            }
                            cIMEnumeration = (CIMEnumeration)stringBuffer.enumerateClassNames(new CIMObjectPath(query.getClassName()));
                            break;
                        }
                        case 4: {
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.enumerateClasses" + query.getCmd());
                            }
                            cIMEnumeration = (CIMEnumeration)stringBuffer.enumerateClasses(new CIMObjectPath(query.getClassName()), true, false, false, false);
                            break;
                        }
                        case 8: {
                            if (this.trace) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": invoking cimClient.getInstance" + query.getCmd());
                            }
                            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(string2, ProbePerfTracker.CIMOM_GETINSTANCE);
                            CIMInstance cIMInstance = stringBuffer.getInstance(query.getCOP(), false, null);
                            TrackProbePerformance.finishedProbeAction(probeAction);
                            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>(1);
                            arrayList.add(cIMInstance);
                            cIMEnumeration = new FakeCIMEnumeration(Collections.enumeration(arrayList));
                            break;
                        }
                        default: {
                            if (!this.trace) break;
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)this.className, string, String.valueOf(queueName) + ": Unsupported query " + query.getCmd());
                        }
                    }
                    jobInfo.setResponse((Response)new CIMEnumerationResponse((Enumeration)cIMEnumeration, jobInfo));
                    jobInfo.setReturnCode(99);
                    jobInfo.complete(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    if (this.trace) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, string, (Throwable)exception);
                    }
                    jobInfo.setResponse((Response)new CIMExceptionResponse((Throwable)exception, jobInfo));
                    jobInfo.setReturnCode(99);
                    jobInfo.complete(false);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, throwable);
                    if (this.trace) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, string, throwable);
                    }
                    jobInfo.setResponse((Response)new CIMExceptionResponse(throwable, jobInfo));
                    jobInfo.setReturnCode(99);
                    jobInfo.complete(false);
                }
            }
            catch (Throwable throwable) {
                var12_15 = null;
                if (stringBuffer != null) {
                    cimomWrapperPool.freeResource((Object)stringBuffer);
                }
                throw throwable;
            }
            {
                var12_15 = null;
                if (stringBuffer == null) continue;
            }
            cimomWrapperPool.freeResource((Object)stringBuffer);
        }
    }

    public void shutdown() {
        this.shutdown = true;
        String string = "shutdown";
        if (traceLogger != null && traceLogger.isLogging()) {
            this.trace = true;
        }
        if (this.thread != null) {
            try {
                if (this.trace) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)this, string, "CIMScanner is shutting down");
                }
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception exception) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "Error during CIMScanner shutdown");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this.className, string, (Throwable)exception);
                }
                exception.printStackTrace();
            }
        }
    }
}

