/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner.interfaces;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Response
implements Serializable {
    private static final long serialVersionUID = 20001130L;
    public static final String level = "LEVEL";
    public static final String benchmarkLevel = "BENCHMARK";
    public static final String benchmarkLabel = "BENCHMARK LABEL";
    public static final String sameAsBenchmark = "SAME AS BENCHMARK";
    public static int RETURN_CODE_OK = 0;
    public static int RETURN_CODE_ERROR = 47;
    public static int RETURN_CODE_INACTIVE_SCANNER = 48;
    private Hashtable parameters = new Hashtable();
    private int returnCode;
    private byte[] data;

    public Response(int n, String string) {
        this(n, string, new Hashtable());
    }

    public Response(int n, String[] stringArray) {
        this(n, stringArray, new Hashtable());
    }

    public Response(int n, String string, Hashtable hashtable) {
        this.returnCode = n;
        this.data = (byte[])(string != null && !string.equals("") ? this.compressData(string.getBytes()) : null);
    }

    public Response(int n, String[] stringArray, Hashtable hashtable) {
        this.returnCode = n;
        this.parameters = hashtable;
        this.data = (byte[])(stringArray != null && stringArray.length != 0 ? this.compressData(this.convertToByteArray(stringArray)) : null);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getData() {
        if (this.data == null || this.data.length == 0) {
            return new String();
        }
        return new String(this.uncompressData(this.data));
    }

    public Hashtable getParameters() {
        return this.parameters;
    }

    public String toString() {
        String string = new String();
        string = string.concat("\nResponse object\n");
        string = string.concat("  Return code = " + this.returnCode + "\n");
        if (this.data != null) {
            string = string.concat("  Data = \n" + this.getData() + "\n\n");
        }
        return string;
    }

    private byte[] compressData(byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length != 0) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                gZIPOutputStream.write(byArray, 0, byArray.length);
                gZIPOutputStream.close();
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                byArray2 = null;
            }
        }
        return byArray2;
    }

    private byte[] uncompressData(byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length != 0) {
            try {
                int n;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray3 = new byte[1024];
                while ((n = gZIPInputStream.read(byArray3, 0, byArray3.length)) != -1) {
                    byteArrayOutputStream.write(byArray3, 0, n);
                }
                gZIPInputStream.close();
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byArray2;
    }

    private String convertToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (stringArray != null && stringArray.length != 0) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private byte[] convertToByteArray(String[] stringArray) {
        byte[] byArray = null;
        if (stringArray != null && stringArray.length != 0) {
            byArray = this.convertToString(stringArray).getBytes();
        }
        return byArray;
    }
}

