/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskCIMProcessor
extends CIMProcessor {
    protected String cSMISVersion;
    protected String cDeviceModel;
    protected String cInstrumentationVersion;
    protected Hashtable cDBReferences = null;
    protected String cCIMNamespace;
    protected String cCIMServiceURL;
    protected String cScannerId;
    protected String cDedicated = null;
    protected String cAlertID = null;
    protected int cRequestId = 0;
    private int cCommitThreshold = 0;
    private List cCommitBuffer = null;
    private int cDeadlockRetries = 0;
    private int cMaxRetryInterval = 0;
    private DBPreparedStatement cVolKeyStmt = null;
    private DBPreparedStatement cVolIDStmt = null;
    private DBPreparedStatement cPortIDStmt = null;
    private DBPreparedStatement cNSIDStmt = null;
    protected NamesIDCache cNamesCache = null;
    private Map cPortIDCache = null;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DiskCIMProcessor(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"DiskCIMProcessor", (Object[])new Object[]{string});
        try {
            this.cSMISVersion = "";
            this.cDeviceModel = "";
            this.cInstrumentationVersion = "";
            this.cCIMNamespace = "";
            this.cCIMServiceURL = "";
            this.cScannerId = string;
            this.cAlertID = null;
            this.cCommitBuffer = new ArrayList();
            this.cCommitThreshold = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.CommitThreshold", (int)1);
            this.cDeadlockRetries = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetries", (int)2);
            this.cMaxRetryInterval = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetryInterval", (int)5000);
            this.cNamesCache = new NamesIDCache();
            this.cDBReferences = new Hashtable();
            this.cPortIDCache = new HashMap();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result initializeForSubsystemProbe(Map map) {
        Result result = new Result();
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"initializeForSubsystemProbe", null);
        try {
            this.setSMISVersion(((CapabilityData)map.get("CAPABILITY")).getSmisVersion());
            this.setDeviceModel((String)map.get("MODEL"));
            this.setInstrumentationVersion((String)map.get("CIMOMSWLVL"));
            this.setCIMNamespace(((String[])map.get("CIMOM"))[1]);
            this.setCIMServiceURL(((String[])map.get("CIMOM"))[0]);
            this.cAlertID = null;
            String string = (String)map.get("SUBSYSTEMID");
            CIMObjectPath cIMObjectPath = (CIMObjectPath)map.get("TL_CS");
            CIMInstance cIMInstance = new CIMInstance(cIMObjectPath);
            map.put("CIM_ComputerSystem", cIMInstance);
            Hashtable hashtable = new Hashtable();
            hashtable.put("ref_toplevelsystem_id", map.get("DEVICEID"));
            String[] stringArray = null;
            try {
                stringArray = ExternalKeyConverter.obtainStorageSubsystemKeyParts((String)string, (LogTraceHelper)logTraceHelper);
            }
            catch (IDParseException iDParseException) {
                Result result2 = new Result(1);
                Object var10_10 = null;
                logTraceHelper.exit((Object)result);
                return result2;
            }
            hashtable.put("ref_toplevelsystem_name", stringArray[0]);
            hashtable.put("ref_toplevelsystem_nameformat", stringArray[1]);
            Hashtable hashtable2 = new Hashtable();
            hashtable2.put(cIMInstance.getClassName(), hashtable);
            this.setDBReferences(hashtable2);
            result.setRc(0);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        logTraceHelper.exit((Object)result);
        return result;
    }

    public boolean start(int n) {
        this.cRequestId = n;
        this.cAlertID = String.valueOf(discoverEventPrefix) + n;
        TrackProbePerformance.startProbe(this.cScannerId);
        return super.start(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MapperResult handleEntity(String string, String string2, Hashtable hashtable) throws DiscoveryException {
        ProbePerfTracker.ProbeAction probeAction;
        MapperResult mapperResult;
        LogTraceHelper logTraceHelper;
        block17: {
            block15: {
                logTraceHelper = LogTraceHelper.entry((Object)this, (String)"handleEntity", (Object[])new Object[]{string, string2});
                Hashtable hashtable2 = new Hashtable();
                mapperResult = null;
                String string3 = null;
                string3 = string == null || string.length() == 0 ? this.cScannerId : string;
                probeAction = TrackProbePerformance.startProbeAction(string3, ProbePerfTracker.DISKCIMPROCESSOR_HANDLE_ENTITY);
                try {
                    try {
                        Object object;
                        String string4;
                        IDBAttributeMapper iDBAttributeMapper;
                        String string5;
                        block16: {
                            String string6;
                            if (logTraceHelper.isTraceHighEnabled()) {
                                logTraceHelper.traceHigh("Properties to persist: " + DiskMessageHelper.toMsgString((Object)hashtable));
                            }
                            string5 = (string6 = (String)hashtable.get("originalcimclassname")) != null ? string6 : string2;
                            iDBAttributeMapper = MapperRouter.getMapperRouter().findMapper(string2, this.cSMISVersion, this.cDeviceModel, this.cInstrumentationVersion, this.cDedicated, string6);
                            if (iDBAttributeMapper == null) {
                                logTraceHelper.traceWarning("DB Mapper does not exist for " + string2 + " or original class " + string6);
                                Object var19_13 = null;
                                break block15;
                            }
                            Enumeration enumeration = this.cDBReferences.keys();
                            while (true) {
                                if (!enumeration.hasMoreElements()) {
                                    hashtable2.put("ref_namespace", this.cCIMNamespace);
                                    hashtable2.put("ref_serviceurl", this.cCIMServiceURL);
                                    hashtable2.put("ref_classname", string2);
                                    hashtable2.putAll(hashtable);
                                    hashtable2 = this.addSystemNameID(hashtable2);
                                    string4 = String.valueOf(iDBAttributeMapper.getClass().getName()) + ".persist ";
                                    object = null;
                                    if (!logTraceHelper.isTraceHighEnabled()) break;
                                    logTraceHelper.traceSvcEntry(string4, new Object[]{this.connection, hashtable2, string3});
                                    break block16;
                                }
                                string4 = (String)enumeration.nextElement();
                                object = (Hashtable)this.cDBReferences.get(string4);
                                hashtable2.putAll(object);
                            }
                            logTraceHelper.traceSvcEntry(string4, null);
                        }
                        CommitBufferEntry commitBufferEntry = new CommitBufferEntry(iDBAttributeMapper, hashtable2, string3);
                        this.cCommitBuffer.add(commitBufferEntry);
                        object = TrackProbePerformance.startProbeAction(string3, ProbePerfTracker.MAPPER_PERSIST);
                        mapperResult = iDBAttributeMapper.persist(this.connection, hashtable2, string3);
                        TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)object);
                        commitBufferEntry.setKeyRefs(mapperResult.getKeyReferences());
                        if (this.cAlertID != null) {
                            boolean bl = false;
                            String string7 = (String)hashtable2.get("ref_subsystem_migrated");
                            if (string7 != null && string7.compareTo("1") == 0) {
                                bl = true;
                            }
                            AlertProcessor.processAlerts(this.cAlertID, mapperResult, this.newEntities, this.modifiedEntities, bl);
                        }
                        Hashtable hashtable3 = mapperResult.getKeyReferences();
                        logTraceHelper.traceSvcReturn(string4, (Object)hashtable3);
                        if (!hashtable3.isEmpty()) {
                            this.cDBReferences.put(string5, hashtable3);
                        }
                        this.commit(logTraceHelper);
                        break block17;
                    }
                    catch (SQLException sQLException) {
                        logTraceHelper.traceWarning("SQL Exception while persisting properties: " + DiskMessageHelper.toMsgString(hashtable2));
                        logTraceHelper.traceError(sQLException.getMessage(), (Throwable)sQLException);
                        try {
                            this.handleSQLException(logTraceHelper, sQLException, "handle Entity");
                            break block17;
                        }
                        catch (SQLException sQLException2) {
                            this.rollback(logTraceHelper);
                            throw new DiscoveryException(sQLException2);
                        }
                    }
                    catch (Exception exception) {
                        logTraceHelper.traceWarning("Exception while persisting properties: " + DiskMessageHelper.toMsgString(hashtable2));
                        logTraceHelper.traceError(exception.getMessage(), (Throwable)exception);
                        this.rollback(logTraceHelper);
                        throw new DiscoveryException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_14 = null;
                    TrackProbePerformance.finishedProbeAction(probeAction);
                    logTraceHelper.exit(mapperResult);
                    throw throwable;
                }
            }
            TrackProbePerformance.finishedProbeAction(probeAction);
            logTraceHelper.exit(mapperResult);
            return null;
        }
        Object var19_15 = null;
        TrackProbePerformance.finishedProbeAction(probeAction);
        logTraceHelper.exit(mapperResult);
        return mapperResult;
    }

    public void handleSQLException(LogTraceHelper logTraceHelper, SQLException sQLException, String string) throws SQLException {
        block10: {
            boolean bl = false;
            boolean bl2 = false;
            try {
                int n = 0;
                boolean bl3 = this.connection.isClosed();
                while (this.connection != null && this.connection.isClosed() && n < this.cDeadlockRetries) {
                    if (logTraceHelper != null) {
                        logTraceHelper.traceWarning("Connection closed, obtaining new Connection");
                    }
                    this.connection = ServiceUtils.getConnection();
                    this.cVolKeyStmt = null;
                    this.cNamesCache.reset();
                    ++n;
                }
                boolean bl4 = bl2 = this.connection != null && !this.connection.isClosed();
                if (bl3 && bl2) {
                    if (logTraceHelper != null) {
                        logTraceHelper.traceWarning("Continueing probe with scanner ID " + this.cScannerId + " with new db connection.");
                    }
                    this.handleDeadlock();
                    break block10;
                }
                if (!bl3 && SQLExceptionHelper.isDeadlock((DBConnection)this.connection, (SQLException)sQLException)) {
                    this.handleDeadlock();
                    break block10;
                }
                bl = true;
                throw sQLException;
            }
            catch (SQLException sQLException2) {
                this.rollback(logTraceHelper);
                if (bl) {
                    if (logTraceHelper != null) {
                        logTraceHelper.traceError("Non-deadlock exception during " + string, (Throwable)sQLException2);
                    }
                    throw sQLException;
                }
                if (logTraceHelper != null) {
                    logTraceHelper.traceError("Exception during connection check or deadlock handling.", (Throwable)sQLException2);
                }
                throw sQLException2;
            }
        }
    }

    public void handleEntity(JobInfo jobInfo, String string, Hashtable hashtable) throws DiscoveryException {
        this.handleEntity(this.getScanID(jobInfo), string, hashtable);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAssociation(JobInfo jobInfo, String string, String string2, Hashtable hashtable, String string3, Hashtable hashtable2, Hashtable hashtable3) throws DiscoveryException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"handleAssociation", (Object[])new Object[]{jobInfo.getResourceId(), string, string3});
        try {
            this.handleEntity(jobInfo, string3, hashtable2);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        logTraceHelper.exit(null);
    }

    public void handleInstance(JobInfo jobInfo, CIMInstance cIMInstance) throws DiscoveryException {
        Hashtable hashtable = CIMProcessor.convertPropertiesToHashtable(cIMInstance.getAllProperties(), new Hashtable());
        hashtable.put("originalcimclassname", cIMInstance.getClassName());
        this.handleEntity(jobInfo, cIMInstance.getClassName(), hashtable);
    }

    protected String getScanID(JobInfo jobInfo) {
        String string = null;
        if (jobInfo != null) {
            string = super.getScanID(jobInfo);
        }
        if (string == null) {
            string = this.cScannerId;
        }
        return string;
    }

    public void setDBReferences(Hashtable hashtable) {
        this.cDBReferences = hashtable;
    }

    public Hashtable getDBReferences() {
        return this.cDBReferences;
    }

    public void setCIMNamespace(String string) {
        this.cCIMNamespace = string == null ? "" : string;
    }

    public String getCIMNamespace() {
        return this.cCIMNamespace;
    }

    public void setCIMServiceURL(String string) {
        this.cCIMServiceURL = string == null ? "" : string;
    }

    public String getCIMServiceURL() {
        return this.cCIMServiceURL;
    }

    public void setDeviceModel(String string) {
        this.cDeviceModel = string;
    }

    public void setInstrumentationVersion(String string) {
        this.cInstrumentationVersion = string;
    }

    public void setSMISVersion(String string) {
        this.cSMISVersion = string;
    }

    public void setDedicated(String string) {
        this.cDedicated = string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void end(int n) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((String)("" + n), (Object)this, (String)"end", (Object[])new Object[]{"" + n});
        try {
            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.PROCESSOR_END);
            super.end(n);
            TrackProbePerformance.finishedProbeAction(probeAction);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit((Object)"void");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit((Object)"void");
    }

    public void shutdown(int n) {
        this.cRequestId = n;
        this.shutdown();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((String)("" + this.cRequestId), (Object)this, (String)"shutdown", (Object[])new Object[]{"" + this.cRequestId});
        try {
            TrackProbePerformance.finishedProbe(this.cScannerId, logTraceHelper);
            try {
                this.doCommit(logTraceHelper);
                if (this.cVolKeyStmt != null) {
                    this.cVolKeyStmt.close();
                }
                if (this.cVolIDStmt != null) {
                    this.cVolIDStmt.close();
                }
                if (this.cPortIDStmt != null) {
                    this.cPortIDStmt.close();
                }
                if (this.cNSIDStmt != null) {
                    this.cNSIDStmt.close();
                }
                this.cNamesCache.release();
                this.cPortIDCache.clear();
                this.cPortIDCache = null;
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Error commiting or closing statements", (Throwable)sQLException);
            }
            super.shutdown();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            logTraceHelper.exit((Object)"void");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        logTraceHelper.exit((Object)"void");
    }

    public short getSystemNamesID(String string) throws SQLException {
        return this.cNamesCache.getSystemNameID(string);
    }

    public int getVolumeID(Hashtable hashtable, int n) throws SQLException {
        int n2 = Integer.MIN_VALUE;
        String string = (String)hashtable.get("DeviceID".toLowerCase());
        DBPreparedStatement dBPreparedStatement = this.getVolIdStatement();
        dBPreparedStatement.setInt(1, n);
        dBPreparedStatement.setShort(2, this.cNamesCache.getClassNameID((String)hashtable.get("CreationClassName".toLowerCase())));
        dBPreparedStatement.setString(3, string);
        dBPreparedStatement.setShort(4, this.cNamesCache.getClassNameID((String)hashtable.get("SystemCreationClassName".toLowerCase())));
        dBPreparedStatement.setShort(5, this.cNamesCache.getSystemNameID((String)hashtable.get("SystemName".toLowerCase())));
        ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.DBC_QUERY);
        DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
        if (dBResultSet.next()) {
            n2 = dBResultSet.getInt(1);
        }
        TrackProbePerformance.finishedProbeAction(probeAction);
        dBResultSet.close();
        this.commit(null);
        return n2;
    }

    private DBPreparedStatement getVolIdStatement() throws SQLException {
        if (this.cVolIDStmt == null) {
            this.cVolIDStmt = this.connection.prepareStatement("SELECT VOLUME_ID FROM T_RES_CIMKEY_VOLUME WHERE CIM_NAMESPACE_ID=? AND CREATION_CLASS_NAME_ID=? AND DEVICE_ID=? AND SYSTEM_CREATION_CLASS_NAME_ID=? AND SYSTEM_NAMES_ID=?");
        }
        return this.cVolIDStmt;
    }

    public Object[] getVolumeKeys(Hashtable hashtable, int n) throws SQLException {
        Object[] objectArray = null;
        String string = (String)hashtable.get("DeviceID".toLowerCase());
        DBPreparedStatement dBPreparedStatement = this.getVolKeyStatement();
        dBPreparedStatement.setInt(1, n);
        dBPreparedStatement.setInt(2, (int)this.cNamesCache.getClassNameID((String)hashtable.get("CreationClassName".toLowerCase())));
        dBPreparedStatement.setString(3, string);
        dBPreparedStatement.setInt(4, (int)this.cNamesCache.getClassNameID((String)hashtable.get("SystemCreationClassName".toLowerCase())));
        dBPreparedStatement.setShort(5, this.cNamesCache.getSystemNameID((String)hashtable.get("SystemName".toLowerCase())));
        ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.DBC_QUERY);
        DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
        if (dBResultSet.next()) {
            objectArray = new Object[]{dBResultSet.getString(1), new Integer(dBResultSet.getInt(2)), new Integer(dBResultSet.getInt(3)), new Integer(dBResultSet.getInt(4))};
        }
        TrackProbePerformance.finishedProbeAction(probeAction);
        dBResultSet.close();
        this.commit(null);
        return objectArray;
    }

    private DBPreparedStatement getVolKeyStatement() throws SQLException {
        if (this.cVolKeyStmt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT sv.").append("NAME").append(",");
            stringBuffer.append("sv.").append("NAME_FORMAT").append(",");
            stringBuffer.append("sv.").append("SUBSYSTEM_ID").append(",");
            stringBuffer.append("sv.").append("SVID").append(" FROM ");
            stringBuffer.append(TResStorageVolumeTable.getTablename()).append(" as sv ");
            stringBuffer.append("WHERE sv.").append("SVID").append(" IN (SELECT ck.");
            stringBuffer.append("VOLUME_ID").append(" FROM ");
            stringBuffer.append(TResCimkeyVolumeTable.getTablename()).append(" as ck WHERE ck.");
            stringBuffer.append("CIM_NAMESPACE_ID").append("=? AND ck.");
            stringBuffer.append("CREATION_CLASS_NAME_ID").append("=? AND ck.");
            stringBuffer.append("DEVICE_ID").append("=? AND ck.");
            stringBuffer.append("SYSTEM_CREATION_CLASS_NAME_ID").append("=? AND ck.");
            stringBuffer.append("SYSTEM_NAMES_ID").append("=?)");
            this.cVolKeyStmt = this.connection.prepareStatement(stringBuffer.toString());
        }
        return this.cVolKeyStmt;
    }

    public int getPortID(Hashtable hashtable, int n) throws SQLException {
        Integer n2 = (Integer)this.cPortIDCache.get(hashtable.toString());
        if (n2 != null) {
            return n2;
        }
        int n3 = Integer.MIN_VALUE;
        String string = (String)hashtable.get("DeviceID".toLowerCase());
        DBPreparedStatement dBPreparedStatement = this.getPortIdStatement();
        dBPreparedStatement.setInt(1, n);
        dBPreparedStatement.setShort(2, this.cNamesCache.getClassNameID((String)hashtable.get("CreationClassName".toLowerCase())));
        dBPreparedStatement.setString(3, string);
        dBPreparedStatement.setShort(4, this.cNamesCache.getClassNameID((String)hashtable.get("SystemCreationClassName".toLowerCase())));
        dBPreparedStatement.setShort(5, this.cNamesCache.getSystemNameID((String)hashtable.get("SystemName".toLowerCase())));
        ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.DBC_QUERY);
        DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
        if (dBResultSet.next()) {
            n3 = dBResultSet.getInt(1);
        }
        TrackProbePerformance.finishedProbeAction(probeAction);
        dBResultSet.close();
        this.commit(null);
        if (n3 != Integer.MIN_VALUE) {
            this.cPortIDCache.put(hashtable.toString(), new Integer(n3));
        }
        return n3;
    }

    private DBPreparedStatement getPortIdStatement() throws SQLException {
        if (this.cPortIDStmt == null) {
            this.cPortIDStmt = this.connection.prepareStatement("SELECT PORT_ID FROM T_RES_CIMKEY_PORT WHERE CIM_NAMESPACE_ID=? AND CREATION_CLASS_NAME_ID=? AND DEVICE_ID=? AND SYSTEM_CREATION_CLASS_NAME_ID=? AND SYSTEM_NAMES_ID=?");
        }
        return this.cPortIDStmt;
    }

    public void commit(LogTraceHelper logTraceHelper) throws SQLException {
        if (this.cCommitBuffer.size() >= this.cCommitThreshold) {
            this.doCommit(logTraceHelper);
        }
    }

    protected void rollback(LogTraceHelper logTraceHelper) {
        block2: {
            try {
                this.cCommitBuffer.clear();
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                if (logTraceHelper == null) break block2;
                logTraceHelper.traceWarning("SQLException during rolback: " + sQLException.getMessage());
            }
        }
    }

    public void doCommit(LogTraceHelper logTraceHelper) throws SQLException {
        try {
            if (logTraceHelper != null) {
                logTraceHelper.traceHigh("Commiting processor transaction (buffer-size :" + this.cCommitBuffer.size() + ") ");
            }
            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.DBC_COMMIT);
            this.connection.commit();
            TrackProbePerformance.finishedProbeAction(probeAction);
            this.cCommitBuffer.clear();
        }
        catch (SQLException sQLException) {
            this.handleSQLException(logTraceHelper, sQLException, "commit");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleDeadlock() throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"handleDeadlock", null);
        this.cCommitThreshold /= 2;
        if (this.cCommitThreshold < 1) {
            this.cCommitThreshold = 1;
        }
        logTraceHelper.traceWarning("Handling deadlock situation for scanner ID " + this.cScannerId + " with " + this.cCommitBuffer.size() + " entries in the buffer.");
        logTraceHelper.traceWarning("Transaction size now set to  " + this.cCommitThreshold);
        try {
            Random random = new Random();
            int n = 0;
            while (n < this.cDeadlockRetries) {
                try {
                    this.persistCommitBuffer(logTraceHelper);
                    break;
                }
                catch (SQLException sQLException) {
                    try {
                        if (!SQLExceptionHelper.isDeadlock((DBConnection)this.connection, (SQLException)sQLException)) {
                            logTraceHelper.traceError("Non-deadlock exception during re-persisting of commit buffer", (Throwable)sQLException);
                            throw sQLException;
                        }
                        logTraceHelper.traceWarning("Deadlock during retry (" + ++n + "/" + this.cDeadlockRetries + ")");
                        try {
                            long l = (long)random.nextInt(this.cMaxRetryInterval) * (long)n;
                            logTraceHelper.traceHigh("Waiting for " + l + "msecs before retrying deadlocked operations");
                            Thread.sleep(random.nextInt(this.cMaxRetryInterval));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (SQLException sQLException2) {
                        logTraceHelper.traceError("Checking exception for deadlock situation produced an error.", (Throwable)sQLException2);
                        logTraceHelper.traceError("Original exception to check:", (Throwable)sQLException);
                        throw sQLException2;
                    }
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            logTraceHelper.exit((Object)"void");
            throw throwable;
        }
        logTraceHelper.exit((Object)"void");
    }

    private MapperResult persistCommitBuffer(LogTraceHelper logTraceHelper) throws SQLException {
        MapperResult mapperResult = new MapperResult();
        int n = this.cCommitBuffer.size();
        Iterator iterator = this.cCommitBuffer.iterator();
        while (iterator.hasNext()) {
            --n;
            CommitBufferEntry commitBufferEntry = (CommitBufferEntry)iterator.next();
            if (logTraceHelper != null && logTraceHelper.isTraceHighEnabled()) {
                logTraceHelper.traceHigh("Properties to persist during retry (" + n + " left): " + DiskMessageHelper.toMsgString((Object)commitBufferEntry.getPersistData()));
            }
            ProbePerfTracker.ProbeAction probeAction = TrackProbePerformance.startProbeAction(commitBufferEntry.getScannerID(), ProbePerfTracker.MAPPER_PERSIST);
            mapperResult = commitBufferEntry.getMapper().persist(this.connection, commitBufferEntry.getPersistData(), commitBufferEntry.getScannerID());
            TrackProbePerformance.finishedProbeAction(probeAction);
            if (!commitBufferEntry.compareKeyRefs(mapperResult.getKeyReferences())) {
                if (logTraceHelper != null) {
                    logTraceHelper.traceError("Retry to persist entity returned different key references. Rolling back to maintain db integrity", null);
                }
                this.rollback(logTraceHelper);
                throw new SQLException("Error during deadlock handling retry: different key references returned by mapper during retry.");
            }
            this.connection.commit();
            iterator.remove();
        }
        if (this.cAlertID != null) {
            AlertProcessor.processAlerts(this.cAlertID, mapperResult, this.newEntities, this.modifiedEntities);
        }
        this.connection.commit();
        this.cCommitBuffer.clear();
        return mapperResult;
    }

    private Hashtable addSystemNameID(Hashtable hashtable) {
        if (hashtable.get("ref_system_names_id") != null) {
            return hashtable;
        }
        String string = (String)hashtable.get("systemname");
        if (string == null) {
            return hashtable;
        }
        try {
            short s = this.cNamesCache.getSystemNameID(string);
            if (s != Short.MIN_VALUE) {
                hashtable.put("ref_system_names_id", "" + s);
            }
            return hashtable;
        }
        catch (SQLException sQLException) {
            return hashtable;
        }
    }

    public String getNamespaceID(String string, String string2, LogTraceHelper logTraceHelper) throws SQLException {
        String string3 = null;
        DBPreparedStatement dBPreparedStatement = this.getNSIDStatement();
        dBPreparedStatement.clearParameters();
        dBPreparedStatement.setString(1, string2);
        dBPreparedStatement.setString(2, string);
        DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
        if (dBResultSet.next()) {
            string3 = String.valueOf(dBResultSet.getString(1));
        }
        dBResultSet.closeAll();
        this.commit(logTraceHelper);
        return string3;
    }

    private DBPreparedStatement getNSIDStatement() throws SQLException {
        if (this.cNSIDStmt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT c2n.").append("CIM_NAMESPACE_ID");
            stringBuffer.append(" FROM ");
            stringBuffer.append(TResCimom2namespaceTable.getTablename()).append(" as c2n ");
            stringBuffer.append("WHERE c2n.").append("NAMESPACE").append("=? AND c2n.");
            stringBuffer.append("CIMOM_ID").append(" IN (SELECT rc.");
            stringBuffer.append("REG_CIMOM_ID").append(" FROM ");
            stringBuffer.append(TResRegisteredCimomTable.getTablename()).append(" as rc WHERE rc.");
            stringBuffer.append("SERVICE_URL").append("=?)");
            this.cNSIDStmt = this.connection.prepareStatement(stringBuffer.toString());
        }
        return this.cNSIDStmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int updateComplexQueryDeadlockRetry(DBConnection dBConnection, String string, Hashtable hashtable) throws SQLException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.disk.collection.DiskCIMProcessor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)clazz.getName(), (String)"updateComplexQueryDeadlockRetry", (Object[])new Object[]{dBConnection, string, hashtable});
        int n = 0;
        try {
            int n2 = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetries", (int)2);
            int n3 = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetryInterval", (int)5000);
            Random random = new Random();
            int n4 = 0;
            while (n4 < n2) {
                try {
                    n = ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string, (Hashtable)hashtable);
                    break;
                }
                catch (SQLException sQLException) {
                    try {
                        if (!SQLExceptionHelper.isDeadlock((DBConnection)dBConnection, (SQLException)sQLException)) {
                            logTraceHelper.traceError("Non-deadlock exception during re-persisting of commit buffer", (Throwable)sQLException);
                            throw sQLException;
                        }
                        logTraceHelper.traceWarning("Deadlock during retry (" + ++n4 + "/" + n2 + ")");
                        try {
                            long l = (long)random.nextInt(n3) * (long)n4;
                            logTraceHelper.traceHigh("Waiting for " + l + "msecs before retrying deadlocked operations");
                            Thread.sleep(random.nextInt(n3));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (SQLException sQLException2) {
                        logTraceHelper.traceError("Checking exception for deadlock situation produced an error.", (Throwable)sQLException2);
                        logTraceHelper.traceError("Original exception to check:", (Throwable)sQLException);
                        throw sQLException2;
                    }
                }
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            logTraceHelper.exit((Object)new Integer(n));
            throw throwable;
        }
        logTraceHelper.exit((Object)new Integer(n));
        return n;
    }

    protected class CommitBufferEntry {
        IDBAttributeMapper cMapper;
        Hashtable cPropertiesToPersist;
        String cScannerID;
        Hashtable cRetKeyRefs = null;

        public CommitBufferEntry(IDBAttributeMapper iDBAttributeMapper, Hashtable hashtable, String string) {
            this.cMapper = iDBAttributeMapper;
            this.cPropertiesToPersist = (Hashtable)hashtable.clone();
            this.cScannerID = string;
        }

        public IDBAttributeMapper getMapper() {
            return this.cMapper;
        }

        public Hashtable getPersistData() {
            return this.cPropertiesToPersist;
        }

        public String getScannerID() {
            return DiskCIMProcessor.this.cScannerId;
        }

        public void setKeyRefs(Hashtable hashtable) {
            this.cRetKeyRefs = (Hashtable)hashtable.clone();
        }

        public boolean compareKeyRefs(Hashtable hashtable) {
            if (this.cRetKeyRefs == null) {
                return true;
            }
            return DiskMessageHelper.toMsgString((Object)this.cRetKeyRefs).equals(DiskMessageHelper.toMsgString((Object)hashtable));
        }
    }

    public class NamesIDCache {
        private Map cCreationClassNamesList = new HashMap();
        private Map cSystemNamesList = new HashMap();
        private DBPreparedStatement cSysNameStmt = null;
        private DBPreparedStatement cCrClsNameStmt = null;

        public short getSystemNameID(String string) throws SQLException {
            Short s = (Short)this.cSystemNamesList.get(string);
            if (s != null) {
                return s;
            }
            s = this.retrieveSystemNameID(string);
            if (s == null) {
                return Short.MIN_VALUE;
            }
            this.cSystemNamesList.put(string, s);
            return s;
        }

        private Short retrieveSystemNameID(String string) throws SQLException {
            Short s = null;
            DBPreparedStatement dBPreparedStatement = this.getSysNamesStmt();
            dBPreparedStatement.setString(1, string);
            DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
            if (dBResultSet.next()) {
                s = new Short(dBResultSet.getShort(1));
            }
            dBResultSet.close();
            DiskCIMProcessor.this.doCommit(null);
            return s;
        }

        private DBPreparedStatement getSysNamesStmt() throws SQLException {
            if (this.cSysNameStmt == null) {
                this.cSysNameStmt = DiskCIMProcessor.this.connection.prepareStatement("select SYSTEM_NAMES_ID from T_RES_SYSTEM_NAMEs WHERE SYSTEM_NAME = ? FOR READ ONLY");
            }
            return this.cSysNameStmt;
        }

        public short getClassNameID(String string) throws SQLException {
            Short s = (Short)this.cCreationClassNamesList.get(string);
            if (s != null) {
                return s;
            }
            s = this.retrieveClassNameID(string);
            if (s == null) {
                return Short.MIN_VALUE;
            }
            this.cCreationClassNamesList.put(string, s);
            return s;
        }

        private Short retrieveClassNameID(String string) throws SQLException {
            Short s = null;
            DBPreparedStatement dBPreparedStatement = this.getClassNamesStmt();
            dBPreparedStatement.setString(1, string);
            DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
            if (dBResultSet.next()) {
                s = new Short(dBResultSet.getShort(1));
            }
            dBResultSet.close();
            DiskCIMProcessor.this.doCommit(null);
            return s;
        }

        private DBPreparedStatement getClassNamesStmt() throws SQLException {
            if (this.cCrClsNameStmt == null) {
                this.cCrClsNameStmt = DiskCIMProcessor.this.connection.prepareStatement("select ID from T_RES_CREATION_CLASS_NAME WHERE NAME = ? FOR READ ONLY");
            }
            return this.cCrClsNameStmt;
        }

        public void release() throws SQLException {
            this.cSystemNamesList = null;
            this.cCreationClassNamesList = null;
            if (this.cSysNameStmt != null) {
                this.cSysNameStmt.close();
            }
            if (this.cCrClsNameStmt != null) {
                this.cCrClsNameStmt.close();
            }
        }

        public void reset() throws SQLException {
            this.cSysNameStmt = null;
            this.cCrClsNameStmt = null;
        }
    }
}

