/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import org.eclipse.aperi.control.ControlThread;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.interfaces.NoResourcesAvailableException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ThreadPool {
    private Thread[] controlThreads = null;
    private Runnable nextJob = null;
    private String controllerName;
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.ThreadPool");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public ThreadPool(int n) {
        String string = "ThreadPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Starting " + n + " control threads...");
        }
        this.initializeThreadPool(n, "Controller");
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public ThreadPool(int n, String string) {
        String string2 = "ThreadPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string2);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Starting " + n + " control threads...");
        }
        this.initializeThreadPool(n, string);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    protected void initializeThreadPool(int n, String string) {
        String string2 = "initializeThreadPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string2);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Starting " + n + " control threads for " + string + "...");
        }
        this.controllerName = string;
        this.controlThreads = new ControlThread[n];
        int n2 = 0;
        while (n2 < this.controlThreads.length) {
            this.controlThreads[n2] = new ControlThread(this, n2 + 1);
            this.controlThreads[n2].start();
            ++n2;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public synchronized void addJobToPool(Runnable runnable) throws NoResourcesAvailableException {
        String string = "addJobToPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        if (this.nextJob != null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "All control threads are being used.  Throwing NoResourcesAvailableException");
            }
            throw new NoResourcesAvailableException();
        }
        this.nextJob = runnable;
        this.notify();
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public synchronized Runnable getNextJob() {
        String string = "getNextJob";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        try {
            if (this.nextJob == null) {
                this.wait();
            }
            Runnable runnable = this.nextJob;
            this.nextJob = null;
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return runnable;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void shutdown() {
        String string = "shutdown";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        int n = 0;
        while (n < this.controlThreads.length) {
            block5: {
                try {
                    this.controlThreads[n].interrupt();
                    this.controlThreads[n].join(30000L);
                }
                catch (Exception exception) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block5;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
            ++n;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }
}

