/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent;

import java.util.Vector;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.svp.SocketHandler;
import org.eclipse.aperi.agent.util.SubprocessRegistry;
import org.eclipse.aperi.identity.SingleInstance;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.xmsg.MessageLog;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Activator
implements BundleActivator {
    private static Vector<IDisposable> _disposables = new Vector();
    private static BundleContext _bundleContext = null;
    private static boolean _abort = false;

    public void start(BundleContext bundleContext) throws Exception {
        _abort = false;
        _bundleContext = bundleContext;
        Agent.start();
        SocketHandler.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        Agent.state = (byte)2;
        String string = _abort ? "AGT0061I" : "AGT0060I";
        MessageLog.logMessage((String)string);
        SocketHandler.setEnabled(false);
        if (_abort) {
            Agent.setStopNow(true);
            SubprocessRegistry.killAll();
            SocketRegistry.deactivate();
        } else {
            Agent.jobManager.waitUntilJobsComplete();
        }
        Agent.state = (byte)3;
        Agent.reporter.shutdown(!_abort);
        if (Agent.upTimePoller != null) {
            Agent.upTimePoller.shutdown();
        }
        if (Agent.clsEventListener != null) {
            Agent.clsEventListener.shutdown();
        }
        SingleInstance.cleanup();
        TraceLoggerFactory.stopLogger((String)"org.eclipse.aperi.agent.svp.AgentSvp");
        Agent.closeAgentLog();
        Vector<IDisposable> vector = _disposables;
        synchronized (vector) {
            int n = 0;
            while (n < _disposables.size()) {
                IDisposable iDisposable = _disposables.get(n);
                iDisposable.dispose();
                ++n;
            }
            _disposables.clear();
        }
        Agent.reset();
    }

    public static void registerDisposable(IDisposable iDisposable) {
        _disposables.add(iDisposable);
    }

    public static void stopBundle(boolean bl) throws BundleException {
        _abort = bl;
        _bundleContext.getBundle().stop();
    }
}

