/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;

public class LANManagerDiscovery {
    private static String domain;

    static {
        LANManagerDiscovery.initIDs();
    }

    private static native void initIDs();

    private static native FoundComputer queryLANManager(String var0, boolean var1) throws LocalizableException;

    private static native String[] queryWorkstation(String var0) throws LocalizableException;

    public static FoundComputer findComputers(String string, boolean bl) throws LocalizableException {
        FoundComputer foundComputer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.LANManagerDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"findComputers", (String)"pDomain, excludeWorkstations");
        }
        FoundComputer foundComputer2 = foundComputer = LANManagerDiscovery.queryLANManager(string, bl);
        while (foundComputer2 != null) {
            InetAddress inetAddress;
            block13: {
                foundComputer2.fcDiscoveryMethod = 0;
                inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(foundComputer2.fcName);
                }
                catch (UnknownHostException unknownHostException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block13;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.LANManagerDiscovery");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"findComputers", (Throwable)unknownHostException);
                }
            }
            if (inetAddress == null) {
                foundComputer2.fcIPAddress = " ";
            } else {
                foundComputer2.fcIPAddress = inetAddress.getHostAddress();
                foundComputer2.fcAddress = inetAddress;
            }
            foundComputer2.fcName = foundComputer2.fcName.toLowerCase();
            foundComputer2 = foundComputer2.fcNext;
        }
        FoundComputer foundComputer3 = foundComputer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.LANManagerDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"findComputers", (Object)foundComputer3);
        }
        return foundComputer3;
    }

    public static FoundComputer findComputers(String string) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.LANManagerDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"findComputers", (String)"pDomain");
        }
        FoundComputer foundComputer = LANManagerDiscovery.findComputers(string, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.LANManagerDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"findComputers", (Object)foundComputer);
        }
        return foundComputer;
    }

    public static FoundComputer findComputers() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.LANManagerDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"findComputers", (String)"");
        }
        FoundComputer foundComputer = LANManagerDiscovery.findComputers(null, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.LANManagerDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"findComputers", (Object)foundComputer);
        }
        return foundComputer;
    }

    public static String[] manualQuery(String string) throws LocalizableException {
        String[] stringArray = null;
        stringArray = LANManagerDiscovery.queryWorkstation(string);
        return stringArray;
    }
}

