/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.script;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.aperi.agent.handler.script.AbstractScriptHandler;
import org.eclipse.aperi.agent.handler.script.ScriptContext;
import org.eclipse.aperi.agent.handler.script.ScriptReaper;
import org.eclipse.aperi.agent.handler.script.WindowsScriptReaper;
import org.eclipse.aperi.agent.handler.script.unix.IPlatformSpecific;
import org.eclipse.aperi.agent.handler.script.unix.UnixScriptContext;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.WindowsCommandContext;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class WindowsScriptRunner
implements IAssignable {
    public static String systemDirectory;
    private String logFile;
    private PrintWriter out;
    private RunScriptReq requestData;
    private boolean purge;

    static {
        WindowsScriptRunner.init(Variables.homeDirectory);
    }

    private static native void init(String var0);

    private static native long spawn(String var0, String var1, String var2, long var3, long var5) throws LocalizableException;

    public static native int waitForProcess(long var0) throws LocalizableException;

    private WindowsScriptRunner(RunScriptReq runScriptReq, String string, PrintWriter printWriter, boolean bl) {
        this.requestData = runScriptReq;
        this.logFile = string;
        this.out = printWriter;
        this.purge = bl;
    }

    public static AbstractScriptHandler makeHandler() {
        return new WindowsScriptHandler();
    }

    public void execute() {
        int n;
        Comparable<StringBuffer> comparable;
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"execute", (String)"");
        }
        PrintWriter printWriter = MessageLog.getThreadLog();
        MessageLog.setThreadLog((PrintWriter)this.out);
        String string2 = null;
        String string3 = null;
        String string4 = this.requestData.scrArgv[0];
        WindowsScript windowsScript = JobUtil.resolveWindowsScript((String)string4);
        if (windowsScript != null) {
            string3 = windowsScript.wsResolvedName;
        } else if (Agent.honorSentScripts && this.requestData.scrData != null && this.requestData.scrData[0] != null) {
            string3 = string4;
            int n2 = string4.lastIndexOf(46);
            if (n2 >= 0) {
                this.requestData.scrExtension = string4.substring(n2 + 1);
            }
            string = String.valueOf('.') + this.requestData.scrExtension;
            if (n2 < 0) {
                string3 = String.valueOf(string3) + string;
            }
            if ((comparable = AbstractScriptHandler.writeTempFile("SCR", string, this.requestData.scrData[0])) != null) {
                n = WindowsScript.indexForExtension((String)this.requestData.scrExtension);
                string2 = ((File)comparable).getName();
                windowsScript = new WindowsScript(n, string2);
            }
        }
        if (windowsScript == null) {
            MessageLog.logMessage((String)"AGT0132E", (Object)string4);
            MessageLog.setThreadLog((PrintWriter)printWriter);
            this.out.close();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"execute");
            }
            return;
        }
        ScriptContext scriptContext = new ScriptContext();
        try {
            scriptContext.tempFiles = AbstractScriptHandler.makeMoreTempFiles(this.requestData, string2, this.purge);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"execute", (Throwable)generalException);
            }
            MessageLog.setThreadLog((PrintWriter)printWriter);
            this.out.close();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"execute");
            }
            return;
        }
        scriptContext.logFileName = this.logFile;
        string = null;
        comparable = new StringBuffer();
        switch (windowsScript.wsInterpreter) {
            case 0: {
                string = String.valueOf(JobUtil.scriptsDir) + '\\' + windowsScript.wsResolvedName;
                ((StringBuffer)comparable).append(string4);
                break;
            }
            case 1: {
                string = String.valueOf(systemDirectory) + "\\CMD.EXE";
                ((StringBuffer)comparable).append("CMD /C ");
                ((StringBuffer)comparable).append(windowsScript.wsResolvedName);
                break;
            }
            case 2: {
                string = String.valueOf(systemDirectory) + "\\CSCRIPT.EXE";
                ((StringBuffer)comparable).append("CSCRIPT ");
                ((StringBuffer)comparable).append(windowsScript.wsResolvedName);
            }
        }
        n = ((StringBuffer)comparable).length();
        int n3 = 1;
        while (n3 < this.requestData.scrArgv.length) {
            ((StringBuffer)comparable).append(' ');
            String string5 = this.requestData.scrArgv[n3];
            if (string5 != null) {
                boolean bl;
                boolean bl2 = bl = string5.indexOf(32) >= 0;
                if (bl) {
                    ((StringBuffer)comparable).append('\"');
                }
                ((StringBuffer)comparable).append(string5);
                if (bl) {
                    ((StringBuffer)comparable).append('\"');
                }
            }
            ++n3;
        }
        String string6 = ((StringBuffer)comparable).toString();
        MessageLog.logMessage((String)"AGT0133I", (Object)string3, (Object)string6.substring(n));
        this.out.println("--------------------- BEGIN OUTPUT ---------------------");
        boolean bl = false;
        try {
            scriptContext.handle = WindowsScriptRunner.spawn(string, string6, this.logFile, 0L, 0L);
            bl = true;
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"execute", (Throwable)localizableException);
            }
            localizableException.print();
        }
        if (bl) {
            WindowsScriptReaper.addJob(scriptContext, printWriter, this.out);
        } else {
            MessageLog.setThreadLog((PrintWriter)printWriter);
            this.out.close();
            ScriptReaper.removeTempFiles(scriptContext);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"execute");
        }
    }

    public static IPlatformSpecific makePlatformSpecific() {
        return new WinPlatformSpecific();
    }

    /* synthetic */ WindowsScriptRunner(RunScriptReq runScriptReq, String string, PrintWriter printWriter, boolean bl, WindowsScriptRunner windowsScriptRunner) {
        this(runScriptReq, string, printWriter, bl);
    }

    private static class WindowsScriptHandler
    extends AbstractScriptHandler {
        private WindowsScriptHandler() {
        }

        public IAssignable makeRunner(RunScriptReq runScriptReq, String string, PrintWriter printWriter, boolean bl) {
            return new WindowsScriptRunner(runScriptReq, string, printWriter, bl, null);
        }
    }

    private static class WinPlatformSpecific
    implements IPlatformSpecific {
        private WinPlatformSpecific() {
        }

        public void start(UnixScriptContext unixScriptContext) throws LocalizableException {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner$WinPlatformSpecific");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"start", (String)"uContext");
            }
            if (!(unixScriptContext instanceof WindowsCommandContext)) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner$WinPlatformSpecific");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"start");
                }
                throw new RuntimeException(MessageLog.getMessage((String)"STA0427E"));
            }
            WindowsCommandContext windowsCommandContext = (WindowsCommandContext)unixScriptContext;
            long l = 0L;
            if (windowsCommandContext.user != null) {
                l = NasUtil.logonUser(windowsCommandContext.domain, windowsCommandContext.user, windowsCommandContext.password);
            }
            windowsCommandContext.handle = WindowsScriptRunner.spawn(windowsCommandContext.exe, windowsCommandContext.commandLine, windowsCommandContext.logFileName, l, windowsCommandContext.envBlock);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.script.WindowsScriptRunner$WinPlatformSpecific");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"start");
            }
        }
    }
}

