/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas.netapp;

import java.io.Serializable;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class TableHandler {
    protected OID oid;
    protected long[] array;
    protected NasFiler filer;
    protected Computer comp;
    protected SnmpSession listener;
    protected String badTypeMsgID;
    protected int tableOIDLength;

    private static boolean agreeUpTo(long[] lArray, long[] lArray2, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"agreeUpTo", (String)"a1, a2, l");
        }
        boolean bl = true;
        while (bl && n > 0) {
            if (lArray[--n] == lArray2[n]) continue;
            bl = false;
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"agreeUpTo", (boolean)bl2);
        }
        return bl2;
    }

    public TableHandler(OID oID, NasFiler nasFiler, SnmpSession snmpSession) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TableHandler", (String)"pOID, pFiler, pListener");
        }
        this.oid = oID;
        this.array = this.oid.value;
        this.filer = nasFiler;
        this.comp = this.filer.nfComputer;
        this.listener = snmpSession;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TableHandler");
        }
    }

    protected abstract String checkNameLength();

    protected abstract boolean typeOK(Serializable var1);

    protected abstract void process(Serializable var1) throws GeneralException;

    private boolean inTable(long[] lArray) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"inTable", (String)"returnedArray");
        }
        boolean bl2 = bl = lArray.length >= this.tableOIDLength && TableHandler.agreeUpTo(this.array, lArray, this.tableOIDLength);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"inTable", (boolean)bl);
        }
        return bl;
    }

    public boolean go() {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"go", (String)"");
        }
        String string = "NAA0079E";
        GeneralException generalException = null;
        boolean bl2 = true;
        SnmpPDU snmpPDU = this.listener.makePDU();
        SnmpVarBind snmpVarBind = new SnmpVarBind(this.oid);
        snmpPDU.addVarBind(snmpVarBind);
        snmpPDU.operation = 1;
        while (bl2 && generalException == null) {
            Object object;
            SnmpVarBind snmpVarBind2 = null;
            SnmpPDU snmpPDU2 = this.listener.send(snmpPDU);
            if (snmpPDU2 != null) {
                if (snmpPDU2.errorStatus == 101) {
                    string = "NAA0075E";
                    generalException = this.makeGeneralException(snmpPDU2);
                    continue;
                }
                if (snmpPDU2.errorStatus != 0) {
                    string = "NAA0078E";
                    generalException = this.makeGeneralException(snmpPDU2);
                    continue;
                }
                if (snmpPDU2.varBindListSize() > 0) {
                    snmpVarBind2 = snmpPDU2.varBindAt(0);
                }
            }
            if (snmpVarBind2 == null) {
                object = MessageLog.getMessage((String)"NAA0080E");
                generalException = new GeneralException((String)object);
                continue;
            }
            OID oID = snmpVarBind2.getOID();
            if (oID == null) {
                object = MessageLog.getMessage((String)"NAA0082E");
                generalException = new GeneralException((String)object);
                continue;
            }
            long[] lArray = oID.value;
            if (!this.inTable(lArray)) {
                bl2 = false;
                continue;
            }
            this.array = lArray;
            snmpVarBind.set_oid(new OID(this.array));
            object = this.checkNameLength();
            if (object != null) {
                generalException = new GeneralException(MessageLog.getMessage((String)object));
                continue;
            }
            Serializable serializable = snmpVarBind2.getVar();
            object = serializable == null ? "null" : (this.typeOK(serializable) ? null : serializable.getClass().getName());
            if (object == null) {
                try {
                    this.process(serializable);
                }
                catch (GeneralException generalException2) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"go", (Throwable)generalException2);
                    }
                    generalException = generalException2;
                }
                continue;
            }
            object = MessageLog.getMessage((String)this.badTypeMsgID, (Object)object);
            generalException = new GeneralException((String)object);
        }
        boolean bl3 = bl = generalException == null;
        if (!bl) {
            MessageLog.logException((String)string, generalException, (Object)this.filer.nfName);
            MessageLog.logMessage((String)"NAA0081I", (Object)this.oid.toString());
        }
        boolean bl4 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"go", (boolean)bl4);
        }
        return bl4;
    }

    private GeneralException makeGeneralException(SnmpPDU snmpPDU) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeGeneralException", (String)"pdu");
        }
        String string = MessageLog.getMessage((String)"NAA0005W");
        GeneralException generalException = new GeneralException(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.TableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeGeneralException", (Object)((Object)generalException));
        }
        return generalException;
    }
}

