/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Level;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class LogEvent
implements Serializable {
    static final long serialVersionUID = 8783775590051976528L;
    private boolean typeValid;
    private HashMap extensions = null;
    private Level level = null;
    private long timeStamp;
    private long type = 0L;
    private Object[] inserts = null;
    private String client = null;
    private String component = null;
    private String correlationId = null;
    private String loggingClass = null;
    private String loggingMethod = null;
    private String messageKey = null;
    private String messageFile = null;
    private String messageText = null;
    private String messageId = null;
    private String organization = null;
    private String product = null;
    private String productInstance = null;
    private String server = null;
    private String serverFormat = null;
    private String stackTrace = null;
    private String threadName;
    private Throwable throwable = null;

    public LogEvent() {
        this.typeValid = false;
        this.timeStamp = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
    }

    public LogEvent(Throwable throwable) {
        this();
        this.throwable = throwable;
    }

    public LogEvent(Throwable throwable, String string) {
        this();
        this.throwable = throwable;
        this.messageText = string;
    }

    public LogEvent(String string, String string2, Object[] objectArray) {
        this();
        this.messageKey = string;
        this.messageFile = string2;
        this.inserts = objectArray;
    }

    public LogEvent(String string, Object[] objectArray) {
        this();
        this.messageText = string;
        this.inserts = objectArray;
    }

    public LogEvent(long l, Throwable throwable) {
        this();
        this.typeValid = true;
        this.type = l;
        this.throwable = throwable;
    }

    public LogEvent(long l, Throwable throwable, String string) {
        this();
        this.typeValid = true;
        this.type = l;
        this.throwable = throwable;
        this.messageText = string;
    }

    public LogEvent(long l, String string, String string2, Object[] objectArray) {
        this();
        this.typeValid = true;
        this.type = l;
        this.messageKey = string;
        this.messageFile = string2;
        this.inserts = objectArray;
    }

    public LogEvent(long l, String string, Object[] objectArray) {
        this();
        this.typeValid = true;
        this.type = l;
        this.messageText = string;
        this.inserts = objectArray;
    }

    public LogEvent(Level level, Throwable throwable) {
        this();
        this.level = level;
        this.throwable = throwable;
    }

    public LogEvent(Level level, Throwable throwable, String string) {
        this();
        this.throwable = throwable;
        this.level = level;
        this.messageText = string;
    }

    public LogEvent(Level level, String string, String string2, Object[] objectArray) {
        this();
        this.level = level;
        this.messageKey = string;
        this.messageFile = string2;
        this.inserts = objectArray;
    }

    public LogEvent(Level level, String string, Object[] objectArray) {
        this();
        this.level = level;
        this.messageText = string;
        this.inserts = objectArray;
    }

    public LogEvent(Level level, Object object, String string, Throwable throwable, String string2, String string3, String string4, String string5, String string6) {
        this();
        this.loggingClass = this.convertClassName(object);
        this.loggingMethod = string;
        this.level = level;
        this.throwable = throwable;
        this.organization = string2;
        this.product = string3;
        this.component = string4;
        this.client = string5;
        this.server = string6;
    }

    public LogEvent(Level level, Object object, String string, Throwable throwable, String string2, String string3, String string4, String string5, String string6, String string7) {
        this();
        this.loggingClass = this.convertClassName(object);
        this.loggingMethod = string;
        this.throwable = throwable;
        this.level = level;
        this.messageText = string2;
        this.organization = string3;
        this.product = string4;
        this.component = string5;
        this.client = string6;
        this.server = string7;
    }

    public LogEvent(Level level, Object object, String string, String string2, String string3, Object[] objectArray, String string4, String string5, String string6, String string7, String string8) {
        this();
        this.loggingClass = this.convertClassName(object);
        this.loggingMethod = string;
        this.level = level;
        this.messageKey = string2;
        this.messageFile = string3;
        this.inserts = objectArray;
        this.organization = string4;
        this.product = string5;
        this.component = string6;
        this.client = string7;
        this.server = string8;
    }

    public LogEvent(Level level, Object object, String string, String string2, Object[] objectArray, String string3, String string4, String string5, String string6, String string7) {
        this();
        this.loggingClass = this.convertClassName(object);
        this.loggingMethod = string;
        this.level = level;
        this.messageText = string2;
        this.inserts = objectArray;
        this.organization = string3;
        this.product = string4;
        this.component = string5;
        this.client = string6;
        this.server = string7;
    }

    public LogEvent(Level level, Object object, String string, Throwable throwable, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this();
        this.loggingClass = this.convertClassName(object);
        this.loggingMethod = string;
        this.level = level;
        this.throwable = throwable;
        this.organization = string2;
        this.product = string3;
        this.component = string4;
        this.client = string5;
        this.server = string6;
        this.serverFormat = string7;
        this.productInstance = string8;
        this.correlationId = string9;
    }

    public LogEvent(Level level, Object object, String string, Throwable throwable, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this();
        this.loggingClass = this.convertClassName(object);
        this.loggingMethod = string;
        this.throwable = throwable;
        this.level = level;
        this.messageText = string2;
        this.organization = string3;
        this.product = string4;
        this.component = string5;
        this.client = string6;
        this.server = string7;
        this.serverFormat = string8;
        this.productInstance = string9;
        this.correlationId = string10;
    }

    public LogEvent(Level level, Object object, String string, String string2, String string3, Object[] objectArray, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        this();
        this.loggingClass = this.convertClassName(object);
        this.loggingMethod = string;
        this.level = level;
        this.messageKey = string2;
        this.messageFile = string3;
        this.inserts = objectArray;
        this.organization = string4;
        this.product = string5;
        this.component = string6;
        this.client = string7;
        this.server = string8;
        this.serverFormat = string9;
        this.productInstance = string10;
        this.correlationId = string11;
    }

    public LogEvent(Level level, Object object, String string, String string2, Object[] objectArray, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this();
        this.loggingClass = this.convertClassName(object);
        this.loggingMethod = string;
        this.level = level;
        this.messageText = string2;
        this.inserts = objectArray;
        this.organization = string3;
        this.product = string4;
        this.component = string5;
        this.client = string6;
        this.server = string7;
        this.serverFormat = string8;
        this.productInstance = string9;
        this.correlationId = string10;
    }

    public LogEvent(Level level, long l, String string, String string2, String string3, String string4, String string5, Object[] objectArray, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, long l2, String string15) {
        if (level != null) {
            this.level = level;
        }
        if (l != 0L) {
            this.typeValid = true;
            this.type = l;
        }
        if (string != null) {
            this.loggingClass = string;
        }
        if (string2 != null) {
            this.loggingMethod = string2;
        }
        if (string3 != null) {
            this.messageKey = string3;
        }
        if (string4 != null) {
            this.messageFile = string4;
        }
        if (string5 != null) {
            this.messageText = string5;
        }
        if (objectArray != null) {
            this.inserts = objectArray;
        }
        if (string6 != null) {
            this.organization = string6;
        }
        if (string7 != null) {
            this.product = string7;
        }
        if (string8 != null) {
            this.component = string8;
        }
        if (string9 != null) {
            this.client = string9;
        }
        if (string10 != null) {
            this.server = string10;
        }
        if (string11 != null) {
            this.serverFormat = string11;
        }
        if (string12 != null) {
            this.productInstance = string12;
        }
        if (string14 != null) {
            this.stackTrace = string14;
        }
        if (string13 != null) {
            this.correlationId = string13;
        }
        this.timeStamp = l2;
        if (string15 != null) {
            this.threadName = string15;
        }
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getStackTrace() {
        if (this.stackTrace == null && this.throwable != null) {
            StringWriter stringWriter = new StringWriter();
            this.throwable.printStackTrace(new PrintWriter(stringWriter));
            this.stackTrace = stringWriter.toString();
        }
        return this.stackTrace;
    }

    public void convertException() {
        if (this.throwable != null) {
            this.getStackTrace();
            this.throwable = null;
        }
    }

    public boolean isTypeValid() {
        return this.typeValid;
    }

    public String getClient() {
        return this.client;
    }

    public String getComponent() {
        return this.component;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Object[] getInserts() {
        return this.inserts;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLoggingClass() {
        return this.loggingClass;
    }

    public String getLoggingMethod() {
        return this.loggingMethod;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getProduct() {
        return this.product;
    }

    public String getProductInstance() {
        return this.productInstance;
    }

    public String getServer() {
        return this.server;
    }

    public String getServerFormat() {
        return this.serverFormat;
    }

    public String getText() {
        return this.messageText;
    }

    public long getType() {
        return this.type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    protected String convertClassName(Object object) {
        String string = object != null ? (object instanceof String ? (String)object : object.getClass().getName()) : LogUtil.getLogMsg("NULL_OBJECT");
        return string;
    }

    public Object put(String string, Object object) {
        if (this.extensions == null) {
            this.extensions = new HashMap();
        }
        Object object2 = this.extensions.put(string, object);
        return object2;
    }

    public Object get(String string) {
        Object var2_2 = null;
        if (this.extensions != null) {
            var2_2 = this.extensions.get(string);
        }
        return var2_2;
    }

    public boolean containsKey(String string) {
        boolean bl = false;
        if (this.extensions != null) {
            bl = this.extensions.containsKey(string);
        }
        return bl;
    }

    public Iterator getKeysAndValues() {
        Iterator iterator = null;
        if (this.extensions != null) {
            Set set = this.extensions.entrySet();
            iterator = set.iterator();
        }
        return iterator;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getStackTrace();
        if (this.inserts != null) {
            int n = 0;
            while (n < this.inserts.length) {
                Object object = this.inserts[n];
                if (object != null && !(object instanceof Serializable)) {
                    this.inserts[n] = object.toString();
                }
                ++n;
            }
        }
        if (objectOutputStream != null) {
            objectOutputStream.defaultWriteObject();
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public synchronized void setMessageId(String string) {
        if (string != null) {
            this.messageId = string;
        }
    }
}

