/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.Capabilities;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.UnsignedInt16;

public class StorageDeviceData
implements DiscoveryConstants,
CIMNames {
    private static final String ACCESS_INFO = "accessinfo";
    private static final String INFO_FORMAT = "infoformat";
    private Map cInstance = new HashMap();
    private String cProfile = null;
    private String cSubProfile = null;
    private String cSMISVersion = null;
    private StringBuffer cDebugBuffer = null;
    private Capabilities cCapabilities = null;
    private String cNameSpace = null;
    private String cCIMOMVersion = null;

    public void setDataFromInstance(String string, CIMInstance cIMInstance, LogTraceHelper logTraceHelper) {
        this.setDebug(string);
        if (logTraceHelper.isTraceHighEnabled()) {
            this.setDebug(CIMInstanceHelper.changeCIMInstanceToHashtable((CIMInstance)cIMInstance).toString());
        }
        this.cInstance.put(string, cIMInstance);
    }

    private void setDebug(String string) {
        this.getDebugBuffer().append(String.valueOf(string) + "\n");
    }

    private StringBuffer getDebugBuffer() {
        if (this.cDebugBuffer == null) {
            this.cDebugBuffer = new StringBuffer();
        }
        return this.cDebugBuffer;
    }

    public String getDebugString() {
        return this.getDebugBuffer().toString();
    }

    public Capabilities getCapabilities() {
        if (this.cCapabilities != null) {
            return this.cCapabilities;
        }
        this.cCapabilities = new Capabilities();
        return this.cCapabilities;
    }

    public void setCapabilities(Capabilities capabilities) {
        this.cCapabilities = capabilities;
    }

    public CIMInstance getInstance(String string) {
        return (CIMInstance)this.cInstance.get(string);
    }

    public String getProfile() {
        return this.cProfile;
    }

    public void setProfile(String string) {
        this.cProfile = string;
    }

    public String getSMISVersion() {
        return this.cSMISVersion;
    }

    public void setSMISVersion(String string) {
        if (string != null) {
            this.cSMISVersion = string;
        }
    }

    public String getSubProfile() {
        return this.cSubProfile;
    }

    public void setSubProfile(String string) {
        this.cSubProfile = string;
    }

    public void addAccessInfo(Hashtable hashtable) {
        CIMInstance cIMInstance = this.getInstance("accessPoint");
        if (cIMInstance != null) {
            UnsignedInt16 unsignedInt16;
            String string = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"AccessInfo");
            if (string != null) {
                hashtable.put(ACCESS_INFO, string);
            }
            if ((unsignedInt16 = (UnsignedInt16)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"InfoFormat")) != null) {
                hashtable.put(INFO_FORMAT, "" + unsignedInt16.intValue());
            }
        }
    }

    public String getNameSpace() {
        return this.cNameSpace;
    }

    public void setNameSpace(String string) {
        this.cNameSpace = string;
    }

    public String getCIMOMVersion() {
        return this.cCIMOMVersion;
    }

    public void setCIMOMVersion(String string) {
        this.cCIMOMVersion = string;
    }

    public CIMInstance[] getNodes() {
        return this.cInstance.values().toArray(new CIMInstance[this.cInstance.size()]);
    }
}

