/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;

public class DiskEventQueue {
    private LinkedList cQueue = new LinkedList();
    private boolean bShutdown = false;

    public synchronized void shutdown() {
        this.cQueue.clear();
    }

    public synchronized void add(CIMIndicationEvent cIMIndicationEvent) {
        this.cQueue.add(cIMIndicationEvent);
        this.notifyAll();
    }

    public synchronized CIMIndicationEvent remove() throws InterruptedException {
        if (!this.cQueue.isEmpty()) {
            return (CIMIndicationEvent)this.cQueue.removeFirst();
        }
        if (this.bShutdown) {
            return null;
        }
        this.wait();
        return this.remove();
    }

    public synchronized boolean isEmpty() {
        return this.cQueue.isEmpty();
    }

    public synchronized int size() {
        return this.cQueue.size();
    }

    public synchronized boolean contains(CIMIndicationEvent cIMIndicationEvent) {
        ListIterator listIterator = this.cQueue.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().equals(cIMIndicationEvent)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean contains(CIMIndicationEvent cIMIndicationEvent, Comparator comparator) {
        ListIterator listIterator = this.cQueue.listIterator();
        while (listIterator.hasNext()) {
            if (comparator.compare(listIterator.next(), cIMIndicationEvent) != 0) continue;
            return true;
        }
        return false;
    }
}

