/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;

public class RptDiskAssetHist
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT_START = "select disk_id, statistic_time, ";
    private static final String SELECT_PRIMARY_DEFECTS = "primary_defects";
    private static final String SELECT_GROWN_DEFECTS = "grown_defects";
    private static final String SELECT_UNALLOCATED = "free_space";
    private static final String SELECT_RECOVERED_ERR = "recovrd_rd_errs + recovrd_wrt_errs + recovrd_vfy_errs";
    private static final String SELECT_UNRECOVERED_ERR = "unrecovrd_rd_errs + unrecovrd_wrt_errs + unrecovrd_vfy_errs";
    private static final String SELECT_TABLE = " from t_stat_disk_hist";

    public RptDiskAssetHist(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskAssetHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RptDiskAssetHist", (String)"dbc");
        }
        this.tableName = "t_stat_disk_hist";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskAssetHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RptDiskAssetHist");
        }
    }

    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        SpaceHistory spaceHistory;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskAssetHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReportData", (String)"grr");
        }
        SpaceHistory spaceHistory2 = null;
        int n = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(SELECT_START);
        if (guiReportReq.reportSubtype == -39) {
            stringBuffer.append(SELECT_UNALLOCATED);
            bl = true;
        } else if (guiReportReq.reportSubtype == -24) {
            stringBuffer.append(SELECT_GROWN_DEFECTS);
        } else if (guiReportReq.reportSubtype == -23) {
            stringBuffer.append(SELECT_PRIMARY_DEFECTS);
        } else if (guiReportReq.reportSubtype == -25) {
            stringBuffer.append(SELECT_RECOVERED_ERR);
        } else {
            stringBuffer.append(SELECT_UNRECOVERED_ERR);
        }
        stringBuffer.append(SELECT_TABLE);
        stringBuffer.append(" where statistic_type in ('");
        stringBuffer.append(guiReportReq.histType);
        if (guiReportReq.histType == 0) {
            stringBuffer.append("','3') and");
        } else {
            stringBuffer.append("') and");
        }
        if (guiReportReq.startTime > 0L) {
            stringBuffer.append(" statistic_time between ? and ? and");
        }
        if (guiReportReq.reportSubtype == -24) {
            stringBuffer.append(" grown_defects > -1 and");
        }
        SQLUtil.appendInClause(stringBuffer, "disk_id", guiReportReq.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(stringBuffer.toString());
            if (guiReportReq.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, guiReportReq.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, guiReportReq.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            spaceHistory = new SpaceHistory();
            while (this.resultSet.next()) {
                this.getPhase();
                spaceHistory.shLegendID1 = this.getInt(this.resultSet);
                spaceHistory.shLegendID2 = Integer.MIN_VALUE;
                spaceHistory.shStatisticTime = this.getTimestamp(this.resultSet);
                if (bl) {
                    spaceHistory.shTotalSize = this.getLong(this.resultSet);
                    if (spaceHistory.shTotalSize < 0L) {
                        spaceHistory.shTotalSize = 0L;
                    }
                } else {
                    spaceHistory.shFileCount = this.getLong(this.resultSet);
                    if (spaceHistory.shFileCount < 0L) {
                        spaceHistory.shFileCount = 0L;
                    }
                }
                spaceHistory.shNext = spaceHistory2;
                spaceHistory2 = spaceHistory;
                spaceHistory = new SpaceHistory();
                ++n;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskAssetHist");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getReportData", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        spaceHistory = RptUserSpace.packUpHistory(spaceHistory2, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.report.RptDiskAssetHist");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReportData", (Object)spaceHistory);
        }
        return spaceHistory;
    }
}

