/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptLun
extends RepositoryAccessor
implements GuiDataProvider {
    private Share share;
    private TResShare shAccessor;
    private static final String SELECT = ", d.subsystem_id , v.update_timestamp, v.display_name,  vendor.vendor_name, model.model_name, case when d.user_provided_name is not null  and d.user_provided_name <> ''  then d.user_provided_name else d.display_name end as ss_display_name,  d.os_type, v.mdisk_id, cimv.device_id from t_res_storage_volume v, t_res_storage_subsystem d, t_res_vendor vendor,   t_res_model model, t_res_cimkey_volume cimv where d.subsystem_id = v.subsystem_id  and model.model_id = d.model_id and vendor.vendor_id = d.vendor_id  and v.svid = cimv.volume_id";
    private static final String BY_SUBSYSTEM = " order by ss_display_name desc, v.name desc";
    private static final String BY_CAPACITY = " order by capacity";
    private static final String BY_PROBE_TIME = " order by v.update_timestamp desc";

    public RptLun(Connection connection) {
        super(connection);
        this.tableName = "t_res_storage_volume";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        Lun lun = null;
        Lun lun2 = new Lun();
        LogicalDisk logicalDisk = new LogicalDisk();
        boolean bl = true;
        ReportFilter reportFilter = null;
        if (guiReportReq.columnFilters != null) {
            reportFilter = new ReportFilter(guiReportReq, lun2);
        }
        TResLogicalDisk tResLogicalDisk = new TResLogicalDisk(this.dbc);
        try {
            try {
                this.selectStmt = this.prepareStmt(this.getSQLText(guiReportReq));
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                while (this.nextResult()) {
                    this.colIndex = tResLogicalDisk.fetchLogicalDisk(logicalDisk, this.resultSet, true);
                    lun2.lunLogicalDisk = logicalDisk;
                    lun2.lunID = logicalDisk.ldID;
                    lun2.lunDaID = this.getInt(this.resultSet);
                    lun2.lunProbeTime = this.getTimestamp(this.resultSet);
                    lun2.lunName = logicalDisk.ldName;
                    lun2.lunWWN = this.getString(this.resultSet);
                    lun2.lunDaManufacturer = this.getString(this.resultSet);
                    lun2.lunDaModel = this.getString(this.resultSet);
                    lun2.lunDaAlias = this.getString(this.resultSet);
                    lun2.lunOSType = this.getShort(this.resultSet);
                    lun2.lunMdisk_id = this.getInt(this.resultSet);
                    lun2.lunDeviceId = this.getString(this.resultSet);
                    if (!Constants.hasLunWWN((short)lun2.lunOSType)) {
                        if (SQLUtil.isNullString(lun2.lunName)) {
                            lun2.lunName = lun2.lunWWN;
                        }
                        lun2.lunWWN = null;
                    } else if (lun2.lunOSType == 25 || lun2.lunOSType == 27) {
                        if (!SQLUtil.isNullString(lun2.lunName)) {
                            lun2.lunWWN = lun2.lunDeviceId;
                        } else {
                            lun2.lunName = lun2.lunDeviceId;
                            lun2.lunWWN = null;
                        }
                    }
                    if (logicalDisk.ldSnapSourceID > 0) {
                        this.getDetachableMirrorInfo(lun2);
                    }
                    if (reportFilter != null) {
                        bl = reportFilter.isSelected(lun2);
                    }
                    if (lun2.lunMdisk_id > 0) {
                        bl = false;
                    } else if (reportFilter == null) {
                        bl = true;
                    }
                    if (!bl) continue;
                    lun2.lunNext = lun;
                    lun = lun2;
                    lun2 = new Lun();
                    logicalDisk = new LogicalDisk();
                }
            }
            catch (SQLException sQLException) {
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.close(this);
            if (this.shAccessor == null) throw throwable;
            this.close(this.shAccessor);
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.close(this);
            if (this.shAccessor == null) return (Serializable)Packer.pack(lun);
            this.close(this.shAccessor);
            return (Serializable)Packer.pack(lun);
        }
    }

    private String getSQLText(GuiReportReq guiReportReq) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("select distinct");
        stringBuffer.append(" v.svid, v.pool_id, v.logical_disk_type, v.capacity,  v.use_count, v.mirror_count, v.is_swap, v.snap_source_id,  v.is_vcmdb, v.replication_mode, v.not_exposed, v.overhead,  v.pool_id, v.lun_identity, -1, v.format, v.display_name, v.name,  v.package_redundancy, v.data_redundancy, v.is_assigned,  cimv.device_id ");
        stringBuffer.append(SELECT);
        switch (guiReportReq.reportSubtype) {
            case 77: 
            case 79: {
                stringBuffer.append(BY_SUBSYSTEM);
                break;
            }
            case 78: {
                stringBuffer.append(BY_CAPACITY);
                break;
            }
            case 18: {
                stringBuffer.append(BY_PROBE_TIME);
                break;
            }
            default: {
                Object[] objectArray = new Object[]{new Integer(guiReportReq.reportType), new Integer(guiReportReq.reportSubtype)};
                String string = MessageLog.getMessage((String)"GEN0125E", (Object[])objectArray);
                throw new GeneralException(string);
            }
        }
        return stringBuffer.toString();
    }

    private void getDetachableMirrorInfo(Lun lun) throws GeneralException {
        if (this.shAccessor == null) {
            this.share = new Share();
            this.shAccessor = new TResShare(this.dbc);
            this.shAccessor.prepGetUniqueShare();
        }
        LogicalDisk logicalDisk = lun.lunLogicalDisk;
        this.share.shComputerID = lun.lunDaID;
        this.share.shResourceID = logicalDisk.ldSnapSourceID;
        this.share.shPath = null;
        this.shAccessor.getUniqueShare(this.share);
        if (this.share.shPath != null) {
            lun.lunPrimaryName = this.share.shPath;
        }
    }

    private void close(RepositoryAccessor repositoryAccessor) {
        try {
            repositoryAccessor.closeSelect();
        }
        catch (GeneralException generalException) {}
    }
}

