/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.guireq.SmtpSettings;
import org.eclipse.aperi.server.guireq.SnmpDestination;
import org.eclipse.aperi.xmsg.MessageLog;

public class TConfigSettings
extends RepositoryAccessor {
    private static final String EMAIL_FILENAME = "configuration" + File.separator + "SmtpSettings.ser";
    private static final String SELECT = "select snmp_server, snmp_port, snmp_community, snmp2_server, snmp2_port, snmp2_community, tec_server, tec_port, retain_copies, retain_days, dellog_after_days, smtp_server, smtp_port, smtp_reply_to, smtp_return, smtp_dflt_domain from t_config_settings";
    private static final String INSERT = "insert into t_config_settings (snmp_server, snmp_port, snmp_community, snmp2_server, snmp2_port, snmp2_community, tec_server, tec_port, dellog_after_days, smtp_server, smtp_port, smtp_reply_to, smtp_return, smtp_dflt_domain, retain_copies, retain_days) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_NETWORK = "update t_config_settings set snmp_server = ?, snmp_port = ?, snmp_community = ?, snmp2_server = ?, snmp2_port = ?, snmp2_community = ?, tec_server = ?, tec_port = ?, dellog_after_days = ?";
    private static final String UPDATE_RETENTION = "update t_config_settings set retain_copies = ?, retain_days = ?";

    public TConfigSettings(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TConfigSettings", (String)"dbc");
        }
        this.tableName = "t_config_settings";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TConfigSettings");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigSettings getConfigSettings(boolean bl) throws GeneralException {
        ConfigSettings configSettings;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getConfigSettings", (String)"throwException");
        }
        ConfigSettings configSettings2 = null;
        this.selectStmt = this.prepareStmt(SELECT);
        try {
            block20: {
                try {
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    while (this.resultSet.next()) {
                        configSettings2 = new ConfigSettings();
                        this.stmtPhase = 1;
                        this.colIndex = 1;
                        int n = 0;
                        while (n < configSettings2.csSnmp.length) {
                            this.getSnmpSettings(configSettings2.csSnmp[n]);
                            ++n;
                        }
                        configSettings2.csTecServer = this.getString(this.resultSet);
                        configSettings2.csTecPort = this.getInt(this.resultSet);
                        configSettings2.csRetainCopies = this.getInt(this.resultSet);
                        configSettings2.csRetainDays = this.getInt(this.resultSet);
                        configSettings2.csDellogDays = this.getInt(this.resultSet);
                        configSettings = TConfigSettings.getSmtpSettings();
                        if (configSettings != null) {
                            configSettings2.csSmtp = configSettings;
                            continue;
                        }
                        configSettings2.csSmtp.ssServer = this.getString(this.resultSet);
                        configSettings2.csSmtp.ssPort = this.getInt(this.resultSet);
                        configSettings2.csSmtp.ssReplyTo = this.getString(this.resultSet);
                        configSettings2.csSmtp.ssReturn = this.getString(this.resultSet);
                        configSettings2.csSmtp.ssDfltDomain = this.getString(this.resultSet);
                    }
                    if (configSettings2 != null || !bl) break block20;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getConfigSettings");
                    }
                    throw new GeneralException(MessageLog.getMessage((String)"SRV0087E", null));
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"getConfigSettings", (Throwable)sQLException);
                    }
                    this.stmtType = 0;
                    this.sqlError(sQLException);
                }
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.closeSelect();
            throw throwable;
        }
        this.closeSelect();
        configSettings = configSettings2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getConfigSettings", (Object)configSettings);
        }
        return configSettings;
    }

    private void getSnmpSettings(SnmpDestination snmpDestination) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSnmpSettings", (String)"snmp");
        }
        snmpDestination.csSnmpServer = this.getString(this.resultSet);
        snmpDestination.csSnmpPort = this.getInt(this.resultSet);
        snmpDestination.csSnmpCommunity = this.getString(this.resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSnmpSettings");
        }
    }

    public ConfigSettings getConfigSettings() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getConfigSettings", (String)"");
        }
        ConfigSettings configSettings = this.getConfigSettings(true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getConfigSettings", (Object)configSettings);
        }
        return configSettings;
    }

    private void setNetwork(PreparedStatement preparedStatement, ConfigSettings configSettings) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setNetwork", (String)"stmt, settings");
        }
        int n = 0;
        while (n < configSettings.csSnmp.length) {
            SnmpDestination snmpDestination = configSettings.csSnmp[n];
            this.setString(preparedStatement, snmpDestination.csSnmpServer);
            this.setInt(preparedStatement, snmpDestination.csSnmpPort);
            this.setString(preparedStatement, snmpDestination.csSnmpCommunity);
            ++n;
        }
        this.setString(preparedStatement, configSettings.csTecServer);
        this.setInt(preparedStatement, configSettings.csTecPort);
        TConfigSettings.saveSmtpSettings(configSettings.csSmtp);
        this.setInt(preparedStatement, configSettings.csDellogDays);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setNetwork");
        }
    }

    private void setRetention(PreparedStatement preparedStatement, ConfigSettings configSettings) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setRetention", (String)"stmt, settings");
        }
        this.setInt(preparedStatement, configSettings.csRetainCopies);
        this.setInt(preparedStatement, configSettings.csRetainDays);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setRetention");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(ConfigSettings configSettings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"settings");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            try {
                this.setNetwork(this.insertStmt, configSettings);
                this.setString(this.insertStmt, configSettings.csSmtp.ssServer);
                this.setInt(this.insertStmt, configSettings.csSmtp.ssPort);
                this.setString(this.insertStmt, configSettings.csSmtp.ssReplyTo);
                this.setString(this.insertStmt, configSettings.csSmtp.ssReturn);
                this.setString(this.insertStmt, configSettings.csSmtp.ssDfltDomain);
                this.setRetention(this.insertStmt, configSettings);
                this.executeUpdate(this.insertStmt);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
                }
                this.stmtType = 1;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.closeInsert();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateNetwork(ConfigSettings configSettings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateNetwork", (String)"settings");
        }
        int n = 0;
        this.updateStmt = this.prepareStmt(UPDATE_NETWORK);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            try {
                this.setNetwork(this.updateStmt, configSettings);
                n = this.executeUpdate(this.updateStmt);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"updateNetwork", (Throwable)sQLException);
                }
                this.stmtType = 2;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeUpdate();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeUpdate();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateNetwork", (int)n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateRetention(ConfigSettings configSettings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateRetention", (String)"settings");
        }
        int n = 0;
        this.updateStmt = this.prepareStmt(UPDATE_RETENTION);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            try {
                this.setRetention(this.updateStmt, configSettings);
                n = this.executeUpdate(this.updateStmt);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"updateRetention", (Throwable)sQLException);
                }
                this.stmtType = 2;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeUpdate();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeUpdate();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateRetention", (int)n2);
        }
        return n2;
    }

    public static synchronized SmtpSettings getSmtpSettings() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSmtpSettings", (String)"");
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        SmtpSettings smtpSettings = null;
        Exception exception = null;
        File file = new File(EMAIL_FILENAME);
        if (file.canRead()) {
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {}
            if (fileInputStream != null) {
                try {
                    objectInputStream = new ObjectInputStream(fileInputStream);
                }
                catch (IOException iOException) {
                    exception = iOException;
                    MessageLog.logException((String)"STS0205E", (Exception)iOException, (Object)EMAIL_FILENAME);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (objectInputStream != null) {
                    try {
                        smtpSettings = (SmtpSettings)objectInputStream.readObject();
                    }
                    catch (EOFException eOFException) {
                        exception = eOFException;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        exception = classNotFoundException;
                        MessageLog.logMessage((String)"STS0205E", (Object)EMAIL_FILENAME);
                        MessageLog.logException((String)"STS0049W", (Exception)classNotFoundException, (Object)EMAIL_FILENAME);
                    }
                    catch (IOException iOException) {
                        exception = iOException;
                        MessageLog.logException((String)"STS0205E", (Exception)iOException, (Object)EMAIL_FILENAME);
                    }
                    catch (ClassCastException classCastException) {
                        exception = classCastException;
                        MessageLog.logMessage((String)"STS0205E", (Object)EMAIL_FILENAME);
                        MessageLog.logException((String)"STS0050W", (Exception)classCastException, (Object)EMAIL_FILENAME);
                    }
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (exception != null) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz2.getName(), (String)"getSmtpSettings", (Throwable)exception);
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getSmtpSettings");
                    }
                    Object[] objectArray = new Object[]{EMAIL_FILENAME};
                    throw new GeneralException("STS0205E", objectArray);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSmtpSettings", smtpSettings);
        }
        return smtpSettings;
    }

    public static synchronized void saveSmtpSettings(SmtpSettings smtpSettings) throws GeneralException {
        boolean bl;
        IOException iOException;
        block24: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"saveSmtpSettings", (String)"smtp");
            }
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            iOException = null;
            bl = false;
            try {
                fileOutputStream = new FileOutputStream(EMAIL_FILENAME);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                MessageLog.logException((String)"STS0206E", (Exception)iOException2, (Object)EMAIL_FILENAME);
            }
            if (fileOutputStream != null) {
                try {
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(smtpSettings);
                    bl = true;
                }
                catch (IOException iOException3) {
                    iOException = iOException3;
                    MessageLog.logException((String)"STS0206E", (Exception)iOException3, (Object)EMAIL_FILENAME);
                }
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException4) {
                        iOException = iOException4;
                        if (bl) {
                            MessageLog.logException((String)"STS0206E", (Exception)iOException4, (Object)EMAIL_FILENAME);
                            bl = false;
                        }
                        break block24;
                    }
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException5) {}
            }
        }
        if (iOException != null && TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exception((String)clazz.getName(), (String)"saveSmtpSettings", (Throwable)iOException);
        }
        if (!bl) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"saveSmtpSettings");
            }
            Object[] objectArray = new Object[]{EMAIL_FILENAME};
            throw new GeneralException("STS0206E", objectArray);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TConfigSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveSmtpSettings");
        }
    }
}

