/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Group;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameListProxy;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.EditableObjectProxy;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class TGroup
extends RepositoryAccessor
implements CreatorNameQueryable {
    public static final String ID_COLUMN_NAME = "group_id";
    private static final String SELECT_BY_ID = "select group_id, creator, name, description, share_mode, group_type, flags from t_group where group_id = ?";
    private static final String SELECT_NAME_BY_ID = "select creator, name from t_group where group_id = ?";
    private static final String SELECT_ID_BY_NAME = "select group_id from t_group where creator = ? and name = ?";
    private static final String INSERT = "insert into t_group (group_id, creator, name, description, last_modified, last_mod_user, share_mode, group_type, flags) values (?, ?, ?, ?, ?, ?, '0', ?, 0)";
    private static final String COLUMNS = "group_type, share_mode, flags";

    public TGroup(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TGroup", (String)"dbc");
        }
        this.tableName = "t_group";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TGroup");
        }
    }

    public void prepSelectNameByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectNameByID", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_NAME_BY_ID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectNameByID");
        }
    }

    public String fetchNameByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchNameByID", (String)"groupID");
        }
        String string = null;
        String string2 = null;
        boolean bl = false;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            bl = this.nextResult();
            if (bl) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                string = this.getString(this.resultSet);
                string2 = this.getString(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchNameByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (bl) {
            String string3 = String.valueOf(string) + '.' + string2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchNameByID", (Object)string3);
            }
            return string3;
        }
        String string4 = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchNameByID", string4);
        }
        return string4;
    }

    public Group selectByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectByID", (String)"id");
        }
        Group group = new Group();
        try {
            this.selectStmt = this.prepareStmt(SELECT_BY_ID);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.fetchOne(group);
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Group group2 = group;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectByID", (Object)group2);
        }
        return group2;
    }

    private boolean fetchOne(Group group) throws GeneralException {
        block14: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"fetchOne", (String)"group");
            }
            this.stmtPhase = 1;
            try {
                if (!this.resultSet.next()) break block14;
                this.colIndex = 1;
                group.grpGroupID = this.getInt(this.resultSet);
                group.grpCreator = this.getString(this.resultSet);
                group.setGrpName(this.getString(this.resultSet));
                group.setGrpDescription(this.getString(this.resultSet));
                group.grpShareMode = this.getByte(this.resultSet);
                group.grpType = this.getByte(this.resultSet);
                group.grpFlags = this.getInt(this.resultSet);
                boolean bl = true;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"fetchOne", (boolean)bl);
                }
                return bl;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"fetchOne", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchOne", (boolean)bl);
        }
        return bl;
    }

    public NameList selectNames(GuiListReq guiListReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectNames", (String)"requestData");
        }
        CreatorNameListProxy creatorNameListProxy = new CreatorNameListProxy(this, guiListReq);
        NameList nameList = creatorNameListProxy.select();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectNames", (Object)nameList);
        }
        return nameList;
    }

    public String getIDColumnName() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getIDColumnName", (String)"");
        }
        String string = ID_COLUMN_NAME;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getIDColumnName", (Object)string);
        }
        return string;
    }

    public void appendWhereClause(GuiListReq guiListReq, StringBuffer stringBuffer) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendWhereClause", (String)"requestData, buf");
        }
        stringBuffer.append(" WHERE group_type = ");
        stringBuffer.append(Integer.toString(guiListReq.listRequested));
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendWhereClause");
        }
    }

    public void addQualifiers(GuiListReq guiListReq, NameList nameList) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addQualifiers", (String)"requestData, element");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addQualifiers");
        }
    }

    public void retrieve(CreateHeader createHeader, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"retrieve", (String)"header, groupType");
        }
        EditableObjectProxy editableObjectProxy = new EditableObjectProxy(this, createHeader, string);
        editableObjectProxy.initSelect(null);
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"retrieve");
        }
    }

    public void deleteByID(int n, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"groupID, groupType");
        }
        EditableObjectProxy editableObjectProxy = new EditableObjectProxy(this, null, string);
        editableObjectProxy.deleteByID(n, this.getIDColumnName());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID");
        }
    }

    public void insert(CreateHeader createHeader, short s, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"header, groupType, groupTypeLabel");
        }
        EditableObjectProxy editableObjectProxy = new EditableObjectProxy(this, createHeader, string);
        editableObjectProxy.initInsert(COLUMNS);
        try {
            this.setShort(this.insertStmt, s);
            this.setByte(this.insertStmt, (byte)0);
            this.setInt(this.insertStmt, 0);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        editableObjectProxy.finishInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    private void prepareUpdate(String string, String string2, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepareUpdate", (String)"pTableName, idColumnName, groupID");
        }
        this.tableName = string;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" SET group_id = ");
        stringBuffer.append(Integer.toString(n));
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string2);
        stringBuffer.append(" = ?");
        this.updateStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepareUpdate");
        }
    }

    public void setGroup(String string, String string2, int n, NameList nameList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setGroup", (String)"pTableName, idColumnName, groupID, objects");
        }
        this.prepareUpdate(string, string2, n);
        try {
            while (nameList != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.updateStmt, nameList.nlID);
                this.executeUpdate(this.updateStmt);
                nameList = nameList.nlNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"setGroup", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setGroup");
        }
    }

    public void revertToDefaultGroup(String string, int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"revertToDefaultGroup", (String)"pTableName, groupID, defaultGroupID");
        }
        this.prepareUpdate(string, ID_COLUMN_NAME, n2);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.updateStmt, n);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"revertToDefaultGroup", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"revertToDefaultGroup");
        }
    }

    private int selectIDByName(String string, String string2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectIDByName", (String)"creator, name");
        }
        int n = -1;
        this.setPhase();
        try {
            this.setString(this.selectStmt, string);
            this.setString(this.selectStmt, string2);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.getPhase();
                n = this.getInt(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectIDByName", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectIDByName", (int)n2);
        }
        return n2;
    }

    public int createDefaultGroup(String string, short s, String string2, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"createDefaultGroup", (String)"name, groupType, description, defaultID");
        }
        this.selectStmt = this.prepareStmt(SELECT_ID_BY_NAME);
        int n2 = this.selectIDByName("Default", string);
        if (n2 >= 0) {
            this.closeSelect();
            int n3 = n2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"createDefaultGroup", (int)n3);
            }
            return n3;
        }
        this.closeResultSet();
        boolean bl = false;
        this.insertStmt = this.prepareStmt(INSERT);
        this.setPhase();
        try {
            this.setInt(this.insertStmt, n);
            this.setString(this.insertStmt, "Default");
            this.setString(this.insertStmt, string);
            this.setString(this.insertStmt, string2);
            this.setLong(this.insertStmt, 0L);
            this.setString(this.insertStmt, "Default");
            this.setShort(this.insertStmt, s);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"createDefaultGroup", (Throwable)sQLException);
            }
            this.stmtType = 1;
            if (SQLUtil.isDuplicateKeyViolation(sQLException)) {
                bl = true;
            }
            this.sqlError(sQLException);
        }
        if (!bl) {
            this.commit();
        }
        this.closeInsert();
        if (!bl) {
            this.closeSelect();
            int n4 = n;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"createDefaultGroup", (int)n4);
            }
            return n4;
        }
        n2 = this.selectIDByName("Default", string);
        this.closeSelect();
        if (n2 < 0) {
            String string3 = MessageLog.getMessage((String)"SRV0159E", (Object)string);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"createDefaultGroup");
            }
            throw new GeneralException(string3);
        }
        int n5 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"createDefaultGroup", (int)n5);
        }
        return n5;
    }
}

