/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;

public class TResDevAccess
extends StorageRepositoryAccessor
implements NameListQueryable {
    public TResComputer cmpAccessor = null;
    private static final String FETCH = "select controller_id, device_id, target, lun, path, in_active from t_res_dev_access";
    private static final String BY_CONTROLLER = " where controller_id = ? order by target desc, lun desc";
    private static final String BY_DEVICE = " where device_id = ?";
    private static final String GET_ALL_DISKS = "select d.device_id, d.path, s.computer_id  from t_res_dev_access d, t_res_share s, t_res_controller c where s.resource_type = 10   and s.resource_id = d.device_id   and s.computer_id = c.computer_id   and d.controller_id = c.controller_id union  select d.device_id, d.path, s.computer_id  from t_res_dev_access d, t_res_share s, t_res_disk_group c where s.resource_type = 10   and s.resource_id = d.device_id   and s.computer_id = c.subsystem_id   and d.controller_id = c.disk_group_id";
    private static final String GET_DISKS_BY_COMPUTER = "select device_id, d.path, 0  from t_res_dev_access d, t_res_share s, t_res_controller c,       t_stat_disk x where s.computer_id = ? and s.resource_type = 10   and s.resource_id = d.device_id   and s.computer_id = c.computer_id   and d.device_id   = x.disk_id   and d.controller_id = c.controller_id";
    private static final String GET_SVC_DISKS_BY_SS = "select storage_extent_id, element_name, 0  from t_res_storage_extent where subsystem_id = ?";
    private static final String GET_DISKS_BY_SS = "select physical_volume_id, device_id, 0  from t_res_physical_volume where subsystem_id = ?";
    private static final String GET_DISKS_BY_DISK_GROUP = "select pv.physical_volume_id, pv.device_id, 0  from t_res_physical_volume pv, t_res_disk_group dg where pv.subsystem_id = ? and pv.disk_group_id = dg.disk_group_id";
    private static final String GET_DISKS_IN_POOL_FOR_CHUNK_COLLECTION = "select pv.physical_volume_id, pv.device_id, 0  from t_res_physical_volume pv, t_res_physicalvolume2extent pve, t_res_storage_extent se where pv.subsystem_id = ? and pv.physical_volume_id = pve.physical_volume_id and pve.storage_extent_id = se.storage_extent_id and se.pool_id = ?  order by pv.serial_number";
    private static final String GET_DISKS_BY_POOL = "select pv.physical_volume_id, pv.device_id, 0  from t_res_physical_volume pv, t_res_physicalvolume2extent pve, t_res_storage_extent se where pv.subsystem_id = ? and pv.physical_volume_id = pve.physical_volume_id and pve.storage_extent_id = se.storage_extent_id and se.pool_id = ? UNION select pv.physical_volume_id, pv.device_id, 0 from t_res_physical_volume pv, t_stat_disk sd where pv.physical_volume_id = sd.disk_id and sd.volgroup_id = ?";
    private static final String GET_SVC_DISKS_BY_POOL = "select storage_extent_id, element_name, 0  from t_res_storage_extent where subsystem_id = ? and pool_id  = ? ";
    private static final String ORDER_BY_DISK_NAME = " order by 2 desc";
    private static final String GET_DISKS_BY_CONTROLLER = "select device_id, path, 0  from t_res_dev_access  where controller_id = ?  order by path desc";
    private static final String GET_PATH_BY_DEVICE_COMPUTER = "select a.path from t_res_dev_access a, t_res_controller c where a.device_id = ? and c.computer_id = ? and a.controller_id = c.controller_id";
    private static final String GET_PATH_BY_DEVICE_SS = "select a.path from t_res_dev_access a, t_res_disk_group c where a.device_id = ? and c.subsystem_id = ? and a.controller_id = c.disk_group_id";
    private static final String INSERT = "insert into t_res_dev_access (controller_id, target, lun, device_id, path, in_active) values (?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_dev_access set device_id = ?, path = ?, in_active = ? where controller_id = ? and target = ? and lun = ?";
    private static final String DELETE_BY_KEY = "delete from t_res_dev_access where controller_id = ? and target = ? and lun = ?";
    private static final String DELETE_BY_CONTROLLER = "delete from t_res_dev_access where controller_id = ?";
    private static final String DELETE_BY_COMPUTER = "delete from t_res_dev_access where controller_id in (select controller_id from t_res_controller where computer_id = ?)";
    private static final String DELETE_BY_SS = "delete from t_res_dev_access where controller_id in (select controller_id from t_res_disk_group where subsystem_id = ?)";

    public TResDevAccess(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResDevAccess", (String)"dbc");
        }
        this.tableName = "t_res_dev_access";
        this.cmpAccessor = new TResComputer(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResDevAccess");
        }
    }

    public void prepSelectByCtlr() throws GeneralException {
        this.selectStmt = this.prepareStmt("select controller_id, device_id, target, lun, path, in_active from t_res_dev_access where controller_id = ? order by target desc, lun desc");
    }

    public void prepSelectByDevice() throws GeneralException {
        this.selectStmt = this.prepareStmt("select controller_id, device_id, target, lun, path, in_active from t_res_dev_access where device_id = ?");
    }

    public ResultSet getPoolDisks(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPoolDisks", (String)"ss_id, pool_id");
        }
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.dbc.prepareStatement(GET_DISKS_IN_POOL_FOR_CHUNK_COLLECTION);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPoolDisks", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPoolDisks", (Object)resultSet);
        }
        return resultSet;
    }

    public DevAccess getDevAccess(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDevAccess", (String)"id");
        }
        DevAccess devAccess = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                DevAccess devAccess2 = new DevAccess();
                devAccess2.daControllerID = this.getInt(this.resultSet);
                devAccess2.daDeviceID = this.getInt(this.resultSet);
                devAccess2.daTarget = this.getShort(this.resultSet);
                devAccess2.daLUN = this.getShort(this.resultSet);
                devAccess2.daPath = this.getString(this.resultSet);
                devAccess2.daInactive = this.getBoolean(this.resultSet);
                devAccess2.daNextDevice = devAccess;
                devAccess = devAccess2;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDevAccess", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        DevAccess devAccess3 = devAccess;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDevAccess", devAccess3);
        }
        return devAccess3;
    }

    public NameList selectNames(GuiListReq guiListReq) throws GeneralException {
        return this.getDiskList(guiListReq.computerID, guiListReq.controllerID, guiListReq.qualifier, guiListReq.groupID);
    }

    public NameList getDiskList(int n, int n2, short s, int n3) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDiskList", (String)"computerID, controllerID, qualifier, volgroupID");
        }
        NameList nameList = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            short s2 = this.cmpAccessor.getStorageSubsystemType(n);
            if (s2 < 0) {
                this.prepDiskListStmtHost(n, n2, s, n3);
            } else {
                this.prepDiskListStmtSS(n, n2, n3, s2);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                NameList nameList2 = new NameList();
                nameList2.nlID = this.getInt(this.resultSet);
                nameList2.nlName = this.getString(this.resultSet);
                nameList2.nlID2 = this.getInt(this.resultSet);
                nameList2.nlNext = nameList;
                nameList = nameList2;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDiskList", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        NameList nameList3 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDiskList", nameList3);
        }
        return nameList3;
    }

    private void prepDiskListStmtSS(int n, int n2, int n3, short s) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepareDiskListStatementSS", (String)"computerID, controllerID, volgroupID, ssType");
        }
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(500);
        if (n2 > 0) {
            stringBuffer.append(GET_DISKS_BY_DISK_GROUP);
            stringBuffer.append(" and dg.disk_group_id = " + n2);
        } else if (s == 21) {
            if (n3 > 0) {
                stringBuffer.append(GET_SVC_DISKS_BY_POOL);
                bl = true;
            } else {
                stringBuffer.append(GET_SVC_DISKS_BY_SS);
            }
        } else if (n3 > 0) {
            stringBuffer.append(GET_DISKS_BY_POOL);
            bl = true;
            bl2 = true;
        } else {
            stringBuffer.append(GET_DISKS_BY_SS);
        }
        stringBuffer.append(ORDER_BY_DISK_NAME);
        String string = stringBuffer.toString();
        this.selectStmt = this.prepareStmt(string);
        this.setInt(this.selectStmt, n);
        if (bl) {
            this.setInt(this.selectStmt, n3);
            if (bl2) {
                this.setInt(this.selectStmt, n3);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepareDiskListStatementSS");
        }
    }

    private void prepDiskListStmtHost(int n, int n2, short s, int n3) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepareDiskListStatementHost", (String)"computerID, controllerID, qaulifier, volgroupID");
        }
        if (n2 > 0) {
            this.selectStmt = this.prepareStmt(GET_DISKS_BY_CONTROLLER);
            this.setInt(this.selectStmt, n2);
        } else if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(500);
            stringBuffer.append(GET_DISKS_BY_COMPUTER);
            if (s != 0) {
                stringBuffer.append(" and c.controller_type ");
                if (s > 0) {
                    stringBuffer.append("= ");
                } else {
                    stringBuffer.append("<> ");
                }
                stringBuffer.append(8);
            }
            if (n3 > 0) {
                stringBuffer.append(" and x.volgroup_id = " + n3);
            }
            stringBuffer.append(" order by d.path desc");
            String string = stringBuffer.toString();
            this.selectStmt = this.prepareStmt(string);
            this.setInt(this.selectStmt, n);
        } else {
            this.selectStmt = this.prepareStmt(GET_ALL_DISKS);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepareDiskListStatementHost");
        }
    }

    public void prepPathDevCompQuery() throws GeneralException {
        this.selectStmt = this.prepareStmt(GET_PATH_BY_DEVICE_COMPUTER);
    }

    public void prepPathDevSSQuery() throws GeneralException {
        this.selectStmt = this.prepareStmt(GET_PATH_BY_DEVICE_SS);
    }

    public String getPathByDeviceComputer(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPathByDeviceComputer", (String)"deviceID, computerID");
        }
        String string = null;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, n);
            this.setInt(this.selectStmt, n2);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                string = this.getString(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPathByDeviceComputer", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPathByDeviceComputer", string2);
        }
        return string2;
    }

    public void insertDevAccess(DevAccess devAccess) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertDevAccess", (String)"daList");
        }
        try {
            this.insertStmt = this.prepareStmt(INSERT);
            DevAccess devAccess2 = devAccess;
            while (devAccess2 != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setKey(this.insertStmt, devAccess2);
                this.setAttributes(this.insertStmt, devAccess2);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                devAccess2 = devAccess2.daNextDevice;
            }
            this.closeInsert();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertDevAccess", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertDevAccess");
        }
    }

    private void setKey(PreparedStatement preparedStatement, DevAccess devAccess) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setKey", (String)"stmt, da");
        }
        this.setInt(preparedStatement, devAccess.daControllerID);
        this.setShort(preparedStatement, devAccess.daTarget);
        this.setShort(preparedStatement, devAccess.daLUN);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setKey");
        }
    }

    private void setAttributes(PreparedStatement preparedStatement, DevAccess devAccess) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setAttributes", (String)"stmt, da");
        }
        this.setInt(preparedStatement, devAccess.daDeviceID);
        this.setString(preparedStatement, devAccess.daPath);
        this.setBoolean(preparedStatement, devAccess.daInactive);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setAttributes");
        }
    }

    public void updateDevAccess(DevAccess devAccess) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateDevAccess", (String)"daList");
        }
        try {
            this.updateStmt = this.prepareStmt(UPDATE);
            DevAccess devAccess2 = devAccess;
            while (devAccess2 != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setAttributes(this.updateStmt, devAccess2);
                this.setKey(this.updateStmt, devAccess2);
                this.executeUpdate(this.updateStmt);
                this.dbc.commit();
                devAccess2 = devAccess2.daNextDevice;
            }
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateDevAccess", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateDevAccess");
        }
    }

    public void deleteDevAccess(DevAccess devAccess) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteDevAccess", (String)"daList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_KEY);
            DevAccess devAccess2 = devAccess;
            while (devAccess2 != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setKey(this.deleteStmt, devAccess2);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                devAccess2 = devAccess2.daNextDevice;
            }
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteDevAccess", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.deleteError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteDevAccess");
        }
    }

    public void deleteDevAccess(Controller controller) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteDevAccess", (String)"ctlrList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_CONTROLLER);
            Controller controller2 = controller;
            while (controller2 != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, controller2.ctlrID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                controller2 = controller2.ctlrNext;
            }
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteDevAccess", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.deleteError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteDevAccess");
        }
    }

    public void deleteByComputer(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByComputer", (String)"computerID");
        }
        try {
            boolean bl = this.cmpAccessor.isStorageSubsystem(n);
            this.deleteStmt = !bl ? this.prepareStmt(DELETE_BY_COMPUTER) : this.prepareStmt(DELETE_BY_SS);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, n);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteByComputer", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.deleteError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResDevAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByComputer");
        }
    }
}

