/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.FsNameList;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.QueryBySchedule;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.ResourceFilter;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.ScheduleQueryable;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.LocalizableException;

public class TResFS
extends StorageRepositoryAccessor
implements NameListQueryable,
ScheduleQueryable {
    private Timestamp tsScan = new Timestamp(0L);
    private Timestamp tsCurr = new Timestamp(0L);
    public static final String[] dependentTables = new String[]{"t_stat_user", "t_stat_group", "t_stat_file_type", "t_stat_file", "t_stat_large_dir", "t_stat_time_dist", "t_stat_time_hist", "t_stat_summary", "t_stat_user_hist", "t_stat_group_hist", "t_stat_ftype_hist", "t_stat_space_hist", "t_stat_size_dist", "t_stat_directory", "t_stat_scan_spoor", "t_stat_fs_hist", "t_res_filesystem"};
    public static final int TABLES_WITH_STAT_ID = 13;
    private QueryBySchedule queryBySchedule;
    private long currentTime;
    PreparedStatement updateUseCountStmt;
    public static final String ID_COLUMN_NAME = "filesystem_id";
    private static final String SELECT = "select filesystem_id, mount_point, computer_id, group_id, log_disk_id, logical_disk_id, filesystem_type, use_count, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, scanning_comp_id, export_name, discovered_time from t_res_filesystem where ";
    private static final String BY_ID = "filesystem_id = ?";
    private static final String BY_LOGICAL_DISK = "logical_disk_id = ?";
    private static final String BY_COMPUTER = "computer_id = ?";
    private static final String SELECT_BY_MOUNT_POINT = "select f.computer_id, f.filesystem_id, f.group_id, f.logical_disk_id, f.use_count, f.capacity from t_res_filesystem f, t_res_share s where s.computer_id = ? and s.resource_type = 3 and s.resource_id = f.filesystem_id and f.mount_point = ? order by f.use_count";
    private static final String SELECT_AGENT_GROUP_FS = "select distinct f.filesystem_id, a.exclude, f.mount_point, f.computer_id, f.group_id, f.log_disk_id, f.logical_disk_id, f.filesystem_type, f.use_count, f.physical_size, f.capacity, f.used_space, f.free_space, f.maxfiles, f.used_inodes, f.free_inodes, f.last_scan_time, scanning_comp_id, export_name from t_res_filesystem f, t_res_attribute a, t_stat_computer c where a.attribute_id = ? and f.scanning_comp_id = ? and c.computer_id = f.computer_id and (f.filesystem_id = a.resource_id or f.group_id = a.resource_id or a.resource_id = c.computer_id or a.resource_id = c.group_id or a.resource_id = c.cluster_id or a.resource_type = " + Short.toString((short)13) + ") order by 1, 2 desc";
    private static final String SELECT_ID_BY_GROUP = "select filesystem_id from t_res_filesystem where group_id = ?";
    private static final String SELECT_ID_BY_COMPUTER = "select filesystem_id from t_res_filesystem where computer_id = ?";
    private static final String SELECT_NAMES = "select computer_id, mount_point, filesystem_id from t_res_filesystem";
    private static final String SELECT_EXTENDABLE = "select f.computer_id, f.mount_point, f.filesystem_id, f.capacity, f.free_space from t_res_filesystem f, t_res_logical_disk l, t_res_volgroup v where f.filesystem_type in (8,6) and f.logical_disk_id = l.logical_disk_id and l.volgroup_id = v.volgroup_id and v.volgroup_type in (0,1 ) order by 1 desc, 2 desc";
    private static final String IS_EXTENSIBLE = "select f.computer_id  from t_res_filesystem f, t_res_logical_disk l, t_res_volgroup v, t_res_host c where f.filesystem_type in (8,6) and (f.logical_disk_id = l.logical_disk_id) and (c.computer_id = f.computer_id) and l.volgroup_id = v.volgroup_id and v.volgroup_type in (0,1 ) and (c.host_url = ?) and (f.mount_point = ?)";
    private static final String SELECT_VISIBLE_NAMES = "select s.computer_id, f.mount_point, f.filesystem_id from t_res_filesystem f, t_res_share s where s.computer_id = ? and s.resource_type = 3 and s.resource_id = f.filesystem_id order by f.mount_point";
    private static final String JOIN_1 = "select f.computer_id, f.mount_point, f.filesystem_id, a.exclude from t_res_filesystem f, t_res_attribute a where a.attribute_id = ? and f.filesystem_id = a.resource_id";
    private static final String JOIN_1_ORDER_BY = " order by 1, 2";
    private static final String JOIN_2_PT_I = ", f.filesystem_id, a.exclude from t_res_filesystem f, t_res_attribute a, t_stat_computer c where f.computer_id = c.computer_id and a.attribute_id = ? and ";
    private static final String JOIN_2_PT_II;
    private static final String JOIN_3_PT_I = "select distinct a.attribute_id, f.filesystem_id, a.exclude from t_res_filesystem f, t_res_attribute a, t_stat_computer c where c.computer_id = f.computer_id and a.attribute_type = ?";
    private static final String JOIN_3_PT_II;
    public static final String SELECT_PARENT_IDS = "select distinct f.filesystem_id, gr.group_id from t_res_filesystem f, t_view_group2res gr where gr.res_type = 3 and f.filesystem_id = gr.resource_id union  select f.filesystem_id, f.computer_id from t_res_filesystem f union  select f.filesystem_id, c.domain_id from t_res_filesystem f, t_stat_computer c where f.computer_id = c.computer_id union select distinct f.filesystem_id, gr.group_id from t_res_filesystem f, t_view_group2res gr where f.computer_id = gr.resource_id order by 1";
    private static final String INSERT = "insert into t_res_filesystem (physical_size, filesystem_type, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, mount_point, computer_id, filesystem_id, logical_disk_id, log_disk_id, group_id, use_count, discovered_time, file_count, directory_count, scanning_comp_id, export_name) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SCAN_UPDATE = "update t_res_filesystem set filesystem_type = ?, capacity = ?, used_space = ?, free_space = ?, maxfiles = ?, used_inodes = ?, free_inodes = ?, last_scan_time = ?, file_count = ?, directory_count = ? where filesystem_id = ?";
    private static final String PROBE_UPDATE = "update t_res_filesystem set physical_size = ?, filesystem_type = ?,  capacity = ?, used_space = ?, free_space = ?, maxfiles = ?, used_inodes = ?, free_inodes = ?, log_disk_id = ?, mount_point = ?";
    private static final String WHERE_FSID = " where filesystem_id = ?";
    private static final String UPDATE_USE_COUNT = "update t_res_filesystem set use_count = ? where filesystem_id = ?";
    private static final String UPDATE_LOGICAL_DISK = "update t_res_filesystem set logical_disk_id = ? where filesystem_id = ?";
    private static final String UPDATE_SCAN_COMPUTER = "update t_res_filesystem set computer_id = ?, scanning_comp_id = ? where filesystem_id = ?";
    private static final String RESET_SCAN_COMPUTER = "update t_res_filesystem set scanning_comp_id = 0 where scanning_comp_id = ? and computer_id <> scanning_comp_id";
    private static final String RESET_DISCOVERY_SCAN_COMPUTER = "update t_found_filesystem set scanning_comp_id = 0 where scanning_comp_id = ?";
    private static final String RESET_NAS_SCAN_COMPUTER = "update t_found_filesystem set scanning_comp_id = 0 where computer_id = ?";
    private static final String DELETE_BY_FS = "delete from t_res_filesystem where filesystem_id = ?";
    private static final String IN_FS_GROUP = " in (select resource_id from t_view_group2res where res_indicator in (1,2, 5) group_id = ";
    private static final String SELECT_NAS_FILESYSTEMS = "select computer_id, filesystem_id, mount_point, scanning_comp_id, export_name from t_res_filesystem where computer_id <> scanning_comp_id";
    private static final String UPDATE_SCANNING_AGENT = "update t_res_filesystem set scanning_comp_id = ? where filesystem_id = ?";
    private static final String SELECT_SCANNING_COMPID = "select scanning_comp_id from t_res_filesystem where filesystem_id = ?";

    static {
        JOIN_3_PT_II = JOIN_2_PT_II = " and ((a.resource_type = " + Short.toString((short)3) + "  and f.filesystem_id = a.resource_id) or" + " (a.resource_type = " + Short.toString((short)2) + "  and f.group_id = a.resource_id) or " + " (a.resource_type = " + Short.toString((short)1) + "  and f.computer_id = a.resource_id) or" + " (a.resource_type = " + Short.toString((short)0) + "  and c.group_id = a.resource_id) or" + " (a.resource_type = " + Short.toString((short)99) + "  and a.resource_id = c.cluster_id)  or a.resource_type = " + Short.toString((short)13) + ") order by 1, 2, 3 desc";
    }

    public TResFS(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResFS", (String)"dbc");
        }
        try {
            this.currentTime = SQLUtil.getTimestamp(connection).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"TResFS", (Throwable)exception);
            }
            return;
        }
        this.tableName = "t_res_filesystem";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResFS");
        }
    }

    public Filesystem getAgentScanFS(int n, int n2, Response response) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getAgentScanFS", (String)"computerID, scheduleID, response");
        }
        Filesystem filesystem = null;
        Filesystem filesystem2 = null;
        int n3 = -1;
        try {
            this.selectStmt = this.dbc.prepareStatement(SELECT_AGENT_GROUP_FS);
            this.colIndex = 1;
            this.setInt(this.selectStmt, n2);
            this.setInt(this.selectStmt, n);
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                int n4 = this.getInt(this.resultSet);
                if (n4 == n3) continue;
                n3 = n4;
                if (this.getBoolean(this.resultSet)) continue;
                Filesystem filesystem3 = new Filesystem();
                filesystem3.fsID = n4;
                this.fetchFS(filesystem3, 3);
                if (filesystem2 != null) {
                    filesystem2.fsNext = filesystem3;
                } else {
                    filesystem = filesystem3;
                }
                filesystem2 = filesystem3;
            }
            this.closeSelect();
            Filesystem filesystem4 = filesystem = this.getNasFilers(n, filesystem, response);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getAgentScanFS", (Object)filesystem4);
            }
            return filesystem4;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getAgentScanFS", (Throwable)sQLException);
            }
            this.cleanup();
            Object[] objectArray = new Object[]{String.valueOf(n2)};
            String string = SQLUtil.getSQLExceptionMsg("STS0009E", sQLException, objectArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getAgentScanFS");
            }
            throw new GeneralException(string);
        }
    }

    private void fetchFS(Filesystem filesystem, int n) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchFS", (String)"fs, startingColumn");
        }
        this.stmtPhase = 1;
        this.colIndex = n;
        if (n == 1) {
            filesystem.fsID = this.getInt(this.resultSet);
        }
        filesystem.fsMountPoint = this.getString(this.resultSet);
        filesystem.fsComputerID = this.getInt(this.resultSet);
        filesystem.fsGroupID = this.getInt(this.resultSet);
        filesystem.fsLogDiskID = this.getInt(this.resultSet);
        filesystem.fsLogicalDiskID = this.getInt(this.resultSet);
        filesystem.fsType = this.getShort(this.resultSet);
        filesystem.fsUseCount = this.getShort(this.resultSet);
        filesystem.fsPhysicalSize = this.getLong(this.resultSet);
        filesystem.fsCapacity = this.getLong(this.resultSet);
        filesystem.fsUsedSpace = this.getLong(this.resultSet);
        filesystem.fsFreeSpace = this.getLong(this.resultSet);
        filesystem.fsMaxFiles = this.getInt(this.resultSet);
        filesystem.fsUsedInodes = this.getInt(this.resultSet);
        filesystem.fsFreeInodes = this.getInt(this.resultSet);
        filesystem.fsScanTime = this.getTimestamp(this.resultSet);
        filesystem.fsScanningCompID = this.getInt(this.resultSet);
        filesystem.fsExportName = this.getString(this.resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchFS");
        }
    }

    public Filesystem getNasFilers(int n, Filesystem filesystem, Response response) throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNasFilers", (String)"computerID, fsList, response");
        }
        HashMap<MutableInteger, Object> hashMap = new HashMap<MutableInteger, Object>();
        MutableInteger mutableInteger = new MutableInteger();
        TResComputer tResComputer = new TResComputer(this.dbc);
        tResComputer.prepGetNasFiler();
        Object object2 = filesystem;
        while (object2 != null) {
            block16: {
                block17: {
                    if (object2.fsComputerID == object2.fsScanningCompID) break block16;
                    mutableInteger.value = object2.fsComputerID;
                    object = (NasFiler)hashMap.get(mutableInteger);
                    if (object != null) break block17;
                    object = tResComputer.getNasFiler(object2.fsComputerID);
                    if (object == null) break block16;
                    hashMap.put(new MutableInteger(object2.fsComputerID), object);
                }
                object2.fsNasFiler = object;
            }
            object2 = object2.fsNext;
        }
        tResComputer.closeSelect();
        if (hashMap.isEmpty()) {
            object2 = filesystem;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getNasFilers", (Object)object2);
            }
            return object2;
        }
        tResComputer = null;
        object2 = Server.agentMgr.get(n);
        if (object2 == null || Constants.isWindows((short)object2.osType)) {
            object = new TResPwd(this.dbc);
            ((TResPwd)object).getFilerLogins(hashMap.values().iterator());
        }
        object = filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNasFilers", (Object)object);
        }
        return object;
    }

    private Filesystem pruneNasFilesystems(Filesystem filesystem) {
        Filesystem filesystem2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"pruneNasFilesystems", (String)"fsList");
        }
        Filesystem filesystem3 = null;
        Filesystem filesystem4 = filesystem;
        while (filesystem4 != null) {
            filesystem2 = filesystem4.fsNasFiler;
            if (filesystem2 != null && !filesystem2.nfManufacturer.equals("NOVELL")) {
                if (filesystem3 == null) {
                    filesystem = filesystem4.fsNext;
                } else {
                    filesystem3.fsNext = filesystem4.fsNext;
                }
            } else {
                filesystem3 = filesystem4;
            }
            filesystem4 = filesystem4.fsNext;
        }
        filesystem2 = filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"pruneNasFilesystems", (Object)filesystem2);
        }
        return filesystem2;
    }

    public Filesystem getByComputerID(int n) throws GeneralException {
        Filesystem filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByComputerID", (String)"computerID");
        }
        Filesystem filesystem2 = null;
        this.selectStmt = this.prepareStmt("select filesystem_id, mount_point, computer_id, group_id, log_disk_id, logical_disk_id, filesystem_type, use_count, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, scanning_comp_id, export_name, discovered_time from t_res_filesystem where computer_id = ?");
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                filesystem = new Filesystem();
                this.fetchFS(filesystem, 1);
                filesystem.fsNext = filesystem2;
                filesystem2 = filesystem;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getByComputerID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        filesystem = filesystem2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByComputerID", filesystem);
        }
        return filesystem;
    }

    public void prepSelectByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectByID", (String)"");
        }
        this.selectStmt = this.prepareStmt("select filesystem_id, mount_point, computer_id, group_id, log_disk_id, logical_disk_id, filesystem_type, use_count, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, scanning_comp_id, export_name, discovered_time from t_res_filesystem where filesystem_id = ?");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectByID");
        }
    }

    public Filesystem getByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByID", (String)"fsID");
        }
        Filesystem filesystem = this.singletonSelectByID(n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByID", (Object)filesystem);
        }
        return filesystem;
    }

    private Filesystem singletonSelectByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"singletonSelectByID", (String)"identifier");
        }
        Filesystem filesystem = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                filesystem = new Filesystem();
                this.fetchFS(filesystem, 1);
                filesystem.fsDiscoveredTime = this.getTimestamp(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"singletonSelectByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Filesystem filesystem2 = filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"singletonSelectByID", filesystem2);
        }
        return filesystem2;
    }

    public void prepSelectByLogicalDisk() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectByLogicalDisk", (String)"");
        }
        this.selectStmt = this.prepareStmt("select filesystem_id, mount_point, computer_id, group_id, log_disk_id, logical_disk_id, filesystem_type, use_count, physical_size, capacity, used_space, free_space, maxfiles, used_inodes, free_inodes, last_scan_time, scanning_comp_id, export_name, discovered_time from t_res_filesystem where logical_disk_id = ?");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectByLogicalDisk");
        }
    }

    public Filesystem getByLogicalDisk(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByLogicalDisk", (String)"lDiskID");
        }
        Filesystem filesystem = this.singletonSelectByID(n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByLogicalDisk", (Object)filesystem);
        }
        return filesystem;
    }

    public void prepSelectByMountPoint() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectByMountPoint", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_MOUNT_POINT);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectByMountPoint");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getByMountPoint(Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getByMountPoint", (String)"fs");
        }
        try {
            boolean bl;
            try {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, filesystem.fsComputerID);
                this.setString(this.selectStmt, filesystem.fsMountPoint);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (!this.nextResult()) {
                    boolean bl2 = false;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getByMountPoint", (boolean)bl2);
                    }
                    boolean bl3 = bl2;
                    Object var3_8 = null;
                    this.closeResultSet();
                    return bl3;
                }
                this.stmtPhase = 1;
                this.colIndex = 1;
                filesystem.fsComputerID = this.getInt(this.resultSet);
                filesystem.fsID = this.getInt(this.resultSet);
                filesystem.fsGroupID = this.getInt(this.resultSet);
                filesystem.fsLogicalDiskID = this.getInt(this.resultSet);
                filesystem.fsUseCount = this.getShort(this.resultSet);
                filesystem.fsCapacity = this.getLong(this.resultSet);
                boolean bl4 = true;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getByMountPoint", (boolean)bl4);
                }
                bl = bl4;
                Object var3_9 = null;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getByMountPoint", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
            this.closeResultSet();
            return bl;
            Object var3_11 = null;
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            this.closeResultSet();
            throw throwable;
        }
        this.closeResultSet();
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByMountPoint", (boolean)bl);
        }
        return bl;
    }

    public void prepSelectIDByGroup() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectIDByGroup", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_ID_BY_GROUP);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectIDByGroup");
        }
    }

    public void prepSelectIDByComputer() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectIDByComputer", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_ID_BY_COMPUTER);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectIDByComputer");
        }
    }

    public NameList selectVisibleNames(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectVisibleNames", (String)"computerID");
        }
        NameList nameList = this.nameListQuery(SELECT_VISIBLE_NAMES, n, false, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectVisibleNames", (Object)nameList);
        }
        return nameList;
    }

    private NameList nameListQuery(String string, int n, boolean bl, ResourceFilter resourceFilter) throws GeneralException {
        NameList nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"nameListQuery", (String)"sqlText, ID, hasExclude, filter");
        }
        NameList nameList2 = null;
        NameList nameList3 = null;
        this.selectStmt = this.prepareStmt(string);
        try {
            if (n != -1) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
            }
            nameList = new NameList();
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                nameList.nlID2 = this.getInt(this.resultSet);
                nameList.nlName = this.getString(this.resultSet);
                nameList.nlID = this.getInt(this.resultSet);
                if (bl && this.getBoolean(this.resultSet)) {
                    nameList.nlState = 1;
                }
                nameList.nlInfo = (short)3;
                if (resourceFilter != null && !resourceFilter.accept(nameList)) continue;
                NameList nameList4 = (NameList)nameList.clone();
                if (nameList3 == null) {
                    nameList2 = nameList4;
                } else {
                    nameList3.nlNext = nameList4;
                }
                nameList3 = nameList4;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"nameListQuery", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        nameList = nameList2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"nameListQuery", (Object)nameList);
        }
        return nameList;
    }

    public NameList selectNames(GuiListReq guiListReq) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectNames", (String)"requestData");
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        String string = " order by computer_id, mount_point";
        int n = guiListReq.groupID;
        int n2 = guiListReq.computerID;
        stringBuffer.append(SELECT_NAMES);
        if (n != -1) {
            stringBuffer.append(" where group_id = ?");
        } else if (n2 > 0) {
            stringBuffer.append(" where computer_id = ?");
            n = n2;
        }
        ResourceFilter resourceFilter = null;
        stringBuffer.append(string);
        NameList nameList = this.nameListQuery(stringBuffer.toString(), n, false, resourceFilter);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectNames", (Object)nameList);
        }
        return nameList;
    }

    public NameList queryDependents(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queryDependents", (String)"parentID");
        }
        NameList nameList = this.nameListQuery("select f.computer_id, f.mount_point, f.filesystem_id, a.exclude from t_res_filesystem f, t_res_attribute a where a.attribute_id = ? and f.filesystem_id = a.resource_id order by 1, 2", n, true, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queryDependents", (Object)nameList);
        }
        return nameList;
    }

    public NameList queryDependents(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queryDependents", (String)"computerID, parentID");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JOIN_1);
        stringBuffer.append(" and computer_id = ");
        stringBuffer.append(n);
        stringBuffer.append(JOIN_1_ORDER_BY);
        NameList nameList = this.nameListQuery(stringBuffer.toString(), n2, false, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queryDependents", (Object)nameList);
        }
        return nameList;
    }

    public FsNameList queryExtendable() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queryExtendable", (String)"");
        }
        FsNameList fsNameList = null;
        int n = -1;
        boolean bl = false;
        AgentManager agentManager = Server.getAgentManager();
        this.selectStmt = this.prepareStmt(SELECT_EXTENDABLE);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                int n2 = this.getInt(this.resultSet);
                if (n2 != n) {
                    n = n2;
                    bl = this.isOsExtendable(agentManager.getAgentOsType(n2));
                }
                if (!bl) continue;
                FsNameList fsNameList2 = new FsNameList();
                fsNameList2.nlID2 = n2;
                fsNameList2.nlName = this.getString(this.resultSet);
                fsNameList2.nlID = this.getInt(this.resultSet);
                fsNameList2.fsCapacity = this.getLong(this.resultSet);
                fsNameList2.fsFreespace = this.getLong(this.resultSet);
                fsNameList2.nlNext = fsNameList;
                fsNameList = fsNameList2;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"queryExtendable", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        FsNameList fsNameList3 = fsNameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queryExtendable", fsNameList3);
        }
        return fsNameList3;
    }

    private boolean isOsExtendable(short s) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isOsExtendable", (String)"osType");
        }
        boolean bl2 = bl = s == 2 || s == 6;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isOsExtendable", (boolean)bl);
        }
        return bl;
    }

    public void initQueryBySchedule(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initQueryBySchedule", (String)"scheduleID");
        }
        this.initQueryBySchedule(n, true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initQueryBySchedule");
        }
    }

    public void initQueryBySchedule(int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initQueryBySchedule", (String)"scheduleID, scanningCompID");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = bl ? "f.scanning_comp_id" : "f.computer_id";
        stringBuffer.append("select distinct ");
        stringBuffer.append(string);
        stringBuffer.append(JOIN_2_PT_I);
        stringBuffer.append(string);
        stringBuffer.append(" > 0");
        stringBuffer.append(JOIN_2_PT_II);
        this.queryBySchedule = new QueryBySchedule(this);
        this.queryBySchedule.init(stringBuffer.toString(), n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initQueryBySchedule");
        }
    }

    public void initQueryByAttrType(short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initQueryByAttrType", (String)"attributeType");
        }
        this.initQueryByAttrType(s, null, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initQueryByAttrType");
        }
    }

    public void initQueryByAttrType(short s, Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initQueryByAttrType", (String)"attributeType, fsList");
        }
        this.initQueryByAttrType(s, filesystem, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initQueryByAttrType");
        }
    }

    public void initQueryByAttrType(short s, Filesystem filesystem, ResourceFilter resourceFilter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initQueryByAttrType", (String)"attributeType, fsList, filter");
        }
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append(JOIN_3_PT_I);
        if (filesystem != null) {
            stringBuffer.append(" and f.filesystem_id in (");
            while (filesystem != null) {
                stringBuffer.append(Integer.toString(filesystem.fsID));
                stringBuffer.append(',');
                filesystem = filesystem.fsNext;
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        }
        stringBuffer.append(JOIN_3_PT_II);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setShort(this.selectStmt, s);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initQueryByAttrType", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.stmtPhase = 1;
        this.queryBySchedule = new QueryBySchedule(this, resourceFilter);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initQueryByAttrType");
        }
    }

    public boolean fetchQueryBySchedule(NameList nameList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchQueryBySchedule", (String)"element");
        }
        boolean bl = this.queryBySchedule.fetch(nameList);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchQueryBySchedule", (boolean)bl);
        }
        return bl;
    }

    public void prepSelectParentIDs(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectParentIDs", (String)"sqlText");
        }
        this.prepSelectForParentIDs(string);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectParentIDs");
        }
    }

    public int[] prepSelectCompGroupIDs(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectCompGroupIDs", (String)"sqlText");
        }
        this.prepSelectForParentIDs(string);
        int[] nArray = new int[2];
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectCompGroupIDs", (Object)nArray);
        }
        return nArray;
    }

    private void prepSelectForParentIDs(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectForParentIDs", (String)"sqlText");
        }
        this.selectStmt = this.prepareStmt(string);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepSelectForParentIDs", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.stmtPhase = 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectForParentIDs");
        }
    }

    public boolean selectParentIDs(int[] nArray) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectParentIDs", (String)"fetchBuffer");
        }
        if (bl = this.nextResult()) {
            try {
                this.colIndex = 1;
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = this.getInt(this.resultSet);
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectParentIDs", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectParentIDs", (boolean)bl2);
        }
        return bl2;
    }

    public void prepInsert() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepInsert", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepInsert");
        }
    }

    public void insert(Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"fs");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            if (filesystem.fsType == 18 || filesystem.fsType == 19) {
                filesystem.fsPhysicalSize = -1L;
            }
            this.setLong(this.insertStmt, filesystem.fsPhysicalSize);
            this.setStatistics(this.insertStmt, filesystem);
            this.setTimestamp(this.insertStmt, filesystem);
            this.setString(this.insertStmt, filesystem.fsMountPoint);
            this.setInt(this.insertStmt, filesystem.fsComputerID);
            this.setInt(this.insertStmt, filesystem.fsID);
            this.setInt(this.insertStmt, filesystem.fsLogicalDiskID);
            this.setInt(this.insertStmt, filesystem.fsLogDiskID);
            this.setInt(this.insertStmt, filesystem.fsGroupID);
            this.setInt(this.insertStmt, filesystem.fsUseCount);
            this.setTimestamp(this.insertStmt, this.currentTime, this.tsCurr);
            this.setInt(this.insertStmt, -1);
            this.setInt(this.insertStmt, -1);
            this.setInt(this.insertStmt, filesystem.fsScanningCompID);
            this.setString(this.insertStmt, filesystem.fsExportName);
            this.executeUpdate(this.insertStmt);
            TGroup2Res tGroup2Res = new TGroup2Res(this.dbc);
            tGroup2Res.insertNewResources(filesystem.fsID, filesystem.fsGroupID, filesystem.fsMountPoint, false);
            tGroup2Res = null;
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    private void setStatistics(PreparedStatement preparedStatement, Filesystem filesystem) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setStatistics", (String)"stmt, fs");
        }
        this.setShort(preparedStatement, filesystem.fsType);
        if (filesystem.fsType == 18 || filesystem.fsType == 19) {
            filesystem.fsCapacity = -1L;
            filesystem.fsUsedSpace = -1L;
            filesystem.fsFreeSpace = -1L;
            filesystem.fsMaxFiles = -1;
            filesystem.fsUsedInodes = -1;
            filesystem.fsFreeInodes = -1;
        }
        this.setLong(preparedStatement, filesystem.fsCapacity);
        this.setLong(preparedStatement, filesystem.fsUsedSpace);
        this.setLong(preparedStatement, filesystem.fsFreeSpace);
        this.setInt(preparedStatement, filesystem.fsMaxFiles);
        this.setInt(preparedStatement, filesystem.fsUsedInodes);
        this.setInt(preparedStatement, filesystem.fsFreeInodes);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setStatistics");
        }
    }

    private void setTimestamp(PreparedStatement preparedStatement, Filesystem filesystem) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setTimestamp", (String)"stmt, fs");
        }
        this.setTimestamp(preparedStatement, filesystem.fsScanTime, this.tsScan);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setTimestamp");
        }
    }

    public void prepScanUpdate() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepScanUpdate", (String)"");
        }
        this.updateStmt = this.prepareStmt(SCAN_UPDATE);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepScanUpdate");
        }
    }

    public void scanUpdate(Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"scanUpdate", (String)"fs");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStatistics(this.updateStmt, filesystem);
            this.setTimestamp(this.updateStmt, filesystem);
            this.setInt(this.updateStmt, filesystem.fsFileCount);
            this.setInt(this.updateStmt, filesystem.fsDirectoryCount);
            this.setInt(this.updateStmt, filesystem.fsID);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"scanUpdate", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"scanUpdate");
        }
    }

    public void prepProbeUpdate(boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepProbeUpdate", (String)"setExportName");
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(PROBE_UPDATE);
        if (bl) {
            stringBuffer.append(", export_name = ?");
        }
        stringBuffer.append(WHERE_FSID);
        this.updateStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepProbeUpdate");
        }
    }

    public boolean probeUpdate(Filesystem filesystem) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"probeUpdate", (String)"fs");
        }
        int n = 0;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            if (filesystem.fsType == 18 || filesystem.fsType == 19) {
                filesystem.fsPhysicalSize = -1L;
            }
            this.setLong(this.updateStmt, filesystem.fsPhysicalSize);
            this.setStatistics(this.updateStmt, filesystem);
            this.setInt(this.updateStmt, filesystem.fsLogDiskID);
            this.setString(this.updateStmt, filesystem.fsMountPoint);
            if (filesystem.fsExportName != null) {
                this.setString(this.updateStmt, filesystem.fsExportName);
            }
            this.setInt(this.updateStmt, filesystem.fsID);
            n = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"probeUpdate", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        boolean bl2 = bl = n > 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"probeUpdate", (boolean)bl);
        }
        return bl;
    }

    public void prepUpdateUseCount() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepUpdateUseCount", (String)"");
        }
        this.updateUseCountStmt = this.prepareStmt(UPDATE_USE_COUNT);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepUpdateUseCount");
        }
    }

    public void updateUseCount(Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateUseCount", (String)"fs");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.updateUseCountStmt, filesystem.fsUseCount);
            this.setInt(this.updateUseCountStmt, filesystem.fsID);
            this.executeUpdate(this.updateUseCountStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateUseCount", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateUseCount");
        }
    }

    public void prepUpdateLogicalDisk() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepUpdateLogicalDisk", (String)"");
        }
        this.updateStmt = this.prepareStmt(UPDATE_LOGICAL_DISK);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepUpdateLogicalDisk");
        }
    }

    public void updateLogicalDisk(Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateLogicalDisk", (String)"fs");
        }
        this.updateIdentifier(filesystem, new int[]{filesystem.fsLogicalDiskID});
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateLogicalDisk");
        }
    }

    private void updateIdentifier(Filesystem filesystem, int[] nArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateIdentifier", (String)"fs, newIdentifiers");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            int n = 0;
            while (n < nArray.length) {
                this.setInt(this.updateStmt, nArray[0]);
                ++n;
            }
            if (filesystem != null) {
                this.setInt(this.updateStmt, filesystem.fsID);
            }
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateIdentifier", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateIdentifier");
        }
    }

    public void prepUpdateScanComputer() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepUpdateScanComputer", (String)"");
        }
        this.updateStmt = this.prepareStmt(UPDATE_SCAN_COMPUTER);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepUpdateScanComputer");
        }
    }

    public void updateScanComputer(Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateScanComputer", (String)"fs");
        }
        this.updateIdentifier(filesystem, new int[]{filesystem.fsComputerID, filesystem.fsComputerID});
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateScanComputer");
        }
    }

    public void resetScanComputer(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"resetScanComputer", (String)"computerID");
        }
        int[] nArray = new int[]{n};
        this.updateStmt = this.prepareStmt(RESET_SCAN_COMPUTER);
        this.updateIdentifier(null, nArray);
        this.closeUpdate();
        this.updateStmt = this.prepareStmt(RESET_DISCOVERY_SCAN_COMPUTER);
        this.updateIdentifier(null, nArray);
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"resetScanComputer");
        }
    }

    public void resetNasScanComputer(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"resetNasScanComputer", (String)"computerID");
        }
        int[] nArray = new int[]{n};
        this.updateStmt = this.prepareStmt(RESET_NAS_SCAN_COMPUTER);
        this.updateIdentifier(null, nArray);
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"resetNasScanComputer");
        }
    }

    public void updateScanComputer(int n, int n2, int n3) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateScanComputer", (String)"hostCID, scanCID, filesystemID");
        }
        try {
            this.setPhase();
            this.setInt(this.updateStmt, n);
            this.setInt(this.updateStmt, n2);
            this.setInt(this.updateStmt, n3);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateScanComputer", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateScanComputer");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteFS(Filesystem filesystem, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteFS", (String)"fsList, removeAll");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE filesystem_id IN (");
        boolean bl2 = false;
        Filesystem filesystem2 = filesystem;
        while (filesystem2 != null) {
            if (bl2) {
                stringBuffer.append(',');
            }
            bl2 = true;
            stringBuffer.append(Integer.toString(filesystem2.fsID));
            filesystem2 = filesystem2.fsNext;
        }
        stringBuffer.append(')');
        LockManager.lock((short)0, (String)"GLOBAL", (String)"DELETE", (byte)2, (boolean)true);
        try {
            RepositoryAccessor repositoryAccessor;
            if (bl) {
                TAlertLog tAlertLog = new TAlertLog(this.dbc);
                filesystem2 = filesystem;
                while (filesystem2 != null) {
                    tAlertLog.deleteByFilesystem(filesystem2.fsID);
                    filesystem2 = filesystem2.fsNext;
                }
                repositoryAccessor = new TResAttr(this.dbc);
                ResourceAttribute resourceAttribute = new ResourceAttribute();
                ((TResAttr)repositoryAccessor).prepDelete();
                filesystem2 = filesystem;
                while (filesystem2 != null) {
                    resourceAttribute.raResourceID = filesystem2.fsID;
                    resourceAttribute.raResourceType = (short)3;
                    ((TResAttr)repositoryAccessor).delete(resourceAttribute);
                    filesystem2 = filesystem2.fsNext;
                }
                repositoryAccessor.closeDelete();
                repositoryAccessor = null;
            }
            int n = dependentTables.length;
            if (!bl) {
                n -= 2;
            }
            repositoryAccessor = new TGroup2Res(this.dbc);
            filesystem2 = filesystem;
            while (filesystem2 != null) {
                ((TGroup2Res)repositoryAccessor).deleteResource(filesystem2.fsID, false);
                filesystem2 = filesystem2.fsNext;
            }
            repositoryAccessor.commit();
            repositoryAccessor = null;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
            throw throwable;
        }
        LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteFS");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeUpdate() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeUpdate", (String)"");
        }
        super.closeUpdate();
        if (this.updateUseCountStmt != null) {
            try {
                this.closeStmt(this.updateUseCountStmt, STMT_TYPE[2]);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.updateUseCountStmt = null;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.updateUseCountStmt = null;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeUpdate");
        }
    }

    public static void appendInClause(StringBuffer stringBuffer, String string, String string2, GuiReportReq guiReportReq, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendInClause", (String)"buffer, fsColName, groupColName, grr, appendAnd");
        }
        if (guiReportReq.idSubtype == 11) {
            if (bl) {
                stringBuffer.append(" and");
            }
            if (string2 == null) {
                stringBuffer.append(' ');
                stringBuffer.append(string);
                stringBuffer.append(IN_FS_GROUP);
                stringBuffer.append(guiReportReq.grrID1);
                stringBuffer.append(')');
            } else {
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                stringBuffer.append(" = ");
                stringBuffer.append(guiReportReq.grrID1);
            }
        } else {
            SQLUtil.appendInClause(stringBuffer, string, guiReportReq.selectedResources, guiReportReq.isResourceInList, bl);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendInClause");
        }
    }

    public void prepUpdateScanAgent() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepUpdateScanAgent", (String)"");
        }
        this.updateStmt = this.prepareStmt(UPDATE_SCANNING_AGENT);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepUpdateScanAgent");
        }
    }

    public void updateScanningAgent(NasFilesystem nasFilesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateScanningAgent", (String)"fsList");
        }
        try {
            NasFilesystem nasFilesystem2 = nasFilesystem;
            while (nasFilesystem2 != null) {
                this.setPhase();
                this.setInt(this.updateStmt, nasFilesystem2.nflAgentID);
                this.setInt(this.updateStmt, nasFilesystem2.nflFsID);
                this.executeUpdate(this.updateStmt);
                nasFilesystem2 = nasFilesystem2.nflNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateScanningAgent", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateScanningAgent");
        }
    }

    public NasFilesystem[] getNasFilesystems() throws GeneralException {
        NasFilesystem nasFilesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNasFilesystems", (String)"");
        }
        NasFilesystem nasFilesystem2 = null;
        NasFilesystem nasFilesystem3 = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_NAS_FILESYSTEMS);
            this.stmtPhase = 1;
            while (this.nextResult()) {
                nasFilesystem = new NasFilesystem();
                this.colIndex = 1;
                nasFilesystem.nflComputerID = this.getInt(this.resultSet);
                nasFilesystem.nflFsID = this.getInt(this.resultSet);
                nasFilesystem.nflFsName = this.getString(this.resultSet);
                nasFilesystem.nflAgentID = this.getInt(this.resultSet);
                String string = this.getString(this.resultSet);
                nasFilesystem.nflSeenFromWindows = !Util.isEmpty((String)string);
                if (nasFilesystem3 != null) {
                    nasFilesystem3.nflNext = nasFilesystem;
                } else {
                    nasFilesystem2 = nasFilesystem;
                }
                nasFilesystem3 = nasFilesystem;
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNasFilesystems", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        NameList nameList = new TStatComputer(this.dbc).selectComputersAndDomains();
        while (nameList != null) {
            nasFilesystem = nasFilesystem2;
            while (nasFilesystem != null) {
                if (nasFilesystem.nflComputerID == nameList.nlID) {
                    nasFilesystem.nflDomainName = nameList.nlName;
                }
                nasFilesystem = nasFilesystem.nflNext;
            }
            nameList = nameList.nlNext;
        }
        NasFilesystem[] nasFilesystemArray = (NasFilesystem[])Packer.pack(nasFilesystem2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNasFilesystems", (Object)nasFilesystemArray);
        }
        return nasFilesystemArray;
    }

    public void prepSelectScanningCompID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectScanningCompID", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_SCANNING_COMPID);
        this.stmtType = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectScanningCompID");
        }
    }

    public int selectScanningCompID(int n) throws GeneralException, LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectScanningCompID", (String)"filesystemID");
        }
        int n2 = -1;
        boolean bl = false;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                n2 = this.getInt(this.resultSet);
                bl = true;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectScanningCompID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (!bl) {
            Object[] objectArray = new Object[]{"Filesystem", new Integer(n)};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"selectScanningCompID");
            }
            throw new LocalizableException("STS0092E", objectArray);
        }
        int n3 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectScanningCompID", (int)n3);
        }
        return n3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExtensible(String string, String string2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isExtensible", (String)"host, fs");
        }
        boolean bl = false;
        try {
            try {
                this.selectStmt = this.prepareStmt(IS_EXTENSIBLE);
                this.setPhase();
                this.setString(this.selectStmt, string);
                this.setString(this.selectStmt, string2);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (this.nextResult()) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"isExtensible", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResFS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isExtensible", (boolean)bl2);
        }
        return bl2;
    }
}

