/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.TimeZone;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class TServer {
    public String serverName;
    public TComputer computer;
    public int serverID = -1;
    public int serverPort = -1;
    public long serverToken = -1L;
    public int serverType = 0;
    public boolean serverRelocated;
    public boolean initialRegisitration = false;
    private static final String SELECT_SQL_TEXT = "select server_id, server_token, port_number, computer_id from t_res_server where server_name = ? and server_type <> 1";
    private static final String INSERT_SQL_TEXT = "insert into t_res_server (server_id, server_token, server_name, port_number, computer_id, server_type) values (?,?,?,?,?,?)";
    private static final String UPDATE_SQL_TEXT = "update t_res_server set port_number = ?, computer_id = ? where server_id = ?";

    public TServer(String string, int n, String string2, HardwareID hardwareID, String string3) throws GeneralException {
        this(string2);
        String string4;
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TServer", (String)"hostAlias, port, serverName, hwID, guid");
        }
        this.serverPort = n;
        String string5 = null;
        String string6 = null;
        UnknownHostException unknownHostException = null;
        LocalizableException localizableException = null;
        try {
            string6 = HardwareID.getLocalHostName();
            string6 = string6.toLowerCase();
            object = InetAddress.getByName(string6);
            string5 = ((InetAddress)object).getHostAddress();
        }
        catch (UnknownHostException unknownHostException2) {
            unknownHostException = unknownHostException2;
        }
        catch (LocalizableException localizableException2) {
            localizableException = localizableException2;
        }
        if (unknownHostException != null || localizableException != null) {
            object = unknownHostException == null ? localizableException : unknownHostException;
            MessageLog.logException((String)"GEN0042E", (Exception)object);
            MessageLog.logMessage((String)"SRV0051E");
            throw new GeneralException();
        }
        if (string == null) {
            string = string6;
        }
        if (hardwareID == null) {
            hardwareID = new HardwareID(string6);
        }
        if (hardwareID.hardwareID == null) {
            hardwareID.setBogusHardwareID(string);
        }
        if ((string4 = ((TimeZone)(object = TimeZone.getDefault())).getID()).indexOf("Custom") != -1) {
            string4 = ((TimeZone)object).getDisplayName(((TimeZone)object).useDaylightTime(), 0);
        }
        this.computer = new TComputer(string, hardwareID, null, null, string5, string4, null, string3);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TServer");
        }
    }

    protected TServer(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TServer", (String)"serverName");
        }
        this.serverName = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TServer");
        }
    }

    public boolean registerServer() {
        boolean bl;
        Connection connection;
        int n;
        block48: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"registerServer", (String)"");
            }
            n = 16;
            connection = Server.getConnection();
            if (connection == null) {
                boolean bl2 = this.registrationError();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"registerServer", (boolean)bl2);
                }
                return bl2;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)"Got a dbConnection");
            }
            try {
                TServer tServer;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)("Calling getServer with " + this.serverName + "."));
                }
                if ((tServer = TServer.getServer(this.serverName, connection)) == null) {
                    Class<?> clazz;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.aperi.repository.table.TServer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)3, (String)clazz2.getName(), (String)"registerServer", (String)"Did not get an entry for the server from the repository");
                    }
                    if ((n = this.addServer(connection)) != 0) break block48;
                    this.initialRegisitration = true;
                    if (!TraceLogger.enableTrace) break block48;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)"Successfully created a new entry for the server");
                    break block48;
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)("Successfully found a server and computer entry for " + this.serverName));
                }
                this.serverID = tServer.serverID;
                this.serverToken = tServer.serverToken;
                TComputer tComputer = tServer.computer;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)("Name of server computer, as obtained from repository: " + tComputer.tsName));
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)("Name of server computer, as obtained during TServer()initialization - getLocalHostName(): " + this.computer.tsName));
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)("Contents of hwID for server computer obtained from repository - name: " + tComputer.hwID.hostName + ", hardwareID: " + tComputer.hwID.hardwareID.toString()));
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)("Contents of hwID obtained during TServer() initialization - name: " + this.computer.hwID.hostName + ", hardwareID: " + this.computer.hwID.hardwareID.toString()));
                }
                if (this.computer.tsName.compareToIgnoreCase(tComputer.tsName) == 0 || this.computer.hwID.equals((Object)tComputer.hwID) || this.computer.guid.compareToIgnoreCase(tComputer.guid.trim()) == 0) {
                    this.computer.computerID = tComputer.computerID;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)("Server computer's id was set to: " + this.computer.computerID));
                    }
                }
                boolean bl3 = this.serverRelocated = this.serverPort != tServer.serverPort || this.computer.tsName.compareToIgnoreCase(tComputer.tsName) != 0;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"registerServer", (String)("Value of serverRelocated is: " + (this.serverRelocated ? "true" : "false")));
                }
                n = this.updateServer(tServer, connection);
            }
            catch (SQLException sQLException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block48;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"registerServer", (Throwable)sQLException);
            }
        }
        Server.returnConnection(connection);
        boolean bl4 = bl = n == 0 ? true : this.registrationError();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"registerServer", (boolean)bl);
        }
        return bl;
    }

    private boolean registrationError() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"registrationError", (String)"");
        }
        MessageLog.logMessage((String)"SRV0056E", (Object)this.serverName);
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"registrationError", (boolean)bl);
        }
        return bl;
    }

    public static TServer getServer(String string, Connection connection) throws SQLException {
        Object object;
        int n;
        TServer tServer;
        block34: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getServer", (String)"name, dbConnection");
            }
            tServer = null;
            n = -1;
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(SELECT_SQL_TEXT);
                preparedStatement.setString(1, string);
                object = preparedStatement.executeQuery();
                if (object.next()) {
                    tServer = new TServer(string);
                    tServer.serverID = object.getInt(1);
                    tServer.serverToken = object.getLong(2);
                    tServer.serverPort = object.getInt(3);
                    n = object.getInt(4);
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"getServer", (String)("Found an entry for the server: serverName =  " + string + " serverID = " + tServer.serverID + " serverPort = " + tServer.serverPort + " server computer ID = " + n));
                    }
                }
                preparedStatement.close();
                if (tServer != null) break block34;
                TServer tServer2 = null;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getServer", tServer2);
                }
                return tServer2;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getServer", (Throwable)sQLException);
                }
                SQLUtil.errorCleanup(connection, preparedStatement);
                SQLUtil.logSQLException("SRV0052E", sQLException, new Object[]{string});
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getServer");
                }
                throw sQLException;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"getServer", (String)("Calling getComputer with " + n));
        }
        tServer.computer = TComputer.getComputer(null, null, n, null, connection);
        if (tServer.computer == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"getServer", (String)("Did not find a matching entry for computerID = " + n + " in the repository"));
            }
            MessageLog.logMessage((String)"SRV0058E", (Object)new Integer(n));
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getServer");
            }
            throw new SQLException();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"getServer", (String)("Found a matching entry for computerID = " + n));
        }
        object = tServer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getServer", (Object)object);
        }
        return object;
    }

    public int addServer(Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addServer", (String)"dbConnection");
        }
        if (this.computer.addComputer(connection) != 0) {
            int n = 16;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"addServer", (int)n);
            }
            return n;
        }
        PreparedStatement preparedStatement = null;
        try {
            this.serverID = SQLUtil.getIdentifier(1, 1, connection);
            this.serverToken = SQLUtil.getTimestamp(connection).getTime();
            preparedStatement = connection.prepareStatement(INSERT_SQL_TEXT);
            preparedStatement.setInt(1, this.serverID);
            preparedStatement.setLong(2, this.serverToken);
            preparedStatement.setString(3, this.serverName);
            preparedStatement.setInt(4, this.serverPort);
            preparedStatement.setInt(5, this.computer.computerID);
            preparedStatement.setInt(6, this.serverType);
            preparedStatement.executeUpdate();
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"addServer", (Throwable)sQLException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0057E", sQLException, new Object[]{this.serverName, new Integer(this.serverID)});
            int n = 16;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"addServer", (int)n);
            }
            return n;
        }
        int n = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addServer", (int)n);
        }
        return n;
    }

    public int updateServer(TServer tServer, Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateServer", (String)"repoServer, dbConnection");
        }
        if (this.computer.computerID != tServer.computer.computerID) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"updateServer", (String)"Calling addCommputer() to add new entry for server computer");
            }
            if (this.computer.addComputer(connection) != 0) {
                int n = 16;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"updateServer", (int)n);
                }
                return n;
            }
        } else if (!this.computer.equalsRepositoryComputer(tServer.computer) && this.computer.updateComputer(tServer.computer, connection) != 0) {
            int n = 16;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"updateServer", (int)n);
            }
            return n;
        }
        if (this.serverPort == tServer.serverPort && this.computer.computerID == tServer.computer.computerID) {
            int n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"updateServer", (int)n);
            }
            return n;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(UPDATE_SQL_TEXT);
            preparedStatement.setInt(1, this.serverPort);
            preparedStatement.setInt(2, this.computer.computerID);
            preparedStatement.setInt(3, this.serverID);
            preparedStatement.executeUpdate();
            connection.commit();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateServer", (Throwable)sQLException);
            }
            SQLUtil.errorCleanup(connection, preparedStatement);
            SQLUtil.logSQLException("SRV0054E", sQLException, new Object[]{this.serverName, new Integer(this.serverID)});
            int n = 16;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"updateServer", (int)n);
            }
            return n;
        }
        int n = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateServer", (int)n);
        }
        return n;
    }

    public boolean getInitialRegistration() {
        return this.initialRegisitration;
    }
}

