/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.sql.Connection;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleAlerter {
    private Connection dbc;
    private AlertDefinition alertDef;
    private TAlertDefinition alertAccessor;
    private String[] alertParms;
    private StringBuffer buffer = new StringBuffer(65);
    private static final int SCHEDULE_NAME = 0;
    private static final int SCHEDULE_TYPE = 1;
    private static final int SCHEDULE_RUN = 2;
    private static final int ALERT_TYPE = 3;
    private static final int FAILED_JOBS = 4;
    private static final int TOTAL_JOBS = 5;
    private static final int KEY_COUNT = 6;
    private static final int[] SCHEDULE_NAME_OID = new int[]{3, 1, 1};
    private static final int[] SCHEDULE_TYPE_OID = new int[]{3, 1, 2};
    private static final int[] SCHEDULE_RUN_OID = new int[]{3, 1, 3};
    private static final String SCHEDULE_NAME_SLOT = "scheduleName";
    private static final String SCHEDULE_TYPE_SLOT = "scheduleType";
    private static final String SCHEDULE_RUN_SLOT = "scheduleRun";
    public static final int FAILED_JOB_TRAP = 20;
    public static final String FAILED_JOB_EVENT_CLASS = "JobFailure";
    public static final String FAILED_JOB_EVENT_MSG = MessageLog.getMessageNoID((String)"ALR1339W", null);
    public static final String FAILED_JOB_EVENT_MSG_ID = "ALR1339W";
    private static final String alertType = MessageLog.getMessageNoID((String)"ALR1040W");
    private static final int[][] snmpOIDs = new int[6][];
    private static final String[] tecSlotNames = new String[6];

    public ScheduleAlerter(Connection connection) {
        ScheduleAlerter.snmpOIDs[1] = SCHEDULE_TYPE_OID;
        ScheduleAlerter.snmpOIDs[0] = SCHEDULE_NAME_OID;
        ScheduleAlerter.snmpOIDs[2] = SCHEDULE_RUN_OID;
        ScheduleAlerter.snmpOIDs[3] = Alerter.ALERT_TYPE_OID;
        ScheduleAlerter.tecSlotNames[1] = SCHEDULE_TYPE_SLOT;
        ScheduleAlerter.tecSlotNames[0] = SCHEDULE_NAME_SLOT;
        ScheduleAlerter.tecSlotNames[2] = SCHEDULE_RUN_SLOT;
        ScheduleAlerter.tecSlotNames[3] = "alertType";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ScheduleAlerter", (String)"dbc");
        }
        this.dbc = connection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ScheduleAlerter");
        }
    }

    public static String getTECEventMsg(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTECEventMsg", (String)"trapType");
        }
        String string = "";
        switch (n) {
            case 20: {
                string = MessageLog.getMessageNoID((String)FAILED_JOB_EVENT_MSG_ID, null);
            }
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTECEventMsg", (Object)string2);
        }
        return string2;
    }

    public void alert(SchScheduleNode schScheduleNode) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"alert", (String)"schedule");
        }
        if (schScheduleNode.alertID <= 0) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"alert");
            }
            return;
        }
        if (this.alertAccessor == null) {
            this.alertAccessor = new TAlertDefinition(this.dbc);
            this.alertAccessor.prepSelectByID(false, false);
        }
        this.alertDef = this.alertAccessor.getByID(schScheduleNode.alertID);
        if (this.alertDef == null || !this.alertDef.aldEnabled) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"alert");
            }
            return;
        }
        short s = this.alertDef.aldCondition;
        switch (this.alertDef.aldCondition) {
            case 15: {
                this.alertDef.aldCondition = (short)25;
                break;
            }
            case 31: {
                this.alertDef.aldCondition = (short)26;
                break;
            }
            case 55: {
                this.alertDef.aldCondition = (short)54;
            }
        }
        if (s != this.alertDef.aldCondition) {
            this.alertDef.aldScriptComputerID = -1;
        }
        this.alertParms = new String[6];
        this.alertParms[3] = alertType;
        this.buffer.setLength(0);
        this.buffer.append(schScheduleNode.creator);
        this.buffer.append('.');
        this.buffer.append(schScheduleNode.getName());
        this.alertParms[0] = this.buffer.toString();
        this.alertParms[1] = ResourceTypeManager.getJobName((short)schScheduleNode.jobType);
        short s2 = schScheduleNode.jobType;
        this.setNumParm(2, schScheduleNode.runNumber);
        this.setNumParm(4, schScheduleNode.numberRuns - schScheduleNode.successfulRuns);
        this.setNumParm(5, schScheduleNode.numberRuns);
        Alert alert = new Alert(-1, schScheduleNode.SID, s2, this.alertDef, this.alertParms, 20, snmpOIDs, tecSlotNames, -1, -1, schScheduleNode.runNumber, 33, 9, -1);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"alert");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"");
        }
        if (this.alertAccessor != null) {
            try {
                block14: {
                    try {
                        this.alertAccessor.closeSelect();
                    }
                    catch (GeneralException generalException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block14;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)generalException);
                    }
                }
                Object var2_4 = null;
                this.alertAccessor = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.alertAccessor = null;
                throw throwable;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close");
        }
    }

    private void setNumParm(int n, int n2) {
        this.alertParms[n] = Integer.toString(n2);
    }
}

