/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.ScheduleQueryable;
import org.eclipse.aperi.repository.table.TScript;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.scheduler.SchChangeNode;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchIntervalNode;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.scheduler.ScheduleBuild;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.agent.ProbeDefHndlr;
import org.eclipse.aperi.server.svp.SchedulerSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleInterval {
    Calendar calendar;
    Connection connection;
    Date date;
    PrintWriter logWriter;
    TimeZone timezone;
    TimeZone[] timezoneArray;
    String[] zoneNameArray;
    int[] intArray;
    AgentManager agentRoutine;
    TStatComputer tStatRoutine;
    TScript tScriptRoutine;
    ScheduleBuild buildRoutine;
    ScheduleQueue queueRoutine;
    static SchIntervalNode runNumberHdr;
    SchIntervalNode allHead;
    SchIntervalNode allTail;
    SchIntervalNode buildHdr;
    SchIntervalNode runHdr;
    SchIntervalNode disabledHdr;
    SchIntervalNode[] headArray;
    SchIntervalNode[] midArray;
    SchScheduleNode schedule;
    long startupMillis;
    int numberSchedules;
    int numberLists;
    int buildIndex;
    int timezoneIndex;
    int serverYear;
    int serverMonth;
    int serverDay;
    boolean ok;
    Object[] args = new Object[]{"query", "t_schedule", "ScheduleInterval.init"};
    static final short[] monthDays;
    static final short[] DAYS_ARRAY;
    static final int ERA = 0;
    static final int YEAR = 1;
    static final int MONTH = 2;
    static final int DATE = 5;
    static final int HOUR_OF_DAY = 11;
    static final long DMILLIS = 86400000L;
    static final long HMILLIS = 3600000L;
    static final long MMILLIS = 60000L;
    static final long HIGHLONG = 0x7FFFFFFFFFFFL;

    static {
        short[] sArray = new short[48];
        sArray[1] = 31;
        sArray[2] = 60;
        sArray[3] = 91;
        sArray[4] = 121;
        sArray[5] = 152;
        sArray[6] = 182;
        sArray[7] = 213;
        sArray[8] = 244;
        sArray[9] = 274;
        sArray[10] = 305;
        sArray[11] = 335;
        sArray[12] = 366;
        sArray[13] = 397;
        sArray[14] = 425;
        sArray[15] = 456;
        sArray[16] = 486;
        sArray[17] = 517;
        sArray[18] = 547;
        sArray[19] = 578;
        sArray[20] = 609;
        sArray[21] = 639;
        sArray[22] = 670;
        sArray[23] = 700;
        sArray[24] = 731;
        sArray[25] = 762;
        sArray[26] = 790;
        sArray[27] = 821;
        sArray[28] = 851;
        sArray[29] = 882;
        sArray[30] = 912;
        sArray[31] = 943;
        sArray[32] = 974;
        sArray[33] = 1004;
        sArray[34] = 1035;
        sArray[35] = 1065;
        sArray[36] = 1096;
        sArray[37] = 1127;
        sArray[38] = 1155;
        sArray[39] = 1186;
        sArray[40] = 1216;
        sArray[41] = 1247;
        sArray[42] = 1277;
        sArray[43] = 1308;
        sArray[44] = 1339;
        sArray[45] = 1369;
        sArray[46] = 1400;
        sArray[47] = 1430;
        monthDays = sArray;
        DAYS_ARRAY = new short[]{30, 28, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 27, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 27, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 27, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30};
    }

    public void init(ScheduleBuild scheduleBuild) {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"init", (String)"buildTask");
        }
        ResultSet resultSet = null;
        Statement statement = null;
        SchCommon.intervalRoutine = this;
        this.logWriter = MessageLog.getThreadLog();
        this.connection = Server.getConnection();
        if (this.connection == null) {
            MessageLog.logMessage((String)"JSS0006E", (Object[])this.args);
            SchCommon.stopped = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"init");
            }
            return;
        }
        this.startupMillis = SchCommon.startMillis;
        this.agentRoutine = Server.getAgentManager();
        this.buildRoutine = scheduleBuild;
        this.queueRoutine = ScheduleQueue.routine;
        this.tStatRoutine = new TStatComputer(this.connection);
        this.tScriptRoutine = new TScript(this.connection);
        this.intArray = new int[8000];
        this.zoneNameArray = new String[256];
        this.timezoneArray = new TimeZone[256];
        this.calendar = Calendar.getInstance();
        this.date = new Date(this.startupMillis - 86400000L);
        this.calendar.setTime(this.date);
        this.serverYear = this.calendar.get(1) - 2000;
        this.serverMonth = this.calendar.get(2);
        this.serverDay = this.calendar.get(5) - 1;
        this.serverMonth = this.serverYear * 12 + this.serverMonth;
        this.serverDay = this.serverMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(this.serverMonth, 48)] + this.serverDay;
        this.timezoneArray[0] = TimeZone.getDefault();
        this.timezoneIndex = 1;
        int n = this.timezoneArray[0].getRawOffset();
        this.zoneNameArray[0] = n == -18000000 ? "EST" : (n == -21600000 ? "CST" : (n == -25200000 ? "MST" : (n == -28800000 ? "PST" : (n == 0 ? "GMT" : "unknown"))));
        if (!SchCommon.autoRestart) {
            this.queueRoutine.clear();
        }
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery("select job_type_id      ,        schedule_id      ,        creator          ,        name             ,        enabled          ,        schedule_type    ,        start_year       ,        start_month      ,        start_day        ,        start_hour       ,        start_minute     ,        repeat_type      ,        interval_type    ,        interval_number  ,        run_sunday       ,        run_monday       ,        run_tuesday      ,        run_wednesday    ,        run_thursday     ,        run_friday       ,        run_saturday     ,        timezone_type    ,        global_type      ,        timezone         ,        arguments        ,        alert_id         ,        high_run_number  ,        computer_id        from   t_schedule         ");
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"init", (Throwable)sQLException);
            }
            string = SQLUtil.getSQLExceptionMsg("JSS0007E", sQLException, this.args);
            this.logWriter.println(string);
            SchCommon.stopped = true;
        }
        try {
            while (!SchCommon.stopped && resultSet.next()) {
                short s = resultSet.getShort(1);
                SchIntervalNode schIntervalNode = new SchIntervalNode();
                schIntervalNode.SID = resultSet.getInt(2);
                schIntervalNode.creator = resultSet.getString(3);
                schIntervalNode.setName(resultSet.getString(4));
                schIntervalNode.enabled = resultSet.getByte(5) == 1;
                schIntervalNode.scheduleType = resultSet.getByte(6);
                schIntervalNode.startYear = resultSet.getShort(7) - 2000;
                schIntervalNode.startMonth = resultSet.getShort(8) - 1;
                schIntervalNode.startDay = resultSet.getShort(9) - 1;
                schIntervalNode.startHour = resultSet.getShort(10);
                schIntervalNode.startMinute = resultSet.getShort(11);
                schIntervalNode.intervalType = resultSet.getByte(13);
                schIntervalNode.intervalNumber = resultSet.getShort(14);
                if (resultSet.getByte(12) == 2) {
                    schIntervalNode.daysArray = new boolean[7];
                    if (resultSet.getByte(15) == 2) {
                        schIntervalNode.daysArray[1] = true;
                    }
                    if (resultSet.getByte(16) == 2) {
                        schIntervalNode.daysArray[2] = true;
                    }
                    if (resultSet.getByte(17) == 2) {
                        schIntervalNode.daysArray[3] = true;
                    }
                    if (resultSet.getByte(18) == 2) {
                        schIntervalNode.daysArray[4] = true;
                    }
                    if (resultSet.getByte(19) == 2) {
                        schIntervalNode.daysArray[5] = true;
                    }
                    if (resultSet.getByte(20) == 2) {
                        schIntervalNode.daysArray[6] = true;
                    }
                    if (resultSet.getByte(21) == 2) {
                        schIntervalNode.daysArray[0] = true;
                    }
                }
                schIntervalNode.timezoneType = resultSet.getByte(22);
                schIntervalNode.globalType = resultSet.getByte(23);
                schIntervalNode.timezone = resultSet.getString(24);
                schIntervalNode.arguments = resultSet.getString(25);
                schIntervalNode.alertID = resultSet.getInt(26);
                schIntervalNode.jobType = s;
                schIntervalNode.highRunNumber = resultSet.getInt(27);
                schIntervalNode.computerID = resultSet.getInt(28);
                if (schIntervalNode.jobType != 16 && schIntervalNode.jobType != 36 && schIntervalNode.jobType != 67 && schIntervalNode.jobType != 32) {
                    schIntervalNode.timezoneType = (byte)2;
                }
                this.initNode(schIntervalNode);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"init", (Throwable)sQLException);
            }
            string = SQLUtil.getSQLExceptionMsg("JSS0010E", sQLException, this.args);
            this.logWriter.println(string);
            SchCommon.stopped = true;
        }
        if (resultSet != null) {
            block42: {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block42;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"init", (Throwable)sQLException);
                }
            }
            resultSet = null;
        }
        if (statement != null) {
            block43: {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block43;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"init", (Throwable)sQLException);
                }
            }
            statement = null;
        }
        if (!SchCommon.stopped) {
            this.buildLists();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"init");
        }
    }

    public synchronized boolean checkNoPlaceToRun(int n) {
        SchIntervalNode schIntervalNode = this.allHead;
        while (schIntervalNode != null) {
            if (schIntervalNode.SID == n) {
                return schIntervalNode.CIDarray == null || schIntervalNode.CIDarray.length < 1;
            }
            schIntervalNode = schIntervalNode.allNext;
        }
        return false;
    }

    public synchronized SchScheduleNode getNext(long l) {
        int n = 0;
        long l2 = this.headArray[0].nextMillis;
        this.schedule = null;
        if (ScheduleQueue.head != null) {
            this.processChange();
        }
        if (this.schedule == null && !SchCommon.stopped) {
            int n2 = 1;
            while (n2 < this.headArray.length) {
                if (this.headArray[n2].nextMillis < l2) {
                    n = n2;
                    l2 = this.headArray[n2].nextMillis;
                }
                ++n2;
            }
            SchIntervalNode schIntervalNode = this.headArray[n];
            if (this.runHdr != null && this.runHdr.nextMillis <= schIntervalNode.nextMillis) {
                if (this.runHdr.nextMillis <= l) {
                    schIntervalNode = this.runHdr;
                    this.runHdr = schIntervalNode.runNext;
                    schIntervalNode.runNext = null;
                    schIntervalNode.onRunList = false;
                    this.schedule = this.buildRoutine.addSchedule(schIntervalNode);
                }
            } else if (schIntervalNode.nextMillis <= l) {
                this.schedule = this.buildRoutine.addSchedule(schIntervalNode);
                schIntervalNode.lastRunMillis = schIntervalNode.nextMillis;
                if (schIntervalNode.daysArray != null) {
                    ++schIntervalNode.currentDay;
                    while (!schIntervalNode.daysArray[ScheduleInterval.mod(schIntervalNode.currentDay, 7)]) {
                        ++schIntervalNode.currentDay;
                    }
                    this.getNextMillis(schIntervalNode);
                } else if (schIntervalNode.incrementMillis != 0L) {
                    this.getNextFixed(schIntervalNode);
                } else {
                    if (schIntervalNode.incrementMonths == 0) {
                        schIntervalNode.currentDay += schIntervalNode.incrementDays;
                    } else {
                        schIntervalNode.currentMonth += schIntervalNode.incrementMonths;
                        this.setCurrentDay(schIntervalNode);
                    }
                    this.getNextMillis(schIntervalNode);
                }
                if (schIntervalNode.nextMillis > schIntervalNode.next.nextMillis) {
                    this.headArray[n] = schIntervalNode.next;
                    this.headArray[n].prev = null;
                    this.addNode(schIntervalNode, n);
                }
            }
        }
        return this.schedule;
    }

    public synchronized SchIntervalNode getIntervalNode(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getIntervalNode", (String)"SID");
        }
        SchIntervalNode schIntervalNode = this.allHead;
        while (schIntervalNode != null) {
            if (schIntervalNode.SID == n) break;
            schIntervalNode = schIntervalNode.allNext;
        }
        SchIntervalNode schIntervalNode2 = schIntervalNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getIntervalNode", (Object)schIntervalNode2);
        }
        return schIntervalNode2;
    }

    public void changeConnection(Connection connection) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"changeConnection", (String)"connect");
        }
        this.connection = connection;
        this.tStatRoutine = new TStatComputer(this.connection);
        this.tScriptRoutine = new TScript(this.connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"changeConnection");
        }
    }

    private void retryNode(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"retryNode", (String)"interval");
        }
        this.deleteNode(schIntervalNode.SID);
        try {
            this.startupMillis = SQLUtil.getTimestamp(this.connection).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"retryNode", (Throwable)exception);
            }
            return;
        }
        this.initNode(schIntervalNode);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"retryNode");
        }
    }

    private void initNode(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initNode", (String)"interval");
        }
        schIntervalNode.allNext = null;
        if (this.allHead == null) {
            this.allHead = schIntervalNode;
        } else {
            this.allTail.allNext = schIntervalNode;
        }
        this.allTail = schIntervalNode;
        this.getComputers(schIntervalNode);
        if (!schIntervalNode.enabled || schIntervalNode.noComputers) {
            this.addToDisabledList(schIntervalNode);
        } else if (schIntervalNode.scheduleType == 3) {
            schIntervalNode.next = this.buildHdr;
            this.buildHdr = schIntervalNode;
            this.setupRepeatedly(schIntervalNode);
            ++this.numberSchedules;
        } else if (schIntervalNode.scheduleType == 2) {
            this.setupOnce(schIntervalNode);
        } else {
            this.addToDisabledList(schIntervalNode);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initNode");
        }
    }

    private void buildLists() {
        SchIntervalNode schIntervalNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"buildLists", (String)"");
        }
        if (this.numberSchedules == 0) {
            this.buildHdr = new SchIntervalNode();
            this.buildHdr.nextMillis = 0x7FFFFFFFFFFEL;
            this.numberSchedules = 1;
        }
        this.numberLists = ((int)Math.round(Math.sqrt(this.numberSchedules)) + 1) / 2;
        int n = (this.numberSchedules / this.numberLists + 2) / 2;
        this.headArray = new SchIntervalNode[this.numberLists];
        this.midArray = new SchIntervalNode[this.numberLists];
        int n2 = 0;
        while (n2 < this.numberLists) {
            this.headArray[n2] = new SchIntervalNode();
            this.headArray[n2].setName("sentinal");
            this.headArray[n2].nextMillis = 0x7FFFFFFFFFFFL;
            ++n2;
        }
        this.buildIndex = 0;
        while (this.buildHdr != null) {
            SchIntervalNode schIntervalNode2 = this.buildHdr;
            this.buildHdr = schIntervalNode2.next;
            schIntervalNode2.index = this.buildIndex;
            if (schIntervalNode2.nextMillis < this.headArray[this.buildIndex].nextMillis) {
                schIntervalNode2.next = this.headArray[this.buildIndex];
                this.headArray[this.buildIndex].prev = schIntervalNode2;
                this.headArray[this.buildIndex] = schIntervalNode2;
            } else {
                schIntervalNode = this.headArray[this.buildIndex].next;
                while (schIntervalNode2.nextMillis > schIntervalNode.nextMillis) {
                    schIntervalNode = schIntervalNode.next;
                }
                schIntervalNode2.prev = schIntervalNode.prev;
                schIntervalNode2.next = schIntervalNode;
                schIntervalNode.prev.next = schIntervalNode2;
                schIntervalNode.prev = schIntervalNode2;
            }
            ++this.buildIndex;
            if (this.buildIndex < this.numberLists) continue;
            this.buildIndex = 0;
        }
        n2 = 0;
        while (n2 < this.numberLists) {
            schIntervalNode = this.headArray[n2];
            int n3 = 1;
            while (n3 < n) {
                schIntervalNode = schIntervalNode.next;
                ++n3;
            }
            this.midArray[n2] = schIntervalNode;
            ++n2;
        }
        runNumberHdr = this.allHead;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"buildLists");
        }
    }

    private void processChange() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processChange", (String)"");
        }
        SchChangeNode schChangeNode = this.queueRoutine.getNext();
        if (SchedulerSvp.connectBad(this.connection)) {
            this.queueRoutine.setAsFirst(schChangeNode);
            SchCommon.stopped = true;
            SchCommon.bounceNeeded = true;
        } else if (schChangeNode.type == 1) {
            this.deleteNode(schChangeNode.interval.SID);
            this.addChange(schChangeNode);
        } else if (schChangeNode.type == 2) {
            schChangeNode.interval.highRunNumber = this.deleteNode(schChangeNode.interval.SID);
            this.addChange(schChangeNode);
        } else if (schChangeNode.type == 3) {
            SchIntervalNode schIntervalNode = this.allHead;
            while (schIntervalNode != null && schIntervalNode.SID != schChangeNode.SID) {
                schIntervalNode = schIntervalNode.allNext;
            }
            if (schIntervalNode != null) {
                schIntervalNode.setName(schChangeNode.getTrueName());
            }
        } else if (schChangeNode.type == 4) {
            this.deleteNode(schChangeNode.SID);
        } else if (schChangeNode.type == 5) {
            this.runNode(schChangeNode.SID, schChangeNode.computerID, schChangeNode.jobData, schChangeNode.alertLogID);
        } else if (schChangeNode.type == 6) {
            this.rebuild();
        } else {
            SchIntervalNode schIntervalNode = this.getIntervalNode(schChangeNode.SID);
            if (schIntervalNode != null) {
                this.retryNode(schIntervalNode);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processChange");
        }
    }

    private void rebuild() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"rebuild", (String)"");
        }
        long l = 0L;
        try {
            l = SQLUtil.getTimestamp(this.connection).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"rebuild", (Throwable)exception);
            }
            return;
        }
        int n = 0;
        while (n < this.headArray.length) {
            if (this.headArray[n].nextMillis < l) {
                l = this.headArray[n].nextMillis;
            }
            ++n;
        }
        if (this.runHdr != null && this.runHdr.nextMillis < l) {
            l = this.runHdr.nextMillis;
        }
        this.calendar = Calendar.getInstance();
        this.date = new Date(l - 86400000L);
        this.calendar.setTime(this.date);
        this.serverYear = this.calendar.get(1) - 2000;
        this.serverMonth = this.calendar.get(2);
        this.serverDay = this.calendar.get(5) - 1;
        this.serverMonth = this.serverYear * 12 + this.serverMonth;
        this.serverDay = this.serverMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(this.serverMonth, 48)] + this.serverDay;
        SchIntervalNode schIntervalNode = this.allHead;
        runNumberHdr = null;
        this.allHead = null;
        this.allTail = null;
        this.buildHdr = null;
        this.runHdr = null;
        this.disabledHdr = null;
        this.headArray = null;
        this.midArray = null;
        this.numberSchedules = 0;
        this.buildIndex = 0;
        while (schIntervalNode != null) {
            SchIntervalNode schIntervalNode2 = schIntervalNode;
            schIntervalNode = schIntervalNode2.allNext;
            schIntervalNode2.clearDerived();
            this.startupMillis = l <= schIntervalNode2.lastRunMillis ? schIntervalNode2.lastRunMillis + 1L : l;
            this.initNode(schIntervalNode2);
        }
        this.buildLists();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"rebuild");
        }
    }

    private void addChange(SchChangeNode schChangeNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addChange", (String)"change");
        }
        SchIntervalNode schIntervalNode = schChangeNode.interval;
        try {
            this.startupMillis = SQLUtil.getTimestamp(this.connection).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"addChange", (Throwable)exception);
            }
            return;
        }
        boolean bl = schIntervalNode.enabled;
        this.initNode(schIntervalNode);
        if (this.buildHdr != null) {
            schIntervalNode = this.buildHdr;
            this.buildHdr = null;
            this.addNode(schIntervalNode, this.buildIndex);
            ++this.buildIndex;
            if (this.buildIndex >= this.numberLists) {
                this.buildIndex = 0;
            }
        }
        if (schIntervalNode.scheduleType == 1 && bl) {
            this.runNode(schIntervalNode.SID, -1, null, -1);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addChange");
        }
    }

    private int deleteNode(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteNode", (String)"SID");
        }
        int n2 = 1;
        if (this.allHead != null) {
            SchIntervalNode schIntervalNode;
            SchIntervalNode schIntervalNode2 = this.allHead;
            if (this.allHead.SID == n) {
                this.allHead = this.allHead.allNext;
                if (this.allHead == null) {
                    this.allTail = null;
                }
            } else {
                schIntervalNode = null;
                while (schIntervalNode2 != null && schIntervalNode2.SID != n) {
                    schIntervalNode = schIntervalNode2;
                    schIntervalNode2 = schIntervalNode2.allNext;
                }
                if (schIntervalNode2 != null) {
                    schIntervalNode.allNext = schIntervalNode2.allNext;
                    if (schIntervalNode2.allNext == null) {
                        this.allTail = schIntervalNode;
                    }
                }
            }
            if (schIntervalNode2 != null) {
                if (schIntervalNode2.onRunList) {
                    if (schIntervalNode2 == this.runHdr) {
                        this.runHdr = this.runHdr.runNext;
                    } else {
                        schIntervalNode = this.runHdr;
                        while (schIntervalNode.runNext != schIntervalNode2) {
                            schIntervalNode = schIntervalNode.runNext;
                        }
                        schIntervalNode.runNext = schIntervalNode2.runNext;
                    }
                }
                if (schIntervalNode2.onDisabledList) {
                    if (schIntervalNode2.prev == null) {
                        this.disabledHdr = schIntervalNode2.next;
                    } else {
                        schIntervalNode2.prev.next = schIntervalNode2.next;
                    }
                    if (schIntervalNode2.next != null) {
                        schIntervalNode2.next.prev = schIntervalNode2.prev;
                    }
                } else {
                    if (schIntervalNode2.prev == null) {
                        this.headArray[schIntervalNode2.index] = schIntervalNode2.next;
                    } else {
                        schIntervalNode2.prev.next = schIntervalNode2.next;
                    }
                    schIntervalNode2.next.prev = schIntervalNode2.prev;
                    if (this.midArray[schIntervalNode2.index] == schIntervalNode2) {
                        this.midArray[schIntervalNode2.index] = schIntervalNode2.prev == null ? schIntervalNode2.next : schIntervalNode2.prev;
                    }
                }
                n2 = schIntervalNode2.highRunNumber;
                schIntervalNode2.clearDerived();
            }
        }
        int n3 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteNode", (int)n3);
        }
        return n3;
    }

    private void runNode(int n, int n2, Serializable serializable, int n3) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"runNode", (String)"SID, computerID, jobData, alertLogID");
        }
        SchIntervalNode schIntervalNode = this.allHead;
        while (schIntervalNode != null) {
            if (schIntervalNode.SID == n) {
                if (schIntervalNode.fetchFailed) {
                    this.retryNode(schIntervalNode);
                }
                if (schIntervalNode.fetchFailed) break;
                schIntervalNode.alertLogID = n3;
                schIntervalNode.jobData = serializable;
                int[] nArray = schIntervalNode.CIDarray;
                if (n2 > 0) {
                    schIntervalNode.CIDarray = new int[1];
                    schIntervalNode.CIDarray[0] = n2;
                }
                schIntervalNode.runNow = true;
                this.schedule = this.buildRoutine.addSchedule(schIntervalNode);
                schIntervalNode.runNow = false;
                schIntervalNode.CIDarray = nArray;
                schIntervalNode.jobData = null;
                schIntervalNode.alertLogID = -1;
                break;
            }
            schIntervalNode = schIntervalNode.allNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"runNode");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addNode(SchIntervalNode var1_1, int var2_2) {
        block9: {
            block8: {
                if (TraceLogger.enableTrace) {
                    try {
                        v0 = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                    TraceLogger.entry((String)v0.getName(), (String)"addNode", (String)"interval, currentIndex");
                }
                var3_3 = this.midArray[var2_2];
                var1_1.index = var2_2;
                if (var1_1.nextMillis < var3_3.nextMillis) break block8;
                var3_3 = var3_3.next;
                while (var1_1.nextMillis > var3_3.nextMillis) {
                    var3_3 = var3_3.next;
                }
                var1_1.prev = var3_3.prev;
                var1_1.next = var3_3;
                var3_3.prev.next = var1_1;
                var3_3.prev = var1_1;
                this.midArray[var2_2] = this.midArray[var2_2].next;
                break block9;
            }
            var3_3 = this.headArray[var2_2];
            if (var1_1.nextMillis >= var3_3.nextMillis) ** GOTO lbl30
            var1_1.prev = null;
            var1_1.next = var3_3;
            var3_3.prev = var1_1;
            this.headArray[var2_2] = var1_1;
            break block9;
lbl-1000:
            // 1 sources

            {
                var3_3 = var3_3.next;
lbl30:
                // 2 sources

                ** while (var1_1.nextMillis >= var3_3.nextMillis)
            }
lbl31:
            // 1 sources

            var1_1.prev = var3_3.prev;
            var1_1.next = var3_3;
            var3_3.prev.next = var1_1;
            var3_3.prev = var1_1;
        }
        if (TraceLogger.enableTrace) {
            try {
                v2 = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException v3) {
                throw new NoClassDefFoundError(v3.getMessage());
            }
            TraceLogger.exit((String)v2.getName(), (String)"addNode");
        }
    }

    private void setupRepeatedly(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setupRepeatedly", (String)"interval");
        }
        if (schIntervalNode.daysArray != null) {
            schIntervalNode.incrementDays = 1;
            this.setupDay(schIntervalNode);
            if (!schIntervalNode.daysArray[ScheduleInterval.mod(schIntervalNode.currentDay, 7)]) {
                ++schIntervalNode.currentDay;
                while (!schIntervalNode.daysArray[ScheduleInterval.mod(schIntervalNode.currentDay, 7)]) {
                    ++schIntervalNode.currentDay;
                }
                this.getNextMillis(schIntervalNode);
            }
        } else if (schIntervalNode.intervalType == 5) {
            schIntervalNode.incrementMonths = schIntervalNode.intervalNumber;
            this.setupMonth(schIntervalNode);
        } else if (schIntervalNode.intervalType == 4) {
            schIntervalNode.incrementDays = schIntervalNode.intervalNumber * 7;
            this.setupDay(schIntervalNode);
        } else if (schIntervalNode.intervalType == 3) {
            schIntervalNode.incrementDays = schIntervalNode.intervalNumber;
            this.setupDay(schIntervalNode);
        } else if (schIntervalNode.intervalType == 2) {
            schIntervalNode.incrementMillis = (long)schIntervalNode.intervalNumber * 3600000L;
            this.setupFixed(schIntervalNode);
        } else {
            schIntervalNode.incrementMillis = (long)schIntervalNode.intervalNumber * 60000L;
            this.setupFixed(schIntervalNode);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setupRepeatedly");
        }
    }

    private void getComputers(SchIntervalNode schIntervalNode) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputers", (String)"interval");
        }
        if (schIntervalNode.jobType == 16) {
            n = this.getProbe(schIntervalNode);
        } else if (schIntervalNode.jobType == 67) {
            n = this.getScript(schIntervalNode);
            this.getScriptName(schIntervalNode);
        } else if (schIntervalNode.jobType == 36) {
            n = this.getReport(schIntervalNode);
        } else if (schIntervalNode.jobType == 32) {
            n = this.getDiscovery(schIntervalNode);
        } else if (schIntervalNode.jobType == 104) {
            this.intArray[0] = -999999999;
            n = 1;
        } else if (schIntervalNode.jobType == 105) {
            this.intArray[0] = -999999999;
            n = 1;
        } else {
            if (schIntervalNode.jobType == 17) {
                this.getPing(schIntervalNode);
            }
            this.intArray[0] = -1;
            n = 1;
        }
        if (n == 0) {
            schIntervalNode.noComputers = true;
            schIntervalNode.fetchFailed = true;
        } else {
            schIntervalNode.CIDarray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                schIntervalNode.CIDarray[n2] = this.intArray[n2];
                ++n2;
            }
            if (schIntervalNode.timezoneType == 2) {
                schIntervalNode.TZ = schIntervalNode.globalType == 1 ? 0 : this.lookUpZone(schIntervalNode.timezone);
            } else {
                schIntervalNode.CIDTZarray = new int[n];
                int n3 = 0;
                n2 = 0;
                while (n2 < n) {
                    TimeZone timeZone = schIntervalNode.CIDarray[n2] < 0 ? null : this.agentRoutine.getAgentTimezone(schIntervalNode.CIDarray[n2]);
                    if (timeZone == null) {
                        timeZone = this.timezoneArray[0];
                    }
                    int n4 = this.lookUpZone(timeZone.getID());
                    int n5 = 0;
                    while (n5 < n3) {
                        if (this.intArray[n5] == n4) break;
                        ++n5;
                    }
                    if (n5 == n3) {
                        this.intArray[n3] = n4;
                        ++n3;
                    }
                    schIntervalNode.CIDTZarray[n2] = n5;
                    ++n2;
                }
                if (n3 < 2) {
                    schIntervalNode.TZ = this.intArray[0];
                } else {
                    schIntervalNode.TZarray = new int[n3];
                    schIntervalNode.submitMillisArray = new long[n3];
                    n2 = 0;
                    while (n2 < n3) {
                        schIntervalNode.TZarray[n2] = this.intArray[n2];
                        ++n2;
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputers");
        }
    }

    private int getProbe(SchIntervalNode schIntervalNode) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getProbe", (String)"interval");
        }
        try {
            n = ProbeDefHndlr.getProbeComputers(this.connection, schIntervalNode.SID, this.intArray);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getProbe", (Throwable)generalException);
            }
            Object[] objectArray = new Object[]{ResourceTypeManager.getJobName((short)schIntervalNode.jobType), String.valueOf(schIntervalNode.creator) + "." + schIntervalNode.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)generalException), (Object[])objectArray);
            n = 0;
        }
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getProbe", (int)n2);
        }
        return n2;
    }

    private int getScript(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getScript", (String)"interval");
        }
        NameList nameList = null;
        try {
            nameList = this.tStatRoutine.computersTiedTo(schIntervalNode.SID, true);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getScript", (Throwable)generalException);
            }
            Object[] objectArray = new Object[]{ResourceTypeManager.getJobName((short)schIntervalNode.jobType), String.valueOf(schIntervalNode.creator) + "." + schIntervalNode.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)generalException), (Object[])objectArray);
            nameList = null;
        }
        int n = 0;
        while (nameList != null) {
            if (!Constants.isVirtualServer((int)nameList.nlInfo)) {
                this.intArray[n] = nameList.nlID;
                ++n;
            }
            nameList = nameList.nlNext;
        }
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getScript", (int)n2);
        }
        return n2;
    }

    private int getReport(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getReport", (String)"interval");
        }
        this.intArray[0] = schIntervalNode.computerID;
        int n = 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getReport", (int)n);
        }
        return n;
    }

    private int getDiscovery(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDiscovery", (String)"interval");
        }
        NameList nameList = new NameList();
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        boolean s = false;
        boolean bl = true;
        try {
            this.tStatRoutine.initQueryBySchedule(schIntervalNode.SID, schIntervalNode.jobType);
            while (this.tStatRoutine.fetchQueryBySchedule(nameList)) {
                AgentManager.AgentAddress generalException;
                short s2;
                if (nameList.nlID == -1) {
                    this.intArray[n++] = nameList.nlID2;
                    continue;
                }
                if (nameList.nlID != n2) {
                    if (n3 > 0) {
                        this.intArray[n++] = n3;
                    }
                    n2 = nameList.nlID;
                    n4 = 2;
                    s2 = Integer.MAX_VALUE;
                    bl = false;
                }
                if (nameList.nlID2 == n3) continue;
                if (n4 == 1 && nameList.nlState == 1) {
                    this.intArray[n++] = n3;
                }
                if (nameList.nlState == 1) {
                    n3 = nameList.nlID2;
                    n4 = nameList.nlState;
                    bl = false;
                    s2 = 0;
                    continue;
                }
                if (!bl && s2 <= 0 || (generalException = Server.agentMgr.get(nameList.nlID2)) == null || (generalException.state != 1 || !bl) && generalException.consecutiveErrors >= s2) continue;
                n3 = nameList.nlID2;
                n4 = nameList.nlState;
                bl = generalException.state != 1;
                s2 = generalException.consecutiveErrors;
            }
            if (n3 > 0) {
                this.intArray[n] = n3;
                ++n;
            }
        }
        catch (GeneralException n5) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDiscovery", (Throwable)n5);
            }
            Object[] objectArray = new Object[]{ResourceTypeManager.getJobName((short)schIntervalNode.jobType), String.valueOf(schIntervalNode.creator) + "." + schIntervalNode.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)n5), (Object[])objectArray);
            n = 0;
        }
        int n5 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDiscovery", (int)n5);
        }
        return n5;
    }

    private void getPing(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPing", (String)"interval");
        }
        try {
            NameList nameList = this.tStatRoutine.computersTiedTo(schIntervalNode.SID, true);
            schIntervalNode.pingList = null;
            NameList nameList2 = nameList;
            while (nameList2 != null) {
                if (!this.agentRoutine.isNasComputerExpired(nameList2.nlID)) {
                    LinkedInteger linkedInteger = new LinkedInteger(nameList2.nlID);
                    linkedInteger.next = schIntervalNode.pingList;
                    schIntervalNode.pingList = linkedInteger;
                }
                nameList2 = nameList2.nlNext;
            }
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPing", (Throwable)generalException);
            }
            Object[] objectArray = new Object[]{ResourceTypeManager.getJobName((short)schIntervalNode.jobType), String.valueOf(schIntervalNode.creator) + "." + schIntervalNode.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)generalException), (Object[])objectArray);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPing");
        }
    }

    private void getScriptName(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getScriptName", (String)"interval");
        }
        try {
            schIntervalNode.scriptName = this.tScriptRoutine.select(schIntervalNode.SID);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getScriptName", (Throwable)generalException);
            }
            Object[] objectArray = new Object[]{ResourceTypeManager.getJobName((short)schIntervalNode.jobType), String.valueOf(schIntervalNode.creator) + "." + schIntervalNode.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)generalException), (Object[])objectArray);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getScriptName");
        }
    }

    private int lookUpZone(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"lookUpZone", (String)"zoneName");
        }
        int n = 0;
        while (n < this.timezoneIndex) {
            if (string.equals(this.zoneNameArray[n])) break;
            ++n;
        }
        if (n == this.timezoneIndex) {
            this.zoneNameArray[this.timezoneIndex] = string;
            this.timezoneArray[this.timezoneIndex] = TimeZone.getTimeZone(string);
            ++this.timezoneIndex;
        }
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"lookUpZone", (int)n2);
        }
        return n2;
    }

    private void setupMonth(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setupMonth", (String)"interval");
        }
        schIntervalNode.currentMonth = schIntervalNode.startYear * 12 + schIntervalNode.startMonth;
        while (schIntervalNode.currentMonth < this.serverMonth) {
            schIntervalNode.currentMonth += schIntervalNode.incrementMonths;
        }
        this.setCurrentDay(schIntervalNode);
        if (schIntervalNode.currentDay < this.serverDay) {
            schIntervalNode.currentMonth += schIntervalNode.incrementMonths;
            this.setCurrentDay(schIntervalNode);
        }
        this.getNextMillis(schIntervalNode);
        if (schIntervalNode.nextMillis < this.startupMillis) {
            schIntervalNode.currentMonth += schIntervalNode.incrementMonths;
            this.setCurrentDay(schIntervalNode);
            this.getNextMillis(schIntervalNode);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setupMonth");
        }
    }

    private void setCurrentDay(SchIntervalNode schIntervalNode) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setCurrentDay", (String)"interval");
        }
        schIntervalNode.currentDay = schIntervalNode.currentMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(schIntervalNode.currentMonth, 48)] + schIntervalNode.startDay;
        if (schIntervalNode.startDay > 27 && (n = schIntervalNode.startDay - DAYS_ARRAY[ScheduleInterval.mod(schIntervalNode.currentMonth, 48)]) > 0) {
            schIntervalNode.currentDay -= n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setCurrentDay");
        }
    }

    private void setupDay(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setupDay", (String)"interval");
        }
        schIntervalNode.currentMonth = schIntervalNode.startYear * 12 + schIntervalNode.startMonth;
        schIntervalNode.currentDay = schIntervalNode.currentMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(schIntervalNode.currentMonth, 48)] + schIntervalNode.startDay;
        while (schIntervalNode.currentDay < this.serverDay) {
            schIntervalNode.currentDay += schIntervalNode.incrementDays;
        }
        this.getNextMillis(schIntervalNode);
        while (schIntervalNode.nextMillis < this.startupMillis) {
            schIntervalNode.currentDay += schIntervalNode.incrementDays;
            this.getNextMillis(schIntervalNode);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setupDay");
        }
    }

    private void setupFixed(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setupFixed", (String)"interval");
        }
        schIntervalNode.currentMonth = schIntervalNode.startYear * 12 + schIntervalNode.startMonth;
        schIntervalNode.currentDay = schIntervalNode.currentMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(schIntervalNode.currentMonth, 48)] + schIntervalNode.startDay;
        this.getNextMillis(schIntervalNode);
        long l = schIntervalNode.nextMillis;
        while (schIntervalNode.nextMillis < this.startupMillis) {
            schIntervalNode.nextMillis += schIntervalNode.incrementMillis;
        }
        if (schIntervalNode.TZarray == null) {
            schIntervalNode.submitMillis = schIntervalNode.nextMillis;
        } else {
            l = schIntervalNode.nextMillis - l;
            int n = 0;
            while (n < schIntervalNode.TZarray.length) {
                int n2 = n++;
                schIntervalNode.submitMillisArray[n2] = schIntervalNode.submitMillisArray[n2] + l;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setupFixed");
        }
    }

    private void setupOnce(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setupOnce", (String)"interval");
        }
        this.addToDisabledList(schIntervalNode);
        schIntervalNode.currentMonth = schIntervalNode.startYear * 12 + schIntervalNode.startMonth;
        schIntervalNode.currentDay = schIntervalNode.currentMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(schIntervalNode.currentMonth, 48)] + schIntervalNode.startDay;
        this.getNextMillis(schIntervalNode);
        if (schIntervalNode.nextMillis >= this.startupMillis) {
            this.addToRunList(schIntervalNode);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setupOnce");
        }
    }

    private void addToRunList(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addToRunList", (String)"interval");
        }
        schIntervalNode.onRunList = true;
        if (this.runHdr == null || schIntervalNode.nextMillis < this.runHdr.nextMillis) {
            schIntervalNode.runNext = this.runHdr;
            this.runHdr = schIntervalNode;
        } else {
            SchIntervalNode schIntervalNode2 = this.runHdr;
            while (schIntervalNode2.runNext != null && schIntervalNode.nextMillis >= schIntervalNode2.runNext.nextMillis) {
                schIntervalNode2 = schIntervalNode2.runNext;
            }
            schIntervalNode.runNext = schIntervalNode2.runNext;
            schIntervalNode2.runNext = schIntervalNode;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToRunList");
        }
    }

    private void addToDisabledList(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addToDisabledList", (String)"interval");
        }
        schIntervalNode.onDisabledList = true;
        schIntervalNode.prev = null;
        schIntervalNode.next = this.disabledHdr;
        if (this.disabledHdr != null) {
            this.disabledHdr.prev = schIntervalNode;
        }
        this.disabledHdr = schIntervalNode;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToDisabledList");
        }
    }

    private void getNextMillis(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNextMillis", (String)"interval");
        }
        int n = 2000 + schIntervalNode.currentDay / 1461 * 4;
        int n2 = 0;
        int n3 = ScheduleInterval.mod(schIntervalNode.currentDay, 1461);
        if (n3 < 366) {
            if (n3 < 31) {
                ++n3;
            } else if (n3 < 60) {
                n2 = 1;
                n3 -= 30;
            } else if (n3 < 91) {
                n2 = 2;
                n3 -= 59;
            } else if (n3 < 121) {
                n2 = 3;
                n3 -= 90;
            } else if (n3 < 152) {
                n2 = 4;
                n3 -= 120;
            } else if (n3 < 182) {
                n2 = 5;
                n3 -= 151;
            } else if (n3 < 213) {
                n2 = 6;
                n3 -= 181;
            } else if (n3 < 244) {
                n2 = 7;
                n3 -= 212;
            } else if (n3 < 274) {
                n2 = 8;
                n3 -= 243;
            } else if (n3 < 305) {
                n2 = 9;
                n3 -= 273;
            } else if (n3 < 335) {
                n2 = 10;
                n3 -= 304;
            } else {
                n2 = 11;
                n3 -= 334;
            }
        } else {
            if (n3 < 731) {
                ++n;
                n3 -= 366;
            } else if (n3 < 1096) {
                n += 2;
                n3 -= 731;
            } else {
                n += 3;
                n3 -= 1096;
            }
            if (n3 < 31) {
                ++n3;
            } else if (n3 < 59) {
                n2 = 1;
                n3 -= 30;
            } else if (n3 < 90) {
                n2 = 2;
                n3 -= 58;
            } else if (n3 < 120) {
                n2 = 3;
                n3 -= 89;
            } else if (n3 < 151) {
                n2 = 4;
                n3 -= 119;
            } else if (n3 < 181) {
                n2 = 5;
                n3 -= 150;
            } else if (n3 < 212) {
                n2 = 6;
                n3 -= 180;
            } else if (n3 < 243) {
                n2 = 7;
                n3 -= 211;
            } else if (n3 < 273) {
                n2 = 8;
                n3 -= 242;
            } else if (n3 < 304) {
                n2 = 9;
                n3 -= 272;
            } else if (n3 < 334) {
                n2 = 10;
                n3 -= 303;
            } else {
                n2 = 11;
                n3 -= 333;
            }
        }
        if (schIntervalNode.TZarray == null) {
            this.calendar.setTimeZone(this.timezoneArray[schIntervalNode.TZ]);
            this.calendar.set(n, n2, n3, schIntervalNode.startHour, schIntervalNode.startMinute, 0);
            schIntervalNode.nextMillis = schIntervalNode.submitMillis = this.getMillis();
        } else {
            this.calendar.set(n, n2, n3, schIntervalNode.startHour, schIntervalNode.startMinute, 0);
            schIntervalNode.nextMillis = 0x7FFFFFFFFFFFL;
            int n4 = 0;
            while (n4 < schIntervalNode.TZarray.length) {
                this.calendar.setTimeZone(this.timezoneArray[schIntervalNode.TZarray[n4]]);
                this.calendar.set(1, n);
                schIntervalNode.submitMillisArray[n4] = this.getMillis();
                if (schIntervalNode.submitMillisArray[n4] < schIntervalNode.nextMillis) {
                    schIntervalNode.nextMillis = schIntervalNode.submitMillisArray[n4];
                }
                ++n4;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNextMillis");
        }
    }

    private long getMillis() {
        long l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMillis", (String)"");
        }
        this.date = this.calendar.getTime();
        long l2 = this.date.getTime();
        if (l2 - (l = l2 / 60000L * 60000L) > 30000L) {
            l += 60000L;
        }
        long l3 = l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMillis", (long)l3);
        }
        return l3;
    }

    private void getNextFixed(SchIntervalNode schIntervalNode) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNextFixed", (String)"interval");
        }
        schIntervalNode.nextMillis += schIntervalNode.incrementMillis;
        if (schIntervalNode.TZarray == null) {
            schIntervalNode.submitMillis += schIntervalNode.incrementMillis;
        } else {
            int n = 0;
            while (n < schIntervalNode.TZarray.length) {
                int n2 = n++;
                schIntervalNode.submitMillisArray[n2] = schIntervalNode.submitMillisArray[n2] + schIntervalNode.incrementMillis;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNextFixed");
        }
    }

    private static int mod(int n, int n2) {
        int n3 = n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        return n3;
    }

    private class ComputerFetcher {
        Class accessorClass;
        ScheduleQueryable accessor;
        boolean loadFailed;

        ComputerFetcher(Class clazz) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval$ComputerFetcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)"ComputerFetcher", (String)"className");
            }
            this.accessorClass = clazz;
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval$ComputerFetcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"ComputerFetcher");
            }
        }

        ScheduleQueryable getAccessor() {
            Class[] classArray;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval$ComputerFetcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getAccessor", (String)"");
            }
            if (this.accessor == null && !this.loadFailed) {
                try {
                    Class<?> clazz;
                    Class[] classArray2 = new Class[1];
                    try {
                        clazz = Class.forName("java.sql.Connection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    classArray2[0] = clazz;
                    classArray = classArray2;
                    Constructor constructor = this.accessorClass.getConstructor(classArray);
                    Object[] objectArray = new Object[]{ScheduleInterval.this.connection};
                    this.accessor = (ScheduleQueryable)constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval$ComputerFetcher");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"getAccessor", (Throwable)exception);
                    }
                    this.loadFailed = true;
                    MessageLog.logException((String)"JSS0071E", (Exception)exception, (Object)this.accessorClass);
                    exception.printStackTrace();
                }
            }
            classArray = this.accessor;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.scheduler.ScheduleInterval$ComputerFetcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getAccessor", (Object)classArray);
            }
            return classArray;
        }
    }
}

