/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.eclipse.aperi.backend.SaferServerSocket;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.ClientSocket;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.xmsg.MessageLog;

class Listener
extends Thread {
    ServiceQueue queue;
    PrintWriter logWriter = MessageLog.getThreadLog();

    protected Listener(ThreadGroup threadGroup) {
        super(threadGroup, "Listener");
        this.queue = Server.routerQueue;
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        block14: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Listener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
            }
            SaferServerSocket saferServerSocket = null;
            MessageLog.setThreadLog((PrintWriter)this.logWriter);
            try {
                saferServerSocket = new SaferServerSocket(Server.getListenerPort());
                Server.listenerSocket = saferServerSocket;
                MessageLog.logMessage((String)"SRV0029I");
                while (Server.terminate == 0) {
                    Socket socket = saferServerSocket.accept();
                    ClientSocket clientSocket = ClientSocket.getClientSocket(socket);
                    Server.bumpConnectionCount(1);
                    this.queue.add(clientSocket, false);
                }
            }
            catch (IOException iOException) {
                Class<?> clazz;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.server.Listener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz2.getName(), (String)"run", (Throwable)iOException);
                }
                if (Server.terminate != 0) break block14;
                String string = saferServerSocket == null ? "SRV0027E" : "SRV0028E";
                MessageLog.logException((String)string, (Exception)iOException, (Object)new Integer(Server.getListenerPort()));
                if (!TraceLogger.enableTrace) break block14;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Listener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"run");
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.Listener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }
}

