/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alerts;

import java.sql.Connection;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.MissingAlertAccessible;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.alerts.StormAlerter;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiscoveryAlerter
extends StormAlerter {
    private static final int[][] varBindOIDs;
    private static final String[] tecSlotNames;
    private short alertType;
    private MissingAlertAccessible accessor;
    private short ownerType;
    private int ownerID;
    private String ownerName;
    private String ownerTypeName;

    static {
        int[][] nArrayArray = new int[5][];
        nArrayArray[1] = FILER_NAME_OID;
        nArrayArray[2] = RESOURCE_TYPE_OID;
        nArrayArray[3] = RESOURCE_NAME_OID;
        nArrayArray[4] = Alerter.ALERT_TYPE_OID;
        varBindOIDs = nArrayArray;
        String[] stringArray = new String[5];
        stringArray[1] = "filerName";
        stringArray[2] = "resourceType";
        stringArray[3] = "resourceName";
        stringArray[4] = "alertType";
        tecSlotNames = stringArray;
    }

    public DiscoveryAlerter(Connection connection, MissingAlertAccessible missingAlertAccessible, short s, short s2, int n, String string) {
        super(connection, -1);
        this.alertType = s;
        this.accessor = missingAlertAccessible;
        this.ownerType = s2;
        this.ownerID = n;
        this.ownerName = string;
        this.ownerTypeName = ResourceTypeManager.getName((short)this.ownerType);
    }

    private void processMissingFilerAlert(Share share) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.DiscoveryAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processMissingFilerAlert", (String)"share");
        }
        String[] stringArray = new String[varBindOIDs.length];
        stringArray[0] = ResourceTypeManager.getName((short)share.shResourceType);
        stringArray[1] = share.shPath;
        stringArray[2] = this.ownerTypeName;
        stringArray[3] = this.ownerName;
        stringArray[4] = MessageLog.getMessageNoID((String)this.alertDef.getEmailSubjectID());
        Alert alert = new Alert(share.shResourceID, share.shResourceID, share.shResourceType, this.alertDef, stringArray, 21, varBindOIDs, tecSlotNames, -1, -1, this.ownerID, this.ownerType, 0, -1);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.DiscoveryAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processMissingFilerAlert");
        }
    }

    private void processDiskArrayAlert(Share share) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.DiscoveryAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processDiskArrayAlert", (String)"share");
        }
        this.initParms();
        this.alertParms[0] = this.ownerName;
        this.alertParms[1] = share.shPath;
        this.alertParms[11] = ResourceTypeManager.getName((short)share.shResourceType);
        this.alertParms[10] = MessageLog.getMessageNoID((String)this.alertDef.getEmailSubjectID());
        Alert alert = new Alert(this.ownerID, share.shResourceID, share.shResourceType, this.alertDef, this.alertParms, 22, this.snmpOIDs, DiscoveryAlerter.getTecSlotNames(), -1, -1, -1, -1, 1, -1);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.DiscoveryAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processDiskArrayAlert");
        }
    }

    protected void processAlert(HasID hasID) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.DiscoveryAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processAlert", (String)"resource");
        }
        Share share = (Share)hasID;
        if (this.alertDef.aldCondition == 66) {
            this.processMissingFilerAlert(share);
        } else {
            this.processDiskArrayAlert(share);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.DiscoveryAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processAlert");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alert(Share share) throws GeneralException {
        Share share2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.DiscoveryAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"alert", (String)"resources");
        }
        TreeMap<Integer, Share> treeMap = new TreeMap<Integer, Share>();
        while (share != null) {
            treeMap.put(new Integer(-share.shResourceID), share);
            share = share.shNext;
        }
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            share2 = (Share)iterator.next();
            share2.shNext = share;
            share = share2;
        }
        treeMap = null;
        this.initAlertAccessor();
        try {
            this.accessor.initQueryByAttrType(this.alertType, (HasID)share);
            this.processOncePrepared(this.accessor, (HasID)share);
            share2 = null;
        }
        catch (Throwable throwable) {
            share2 = null;
            this.close();
            throw throwable;
        }
        this.close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.DiscoveryAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"alert");
        }
    }
}

