/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.agent;

import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.table.TBatchReport;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ScriptSubmitter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.server.handler.PartitionedDataProvider;
import org.eclipse.aperi.server.handler.StormReportHndlr;

public class BatchReportHndlr
implements RequestHandler,
StormReportHndlr,
ThrowAway {
    Request request;
    Response response;
    Transceiver transceiver;
    BatchReport batchReport;

    public Response handle(Request request, Transceiver transceiver) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.request = request;
        this.transceiver = transceiver;
        this.response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.common.MutableLong");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (RequestChecker.isDesiredType(clazz, (Request)request, (Response)this.response)) {
            long l = ((MutableLong)request.requestData).value;
            int n = (int)l;
            l >>= 32;
            Connection connection = Server.getConnection();
            if (connection == null) {
                Server.setResponseError(this.response, "GEN0050E");
            } else {
                TBatchReport tBatchReport = new TBatchReport(connection);
                try {
                    this.batchReport = tBatchReport.selectByID(n);
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz3.getName(), (String)"handle", (Throwable)generalException);
                    }
                    Server.setResponseError(this.response, (Exception)((Object)generalException));
                }
                if (this.batchReport != null) {
                    if (this.batchReport.scriptName != null) {
                        this.maybeLoadScript(l != 0L);
                    }
                    this.response.responseData = this.batchReport;
                    GuiReportReq guiReportReq = this.batchReport.grr;
                    guiReportReq.isBatchReport = true;
                    int n2 = this.batchReport.grr.grrID1;
                    byte by = this.batchReport.grr.histType;
                    byte by2 = this.batchReport.grr.histSubtype;
                    this.batchReport.grr.grrID1 = 0;
                    this.batchReport.grr.histType = 0;
                    this.batchReport.grr.histSubtype = 0;
                    GuiDataProvider guiDataProvider = null;
                    PartitionedDataProvider partitionedDataProvider = null;
                    boolean bl = false;
                    String string = GuiReportReq.guiClasses[guiReportReq.reportType][1];
                    try {
                        Class<?> clazz4;
                        Class<?> clazz5;
                        Class<?> clazz6 = Class.forName(string);
                        Class[] classArray = new Class[1];
                        try {
                            clazz5 = Class.forName("java.sql.Connection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        classArray[0] = clazz5;
                        Class[] classArray2 = classArray;
                        Constructor<?> constructor = clazz6.getConstructor(classArray2);
                        Object[] objectArray = new Object[]{connection};
                        try {
                            clazz4 = Class.forName("org.eclipse.aperi.server.handler.PartitionedDataProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (clazz4.isAssignableFrom(clazz6)) {
                            bl = true;
                            partitionedDataProvider = (PartitionedDataProvider)constructor.newInstance(objectArray);
                        } else {
                            bl = true;
                            guiDataProvider = (GuiDataProvider)constructor.newInstance(objectArray);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz7;
                            try {
                                clazz7 = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz7.getName(), (String)"handle", (Throwable)arrayIndexOutOfBoundsException);
                        }
                        Object[] objectArray = new Object[]{new Integer(guiReportReq.reportType), new Integer(guiReportReq.reportSubtype)};
                        Server.setResponseError(this.response, "GEN0125E", objectArray);
                    }
                    catch (Exception exception) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz8;
                            try {
                                clazz8 = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz8.getName(), (String)"handle", (Throwable)exception);
                        }
                        System.err.println(exception);
                        exception.printStackTrace();
                        Server.setResponseError(this.response, exception);
                    }
                    if (bl) {
                        try {
                            if (guiDataProvider != null) {
                                this.batchReport.data = guiDataProvider.getReportData(guiReportReq);
                            } else {
                                partitionedDataProvider.getReportData(guiReportReq, this);
                            }
                        }
                        catch (GeneralException generalException) {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz9;
                                try {
                                    clazz9 = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz9.getName(), (String)"handle", (Throwable)generalException);
                            }
                            Server.setResponseError(this.response, (Exception)((Object)generalException));
                        }
                    }
                    this.batchReport.grr.grrID1 = n2;
                    this.batchReport.grr.histType = by;
                    this.batchReport.grr.histSubtype = by2;
                }
                Server.returnConnection(connection);
            }
        }
        Response response = this.response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz10;
            try {
                clazz10 = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz10.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    public static Object packComps(Computer computer) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packComps", (String)"computer");
        }
        Computer[] computerArray = null;
        int n = 0;
        Computer computer2 = computer;
        while (computer2 != null) {
            ++n;
            computer2 = computer2.cmpNext;
        }
        computerArray = new Computer[n];
        int n2 = 0;
        while (n2 < n) {
            computer2 = computer.cmpNext;
            computer.cmpNext = null;
            computerArray[n2] = computer;
            computer = computer2;
            ++n2;
        }
        Computer[] computerArray2 = computerArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packComps", (Object)computerArray2);
        }
        return computerArray2;
    }

    private void maybeLoadScript(boolean bl) {
        WindowsScript windowsScript;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"maybeLoadScript", (String)"isWindows");
        }
        String string = null;
        StringBuffer stringBuffer = new StringBuffer(120);
        if (bl) {
            windowsScript = JobUtil.resolveWindowsScript((String)this.batchReport.scriptName, (StringBuffer)stringBuffer);
            if (windowsScript != null) {
                if (stringBuffer.length() > 0) {
                    this.batchReport.scriptExtension = stringBuffer.toString();
                }
                stringBuffer.setLength(0);
                stringBuffer.append(JobUtil.scriptsDir);
                stringBuffer.append(File.separatorChar);
                stringBuffer.append(windowsScript.wsResolvedName);
                string = stringBuffer.toString();
            }
        } else {
            stringBuffer.append(JobUtil.scriptsDir);
            stringBuffer.append(File.separatorChar);
            if (JobUtil.resolveUnixScript((String)this.batchReport.scriptName, (StringBuffer)stringBuffer) != null) {
                string = stringBuffer.toString();
            }
        }
        if (string != null) {
            windowsScript = new MutableBoolean(true);
            byte[] byArray = ScriptSubmitter.loadFile(string, (MutableBoolean)windowsScript);
            if (windowsScript.value) {
                this.batchReport.scriptBody = byArray;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"maybeLoadScript");
        }
    }

    public void transmitReportData(PartitionedReport partitionedReport) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"transmitReportData", (String)"partition");
        }
        this.batchReport.data = partitionedReport;
        this.transceiver.transmitResponse(this.request, this.response);
        this.response.returnResponse();
        this.response = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.agent.BatchReportHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"transmitReportData");
        }
    }
}

