/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.server.guireq.GuiSelectionReq;
import org.eclipse.aperi.TStorm.server.guireq.RespSelectionObject;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiSelectionHndlr
implements RequestHandler,
ThrowAway {
    static final String directorySelect = "select d.directory_id,        f.computer_id,         d.name          from   t_stat_directory d,        t_res_filesystem f  where  d.filesystem_id = f.filesystem_id";
    static final String filesystemSelect = "select f.computer_id,          f.filesystem_id,        f.mount_point,          f.capacity,             f.free_space     from   t_res_filesystem f ";
    static final String computerSelect = "select os_type, computer_id, manufacturer, cpu_architecture from t_stat_computer";
    static final String groupSelect = "select group_id, creator, name, description, group_type from t_group where group_type = ? ";
    static final String domainSelect = "select domain_id,        name       from   t_res_domain";
    static final String quotaSelect = "select q.quota_id,           q.creator,            q.name,               q.quota_type,         q.description,        s.creator,            s.name         from   t_quota_definition q,        t_stat_definition  s  where  q.statistic_id = s.statistic_id";
    static final String diskSelect = "select d.device_id,          s.computer_id,        d.path         from   t_res_dev_access d,        t_stat_disk      z,        t_res_share      s,        t_res_controller c  where  s.resource_type = 10 and   s.resource_id   = d.device_id     and   s.resource_id   = z.disk_id       and   s.computer_id   = c.computer_id   and   d.controller_id = c.controller_id and   z.logical_disk_id < 0 union select pv.physical_volume_id, ss.subsystem_id, pv.name from t_res_physical_volume pv, t_res_storage_subsystem ss where pv.subsystem_id = ss.subsystem_id  union select se.storage_extent_id, ss.subsystem_id,  se.element_name from t_res_storage_extent se, t_res_storage_subsystem ss where se.subsystem_id = ss.subsystem_id and ss.os_type = 21";
    static final String diskArraySelect = "select subsystem_id,  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name  from   t_res_storage_subsystem";
    static final String diskArrayDiskSelect = "select pv.physical_volume_id,       case when ss.user_provided_name is not null  and ss.user_provided_name <> ''  then ss.user_provided_name else ss.display_name end display_name,        pv.device_id from   t_res_physical_volume pv,        t_res_storage_subsystem ss  where  pv.subsystem_id  = ss.subsystem_id UNION select se.storage_extent_id,       case when ss.user_provided_name is not null  and ss.user_provided_name <> ''  then ss.user_provided_name else ss.display_name end display_name,        se.element_name from   t_res_storage_extent se,        t_res_storage_subsystem ss  where  se.subsystem_id   = ss.subsystem_id and ss.os_type = 21";
    static final String lunSelect = "select sv.svid, case when ss.user_provided_name is not null  and ss.user_provided_name <> ''  then ss.user_provided_name else ss.display_name end display_name,  sv.element_name, sv.display_name from t_res_storage_volume sv, t_res_storage_subsystem ss  where sv.subsystem_id = ss.subsystem_id";
    static final String instanceSelect = "select rdbms_id,      computer_id,   rdbms_name,    rdbms_type,    rdbms_version from   t_res_rdbms";
    static final String databaseSelect = "select d.database_id, r.computer_id, r.rdbms_name,  d.name,        r.rdbms_type,  u.full_name,   d.total_size,  d.freespace   from   t_res_database  d,        t_res_rdbms     r,        t_res_comp_user u  where  d.rdbms_id = r.rdbms_id  and   d.owner_id = u.user_id";
    static final String tablespaceSelect = "select t.tablespace_id, r.computer_id,   r.rdbms_name,    d.name,          t.name,          r.rdbms_type,    u.full_name,     t.total_size,    t.freespace     from   t_res_tablespace t,        t_res_database   d,        t_res_rdbms      r,        t_res_comp_user  u  where  t.database_id = d.database_id  and   d.rdbms_id    = r.rdbms_id     and   d.owner_id    = u.user_id";
    static final String datafileSelect = "select f.file_id,     r.computer_id, r.rdbms_name,  d.name,        t.name,        f.name,        r.rdbms_type,  t.total_size,  t.freespace   from   t_res_datafile   f,        t_res_tablespace t,        t_res_database   d,        t_res_rdbms      r  where  f.tablespace_id = t.tablespace_id  and   t.database_id   = d.database_id    and   d.rdbms_id      = r.rdbms_id";
    static final String tableSelect = "select t.statistic_id, r.computer_id,  r.rdbms_name,   d.name,         u.full_name,    t.name,         s.name,         t.total_size,   t.unused_space, t.partitions,   t.indexes      from   t_stat_table     t,        t_res_tablespace s,        t_res_database   d,        t_res_rdbms      r,        t_res_comp_user  u  where  t.statistic_type = '1'              and   t.tablespace_id  = s.tablespace_id  and   s.database_id    = d.database_id    and   d.rdbms_id       = r.rdbms_id       and   t.creator_id     = u.user_id";
    static final String deviceSelect = "select d.device_id,   r.computer_id, r.rdbms_name,  d.name,        r.rdbms_type,  d.capacity,    d.freespace   from   t_res_dbdevice   d,        t_res_rdbms      r  where  d.rdbms_id       = r.rdbms_id";
    static final String dbmsTypeSelect = "select distinct r.rdbms_type   from   t_res_rdbms r";
    private static final String GOOD_LDTYPES = " and l.logical_disk_type not in ('7', '4')";
    private static final String noFSLogicalDiskSelect = "select l.logical_disk_id, r.host_name, s.path from t_res_logical_disk l, t_res_host r, t_res_share s, t_stat_computer c where s.resource_type = 11 and s.resource_id = l.logical_disk_id and s.computer_id = c.computer_id and r.computer_id = s.computer_id and r.computer_id = c.computer_id and l.logical_disk_type not in ('7', '4') and l.logical_disk_id not in (select logical_disk_id from t_res_filesystem) order by 1";
    private static final String fsLogicalDiskSelect = "select f.logical_disk_id, r.host_name, f.mount_point from t_res_filesystem f, t_res_host r, t_res_logical_disk l where r.computer_id = f.computer_id and l.logical_disk_id = f.logical_disk_id and l.logical_disk_type not in ('7', '4')";
    private static final String virtualVolumeSelect = "SELECT VDISKS.SVID AS VDISK_ID, CASE WHEN SUBSYSTEMS.USER_PROVIDED_NAME IS NOT NULL AND  SUBSYSTEMS.USER_PROVIDED_NAME <> '' THEN SUBSYSTEMS.USER_PROVIDED_NAME ELSE SUBSYSTEMS.DISPLAY_NAME END  SUBSYSTEM_NAME, VDISKS.DISPLAY_NAME as VDISK_NAME  FROM  TPC.T_RES_STORAGE_VOLUME AS VDISKS  INNER JOIN  TPC.T_RES_STORAGE_SUBSYSTEM AS SUBSYSTEMS ON VDISKS.SUBSYSTEM_ID=SUBSYSTEMS.SUBSYSTEM_ID WHERE SUBSYSTEMS.TYPE='SVC'";
    static final String COMPUTER = MessageLog.getMessageNoID((String)"STS0054I");
    static final String FILESYSTEM = MessageLog.getMessageNoID((String)"STS0067I");
    static final String NETWORK_WIDE = MessageLog.getMessageNoID((String)"STS0141L");
    private Connection connection;
    private ResultSet results;
    private Statement statement;
    private PreparedStatement pStatement;
    private RespSelectionObject head;
    private int count;

    public Response handle(Request request, Transceiver transceiver) {
        GuiSelectionReq guiSelectionReq;
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.connection = null;
        this.statement = null;
        this.results = null;
        this.head = null;
        this.count = 0;
        String string = null;
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiSelectionReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            guiSelectionReq = (GuiSelectionReq)request.requestData;
            response.responseData = guiSelectionReq;
            this.connection = Server.getConnection();
            if (this.connection == null) {
                Object[] objectArray = new Object[]{"GuiSelectionHndlr.handle"};
                string = MessageLog.getMessageNoID((String)"SRV0102E", (Object[])objectArray);
            } else {
                guiSelectionReq.computerColumn = 0;
                guiSelectionReq.appendUserComputerColumn = 0;
                if (guiSelectionReq.objectType == 3) {
                    string = this.getFilesystems(guiSelectionReq);
                } else if (guiSelectionReq.objectType == 4) {
                    string = this.getGroups(guiSelectionReq, (short)2);
                } else if (guiSelectionReq.objectType == 5 || guiSelectionReq.objectType == 21 || guiSelectionReq.objectType == 29) {
                    string = this.getComputers(guiSelectionReq);
                } else if (guiSelectionReq.objectType == 6) {
                    string = this.getGroups(guiSelectionReq, (short)0);
                } else if (guiSelectionReq.objectType == 28) {
                    string = this.getGroups(guiSelectionReq, (short)99);
                } else if (guiSelectionReq.objectType == 7) {
                    string = this.getDomains(guiSelectionReq);
                } else if (guiSelectionReq.objectType == 11) {
                    string = this.getDisks(guiSelectionReq);
                } else if (guiSelectionReq.objectType == 24) {
                    string = this.getDiskArrays(guiSelectionReq);
                } else if (guiSelectionReq.objectType == 26) {
                    string = this.getDiskArrayDisks(guiSelectionReq);
                } else if (guiSelectionReq.objectType == 25) {
                    string = this.getLuns(guiSelectionReq);
                } else if (guiSelectionReq.objectType == 27) {
                    string = this.getLogicalVolumes(guiSelectionReq);
                } else if (guiSelectionReq.objectType == 31) {
                    string = this.getVirtualVolumes(guiSelectionReq);
                }
                this.packItUp(guiSelectionReq);
            }
        }
        if (this.results != null) {
            block46: {
                try {
                    this.results.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz3;
                    if (!TraceLogger.enableTrace) break block46;
                    try {
                        clazz3 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz3.getName(), (String)"handle", (Throwable)sQLException);
                }
            }
            this.results = null;
        }
        if (this.statement != null) {
            block47: {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz4;
                    if (!TraceLogger.enableTrace) break block47;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz4.getName(), (String)"handle", (Throwable)sQLException);
                }
            }
            this.statement = null;
        }
        if (this.connection != null) {
            Server.returnConnection(this.connection);
            this.connection = null;
        }
        if (string != null) {
            response.status = (short)12;
            response.responseData = null;
            response.errorMessage = string;
        }
        guiSelectionReq = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz5.getName(), (String)"handle", (Object)guiSelectionReq);
        }
        return guiSelectionReq;
    }

    private void packItUp(GuiSelectionReq guiSelectionReq) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packItUp", (String)"gsr");
        }
        RespSelectionObject[] respSelectionObjectArray = new RespSelectionObject[this.count];
        this.count = 0;
        while (this.head != null) {
            RespSelectionObject respSelectionObject = this.head.next;
            this.head.next = null;
            respSelectionObjectArray[this.count] = this.head;
            ++this.count;
            this.head = respSelectionObject;
        }
        guiSelectionReq.objectHdr = respSelectionObjectArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packItUp");
        }
    }

    private String getFilesystems(GuiSelectionReq guiSelectionReq) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFilesystems", (String)"gsr");
        }
        String string = "SRV0103E";
        String string2 = filesystemSelect;
        guiSelectionReq.numberColumns = 5;
        guiSelectionReq.nameArray = RespSelectionObject.FILESYSTEM_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.FILESYSTEM_TYPES;
        guiSelectionReq.computerColumn = 1;
        guiSelectionReq.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(string2);
            string = "SRV0104E";
            while (this.results.next()) {
                int n = this.results.getInt(1);
                RespSelectionObject respSelectionObject = new RespSelectionObject();
                respSelectionObject.stringArray = new String[guiSelectionReq.numberColumns];
                respSelectionObject.longArray = new long[guiSelectionReq.numberColumns];
                respSelectionObject.CID = n;
                respSelectionObject.ID = this.results.getInt(2);
                respSelectionObject.stringArray[2] = this.results.getString(3);
                respSelectionObject.longArray[3] = this.results.getLong(4) * 512L;
                respSelectionObject.longArray[4] = this.results.getLong(5) * 512L;
                respSelectionObject.next = this.head;
                this.head = respSelectionObject;
                ++this.count;
            }
            string = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getFilesystems", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_res_filesystem", "GuiSelectionHndlr.getFilesystems"};
            string = SQLUtil.getSQLExceptionMsg(string, sQLException, objectArray);
        }
        String string3 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFilesystems", (Object)string3);
        }
        return string3;
    }

    private String getComputers(GuiSelectionReq guiSelectionReq) {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputers", (String)"gsr");
        }
        String string2 = "SRV0103E";
        String string3 = computerSelect;
        guiSelectionReq.numberColumns = 5;
        guiSelectionReq.nameArray = RespSelectionObject.COMPUTER_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.COMPUTER_TYPES;
        guiSelectionReq.computerColumn = 1;
        guiSelectionReq.sortColumns = 1;
        boolean bl = guiSelectionReq.productCode == 1 && guiSelectionReq.objectType != 21;
        boolean bl2 = true;
        if (guiSelectionReq.objectType == 29) {
            bl2 = false;
            bl = false;
        }
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(string3);
            string2 = "SRV0104E";
            while (this.results.next()) {
                short s = this.results.getShort(1);
                if (!bl && Constants.isNasBox((short)s) || !bl2 && Constants.isVirtualServer((int)s)) continue;
                int n = this.results.getInt(2);
                string = new RespSelectionObject();
                ((RespSelectionObject)string).next = this.head;
                this.head = string;
                ((RespSelectionObject)string).stringArray = new String[guiSelectionReq.numberColumns];
                ((RespSelectionObject)string).ID = n;
                ((RespSelectionObject)string).CID = n;
                String string4 = this.results.getString(3);
                ((RespSelectionObject)string).stringArray[2] = string4.trim().equalsIgnoreCase("unknown") ? MessageLog.getMessageNoID((String)"STG1020L") : string4;
                ((RespSelectionObject)string).stringArray[3] = MessageLog.getMessageNoID((String)Constants.OSTYPES[s]);
                short s2 = this.results.getShort(4);
                ((RespSelectionObject)string).stringArray[4] = Constants.getCPUArchDisplayName((int)s2);
                ++this.count;
            }
            string2 = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getComputers", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_stat_computer, t_res_host", "GuiSelectionHndlr.getComputers"};
            string2 = SQLUtil.getSQLExceptionMsg(string2, sQLException, objectArray);
        }
        string = string2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputers", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getGroups(GuiSelectionReq var1_1, short var2_2) {
        block33: {
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry((String)v0.getName(), (String)"getGroups", (String)"gsr, type");
            }
            var3_3 = "SRV0103E";
            if (var1_1.objectType == 28) {
                var1_1.numberColumns = 3;
                var1_1.nameArray = RespSelectionObject.CLUSTER_NAMES;
                var1_1.typeArray = RespSelectionObject.CLUSTER_TYPES;
                var1_1.sortColumns = 1;
            } else {
                var1_1.numberColumns = 5;
                var1_1.nameArray = RespSelectionObject.RPT_GROUP_NAMES;
                var1_1.typeArray = RespSelectionObject.RPT_GROUP_TYPES;
                var1_1.sortColumns = 2;
            }
            try {
                try {
                    switch (var2_2) {
                        case 0: 
                        case 2: {
                            var4_4 = "select group_id, creator, name, description, group_type from t_group where group_type = ?  or group_type = ?";
                            this.pStatement = this.connection.prepareStatement(var4_4);
                            this.pStatement.setShort(1, var2_2);
                            switch (var2_2) {
                                case 2: {
                                    this.pStatement.setInt(2, 90);
                                    break;
                                }
                                case 0: {
                                    this.pStatement.setInt(2, 89);
                                    break;
                                }
                            }
                            break;
                        }
                        default: {
                            this.pStatement = this.connection.prepareStatement("select group_id, creator, name, description, group_type from t_group where group_type = ? ");
                            this.pStatement.setShort(1, var2_2);
                        }
                    }
                    this.results = this.pStatement.executeQuery();
                    var3_3 = "SRV0104E";
                    while (true) {
                        if (!this.results.next()) {
                            var3_3 = null;
                        }
                        var4_4 = new RespSelectionObject();
                        var4_4.next = this.head;
                        this.head = var4_4;
                        var4_4.stringArray = new String[var1_1.numberColumns];
                        var4_4.ID = this.results.getInt(1);
                        if (var1_1.objectType == 28) {
                            var4_4.stringArray[1] = this.results.getString(3);
                            var4_4.stringArray[2] = ResourceTypeManager.getName((short)this.results.getShort(5));
                        } else {
                            var4_4.stringArray[1] = this.results.getString(2);
                            var4_4.stringArray[2] = this.results.getString(3);
                            var4_4.stringArray[3] = this.results.getString(4);
                            var4_4.stringArray[4] = this.results.getInt(5) == var2_2 ? MessageLog.getMessageNoID((String)"STS0807L") : MessageLog.getMessageNoID((String)"STS0806L");
                        }
                        ++this.count;
                    }
                }
                catch (SQLException var4_5) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v2 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                        }
                        catch (ClassNotFoundException v3) {
                            throw new NoClassDefFoundError(v3.getMessage());
                        }
                        TraceLogger.exception((String)v2.getName(), (String)"getGroups", (Throwable)var4_5);
                    }
                    var5_6 = new Object[]{"t_group", "GuiSelectionHndlr.getGroups"};
                    var3_3 = SQLUtil.getSQLExceptionMsg(var3_3, var4_5, var5_6);
                }
            }
            catch (Throwable var7_7) {
                var6_8 = null;
                try {
                    this.results.close();
                    this.pStatement.close();
                    throw var7_7;
                }
                catch (SQLException var8_10) {
                    if (TraceLogger.enableTrace == false) throw var7_7;
                    try {
                        v4 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                    }
                    catch (ClassNotFoundException v5) {
                        throw new NoClassDefFoundError(v5.getMessage());
                    }
                    TraceLogger.exception((String)v4.getName(), (String)"getGroups", (Throwable)var8_10);
                }
                throw var7_7;
            }
            {
                var6_9 = null;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 564->585)] { 
lbl89:
            // 1 sources

            this.results.close();
            this.pStatement.close();
            break block33;
lbl92:
            // 1 sources

            catch (SQLException var8_11) {
                if (!TraceLogger.enableTrace) break block33;
                try {}
                catch (ClassNotFoundException v6) {
                    throw new NoClassDefFoundError(v6.getMessage());
                }
                TraceLogger.exception((String)Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr").getName(), (String)"getGroups", (Throwable)var8_11);
            }
        }
        var4_4 = var3_3;
        if (TraceLogger.enableTrace == false) return var4_4;
        try {
            v7 = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
        }
        catch (ClassNotFoundException v8) {
            throw new NoClassDefFoundError(v8.getMessage());
        }
        TraceLogger.exit((String)v7.getName(), (String)"getGroups", (Object)var4_4);
        return var4_4;
    }

    private String getDomains(GuiSelectionReq guiSelectionReq) {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDomains", (String)"gsr");
        }
        String string = "SRV0103E";
        String string2 = domainSelect;
        guiSelectionReq.numberColumns = 2;
        guiSelectionReq.nameArray = RespSelectionObject.DOMAIN_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.DOMAIN_TYPES;
        guiSelectionReq.sortColumns = 1;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(string2);
            string = "SRV0104E";
            while (this.results.next()) {
                object = new RespSelectionObject();
                object.next = this.head;
                this.head = object;
                object.stringArray = new String[guiSelectionReq.numberColumns];
                object.ID = this.results.getInt(1);
                object.stringArray[1] = this.results.getString(2);
                ++this.count;
            }
            string = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDomains", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_res_domain", "GuiSelectionHndlr.getDomains"};
            string = SQLUtil.getSQLExceptionMsg(string, sQLException, objectArray);
        }
        object = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDomains", (Object)object);
        }
        return object;
    }

    private String getDisks(GuiSelectionReq guiSelectionReq) {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDisks", (String)"gsr");
        }
        String string = "SRV0103E";
        guiSelectionReq.numberColumns = 3;
        guiSelectionReq.nameArray = RespSelectionObject.DISK_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.DISK_TYPES;
        guiSelectionReq.computerColumn = 1;
        guiSelectionReq.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(diskSelect);
            string = "SRV0104E";
            while (this.results.next()) {
                object = new RespSelectionObject();
                object.next = this.head;
                this.head = object;
                object.stringArray = new String[guiSelectionReq.numberColumns];
                object.ID = this.results.getInt(1);
                object.CID = this.results.getInt(2);
                object.stringArray[2] = this.results.getString(3);
                ++this.count;
            }
            string = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDisks", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_res_dev_access, t_res_share, t_res_controller", "GuiSelectionHndlr.getDisks"};
            string = SQLUtil.getSQLExceptionMsg(string, sQLException, objectArray);
        }
        object = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDisks", (Object)object);
        }
        return object;
    }

    private String getDiskArrays(GuiSelectionReq guiSelectionReq) {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDiskArrays", (String)"gsr");
        }
        String string = "SRV0103E";
        guiSelectionReq.numberColumns = 2;
        guiSelectionReq.nameArray = RespSelectionObject.DISK_ARRAY_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.DISK_ARRAY_TYPES;
        guiSelectionReq.sortColumns = 1;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(diskArraySelect);
            string = "SRV0104E";
            while (this.results.next()) {
                object = new RespSelectionObject();
                object.next = this.head;
                this.head = object;
                object.stringArray = new String[guiSelectionReq.numberColumns];
                object.ID = this.results.getInt(1);
                object.stringArray[1] = this.results.getString(2);
                ++this.count;
            }
            string = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDiskArrays", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_res_storage_subsystem", "GuiSelectionHndlr.getDiskArrays"};
            string = SQLUtil.getSQLExceptionMsg(string, sQLException, objectArray);
        }
        object = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDiskArrays", (Object)object);
        }
        return object;
    }

    private String getDiskArrayDisks(GuiSelectionReq guiSelectionReq) {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getDiskArrayDisks", (String)"gsr");
        }
        String string2 = "SRV0103E";
        guiSelectionReq.numberColumns = 3;
        guiSelectionReq.nameArray = RespSelectionObject.DISK_ARRAY_DISK_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.DISK_ARRAY_DISK_TYPES;
        guiSelectionReq.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(diskArrayDiskSelect);
            string2 = "SRV0104E";
            while (this.results.next()) {
                string = new RespSelectionObject();
                ((RespSelectionObject)string).next = this.head;
                this.head = string;
                ((RespSelectionObject)string).stringArray = new String[guiSelectionReq.numberColumns];
                ((RespSelectionObject)string).ID = this.results.getInt(1);
                ((RespSelectionObject)string).stringArray[1] = this.results.getString(2);
                ((RespSelectionObject)string).stringArray[2] = this.results.getString(3);
                ++this.count;
            }
            string2 = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getDiskArrayDisks", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_res_physical_volume, t_res_storage_extent t_res_storage_subsystem, GuiSelectionHndlr.getDiskArrayDisks"};
            string2 = SQLUtil.getSQLExceptionMsg(string2, sQLException, objectArray);
        }
        string = string2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getDiskArrayDisks", (Object)string);
        }
        return string;
    }

    private String selectLogicalVolumes(GuiSelectionReq guiSelectionReq, String string) {
        String string2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectLogicalVolumes", (String)"gsr, sqlText");
        }
        String string3 = "SRV0103E";
        int n = -1;
        try {
            if (this.statement == null) {
                this.statement = this.connection.createStatement();
            }
            this.results = this.statement.executeQuery(string);
            string3 = "SRV0104E";
            while (this.results.next()) {
                int n2 = this.results.getInt(1);
                if (n2 == n) continue;
                n = n2;
                string2 = new RespSelectionObject();
                ((RespSelectionObject)string2).next = this.head;
                this.head = string2;
                ((RespSelectionObject)string2).stringArray = new String[guiSelectionReq.numberColumns];
                ((RespSelectionObject)string2).ID = n2;
                ((RespSelectionObject)string2).stringArray[1] = this.results.getString(2);
                ((RespSelectionObject)string2).stringArray[2] = this.results.getString(3);
                ++this.count;
            }
            string3 = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectLogicalVolumes", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_res_logical_disk", "GuiSelectionHndlr.selectLogicalVolumes"};
            string3 = SQLUtil.getSQLExceptionMsg(string3, sQLException, objectArray);
        }
        if (this.results != null) {
            block18: {
                try {
                    this.results.close();
                }
                catch (SQLException sQLException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block18;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectLogicalVolumes", (Throwable)sQLException);
                }
            }
            this.results = null;
        }
        string2 = string3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectLogicalVolumes", (Object)string2);
        }
        return string2;
    }

    private String getLogicalVolumes(GuiSelectionReq guiSelectionReq) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLogicalVolumes", (String)"gsr");
        }
        guiSelectionReq.numberColumns = 3;
        guiSelectionReq.nameArray = RespSelectionObject.FSLV_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.FSLV_TYPES;
        guiSelectionReq.sortColumns = 2;
        String string = this.selectLogicalVolumes(guiSelectionReq, noFSLogicalDiskSelect);
        if (string == null) {
            string = this.selectLogicalVolumes(guiSelectionReq, fsLogicalDiskSelect);
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLogicalVolumes", (Object)string2);
        }
        return string2;
    }

    private String getLuns(GuiSelectionReq guiSelectionReq) {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLuns", (String)"gsr");
        }
        String string = "SRV0103E";
        guiSelectionReq.numberColumns = 3;
        guiSelectionReq.nameArray = RespSelectionObject.LUN_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.LUN_TYPES;
        guiSelectionReq.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(lunSelect);
            string = "SRV0104E";
            while (this.results.next()) {
                object = new RespSelectionObject();
                object.next = this.head;
                this.head = object;
                object.stringArray = new String[guiSelectionReq.numberColumns];
                object.ID = this.results.getInt(1);
                object.stringArray[1] = this.results.getString(2);
                String string2 = this.results.getString(3);
                String string3 = this.results.getString(4);
                object.stringArray[2] = Util.isEmpty((String)string3) ? string2 : string3;
                ++this.count;
            }
            string = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getLuns", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_res_storage_subsystem, t_res_share", "GuiSelectionHndlr.getLuns"};
            string = SQLUtil.getSQLExceptionMsg(string, sQLException, objectArray);
        }
        object = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLuns", (Object)object);
        }
        return object;
    }

    private String getVirtualVolumes(GuiSelectionReq guiSelectionReq) {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getVirtualVolumes", (String)"gsr");
        }
        String string = "SRV0103E";
        guiSelectionReq.numberColumns = 3;
        guiSelectionReq.nameArray = RespSelectionObject.VOLUME_TO_BACKEND_VOLUMES_NAMES;
        guiSelectionReq.typeArray = RespSelectionObject.VOLUME_TO_BACKEND_VOLUMES_TYPES;
        guiSelectionReq.sortColumns = 2;
        try {
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(virtualVolumeSelect);
            string = "SRV0104E";
            while (this.results.next()) {
                object = new RespSelectionObject();
                object.next = this.head;
                this.head = object;
                object.stringArray = new String[guiSelectionReq.numberColumns];
                object.ID = this.results.getInt(1);
                object.stringArray[1] = this.results.getString(2);
                object.stringArray[2] = this.results.getString(3);
                ++this.count;
            }
            string = null;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getVirtualVolumes", (Throwable)sQLException);
            }
            Object[] objectArray = new Object[]{"t_res_storage_subsystem, t_res_storage_volume", "GuiSelectionHndlr.getVirtualVolumes"};
            string = SQLUtil.getSQLExceptionMsg(string, sQLException, objectArray);
        }
        object = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getVirtualVolumes", (Object)object);
        }
        return object;
    }
}

