/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;

public class DiskDeviceActionHandler
extends DeviceRequestHndlr {
    private IDiskManagerService dmService = null;
    private IFabricManagerService fmService = null;

    public int deviceAPI(DeviceRequest deviceRequest, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.DiskDeviceActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deviceAPI", (String)"request, response");
        }
        GUIRequestData gUIRequestData = (GUIRequestData)deviceRequest.requestData;
        try {
            Class<?> clazz;
            Class<?> clazz2;
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz2 = Class.forName("org.eclipse.aperi.disk.api.IDiskManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.dmService = (IDiskManagerService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz2, (String)"DiskManagerService");
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.api.IFabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.fmService = (IFabricManagerService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            if (gUIRequestData.getActionId() == 11) {
                this.deleteStorageSubsystems(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 32) {
                this.releaseFabric(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 33) {
                this.rollbackFabricTransaction(gUIRequestData, response);
            }
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.DiskDeviceActionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deviceAPI", (Throwable)exception);
            }
            response.status = (short)12;
            if (exception instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)exception).getLocalizedMessage();
            } else {
                String[] stringArray = new String[]{};
                String string = exception.getMessage();
                if (string != null) {
                    stringArray = new String[]{string};
                }
                response.errorMessage = new SRMMessage("HWN021503E", stringArray).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.DiskDeviceActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deviceAPI", (int)0);
        }
        return 0;
    }

    private Result[] deleteStorageSubsystems(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String[] stringArray = (String[])gUIRequestData.getParameter("subsystem.ids");
        String[] stringArray2 = (String[])gUIRequestData.getParameter("subsystem.internalIds");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"deleteStorageSubsystems", (String)("subsystemIds: " + stringArray));
        Result[] resultArray = this.dmService.deleteStorageSubsystems(stringArray);
        ViewReportTablesUpdater viewReportTablesUpdater = new ViewReportTablesUpdater();
        String[] stringArray3 = stringArray2;
        int n = 0;
        int n2 = stringArray3.length;
        while (n < n2) {
            String string = stringArray3[n];
            viewReportTablesUpdater.deleteDependentViews("subsystem", string);
            ++n;
        }
        return resultArray;
    }

    private int releaseFabric(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("fabric.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"releaseFabric", (String)("fabricId: " + string));
        return this.fmService.release(string);
    }

    private int rollbackFabricTransaction(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("fabric.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"rollbackFabricTransaction", (String)("fabricId: " + string));
        return this.fmService.rollbackTransaction(string);
    }
}

