/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.tape;

import java.util.Hashtable;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.tape.common.model.GUIException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.tape.GUIEntityFactory;

public class LibraryInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        GUIRequestData gUIRequestData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (gUIRequestData.getActionId() == 1) {
                this.getAllTapeLibraries(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 3) {
                this.setLibraryAttributes(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 4) {
                this.deleteTapeLibrary(gUIRequestData, response);
            }
        }
        catch (Exception exception) {
            Server.setResponseError(response, exception);
            response.errorMessage = exception.getMessage();
            response.responseData = null;
        }
        return response;
    }

    private void getAllTapeLibraries(GUIRequestData gUIRequestData, Response response) throws GUIException {
        response.responseData = this.entityFactory.getAllTapeLibraries();
    }

    private void setLibraryAttributes(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("library.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.tape.LibraryInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"setLibraryAttributes", (String)("libraryId: " + string));
        Hashtable hashtable = (Hashtable)gUIRequestData.getParameter("library.attrs");
        response.responseData = new Integer(this.entityFactory.setLibraryAttributes(string, hashtable));
    }

    private void deleteTapeLibrary(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("library.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.tape.LibraryInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"deleteTapeLibrary", (String)("libraryId: " + string));
        response.responseData = new Integer(this.entityFactory.deleteTapeLibrary(string));
        new ViewReportTablesUpdater().deleteDependentViews("tapelibrary", string);
    }
}

