/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.handler.scheduler.JobHndlrThread;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;

public class JobHndlr
implements RequestHandler,
ThreadSafe {
    private static final Map<Integer, JobRun> serverJobTable = new HashMap<Integer, JobRun>();
    private static final ServerJobExtensionManager serverJobManager = new ServerJobExtensionManager();

    public Response handle(Request request, Transceiver transceiver) {
        Object object;
        VMJobResults vMJobResults;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        if ((vMJobResults = ((VMTransceiver)transceiver).getJobData(request)) == null) {
            Response response = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handle", response);
            }
            return response;
        }
        JobRun jobRun = vMJobResults.getJobRun();
        String string = request.userName;
        if (string == null || string.length() == 0) {
            string = jobRun.getSchedCreator();
        }
        String[] stringArray = jobRun.getCommandLine();
        String string2 = stringArray[0];
        int n = stringArray.length - 1;
        String[] stringArray2 = new String[n];
        if (stringArray.length > 0) {
            System.arraycopy(stringArray, 1, stringArray2, 0, n);
        }
        if (TraceLogger.enableAudit) {
            Class<?> clazz;
            object = new StringBuffer("Username=" + string);
            ((StringBuffer)object).append("\n Running " + string2);
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz.getName(), (String)"handle", (String)((StringBuffer)object).toString());
        }
        object = null;
        try {
            object = (ServerJob)serverJobManager.getExtensionImpl(string2, false);
        }
        catch (Exception exception) {}
        new TSThread((Runnable)new JobHndlrThread((ServerJob)object, vMJobResults, stringArray2, string2), this.getClass().getName()).start();
        Response response = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", response);
        }
        return response;
    }

    public static boolean jobNeedsLogFile(JobRun jobRun) {
        boolean bl = true;
        String[] stringArray = jobRun.getCommandLine();
        if (stringArray != null && stringArray.length != 0) {
            String string = stringArray[0];
            bl = Boolean.parseBoolean(serverJobManager.getExtensionAttribute(string, "logged"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToJobTable(JobRun jobRun) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addToJobTable", (String)"jRun");
        }
        Map<Integer, JobRun> map = serverJobTable;
        synchronized (map) {
            Integer n = new Integer(jobRun.getRunNumber());
            serverJobTable.put(n, jobRun);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToJobTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromJobTable(JobRun jobRun) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeFromJobTable", (String)"jRun");
        }
        Map<Integer, JobRun> map = serverJobTable;
        synchronized (map) {
            Integer n = new Integer(jobRun.getRunNumber());
            serverJobTable.remove(n);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeFromJobTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runningOrNot(Integer n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"runningOrNot", (String)"jobNumber");
        }
        boolean bl = false;
        Map<Integer, JobRun> map = serverJobTable;
        synchronized (map) {
            bl = serverJobTable.containsKey(n);
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.JobHndlr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"runningOrNot", (boolean)bl2);
        }
        return bl2;
    }

    private static class ServerJobExtensionManager
    extends AbstractExtensionMgr {
        public static final String ATTR_IMPL = "impl";
        public static final String ATTR_LOGGED = "logged";

        private ServerJobExtensionManager() {
        }

        public String getExtensionPointId() {
            return "org.eclipse.aperi.server.data.serverJob";
        }
    }
}

