/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAggregator;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.repository.table.TStatTotals;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.jobs.HistAvgs;
import org.eclipse.aperi.server.jobs.OSAggregationMap;
import org.eclipse.aperi.server.jobs.SummaryAggregation;
import org.eclipse.aperi.xmsg.MessageLog;

public class Aggregator
implements ServerJob {
    private Connection dbc;
    private Settings settings;
    private OSAggregationMap aggregationMap;
    private TStatDiskHist dhAccessor;
    private TAggregator taAccessor;
    private SummaryAggregation summaryBuffer;
    private long runTime;
    private static final long MILLIS_PER_WEEK = 604800000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final String AGGREGATOR_LOCK = "AGGREGATOR";
    public static final String[] AGGREGATED_FS_HISTORY = new String[]{"t_stat_fs_hist", "t_stat_space_hist", "t_stat_user_hist", "t_stat_group_hist", "t_stat_time_hist", "t_stat_ftype_hist"};
    public static final String[] AGGREGATED_DIR_HISTORY = new String[]{"t_stat_space_hist", "t_stat_time_hist"};

    public Aggregator(Connection connection) {
        this.initialize(connection);
    }

    public Aggregator() {
    }

    public void initialize(Connection connection) {
        block4: {
            this.dbc = connection;
            try {
                this.runTime = SQLUtil.getTimestamp(connection).getTime();
            }
            catch (Exception exception) {
                Class<?> clazz;
                exception.printStackTrace();
                if (!TraceLogger.enableTrace) break block4;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"Aggregator", (Throwable)exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(VMJobResults vMJobResults, String[] stringArray) {
        int n;
        block32: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"job, parms");
            }
            MessageLog.logMessage((String)"STS0128I");
            n = 8;
            boolean bl = false;
            try {
                try {
                    bl = LockManager.lock((short)0, (String)AGGREGATOR_LOCK, (String)AGGREGATOR_LOCK, (byte)1, (boolean)false);
                    if (!bl) {
                        MessageLog.logMessage((String)"STS0135W");
                        int n2 = 0;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"run", (int)n2);
                        }
                        int n3 = n2;
                        Object var18_10 = null;
                        if (this.dhAccessor != null) {
                            this.close(this.dhAccessor);
                        }
                        if (this.taAccessor != null) {
                            this.close(this.taAccessor);
                        }
                        if (bl) {
                            LockManager.unLock((short)0, (String)AGGREGATOR_LOCK, (String)AGGREGATOR_LOCK);
                        }
                        return n3;
                    }
                    TStormSettings tStormSettings = new TStormSettings(this.dbc);
                    this.settings = tStormSettings.getSettings();
                    tStormSettings = null;
                    this.summaryBuffer = new SummaryAggregation(-1);
                    this.aggregationMap = new OSAggregationMap(this.dbc);
                    this.aggregationMap.initMaps(this.summaryBuffer);
                    MessageLog.logMessage((String)"STS0134I");
                    this.dhAccessor = new TStatDiskHist(this.dbc);
                    this.dhAccessor.aggregateHist(this.settings, this.runTime);
                    this.dhAccessor = null;
                    this.aggregationMap = null;
                    this.cleanuplog();
                    this.taAccessor = new TAggregator(this.dbc);
                    long l = this.taAccessor.getLastWeekly();
                    long l2 = this.taAccessor.getLastMonthly();
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(new Date(l2));
                    int n4 = gregorianCalendar.get(2);
                    gregorianCalendar.setTime(new Date(this.runTime));
                    int n5 = gregorianCalendar.get(7);
                    int n6 = gregorianCalendar.get(2);
                    long l3 = this.runTime + 3600000L;
                    HistAvgs histAvgs = null;
                    if (n5 == 7 || l + 604800000L <= l3) {
                        l = this.runTime;
                        histAvgs = new HistAvgs(this.dbc);
                        histAvgs.average(0);
                    }
                    if (n6 != n4) {
                        l2 = this.runTime;
                        if (histAvgs == null) {
                            histAvgs = new HistAvgs(this.dbc);
                        }
                        histAvgs.average(1);
                    }
                    if (histAvgs != null) {
                        this.taAccessor.update(l, l2);
                    }
                    TStatTotals tStatTotals = new TStatTotals(this.dbc);
                    tStatTotals.aggregate(" ");
                    MessageLog.logMessage((String)"STS0126I");
                    n = 0;
                }
                catch (GeneralException generalException) {
                    String string;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)generalException);
                    }
                    if ((string = generalException.getMessage()) != null) {
                        MessageLog.getThreadLog().println(string);
                    }
                    MessageLog.logMessage((String)"STS0125E");
                }
                Object var18_12 = null;
                if (this.dhAccessor != null) {
                    this.close(this.dhAccessor);
                }
                if (this.taAccessor != null) {
                    this.close(this.taAccessor);
                }
                if (!bl) break block32;
            }
            catch (Throwable throwable) {
                Object var18_11 = null;
                if (this.dhAccessor != null) {
                    this.close(this.dhAccessor);
                }
                if (this.taAccessor != null) {
                    this.close(this.taAccessor);
                }
                if (bl) {
                    LockManager.unLock((short)0, (String)AGGREGATOR_LOCK, (String)AGGREGATOR_LOCK);
                }
                throw throwable;
            }
            LockManager.unLock((short)0, (String)AGGREGATOR_LOCK, (String)AGGREGATOR_LOCK);
        }
        int n7 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run", (int)n7);
        }
        return n7;
    }

    private void cleanuplog() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanuplog", (String)"");
        }
        Map<Short, ExtAlertLog> map = null;
        MessageLog.logMessage((String)"STS0400I");
        TAlertLog tAlertLog = new TAlertLog(this.dbc);
        try {
            map = tAlertLog.selectforcleanup();
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"cleanuplog", (Throwable)generalException);
            }
            MessageLog.logException((String)"STS0125E", (Exception)((Object)generalException));
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"cleanuplog");
            }
            return;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"cleanuplog", (Throwable)sQLException);
            }
            MessageLog.logException((String)"STS0125E", (Exception)sQLException);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"cleanuplog");
            }
            return;
        }
        Iterator<ExtAlertLog> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ExtAlertLog extAlertLog = iterator.next();
            while (extAlertLog != null) {
                this.deleteLogRec(tAlertLog, extAlertLog);
                extAlertLog = extAlertLog.alnExt;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanuplog");
        }
    }

    private void deleteLogRec(TAlertLog tAlertLog, ExtAlertLog extAlertLog) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteLogRec", (String)"alr, record");
        }
        try {
            tAlertLog.deleteByID(extAlertLog);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteLogRec", (Throwable)generalException);
            }
            MessageLog.logException((String)"STS0125E", (Exception)((Object)generalException));
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"deleteLogRec");
            }
            return;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteLogRec");
        }
    }

    public void close(RepositoryAccessor repositoryAccessor) {
        block25: {
            block24: {
                block23: {
                    block22: {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"accessor");
                        }
                        try {
                            repositoryAccessor.closeSelect();
                        }
                        catch (GeneralException generalException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block22;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)generalException);
                        }
                    }
                    try {
                        repositoryAccessor.closeInsert();
                    }
                    catch (GeneralException generalException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block23;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)generalException);
                    }
                }
                try {
                    repositoryAccessor.closeUpdate();
                }
                catch (GeneralException generalException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block24;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)generalException);
                }
            }
            try {
                repositoryAccessor.closeDelete();
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block25;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)generalException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Aggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close");
        }
    }

    public static interface HistoryAggregator {
        public void aggregate(Aggregator var1, Connection var2, Settings var3) throws GeneralException;
    }
}

