/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.FabricDiscoveryOptions;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResIpAddresses;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class SnmpDiscover
implements ServerJob {
    public static final String LOCK_RESOURCE_TYPE = "SnmpDiscovery";
    private Connection dbc;
    private VMJobResults job;
    private JobRun jobRun;
    private FabricDiscoveryOptions fdo;
    private final int DISCOVERY_EXECUTED = 8;

    public SnmpDiscover(Connection connection) {
        this.initialize(connection);
    }

    public SnmpDiscover() {
    }

    public void initialize(Connection connection) {
        this.dbc = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(VMJobResults vMJobResults, String[] stringArray) {
        int n;
        block22: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"job, parms");
            }
            this.job = vMJobResults;
            this.jobRun = vMJobResults.getJobRun();
            MessageLog.logMessage((String)"SRV0500I", (Object)this.jobRun.getSchedCreator(), (Object)this.jobRun.getSchedName());
            this.fdo = new FabricDiscoveryOptions(stringArray.length > 0 ? stringArray[0] : null);
            String string = LOCK_RESOURCE_TYPE;
            n = 8;
            boolean bl = false;
            try {
                try {
                    bl = LockManager.lock((short)0, (String)LOCK_RESOURCE_TYPE, (String)string, (byte)1, (boolean)false);
                    if (!bl) {
                        MessageLog.logMessage((String)"SRV0501W", (Object)this.jobRun.getSchedCreator(), (Object)this.jobRun.getSchedName());
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"run", (int)8);
                        }
                        Object var7_6 = null;
                        if (bl) {
                            LockManager.unLock((short)0, (String)LOCK_RESOURCE_TYPE, (String)string);
                        }
                        return 8;
                    }
                    n = this.doSNMPDiscovery();
                }
                catch (Exception exception) {
                    MessageLog.logMessage((String)"SRV0506E");
                    exception.printStackTrace(MessageLog.getThreadLog());
                }
                Object var7_8 = null;
                if (!bl) break block22;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (bl) {
                    LockManager.unLock((short)0, (String)LOCK_RESOURCE_TYPE, (String)string);
                }
                throw throwable;
            }
            LockManager.unLock((short)0, (String)LOCK_RESOURCE_TYPE, (String)string);
        }
        if (n == 0) {
            MessageLog.logMessage((String)"SRV0503I");
        } else if (n < 4) {
            MessageLog.logMessage((String)"SRV0504W");
        } else {
            MessageLog.logMessage((String)"SRV0505E");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run", (int)n);
        }
        return n;
    }

    private int doSNMPDiscovery() {
        AsyncResult asyncResult;
        Class<?> clazz;
        Class<?> clazz2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz3.getName(), (String)"doSNMPDiscovery", (String)"");
        }
        DeviceRequest deviceRequest = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
        try {
            clazz2 = Class.forName("org.eclipse.aperi.interfaces.IDiscover");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IDiscover iDiscover = (IDiscover)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz2, (String)"DiscoverService");
        if (iDiscover == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.interfaces.IDiscover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            MessageLog.logMessage((String)"SRV0450E", (Object)clazz4.getName());
            if (TraceLogger.enableTrace) {
                Class<?> clazz5;
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz5.getName(), (String)"doSNMPDiscovery", (int)8);
            }
            return 8;
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.common.api.IJobMgmtService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IJobMgmtService iJobMgmtService = (IJobMgmtService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
        if (iJobMgmtService == null) {
            Class<?> clazz6;
            try {
                clazz6 = Class.forName("org.eclipse.aperi.common.api.IJobMgmtService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            MessageLog.logMessage((String)"SRV0450E", (Object)clazz6.getName());
            if (TraceLogger.enableTrace) {
                Class<?> clazz7;
                try {
                    clazz7 = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz7.getName(), (String)"doSNMPDiscovery", (int)8);
            }
            return 8;
        }
        String string = "discoverSNMPAgents";
        String[] stringArray = SnmpDiscover.fetchBaseIPs();
        try {
            Class<?> clazz8;
            String string2 = this.jobRun.getSchedCreator();
            String string3 = this.jobRun.getSchedName();
            String string4 = this.jobRun.getFormattedRunNumberSchedID();
            String string5 = this.jobRun.getJobName();
            try {
                clazz8 = Class.forName("org.eclipse.aperi.fabric.api.IFabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            asyncResult = (AsyncResult)iDiscover.invoke(string2, string3, string4, string5, "FabricManagerService", clazz8.getName(), "discoverSNMPAgents", new Object[]{stringArray, this.fdo.getDefaultCommunity(), this.fdo.getUserName(), this.fdo.getPasword()});
        }
        catch (Exception exception) {
            MessageLog.logException((String)"SRV0451E", (Exception)exception, (Object)string);
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz9;
                try {
                    clazz9 = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz9.getName(), (String)"doSNMPDiscovery", (int)8);
            }
            return 8;
        }
        catch (Throwable throwable) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(throwable), (Object)string);
            throwable.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz10;
                try {
                    clazz10 = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz10.getName(), (String)"doSNMPDiscovery", (int)8);
            }
            return 8;
        }
        int n = DeviceJobHndlr.completeDeviceJob(iJobMgmtService, asyncResult, string, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), deviceRequest.deviceServerID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz11;
            try {
                clazz11 = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz11.getName(), (String)"doSNMPDiscovery", (int)n);
        }
        return n;
    }

    public static String[] fetchBaseIPs() {
        NameList nameList;
        String[] stringArray = null;
        int n = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchBaseIPs", (String)"");
        }
        TResIpAddresses tResIpAddresses = new TResIpAddresses();
        try {
            String string = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP");
            nameList = tResIpAddresses.getIPAddressList(Integer.parseInt(string));
        }
        catch (GeneralException generalException) {
            generalException.printStackTrace(MessageLog.getThreadLog());
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchBaseIPs");
            }
            return null;
        }
        NameList nameList2 = nameList;
        while (nameList2 != null) {
            ++n;
            nameList2 = nameList2.nlNext;
        }
        if (n > 0) {
            stringArray = new String[n];
            n = 0;
            nameList2 = nameList;
            while (nameList2 != null) {
                stringArray[n++] = nameList2.nlName;
                nameList2 = nameList2.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.SnmpDiscover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchBaseIPs", (Object)stringArray);
        }
        return stringArray;
    }
}

