/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.svp;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.server.RequestManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceProvider;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.SvpThreadGroup;
import org.eclipse.aperi.server.jobs.Ping;
import org.eclipse.aperi.server.svp.AgentConfigParser;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentSvp
extends ServiceProvider {
    public static final String EXTENSION_POINT_ID = "org.eclipse.aperi.server.data.agentHandler";
    public static final long NULL_DATE = 86400000L;
    public static final String DEVICE_LOCK_TYPE = "Device";
    public static final String PING_LOCK_TYPE = "Ping";
    public static final String HISTORY_LOCK_TYPE = "History";
    public static final String DISK_HISTORY_LOCK = "DiskHist";
    public static final String COMP_HISTORY_LOCK = "CompHist";
    public static final String PING_HISTORY_LOCK = "PingHist";
    public static final String LDAP_TREE_LOCK = "LdapTree";
    public static PrintWriter logWriter;
    public static ThreadGroup threadGroup;
    public static int srvThreadPoolSize;
    public static int srvMaxThreads;
    public static int pingReceiveTimeout;
    public static int guiThreadPoolSize;
    public static int guiMaxThreads;
    public static int keepCachedReport;
    public static int reportRowLimit;
    public static boolean saveNonRootExports;
    public static boolean abbreviatedProbe;
    private static boolean gotConfig;
    private static int activeServices;
    private static final int SRV_PENDING_REQUEST_LIMIT = 4;
    private static final String[] services;
    private static String configFile;
    private RequestManager rm;

    static {
        srvThreadPoolSize = 3;
        srvMaxThreads = 8;
        pingReceiveTimeout = 10;
        guiThreadPoolSize = 3;
        guiMaxThreads = 10;
        keepCachedReport = 5000;
        reportRowLimit = 120;
        saveNonRootExports = false;
        abbreviatedProbe = false;
        services = new String[]{"org.eclipse.aperi.server.svp.AgentSvp", "org.eclipse.aperi.server.svp.GuiSvp"};
        configFile = "configuration" + File.separator + "Aperi.config";
    }

    public String getTypeCode() {
        return "org.eclipse.aperi.server.svp.AgentSvp";
    }

    public void startup(ServiceQueue serviceQueue) throws Exception {
        TraceLoggerFactory.startLogger((String)"ITSRM.logger.trace.TivoliSRM-Agent", (String)this.getTypeCode());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"startup", (String)"queue");
        }
        AgentSvp.stormInit();
        Ping.init();
        this.rm = new RequestManager(EXTENSION_POINT_ID, serviceQueue, threadGroup, "StormAgentRequestHandler", 5, srvThreadPoolSize, srvMaxThreads, 4);
        if (!this.rm.initialize()) {
            AgentSvp.stormTerm();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"startup");
            }
            throw new Exception();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"startup");
        }
    }

    public void shutdown(byte by) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"shutdown", (String)"shutdownOption");
        }
        TraceLoggerFactory.stopLogger((String)this.getTypeCode());
        MessageLog.logMessage((String)"STS0002I");
        if (this.rm != null) {
            this.rm.dispose();
            this.rm = null;
        }
        Ping.term(by);
        AgentSvp.stormTerm();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"shutdown");
        }
    }

    public static synchronized void stormInit() throws Exception {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"stormInit", (String)"");
        }
        if (logWriter == null) {
            try {
                logWriter = Server.initMessageLog("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"stormInit", (Throwable)exception);
                }
                String string = Server.getLogFileName("org.eclipse.aperi.server.svp.AgentSvp");
                MessageLog.logException((String)"GEN0049E", (Exception)exception, (Object)string);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"stormInit");
                }
                throw new Exception(exception);
            }
        }
        MessageLog.setThreadLog((PrintWriter)logWriter);
        if (threadGroup == null) {
            threadGroup = new SvpThreadGroup("T-Storm", services);
        }
        if (!gotConfig) {
            MessageLog.logMessage((String)"STS0001I", (Object)configFile);
            new AgentConfigParser(configFile).parse();
            gotConfig = true;
        }
        ++activeServices;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"stormInit");
        }
    }

    public static synchronized void stormTerm() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"stormTerm", (String)"");
        }
        if (--activeServices == 0) {
            gotConfig = false;
            threadGroup = null;
            if (logWriter != null) {
                block12: {
                    try {
                        logWriter.close();
                    }
                    catch (Exception exception) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block12;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"stormTerm", (Throwable)exception);
                    }
                }
                logWriter = null;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.AgentSvp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"stormTerm");
        }
    }
}

