/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util;

import java.net.Socket;
import java.util.Date;
import org.eclipse.aperi.common.LockRequestor;
import org.eclipse.aperi.common.LockResource;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;

public class ShowLocks {
    private static String hostName;
    private static int port;
    private static Request request;
    private static LockResource requestData;
    private static String indent;
    private static Date date;
    private static final String[] LOCK_TYPE;

    static {
        indent = "";
        date = new Date();
        LOCK_TYPE = new String[]{"", "Exclusive", "Shared"};
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: ShowLocks <server-host> <server-port>");
            System.exit(1);
        }
        hostName = stringArray[0];
        port = Integer.parseInt(stringArray[1]);
        requestData = new LockResource();
        request = new Request();
        ShowLocks.request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        ShowLocks.request.subType = "org.eclipse.aperi.server.handler.server.LockQueryHndlr";
        ShowLocks.request.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.server.svp.ServerSvp");
        ShowLocks.request.flags = (byte)5;
        ShowLocks.request.requestData = requestData;
        ShowLocks.print("Server Side Locks As Of: " + date);
        ShowLocks.lockQuery((short)0);
        ShowLocks.lockQuery((short)1);
        ShowLocks.lockQuery((short)2);
        ShowLocks.lockQuery((short)3);
    }

    private static void lockQuery(short s) {
        ShowLocks.requestData.lrsProductID = s;
        Socket socket = null;
        try {
            socket = new Socket(hostName, port);
        }
        catch (Exception exception) {
            System.out.println("Unable to open socket");
            if (exception.getMessage() != null) {
                System.out.println(exception.getMessage());
            }
            return;
        }
        SocketTransceiver socketTransceiver = new SocketTransceiver(socket, hostName);
        Response response = socketTransceiver.transmitRequest(request, null);
        socketTransceiver.close();
        LockResource lockResource = null;
        if (response != null) {
            lockResource = LockResource.unpack((LockResource[])((LockResource[])response.responseData));
        }
        if (lockResource != null) {
            System.out.println("Locks for: " + LockResource.productName[s]);
            ShowLocks.printLocks(lockResource);
        }
    }

    private static void printLocks(LockResource lockResource) {
        while (lockResource != null) {
            indent = "  ";
            ShowLocks.print("Resource: " + lockResource.lrsResource);
            indent = "    ";
            ShowLocks.print("Lock Holders: ");
            ShowLocks.printRequestors(lockResource.lrsHolders);
            indent = "    ";
            ShowLocks.print("Lock Waiters: ");
            ShowLocks.printRequestors(lockResource.lrsWaitersHead);
            ShowLocks.print("");
            lockResource = lockResource.lrsNext;
        }
    }

    private static void printRequestors(LockRequestor lockRequestor) {
        indent = String.valueOf(indent) + "  ";
        while (lockRequestor != null) {
            date.setTime(lockRequestor.lrqTimestamp);
            ShowLocks.print("Thread: " + lockRequestor.lrqThread + ", Type: " + LOCK_TYPE[lockRequestor.lrqLockType]);
            ShowLocks.print("Time  : " + date + "\n");
            lockRequestor = lockRequestor.lrqNext;
        }
    }

    private static void print(String string) {
        System.out.println(String.valueOf(indent) + string);
    }
}

