/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.aperi.xmsg.LocalizableException;

public class Pipe {
    private long reader;
    private long writer;
    private IStream iStream = null;
    private OStream oStream = null;

    private native void create() throws LocalizableException;

    private native void close(long var1) throws LocalizableException;

    private native int readBytes(long var1, byte[] var3, int var4, int var5) throws LocalizableException;

    private native int bytesAvailable(long var1) throws LocalizableException;

    private native int writeBytes(long var1, byte[] var3, int var4, int var5) throws LocalizableException;

    public long getReadHandle() {
        return this.reader;
    }

    public long getWriteHandle() {
        return this.writer;
    }

    private void closeReader() throws IOException {
        if (this.reader < 0L) {
            return;
        }
        long l = this.reader;
        this.reader = -1L;
        this.close(l);
    }

    private void closeWriter() throws IOException {
        if (this.writer < 0L) {
            return;
        }
        long l = this.writer;
        this.writer = -1L;
        this.close(l);
    }

    public void close() {
        try {
            this.closeReader();
        }
        catch (IOException iOException) {}
        try {
            this.closeWriter();
        }
        catch (IOException iOException) {}
    }

    public Pipe() throws LocalizableException {
        this.create();
    }

    public InputStream getInputStream() {
        if (this.iStream == null) {
            this.iStream = new IStream();
        }
        return this.iStream;
    }

    public OutputStream getOutputStream() {
        if (this.oStream == null) {
            this.oStream = new OStream();
        }
        return this.oStream;
    }

    private class IStream
    extends InputStream {
        private boolean atEOF = false;

        private int readNoCheck(byte[] byArray, int n, int n2) throws IOException {
            int n3 = -1;
            if (this.atEOF) {
                return n3;
            }
            n3 = Pipe.this.readBytes(Pipe.this.reader, byArray, n, n2);
            if (n3 == 0) {
                this.atEOF = true;
                n3 = -1;
            }
            return n3;
        }

        private int readNoCheck(byte[] byArray) throws IOException {
            return this.readNoCheck(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            return this.readNoCheck(byArray, n, n2);
        }

        public int read(byte[] byArray) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            return this.readNoCheck(byArray);
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.readNoCheck(byArray);
            if (n <= 0) {
                return n;
            }
            return byArray[0];
        }

        public int available() throws IOException {
            if (this.atEOF) {
                return -1;
            }
            return Pipe.this.bytesAvailable(Pipe.this.reader);
        }

        public void close() throws IOException {
            Pipe.this.closeReader();
        }

        public void mark(int n) {
        }

        public void reset() throws IOException {
            throw new IOException();
        }

        public boolean markSupported() {
            return false;
        }
    }

    private class OStream
    extends OutputStream {
        private OStream() {
        }

        private void writeNoCheck(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = Pipe.this.writeBytes(Pipe.this.writer, byArray, n, n2);
                n += n3;
                n2 -= n3;
            }
        }

        private void writeNoCheck(byte[] byArray) throws IOException {
            this.writeNoCheck(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            this.writeNoCheck(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.writeNoCheck(byArray);
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            this.writeNoCheck(byArray);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            Pipe.this.closeWriter();
        }
    }
}

