/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.DefaultStatusHandler;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLCompleteImageHandler;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.IEngineConfig;
import org.eclipse.birt.report.engine.api.IReportDocumentLockManager;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.model.api.IResourceLocator;

public class EngineConfig
extends PlatformConfig
implements IEngineConfig {
    public EngineConfig() {
        HTMLEmitterConfig emitterConfig = new HTMLEmitterConfig();
        emitterConfig.setActionHandler(new HTMLActionHandler());
        emitterConfig.setImageHandler(new HTMLCompleteImageHandler());
        this.getEmitterConfigs().put("html", emitterConfig);
    }

    public void setEngineHome(String birtHome) {
        this.setProperty("BIRT_HOME", birtHome);
    }

    public void setConfigurationVariable(String name, String value) {
        this.setProperty(name, value);
    }

    public HashMap getConfigMap() {
        return this.properties;
    }

    public void setLogConfig(String directoryName, Level level) {
        this.setProperty("logDest", directoryName);
        this.setProperty("logLevel", level);
    }

    public HashMap getScriptObjects() {
        HashMap scriptObjects = (HashMap)this.getProperty("org.eclipse.birt.report.engine.api.EngineConfig.scriptObjects");
        if (scriptObjects == null) {
            scriptObjects = new HashMap();
            this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.scriptObjects", scriptObjects);
        }
        return scriptObjects;
    }

    public void addScriptableJavaObject(String jsName, Object obj) {
        this.getScriptObjects().put(jsName, obj);
    }

    public void setEmitterConfiguration(String format, Object emitterConfig) {
        this.getEmitterConfigs().put(format, emitterConfig);
    }

    public HashMap getEmitterConfigs() {
        HashMap emitterConfigs = (HashMap)this.getProperty("org.eclipse.birt.report.engine.api.EngineConfig.emitterConfigs");
        if (emitterConfigs == null) {
            emitterConfigs = new HashMap();
            this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.emitterConfigs", emitterConfigs);
        }
        return emitterConfigs;
    }

    public IStatusHandler getStatusHandler() {
        IStatusHandler statusHandler = (IStatusHandler)this.getProperty("org.eclipse.birt.report.engine.api.EngineConfig.statusHandler");
        if (statusHandler == null) {
            statusHandler = new DefaultStatusHandler();
            this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.statusHandler", statusHandler);
        }
        return statusHandler;
    }

    public void setStatusHandler(IStatusHandler handler) {
        this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.statusHandler", handler);
    }

    public Level getLogLevel() {
        Level level = (Level)this.getProperty("logLevel");
        return level;
    }

    public String getLogDirectory() {
        String logDestination = (String)this.getProperty("logDest");
        return logDestination;
    }

    public void setTempDir(String tmpDir) {
        this.setProperty("tmpDir", tmpDir);
    }

    public String getTempDir() {
        String tempDir = (String)this.getProperty("tmpDir");
        if (tempDir == null) {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        return tempDir;
    }

    public IReportDocumentLockManager getReportDocumentLockManager() {
        Object manager = this.getProperty("org.eclipse.birt.report.engine.api.IReportDocumentLockManager");
        if (manager instanceof IReportDocumentLockManager) {
            return (IReportDocumentLockManager)manager;
        }
        return null;
    }

    public void setReportDocumentLockManager(IReportDocumentLockManager manager) {
        this.setProperty("org.eclipse.birt.report.engine.api.IReportDocumentLockManager", manager);
    }

    public void setEngineContext(IPlatformContext context) {
        this.setPlatformContext(context);
    }

    public IPlatformContext getServletContext() {
        return this.getPlatformContext();
    }

    public IResourceLocator getResourceLocator() {
        Object locator = this.getProperty("resourceLocator");
        if (locator instanceof IResourceLocator) {
            return (IResourceLocator)locator;
        }
        return null;
    }

    public void setResourceLocator(IResourceLocator resourceLocator) {
        this.setProperty("resourceLocator", resourceLocator);
    }

    public String getResourcePath() {
        Object resourcePath = this.getProperty("resourcePath");
        if (resourcePath instanceof String) {
            return (String)resourcePath;
        }
        return null;
    }

    public void setResourcePath(String resourcePath) {
        this.setProperty("resourcePath", resourcePath);
    }

    public void setMaxRowsPerQuery(int maxRows) {
        this.setProperty("maxRowsPerQuery", new Integer(maxRows));
    }

    public int getMaxRowsPerQuery() {
        Object maxRows = this.getProperty("maxRowsPerQuery");
        if (maxRows instanceof Integer) {
            return (Integer)maxRows;
        }
        return 0;
    }

    public String toString() {
        String str = "EngineConfig: ";
        if (this.properties == null) {
            str = str + "null";
        } else {
            Iterator entryIt = this.properties.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry entry = entryIt.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                str = str + (key == null ? "<null>" : key.toString());
                str = str + "=";
                str = str + (value == null ? "<null>" : value.toString());
                str = str + ";";
            }
        }
        return str;
    }
}

