/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.io.File;
import java.io.FilenameFilter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.ConfigSettings;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class JobLogDeletionHandler
implements FilenameFilter {
    public static final int RESTART = -4096;
    public static String scriptsDir;
    private static NumberFormat schedRunFormat;
    private static NumberFormat jobRunFormat;
    private String dirPath = this.getDeviceServerLogDir();
    public static final String MESSAGE_NAME = "aperi.logger.message.JobDeletionHandler";
    public static final String TRACE_NAME = "aperi.logger.trace.JobDeletionHandler";
    public static String MSG_FILE;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    private long purgeBefore;
    private boolean purgeNecessary;
    private int retainDays = -100;
    private int retention = -100;

    static {
        MSG_FILE = "org.eclipse.aperi.resources.Discover";
        msgLogger = null;
        traceLogger = null;
        className = JobLogDeletionHandler.class.getName();
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        schedRunFormat = new DecimalFormat("0000");
        jobRunFormat = new DecimalFormat("00000000");
    }

    public boolean accept(File file, String string) {
        int n = string.length();
        if (n < 20) {
            return false;
        }
        if (!string.endsWith(".log")) {
            return false;
        }
        String string2 = string.substring(0, n - 4);
        int n2 = string2.indexOf(46);
        if (n2 < 0) {
            return false;
        }
        File file2 = new File(file, string);
        long l = file2.lastModified();
        if (l < this.purgeBefore) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "accept", "The File " + file2.getName() + " is marked for deletion ");
            }
            return true;
        }
        return false;
    }

    private JobLogDeletionHandler() {
        this.getLogRetentionValuesFromDb();
        if (this.retainDays <= 0) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "invalid log file retention value.");
            }
            this.purgeBefore = Long.MIN_VALUE;
        } else {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "Log file retention is " + this.retainDays + " days");
            }
            long l = this.retainDays;
            l *= 86400000L;
            try {
                this.purgeBefore = CurrentTime.getTimestamp().getTime() - l;
                this.purgeNecessary = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (traceLogger != null && traceLogger.isLogging()) {
                    TraceLogger.exception(JobLogDeletionHandler.class.getName(), "constructor", exception);
                }
                return;
            }
        }
        if (this.retention > 0) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "Number of copies to retain is " + this.retention);
            }
            this.purgeNecessary = true;
        }
    }

    public static void purgeLogFiles(int n, int n2) {
        JobLogDeletionHandler jobLogDeletionHandler = new JobLogDeletionHandler();
        if (!jobLogDeletionHandler.purgeNecessary) {
            return;
        }
        jobLogDeletionHandler.purgeLogsForSchedule(n, n2, jobLogDeletionHandler.retention);
        File file = new File(jobLogDeletionHandler.dirPath);
        String[] stringArray = file.list(jobLogDeletionHandler);
        if (stringArray != null) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                File file2 = new File(file, stringArray[n3]);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogFiles", "Deleting the expired file " + file2.getName());
                }
                file2.delete();
                ++n3;
            }
        }
    }

    public static void purgeControlLogFiles() {
        JobLogDeletionHandler jobLogDeletionHandler = new JobLogDeletionHandler();
        if (!jobLogDeletionHandler.purgeNecessary) {
            return;
        }
        jobLogDeletionHandler.purgeControlLogsForSchedule();
        File file = new File(jobLogDeletionHandler.dirPath);
        String[] stringArray = file.list(jobLogDeletionHandler);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, "purgeControlLogFiles", "Deleting the expired file " + file2.getName());
                }
                file2.delete();
                ++n;
            }
        }
    }

    private void purgeLogsForSchedule(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "purgeLogsForSchedule", "Schedule Id = " + Integer.toString(n) + " sid_run_number= " + Integer.toString(n2) + " retention is " + Integer.toString(n3));
        }
        int n4 = n2 - n3;
        ArrayList arrayList = this.getLogFileNames(n, n4);
        int n5 = 0;
        while (n5 < arrayList.size()) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogsForSchedule", "Marking file " + (String)arrayList.get(n5) + " For deletion");
            }
            ++n5;
        }
        this.purgeLogFiles(arrayList);
    }

    private void purgeControlLogsForSchedule() {
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, "purgeControlLogsForSchedule");
        }
        ArrayList arrayList = this.getControlLogFileNames();
        int n = 0;
        while (n < arrayList.size()) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "purgeControlLogsForSchedule", "Marking file " + (String)arrayList.get(n) + " For deletion");
            }
            ++n;
        }
        this.purgeLogFiles(arrayList);
    }

    private void getLogRetentionValuesFromDb() {
        block32: {
            DBConnection dBConnection;
            block36: {
                dBConnection = ServiceUtils.getConnection();
                dBConnection.getSchema();
                new Hashtable();
                ConfigSettings.ConfigSettingsCursor configSettingsCursor = null;
                try {
                    try {
                        configSettingsCursor = ConfigSettings.getCursor(dBConnection, null, null);
                        if (configSettingsCursor.next()) {
                            ConfigSettings configSettings = configSettingsCursor.getObject();
                            this.retainDays = configSettings.getRetainDays();
                            this.retention = configSettings.getRetainCopies();
                        }
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Retain copies =" + Integer.toString(this.retention) + " retain Days =" + Integer.toString(this.retainDays));
                        }
                    }
                    catch (Exception exception) {
                        block33: {
                            block31: {
                                exception.printStackTrace();
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_ALL, className, "getLogRetentionValuesFromDb", "Exception while retrieving retention values from the DB ");
                                }
                                if (configSettingsCursor != null) {
                                    try {
                                        configSettingsCursor.close();
                                    }
                                    catch (Exception exception2) {
                                        if (traceLogger == null || !traceLogger.isLogging()) break block31;
                                        traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while committing the DB Connection");
                                    }
                                }
                            }
                            if (dBConnection == null) break block32;
                            try {
                                dBConnection.commit();
                            }
                            catch (Exception exception3) {
                                exception3.printStackTrace();
                                if (traceLogger == null || !traceLogger.isLogging()) break block33;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while closing the DB Connection");
                            }
                        }
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception4) {
                            exception4.printStackTrace();
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    block34: {
                        if (configSettingsCursor != null) {
                            try {
                                configSettingsCursor.close();
                            }
                            catch (Exception exception) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block34;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while committing the DB Connection");
                            }
                        }
                    }
                    if (dBConnection != null) {
                        block35: {
                            try {
                                dBConnection.commit();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (traceLogger == null || !traceLogger.isLogging()) break block35;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while closing the DB Connection");
                            }
                        }
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (configSettingsCursor != null) {
                    try {
                        configSettingsCursor.close();
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block36;
                        traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while committing the DB Connection");
                    }
                }
            }
            if (dBConnection != null) {
                block37: {
                    try {
                        dBConnection.commit();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (traceLogger == null || !traceLogger.isLogging()) break block37;
                        traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while closing the DB Connection");
                    }
                }
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private ArrayList getLogFileNames(int n, int n2) {
        ArrayList<String> arrayList;
        block32: {
            arrayList = new ArrayList<String>();
            DBConnection dBConnection = ServiceUtils.getConnection();
            String string = "SELECT Log_file_name FROM  T_RUN_JOBS  WHERE T_RUN_JOBS.SID_RUN_NUMBER <= " + Integer.toString(n2) + " AND T_RUN_JOBS.SCHEDULE_ID= " + Integer.toString(n);
            String string2 = "delete FROM  T_RUN_JOBS  WHERE T_RUN_JOBS.SID_RUN_NUMBER <= " + Integer.toString(n2) + " AND T_RUN_JOBS.SCHEDULE_ID= " + Integer.toString(n);
            DBResultSet dBResultSet = null;
            try {
                try {
                    dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, new Hashtable());
                    if (dBResultSet != null) {
                        while (dBResultSet.next()) {
                            String string3 = dBResultSet.getString("Log_file_name");
                            if (!string3.startsWith(this.getDeviceServerLogDir())) continue;
                            arrayList.add(string3);
                        }
                    }
                    if (arrayList.size() == 0 && traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "No file names returned for scheduleId =" + Integer.toString(n) + " And sid_run_number<= " + Integer.toString(n2));
                    }
                    ComplexQuery.sqlUpdate(dBConnection, string2, new Hashtable());
                }
                catch (Exception exception) {
                    block33: {
                        block31: {
                            exception.printStackTrace();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_WARN, className, "getLogFileNames", "Exception while getting log file names from the DB ");
                            }
                            if (dBResultSet != null) {
                                try {
                                    dBResultSet.close();
                                }
                                catch (Exception exception2) {
                                    exception2.printStackTrace();
                                    if (traceLogger == null || !traceLogger.isLogging()) break block31;
                                    traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the logFile DB Result Set");
                                }
                            }
                        }
                        if (dBConnection == null) break block32;
                        try {
                            dBConnection.commit();
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                            if (traceLogger == null || !traceLogger.isLogging()) break block33;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while committing the DB Connection");
                        }
                    }
                    try {
                        dBConnection.close();
                    }
                    catch (Exception exception4) {
                        exception4.printStackTrace();
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the DB Connection");
                        }
                    }
                }
            }
            finally {
                block36: {
                    block34: {
                        if (dBResultSet != null) {
                            try {
                                dBResultSet.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (traceLogger == null || !traceLogger.isLogging()) break block34;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the logFile DB Result Set");
                            }
                        }
                    }
                    if (dBConnection != null) {
                        block35: {
                            try {
                                dBConnection.commit();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (traceLogger == null || !traceLogger.isLogging()) break block35;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while committing the DB Connection");
                            }
                        }
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (traceLogger == null || !traceLogger.isLogging()) break block36;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the DB Connection");
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    private ArrayList getControlLogFileNames() {
        ArrayList<String> arrayList;
        block32: {
            arrayList = new ArrayList<String>();
            DBConnection dBConnection = ServiceUtils.getConnection();
            String string = "SELECT Log_file_name FROM T_RUN_JOBS WHERE T_RUN_JOBS.SID_RUN_NUMBER = -9999";
            String string2 = "DELETE FROM T_RUN_JOBS WHERE sid_run_number = -9999";
            DBResultSet dBResultSet = null;
            try {
                try {
                    dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, new Hashtable());
                    if (dBResultSet != null) {
                        while (dBResultSet.next()) {
                            String string3 = dBResultSet.getString("Log_file_name");
                            if (!string3.startsWith(this.getDeviceServerLogDir())) continue;
                            arrayList.add(string3);
                        }
                    }
                    if (arrayList.size() == 0 && traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, className, "getControlLogFileNames", "No Expired Control Logs");
                    }
                    ComplexQuery.sqlUpdate(dBConnection, string2, new Hashtable());
                }
                catch (Exception exception) {
                    block33: {
                        block31: {
                            exception.printStackTrace();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_WARN, className, "getControlLogFileNames", "Exception while getting log file names from the DB ");
                            }
                            if (dBResultSet != null) {
                                try {
                                    dBResultSet.close();
                                }
                                catch (Exception exception2) {
                                    exception2.printStackTrace();
                                    if (traceLogger == null || !traceLogger.isLogging()) break block31;
                                    traceLogger.text(IRecordType.TYPE_INFO, className, "getControlLogFileNames", "Exception while closing the logFile DB Result Set");
                                }
                            }
                        }
                        if (dBConnection == null) break block32;
                        try {
                            dBConnection.commit();
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                            if (traceLogger == null || !traceLogger.isLogging()) break block33;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getControlLogFileNames", "Exception while committing the DB Connection");
                        }
                    }
                    try {
                        dBConnection.close();
                    }
                    catch (Exception exception4) {
                        exception4.printStackTrace();
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getControlLogFileNames", "Exception while closing the DB Connection");
                        }
                    }
                }
            }
            finally {
                block36: {
                    block34: {
                        if (dBResultSet != null) {
                            try {
                                dBResultSet.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (traceLogger == null || !traceLogger.isLogging()) break block34;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getControlLogFileNames", "Exception while closing the logFile DB Result Set");
                            }
                        }
                    }
                    if (dBConnection != null) {
                        block35: {
                            try {
                                dBConnection.commit();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (traceLogger == null || !traceLogger.isLogging()) break block35;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getControlLogFileNames", "Exception while committing the DB Connection");
                            }
                        }
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (traceLogger == null || !traceLogger.isLogging()) break block36;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getControlLogFileNames", "Exception while closing the DB Connection");
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    private String getDeviceServerLogDir() {
        String string = Variables.getBaseDirectory();
        String string2 = String.valueOf(string) + File.separator + "log" + File.separator;
        return string2;
    }

    private void purgeLogFiles(ArrayList arrayList) {
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                File file = new File((String)arrayList.get(n));
                if (file.exists()) {
                    file.delete();
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogFiles", "Could not delete non existent File " + file.getName());
                }
                ++n;
            }
        }
    }
}

