/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskArrayData
implements GuiRequestor {
    public static final int GROUP_SEPARATION = 12;
    private NameList diskArray;
    private JPanel panel;

    public DiskArrayData(NameList nameList) {
        this.diskArray = nameList;
        this.panel = null;
    }

    public static void addItem(Container container, GridBagConstraints gridBagConstraints, String string, String string2) {
        String string3 = MessageLog.getMessageNoID(string);
        JLabel jLabel = new JLabel(string3);
        jLabel.setFont(BaseTree.boldFont);
        jLabel.setForeground(Color.black);
        gridBagConstraints.gridwidth = 1;
        container.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(string2);
        jLabel.setFont(BaseTree.plainFont);
        jLabel.setForeground(Color.black);
        gridBagConstraints.gridwidth = 0;
        int n = gridBagConstraints.insets.left;
        gridBagConstraints.insets.left = 24;
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = n;
    }

    public JComponent getComponent() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(new GridBagLayout());
        Request request = GuiRequest.makeDiskArrayInfoRequest(this.diskArray.nlID);
        GuiClient.doRequest(this, request);
        return this.panel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        NasFiler[] nasFilerArray = (NasFiler[])response.responseData;
        NasFiler nasFiler = nasFilerArray[0];
        Computer computer = nasFiler.nfComputer;
        String string = computer.cmpOSType == 21 ? MessageLog.getMessageNoID("SAG0071L", nasFiler.nfAlias) : MessageLog.getMessageNoID("SAG0006L", nasFiler.nfAlias);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(BaseTree.boldFont);
        jLabel.setForeground(Color.black);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.top = 30;
        gridBagConstraints.insets.bottom = 20;
        this.panel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1103L", nasFiler.nfLdapTree.getLtName());
        gridBagConstraints.insets.bottom = 0;
        if (computer.cmpOSType == 21) {
            this.makeClusterPanel(computer, gridBagConstraints);
        } else {
            this.makeDiskArrayPanel(computer, gridBagConstraints);
        }
        if (computer.cmpLastProbeTime == 0L || computer.cmpLastProbeTime == -1L) {
            DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1119L", Util.getString("STG0019T"));
            DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1120L", Util.getString("DBG0108L"));
        } else {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            Date date = new Date(computer.cmpLastProbeTime);
            string = TableCellStrings.DateRenderer(date, dateFormat);
            DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1119L", string);
            string = ComputersAdjuster.probeStatus[computer.cmpProbeStatus];
            DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1120L", string);
        }
        string = computer.cmpProbingCompID < 0 ? MessageLog.getMessageNoID("SAG0025L") : (Constants.isCimomManaged(computer.cmpOSType) ? GuiClient.serverStatusResp.serverName : GuiUtil.getComputer((int)computer.cmpProbingCompID).gcTSName);
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0011L", string);
        GuiUtil.completePanel(this.panel);
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void makeDiskArrayPanel(Computer computer, GridBagConstraints gridBagConstraints) {
        String string;
        String string2 = computer.cmpManufacturer;
        if (computer.cmpManufacturer.toLowerCase().equals("unknown")) {
            string2 = MessageLog.getMessageNoID("STG1020L");
        }
        DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1105L", string2);
        DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1106L", computer.cmpModel);
        gridBagConstraints.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1107L", computer.cmpSerialNumber);
        gridBagConstraints.insets.bottom = 0;
        if ((computer.cmpOSType == 15 || computer.cmpOSType == 12 || computer.cmpOSType == 25 || computer.cmpOSType == 27) && computer.cmpRAM > 0) {
            long l = computer.cmpRAM;
            string = Util.formatPrefBytes(l <<= 20);
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0007L", string);
            if ((computer.cmpOSType == 12 || computer.cmpOSType == 25 || computer.cmpOSType == 27) && computer.cmpSwapSpace > 0) {
                l = computer.cmpSwapSpace;
                string = Util.formatPrefBytes(l <<= 20);
                DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0024L", string);
            }
        }
        gridBagConstraints.insets.bottom = 12;
        String string3 = computer.cmpOSVersion;
        if (computer.cmpOSVersion == null || computer.cmpOSVersion.toLowerCase().equals("unknown")) {
            string3 = MessageLog.getMessageNoID("STG1020L");
        }
        DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1146L", string3);
        gridBagConstraints.insets.bottom = 0;
        if (Constants.hasDiskInfo(computer.cmpOSType)) {
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0008L", Integer.toString(computer.cmpNDisks));
            string = Util.formatPrefBytes(computer.cmpDiskCapacity << 9);
            if (computer.cmpDiskCapacity > 0L) {
                DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1115L", string);
            } else {
                DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1115L", MessageLog.getMessageNoID("STG0019T"));
            }
            string = Util.formatPrefBytes(computer.cmpDiskFreeSpace << 9);
            gridBagConstraints.insets.bottom = 12;
            if (computer.cmpDiskFreeSpace > 0L) {
                DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0047I", string);
            } else {
                DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0047I", MessageLog.getMessageNoID("STG0019T"));
            }
            gridBagConstraints.insets.bottom = 0;
        }
        if (Constants.hasStoragePoolInfo(computer.cmpOSType)) {
            string = Util.formatPrefBytes(computer.cmpVolGroupCapacity << 9);
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0048I", string);
            string = Util.formatPrefBytes(computer.cmpVolGroupFreespace << 9);
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0049I", string);
            long l = 0L;
            if (computer.cmpOSType == 15) {
                l = computer.cmpDiskCapacity - computer.cmpDiskFreeSpace - computer.cmpLogicalDiskCapacity;
                if (l < 0L) {
                    l = computer.cmpVolGroupCapacity - computer.cmpVolGroupFreespace - computer.cmpLogicalDiskCapacity;
                }
            } else if (computer.cmpDiskGroupFreeCap == -1L) {
                l = -1L;
            } else {
                l = computer.cmpDiskCapacity - computer.cmpDiskGroupFreeCap;
                l -= computer.cmpVolGroupCapacity;
            }
            if (computer.cmpOSType == 12 || computer.cmpOSType == 25 || computer.cmpOSType == 27 || computer.cmpOSType == 15) {
                string = Util.formatPrefBytes(l << 9);
                DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0050I", string);
                gridBagConstraints.insets.bottom = 12;
                string = Util.formatPrefBytes(computer.cmpDiskGroupFreeCap << 9);
                DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0051I", string);
                gridBagConstraints.insets.bottom = 0;
            } else {
                gridBagConstraints.insets.bottom = 12;
                string = Util.formatPrefBytes(l << 9);
                DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0050I", string);
                gridBagConstraints.insets.bottom = 0;
            }
        }
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0009L", Integer.toString(computer.cmpNLogicalDisks));
        string = Util.formatPrefBytes(computer.cmpLogicalDiskCapacity << 9);
        gridBagConstraints.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0010L", string);
        gridBagConstraints.insets.bottom = 0;
    }

    private void makeClusterPanel(Computer computer, GridBagConstraints gridBagConstraints) {
        String string = computer.cmpManufacturer;
        if (computer.cmpManufacturer.toLowerCase().equals("unknown")) {
            string = MessageLog.getMessageNoID("STG1020L");
        }
        DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1105L", string);
        gridBagConstraints.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, gridBagConstraints, "STG1106L", computer.cmpModel);
        gridBagConstraints.insets.bottom = 0;
        long l = computer.cmpRAM;
        String string2 = Util.formatPrefBytes(l * 0x100000L);
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0065L", string2);
        gridBagConstraints.insets.bottom = 12;
        String string3 = computer.cmpOSVersion;
        if (computer.cmpOSVersion.toLowerCase().equals("unknown")) {
            string3 = MessageLog.getMessageNoID("STG1020L");
        }
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0066L", string3);
        gridBagConstraints.insets.bottom = 0;
        if (Constants.hasDiskInfo(computer.cmpOSType)) {
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0067L", Integer.toString(computer.cmpNDisks));
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0079L", Integer.toString(computer.cmpSwapSpace));
            string2 = Util.formatPrefBytes(computer.cmpDiskCapacity * 512L);
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0068L", string2);
            string2 = Util.formatPrefBytes(computer.cmpDiskFreeSpace * 512L);
            gridBagConstraints.insets.bottom = 12;
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0069L", string2);
            gridBagConstraints.insets.bottom = 0;
        }
        if (Constants.hasStoragePoolInfo(computer.cmpOSType)) {
            string2 = Util.formatPrefBytes(computer.cmpVolGroupCapacity * 512L);
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0070L", string2);
            string2 = Util.formatPrefBytes(computer.cmpVolGroupFreespace * 512L);
            gridBagConstraints.insets.bottom = 12;
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0078L", string2);
            gridBagConstraints.insets.bottom = 0;
        }
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0075L", Integer.toString(computer.cmpNLogicalDisks));
        string2 = Util.formatPrefBytes(computer.cmpLogicalDiskCapacity * 512L);
        gridBagConstraints.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0076L", string2);
        gridBagConstraints.insets.bottom = 0;
    }
}

